/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.util.internal;

import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.internal.util.ColorEditor;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.SpectrumColorMap;
import org.eclipse.jface.preference.FontFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class GraphColorUI {
    private FontFieldEditor fontEditor;
    private ColorEditor fClassColorEditor;
    private ColorEditor fBackgroundColorEditor;
    private Button fBackgroundDefaultRadioButton;
    private Button fBackgroundCustomRadioButton;
    private Button fBackgroundColorButton;
    private Button fClassCustomRadioButton;
    private Button fClassDefaultRadioButton;
    private Button fClassColorButton;
    private ColorEditor fSelectionColorEditor;
    private Button fSelectionColorButton;
    private ColorEditor fUnknownColorEditor;
    private Button fUnknownColorButton;

    public Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        composite3.setLayout((Layout)gridLayout);
        Label label = new Label(composite3, 0);
        label.setText(TraceUIPlugin.getString("BACKGROUND_COLOR_GRP"));
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = GraphColorUI.this.fBackgroundCustomRadioButton.getSelection();
                GraphColorUI.this.fBackgroundColorButton.setEnabled(bl);
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        };
        this.fBackgroundDefaultRadioButton = new Button(composite3, 16400);
        this.fBackgroundDefaultRadioButton.setText(TraceUIPlugin.getString("BACKGROUND_DEFAULT"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.fBackgroundDefaultRadioButton.setLayoutData((Object)gridData);
        this.fBackgroundDefaultRadioButton.addSelectionListener(selectionListener);
        this.fBackgroundCustomRadioButton = new Button(composite3, 16400);
        this.fBackgroundCustomRadioButton.setText(TraceUIPlugin.getString("BACKGROUND_CUSTOM"));
        this.fBackgroundCustomRadioButton.addSelectionListener(selectionListener);
        this.fBackgroundColorEditor = new ColorEditor(composite3);
        this.fBackgroundColorButton = this.fBackgroundColorEditor.getButton();
        gridData = new GridData(768);
        gridData.horizontalAlignment = 1;
        this.fBackgroundColorButton.setLayoutData((Object)gridData);
        Composite composite4 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        composite4.setLayout((Layout)gridLayout);
        label = new Label(composite4, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label = new Label(composite4, 0);
        label.setText(TraceUIPlugin.getString("CLASS_COLOR_GRP"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        SelectionListener selectionListener2 = new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = GraphColorUI.this.fClassCustomRadioButton.getSelection();
                GraphColorUI.this.fClassColorButton.setEnabled(bl);
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        };
        this.fClassDefaultRadioButton = new Button(composite4, 16400);
        this.fClassDefaultRadioButton.setText(TraceUIPlugin.getString("CLASS_COLOR_RANDOM"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.fClassDefaultRadioButton.setLayoutData((Object)gridData);
        this.fClassDefaultRadioButton.addSelectionListener(selectionListener2);
        this.fClassCustomRadioButton = new Button(composite4, 16400);
        this.fClassCustomRadioButton.setText(TraceUIPlugin.getString("CLASS_COLOR_ONE"));
        this.fClassCustomRadioButton.addSelectionListener(selectionListener2);
        this.fClassColorEditor = new ColorEditor(composite4);
        this.fClassColorButton = this.fClassColorEditor.getButton();
        gridData = new GridData(768);
        gridData.horizontalAlignment = 1;
        this.fClassColorButton.setLayoutData((Object)gridData);
        Composite composite5 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        composite5.setLayout((Layout)gridLayout);
        label = new Label(composite5, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label = new Label(composite5, 16384);
        label.setText(TraceUIPlugin.getString("UNKNOWN_CLASS_COLOR"));
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        label.setLayoutData((Object)gridData);
        this.fUnknownColorEditor = new ColorEditor(composite5);
        this.fUnknownColorButton = this.fUnknownColorEditor.getButton();
        gridData = new GridData(768);
        gridData.horizontalAlignment = 1;
        this.fUnknownColorButton.setLayoutData((Object)gridData);
        label = new Label(composite5, 16384);
        label.setText(TraceUIPlugin.getString("SELECTION_COLOR"));
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        label.setLayoutData((Object)gridData);
        this.fSelectionColorEditor = new ColorEditor(composite5);
        this.fSelectionColorButton = this.fClassColorEditor.getButton();
        gridData = new GridData(768);
        gridData.horizontalAlignment = 1;
        this.fSelectionColorButton.setLayoutData((Object)gridData);
        label = new Label(composite5, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        Composite composite6 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 3;
        composite6.setLayout((Layout)gridLayout);
        this.fontEditor = this.createFontFieldEditor("graph.font", TraceUIPlugin.getString("GRAPH_FONT"), composite6);
        this.initializeValues();
        return composite2;
    }

    private FontFieldEditor createFontFieldEditor(String string, String string2, Composite composite) {
        FontFieldEditor fontFieldEditor = new FontFieldEditor(string, string2, composite);
        fontFieldEditor.setPreferenceStore(this.getPreferenceStore());
        return fontFieldEditor;
    }

    public IPreferenceStore getPreferenceStore() {
        return TraceUIPlugin.getDefault().getPreferenceStore();
    }

    private void initializeValues() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        this.fontEditor.load();
        String string = iPreferenceStore.getString("bg_option");
        if (string.equals("system_default")) {
            this.fBackgroundDefaultRadioButton.setSelection(true);
            this.fBackgroundColorButton.setEnabled(false);
        } else {
            this.fBackgroundCustomRadioButton.setSelection(true);
            this.fBackgroundColorButton.setEnabled(true);
        }
        String string2 = iPreferenceStore.getString("class_option");
        if (!string2.equals("class_one_color")) {
            this.fClassDefaultRadioButton.setSelection(true);
            this.fClassColorButton.setEnabled(false);
        } else {
            this.fClassCustomRadioButton.setSelection(true);
            this.fClassColorButton.setEnabled(true);
        }
        RGB rGB = PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)"background_rgb");
        this.fBackgroundColorEditor.setColorValue(rGB);
        rGB = PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)"selection_rgb");
        this.fSelectionColorEditor.setColorValue(rGB);
        rGB = PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)"unknown_rgb");
        this.fUnknownColorEditor.setColorValue(rGB);
        rGB = PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)"classes_rgb");
        this.fClassColorEditor.setColorValue(rGB);
    }

    private Composite createComposite(Composite composite, int n) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = n;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)GridUtil.createFill());
        return composite2;
    }

    public static Color getPreferenceColor(String string) {
        IPreferenceStore iPreferenceStore = TraceUIPlugin.getDefault().getPreferenceStore();
        RGB rGB = PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)string);
        return SpectrumColorMap.getColor(rGB);
    }

    public void performDefaults() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        this.fontEditor.loadDefault();
        String string = iPreferenceStore.getDefaultString("bg_option");
        if (string.equals("system_default")) {
            this.fBackgroundDefaultRadioButton.setSelection(true);
            this.fBackgroundCustomRadioButton.setSelection(false);
            this.fBackgroundColorButton.setEnabled(false);
        } else {
            this.fBackgroundCustomRadioButton.setSelection(true);
            this.fBackgroundDefaultRadioButton.setSelection(false);
            this.fBackgroundColorButton.setEnabled(true);
        }
        String string2 = iPreferenceStore.getDefaultString("class_option");
        if (!string2.equals("class_one_color")) {
            this.fClassDefaultRadioButton.setSelection(true);
            this.fClassCustomRadioButton.setSelection(false);
            this.fClassColorButton.setEnabled(false);
        } else {
            this.fClassCustomRadioButton.setSelection(true);
            this.fClassDefaultRadioButton.setSelection(false);
            this.fClassColorButton.setEnabled(true);
        }
        RGB rGB = PreferenceConverter.getDefaultColor((IPreferenceStore)iPreferenceStore, (String)"background_rgb");
        this.fBackgroundColorEditor.setColorValue(rGB);
        rGB = PreferenceConverter.getDefaultColor((IPreferenceStore)iPreferenceStore, (String)"selection_rgb");
        this.fSelectionColorEditor.setColorValue(rGB);
        rGB = PreferenceConverter.getDefaultColor((IPreferenceStore)iPreferenceStore, (String)"unknown_rgb");
        this.fUnknownColorEditor.setColorValue(rGB);
        rGB = PreferenceConverter.getDefaultColor((IPreferenceStore)iPreferenceStore, (String)"classes_rgb");
        this.fClassColorEditor.setColorValue(rGB);
    }

    public boolean performOk() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        this.fontEditor.store();
        if (this.fBackgroundDefaultRadioButton.getSelection()) {
            iPreferenceStore.setValue("bg_option", "system_default");
            this.fBackgroundColorButton.setEnabled(false);
        } else {
            iPreferenceStore.setValue("bg_option", "bg_custom");
            PreferenceConverter.setValue((IPreferenceStore)iPreferenceStore, (String)"background_rgb", (RGB)this.fBackgroundColorEditor.getColorValue());
        }
        if (!this.fClassDefaultRadioButton.getSelection()) {
            iPreferenceStore.setValue("class_option", "class_one_color");
            PreferenceConverter.setValue((IPreferenceStore)iPreferenceStore, (String)"classes_rgb", (RGB)this.fClassColorEditor.getColorValue());
        } else {
            iPreferenceStore.setValue("class_option", "class_default_color");
        }
        PreferenceConverter.setValue((IPreferenceStore)iPreferenceStore, (String)"selection_rgb", (RGB)this.fSelectionColorEditor.getColorValue());
        PreferenceConverter.setValue((IPreferenceStore)iPreferenceStore, (String)"unknown_rgb", (RGB)this.fUnknownColorEditor.getColorValue());
        SpectrumColorMap.updateColors();
        TraceUIPlugin.getDefault().savePluginPreferences();
        return true;
    }

    public static FontData getConsoleFontData() {
        IPreferenceStore iPreferenceStore = TraceUIPlugin.getDefault().getPreferenceStore();
        return PreferenceConverter.getFontData((IPreferenceStore)iPreferenceStore, (String)"graph.font");
    }
}

