/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ui.actions.widgets;

import java.text.MessageFormat;
import org.eclipse.hyades.uml2sd.ui.SDViewerPlugin;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDAdvancedPagingProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.help.WorkbenchHelp;

public class PagesDialog
extends Dialog {
    private IViewPart viewer = null;
    private ISDAdvancedPagingProvider provider = null;
    private TextArea currentPage;
    private Label totalPageComment;

    private void updateComments() {
        int n = Math.max(0, this.provider.pagesCount());
        String string = SDViewerPlugin.getResourceString("PAGES_TOTAL") + n + " ";
        string = n == 0 ? string + SDViewerPlugin.getResourceString("PAGES_NO_PAGES") : (n == 1 ? string + SDViewerPlugin.getResourceString("PAGES_ONE_PAGE") : string + SDViewerPlugin.getResourceString("PAGES_SEVERAL_PAGES"));
        this.totalPageComment.setText(string);
    }

    public Control createDialogArea(Composite composite) {
        Group group = new Group(composite, 0);
        WorkbenchHelp.setHelp((Control)group, (String)(SDViewerPlugin.getId() + ".UML2SDPAGE"));
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        group.setLayoutData((Object)gridData);
        group.setText(SDViewerPlugin.getResourceString("PAGES_GROUP_TITLE"));
        FillLayout fillLayout = new FillLayout(512);
        group.setLayout((Layout)fillLayout);
        Label label = new Label((Composite)group, 0);
        label.setText(SDViewerPlugin.getResourceString("PAGES_CURRENT_PAGE"));
        this.currentPage = new TextArea((Composite)group);
        this.currentPage.setBounds(1, this.provider.pagesCount());
        this.currentPage.setValue(this.provider.currentPage() + 1);
        this.totalPageComment = new Label((Composite)group, 0);
        this.totalPageComment.setAlignment(131072);
        this.updateComments();
        this.getShell().setText(SDViewerPlugin.getResourceString("PAGES_TITLE"));
        return group;
    }

    public PagesDialog(IViewPart iViewPart, ISDAdvancedPagingProvider iSDAdvancedPagingProvider) {
        super(iViewPart.getSite().getShell());
        this.viewer = iViewPart;
        this.provider = iSDAdvancedPagingProvider;
        this.setShellStyle(67680);
    }

    public int open() {
        this.create();
        this.getShell().pack();
        this.getShell().setLocation(this.getShell().getDisplay().getCursorLocation());
        return super.open();
    }

    public void okPressed() {
        int n = this.currentPage.getValue() - 1;
        super.close();
        this.provider.pageNumberChanged(n);
    }

    private class TextArea {
        private Text text;
        int min;
        int max;

        public TextArea(Composite composite) {
            this.text = new Text(composite, 133124);
            this.text.setTextLimit(10);
            GridData gridData = new GridData();
            gridData.widthHint = PagesDialog.super.convertWidthInCharsToPixels(10);
            this.text.setLayoutData((Object)gridData);
        }

        public void setValue(int n) {
            int n2 = Math.max(this.min, Math.min(this.max, n));
            this.text.setText(Integer.toString(n2));
        }

        public int getValue() {
            int n;
            try {
                n = Integer.parseInt(this.text.getText());
            }
            catch (Exception exception) {
                n = 0;
            }
            return Math.max(this.min, Math.min(this.max, n));
        }

        public void setBounds(int n, int n2) {
            this.min = Math.max(0, n);
            this.max = Math.max(this.min, n2);
            Object[] objectArray = new Integer[]{new Integer(this.min), new Integer(this.max)};
            this.text.setToolTipText(MessageFormat.format(SDViewerPlugin.getResourceString("PAGES_BOUNDS"), objectArray));
        }
    }
}

