/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ui.core;

import org.eclipse.hyades.uml2sd.ui.core.AsyncMessageReturn;
import org.eclipse.hyades.uml2sd.ui.core.BaseMessage;
import org.eclipse.hyades.uml2sd.ui.core.Frame;
import org.eclipse.hyades.uml2sd.ui.core.ITimeRange;
import org.eclipse.hyades.uml2sd.ui.core.Lifeline;
import org.eclipse.hyades.uml2sd.ui.core.Metrics;
import org.eclipse.hyades.uml2sd.ui.drawings.IGC;

public class AsyncMessage
extends BaseMessage
implements ITimeRange {
    protected boolean hasTime = false;
    protected double endTime = 0.0;
    protected double startTime = 0.0;
    protected AsyncMessageReturn messageReturn = null;
    protected int startEventOccurrence = 0;

    public int getX() {
        int n = super.getX(true);
        int n2 = 5;
        if (this.startLifeline != null && this.endLifeline != null && this.startLifeline.getX() > this.endLifeline.getX()) {
            n2 = -n2;
        }
        if (this.isMessageStartInActivation(this.startEventOccurrence)) {
            n += n2;
        }
        return n;
    }

    public int getY() {
        if (this.startLifeline != null && this.endLifeline != null) {
            return this.endLifeline.getY() + this.endLifeline.getHeight() + (Metrics.getMessageFontHeigth() + Metrics.getMessagesSpacing()) * this.startEventOccurrence;
        }
        return super.getY();
    }

    public int getWidth() {
        int n = super.getWidth(true);
        int n2 = 5;
        if (this.startLifeline != null && this.endLifeline != null && this.startLifeline.getX() > this.endLifeline.getX()) {
            n2 = -n2;
        }
        if (this.isMessageStartInActivation(this.startEventOccurrence)) {
            n -= n2;
        }
        if (this.isMessageEndInActivation(this.eventOccurrence)) {
            n -= n2;
        }
        return n;
    }

    public int getHeight() {
        if (this.startLifeline != null && this.endLifeline != null) {
            return this.endLifeline.getY() + this.endLifeline.getHeight() + (Metrics.getMessageFontHeigth() + Metrics.getMessagesSpacing()) * this.eventOccurrence - this.getY();
        }
        return super.getHeight();
    }

    protected void setMessageReturn(AsyncMessageReturn asyncMessageReturn) {
        this.messageReturn = asyncMessageReturn;
    }

    public void setEndOccurrence(int n) {
        this.eventOccurrence = this.getEndLifeline() != null ? n : this.startEventOccurrence;
        this.informFrame(this.getEndLifeline(), n);
    }

    public int getEndOccurrence() {
        return this.eventOccurrence;
    }

    protected void informFrame(Lifeline lifeline, int n) {
        if (lifeline != null && lifeline.getFrame() != null && lifeline.getFrame().getMaxEventOccurrence() < n) {
            lifeline.getFrame().setMaxEventOccurrence(n);
        }
    }

    public void setStartOccurrence(int n) {
        this.startEventOccurrence = n;
        if (this.getEndLifeline() == null) {
            this.eventOccurrence = this.startEventOccurrence;
        }
        this.informFrame(this.getStartLifeline(), n);
    }

    public int getStartOccurrence() {
        return this.startEventOccurrence;
    }

    public void autoSetStartLifeline(Lifeline lifeline) {
        lifeline.getNewEventOccurrence();
        this.setStartLifeline(lifeline);
    }

    public void autoSetEndLifeline(Lifeline lifeline) {
        lifeline.getNewEventOccurrence();
        this.setEndLifeline(lifeline);
    }

    public void setStartLifeline(Lifeline lifeline) {
        super.setStartLifeline(lifeline);
        this.setStartOccurrence(this.getStartLifeline().getEventOccurrence());
        if (this.getEndLifeline() == null) {
            this.eventOccurrence = this.startEventOccurrence;
        }
    }

    public void setEndLifeline(Lifeline lifeline) {
        super.setEndLifeline(lifeline);
        this.setEventOccurrence(this.getEndLifeline().getEventOccurrence());
    }

    protected boolean isNearSegment(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n > n3 && n5 > n) {
            return false;
        }
        if (n < n3 && n5 > n3) {
            return false;
        }
        if (n < n3 && n5 < n) {
            return false;
        }
        if (n > n3 && n5 < n3) {
            return false;
        }
        double d = Math.sqrt((n3 - n) * (n3 - n) + (n4 - n2) * (n4 - n2));
        double d2 = (double)((n3 - n) * (n5 - n) + (n4 - n2) * (n6 - n2)) / d;
        double d3 = Math.sqrt((n5 - n) * (n5 - n) + (n6 - n2) * (n6 - n2));
        double d4 = Math.sqrt(Math.abs(d3 * d3 - d2 * d2));
        return d4 <= 10.0;
    }

    public boolean contains(int n, int n2) {
        int n3 = 10 + Metrics.getMessageFontHeigth();
        if (this.startLifeline == this.endLifeline) {
            if (this.getName().length() * Metrics.getAverageCharWidth() > Metrics.swimmingLaneWidth() - 5 + -20 ? Frame.contains(this.getX() + 20 + 10, this.getY(), Metrics.swimmingLaneWidth() - 5 + -20, Metrics.getMessageFontHeigth(), n, n2) : Frame.contains(this.getX() + 20 + 10, this.getY(), this.getName().length() * Metrics.getAverageCharWidth(), Metrics.getMessageFontHeigth(), n, n2)) {
                return true;
            }
            if (Frame.contains(this.getX(), this.getY() - 5, 10, 10, n, n2)) {
                return true;
            }
            if (Frame.contains(this.getX() + 20 - 5, this.getY(), 10, this.getHeight(), n, n2)) {
                return true;
            }
            if (Frame.contains(this.getX(), this.getY() + this.getHeight() - 5, 10, 10, n, n2)) {
                return true;
            }
        }
        if (this.isNearSegment(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), n, n2)) {
            return true;
        }
        int n4 = Metrics.swimmingLaneWidth() - 10;
        int n5 = this.getName().length() * Metrics.getAverageCharWidth();
        return this.getName().length() * Metrics.getAverageCharWidth() > n4 ? Frame.contains(this.getX(), this.getY() - 10 - Metrics.getMessageFontHeigth(), n4, Metrics.getMessageFontHeigth(), n, n2) : Frame.contains(this.getX() + (n4 - n5) / 2, this.getY() - 10 - Metrics.getMessageFontHeigth(), n5, Metrics.getMessageFontHeigth(), n, n2);
    }

    private void drawAsyncMessage(IGC iGC) {
        if (this.startLifeline != null && this.endLifeline != null && this.startLifeline == this.endLifeline && this.startEventOccurrence != this.eventOccurrence) {
            int n = this.getX();
            int n2 = this.getY();
            int n3 = this.getWidth();
            int n4 = this.getHeight();
            int n5 = 0;
            boolean bl = this.isMessageStartInActivation(this.startEventOccurrence);
            boolean bl2 = this.isMessageEndInActivation(this.eventOccurrence);
            if (bl2 && !bl) {
                n5 = 5;
            }
            if (bl && !bl2) {
                n5 = -5;
            }
            int n6 = 10;
            if (this.getHeight() <= 20) {
                n6 = this.getHeight() / 2;
            }
            iGC.drawLine(n, n2, n + 10, n2);
            iGC.drawLine(n + 20, n2 + n6, n + 20, n2 + n4 - n6);
            iGC.drawLine(n + n5, n2 + n4, n + 10, n2 + n4);
            Double d = new Double(Math.cos(0.5) * 10.0);
            Double d2 = new Double(Math.sin(0.5) * 10.0);
            iGC.drawLine(n + d.intValue() + n5, n2 + n4 + d2.intValue(), n + n5, n2 + n4);
            iGC.drawArc(n, n2, 20, 2 * n6, 0, 90);
            iGC.drawArc(n, n2 + n4, 20, -2 * n6, 0, -90);
            iGC.drawLine(n + d.intValue() + n5, n2 + n4 - d2.intValue(), n + n5, n2 + n4);
            iGC.drawTextTruncated(this.getName(), n + 20 + 20, n2, Metrics.swimmingLaneWidth() - 10 + -20, 10 - Metrics.getMessageFontHeigth(), !this.isSelected());
        } else {
            super.draw(iGC);
        }
    }

    public void draw(IGC iGC) {
        if (this.isSelected()) {
            iGC.setForeground(Frame.getUserPref().getBackGroundColorSelection());
            iGC.setLineWidth(5);
            this.drawAsyncMessage(iGC);
            iGC.setBackground(Frame.getUserPref().getBackGroundColorSelection());
            iGC.setForeground(Frame.getUserPref().getForeGroundColorSelection());
        } else {
            iGC.setBackground(Frame.getUserPref().getBackGroundColor("PREF_ASYNC_MESS"));
            iGC.setForeground(Frame.getUserPref().getForeGroundColor("PREF_ASYNC_MESS"));
        }
        iGC.setLineWidth(1);
        this.drawAsyncMessage(iGC);
    }

    public void setEndTime(double d) {
        this.endTime = d;
        this.hasTime = true;
        if (this.getStartLifeline() != null && this.getStartLifeline().getFrame() != null) {
            this.getStartLifeline().getFrame().setHasTimeInfo(true);
        } else if (this.getEndLifeline() != null && this.getEndLifeline().getFrame() != null) {
            this.getEndLifeline().getFrame().setHasTimeInfo(true);
        }
    }

    public void setStartTime(double d) {
        this.startTime = d;
        this.hasTime = true;
        if (this.getStartLifeline() != null && this.getStartLifeline().getFrame() != null) {
            this.getStartLifeline().getFrame().setHasTimeInfo(true);
        } else if (this.getEndLifeline() != null && this.getEndLifeline().getFrame() != null) {
            this.getEndLifeline().getFrame().setHasTimeInfo(true);
        }
    }

    public double getLastTime() {
        return this.endTime;
    }

    public double getFirstTime() {
        return this.startTime;
    }

    public boolean hasTimeInfo() {
        return this.hasTime;
    }
}

