/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ui.preferences;

import java.util.Hashtable;
import org.eclipse.hyades.uml2sd.ui.SDViewerPlugin;
import org.eclipse.hyades.uml2sd.ui.drawings.IColor;
import org.eclipse.hyades.uml2sd.ui.drawings.IFont;
import org.eclipse.hyades.uml2sd.ui.drawings.ISDPreferences;
import org.eclipse.hyades.uml2sd.ui.drawings.impl.ColorImpl;
import org.eclipse.hyades.uml2sd.ui.drawings.impl.FontImpl;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class SDViewPref
implements ISDPreferences {
    public static final String BACK_COLOR_POSTFIX = "_BACK_COLOR";
    public static final String FORE_COLOR_POSTFIX = "_FORE_COLOR";
    public static final String[] fontList = new String[]{"PREF_LIFELINE", "PREF_EXEC", "PREF_SYNC_MESS", "PREF_SYNC_MESS_RET", "PREF_ASYNC_MESS", "PREF_ASYNC_MESS_RET", "PREF_FRAME", "PREF_FRAME_NAME"};
    public static final String[] prefBackColorList = new String[]{"PREF_LIFELINE", "PREF_EXEC", "PREF_FRAME", "PREF_FRAME_NAME"};
    public static final String[] prefForeColorList = new String[]{"PREF_LIFELINE", "PREF_EXEC", "PREF_SYNC_MESS", "PREF_SYNC_MESS_RET", "PREF_ASYNC_MESS", "PREF_ASYNC_MESS_RET", "PREF_FRAME", "PREF_FRAME_NAME"};
    protected Hashtable fontPref;
    protected Hashtable foreColorPref;
    protected Hashtable backColorPref;
    private static SDViewPref handle = null;
    private IPreferenceStore prefStore = SDViewerPlugin.getDefault().getPreferenceStore();
    private IColor timeCompressionSelectionColor = null;
    private Font lifeLineFont = null;
    private Font synMessageFont = null;
    private Font synMessageReturnFont = null;
    private Font asynMessageFont = null;
    private Font asynMessageReturnFont = null;

    private SDViewPref() {
        ColorImpl colorImpl;
        this.prefStore.setDefault("PREF_LINK_FONT", true);
        this.prefStore.setDefault("PREF_LIFELINE_WIDTH", 120);
        this.prefStore.setDefault("PREF_USE_GRADIENT", true);
        this.fontPref = new Hashtable();
        this.foreColorPref = new Hashtable();
        this.backColorPref = new Hashtable();
        Display display = Display.getDefault();
        int n = 0;
        while (n < fontList.length) {
            PreferenceConverter.setDefault((IPreferenceStore)this.prefStore, (String)fontList[n], (FontData[])Display.getDefault().getSystemFont().getFontData());
            ++n;
        }
        int n2 = 0;
        while (n2 < prefBackColorList.length) {
            ColorImpl colorImpl2 = prefBackColorList[n2].equals("PREF_EXEC") || prefBackColorList[n2].equals("PREF_FRAME_NAME") ? new ColorImpl(Display.getDefault(), 201, 222, 233) : (prefBackColorList[n2].equals("PREF_LIFELINE") ? new ColorImpl(Display.getDefault(), 220, 220, 220) : new ColorImpl(Display.getDefault(), 255, 255, 255));
            PreferenceConverter.setDefault((IPreferenceStore)this.prefStore, (String)(prefBackColorList[n2] + BACK_COLOR_POSTFIX), (RGB)((Color)colorImpl2.getColor()).getRGB());
            colorImpl2.dispose();
            ++n2;
        }
        int n3 = 0;
        while (n3 < prefForeColorList.length) {
            colorImpl = prefForeColorList[n3].equals("PREF_LIFELINE") ? new ColorImpl(Display.getDefault(), 129, 129, 129) : (prefForeColorList[n3].equals("PREF_FRAME_NAME") ? new ColorImpl(Display.getDefault(), 81, 153, 200) : new ColorImpl(Display.getDefault(), 134, 176, 212));
            PreferenceConverter.setDefault((IPreferenceStore)this.prefStore, (String)(prefForeColorList[n3] + FORE_COLOR_POSTFIX), (RGB)((Color)colorImpl.getColor()).getRGB());
            colorImpl.dispose();
            ++n3;
        }
        colorImpl = new ColorImpl(Display.getDefault(), 218, 232, 238);
        PreferenceConverter.setDefault((IPreferenceStore)this.prefStore, (String)"PREF_TIME_COMP", (RGB)((Color)colorImpl.getColor()).getRGB());
        colorImpl.dispose();
        this.buildFontsAndColors();
    }

    public IPreferenceStore getPreferenceStore() {
        return this.prefStore;
    }

    public void apply() {
        this.buildFontsAndColors();
        this.prefStore.firePropertyChangeEvent("PREFOK", null, null);
    }

    public static SDViewPref getInstance() {
        if (handle == null) {
            handle = new SDViewPref();
        }
        return handle;
    }

    public IColor getForeGroundColor(String string) {
        if (this.foreColorPref.get(string + FORE_COLOR_POSTFIX) != null && this.foreColorPref.get(string + FORE_COLOR_POSTFIX) instanceof ColorImpl) {
            return (IColor)this.foreColorPref.get(string + FORE_COLOR_POSTFIX);
        }
        return ColorImpl.getSystemColor(2);
    }

    public IColor getBackGroundColor(String string) {
        if (this.backColorPref.get(string + BACK_COLOR_POSTFIX) != null && this.backColorPref.get(string + BACK_COLOR_POSTFIX) instanceof ColorImpl) {
            return (IColor)this.backColorPref.get(string + BACK_COLOR_POSTFIX);
        }
        return ColorImpl.getSystemColor(1);
    }

    public IColor getForeGroundColorSelection() {
        Display display = Display.getDefault();
        return ColorImpl.getSystemColor(27);
    }

    public IColor getBackGroundColorSelection() {
        Display display = Display.getDefault();
        return ColorImpl.getSystemColor(26);
    }

    public IFont getFont(String string) {
        if (this.fontPref.get(string) != null && this.fontPref.get(string) instanceof IFont) {
            return (IFont)this.fontPref.get(string);
        }
        return FontImpl.getSystemFont();
    }

    public int getLifelineWidth() {
        return this.prefStore.getInt("PREF_LIFELINE_WIDTH");
    }

    public boolean fontLinked() {
        return this.prefStore.getBoolean("PREF_LINK_FONT");
    }

    public boolean useGradienColor() {
        return this.prefStore.getBoolean("PREF_USE_GRADIENT");
    }

    public IColor getTimeCompressionSelectionColor() {
        return this.timeCompressionSelectionColor;
    }

    private void buildFontsAndColors() {
        RGB rGB;
        Display display = Display.getDefault();
        int n = 0;
        while (n < fontList.length) {
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)this.prefStore, (String)fontList[n]);
            if (this.fontPref.get(fontList[n]) != null && this.fontPref.get(fontList[n]) instanceof IFont) {
                ((IFont)this.fontPref.get(fontList[n])).dispose();
            }
            this.fontPref.put(fontList[n], new FontImpl(display, fontData));
            ++n;
        }
        int n2 = 0;
        while (n2 < prefBackColorList.length) {
            RGB rGB2 = PreferenceConverter.getColor((IPreferenceStore)this.prefStore, (String)(prefBackColorList[n2] + BACK_COLOR_POSTFIX));
            if (this.backColorPref.get(prefBackColorList[n2] + BACK_COLOR_POSTFIX) != null && this.backColorPref.get(prefBackColorList[n2] + BACK_COLOR_POSTFIX) instanceof IColor) {
                ((IColor)this.backColorPref.get(prefBackColorList[n2] + BACK_COLOR_POSTFIX)).dispose();
            }
            this.backColorPref.put(prefBackColorList[n2] + BACK_COLOR_POSTFIX, new ColorImpl(display, rGB2.red, rGB2.green, rGB2.blue));
            ++n2;
        }
        int n3 = 0;
        while (n3 < prefForeColorList.length) {
            rGB = PreferenceConverter.getColor((IPreferenceStore)this.prefStore, (String)(prefForeColorList[n3] + FORE_COLOR_POSTFIX));
            if (this.foreColorPref.get(prefForeColorList[n3] + FORE_COLOR_POSTFIX) != null && this.foreColorPref.get(prefForeColorList[n3] + FORE_COLOR_POSTFIX) instanceof IColor) {
                ((IColor)this.foreColorPref.get(prefForeColorList[n3] + FORE_COLOR_POSTFIX)).dispose();
            }
            this.foreColorPref.put(prefForeColorList[n3] + FORE_COLOR_POSTFIX, new ColorImpl(display, rGB.red, rGB.green, rGB.blue));
            ++n3;
        }
        rGB = PreferenceConverter.getColor((IPreferenceStore)this.prefStore, (String)"PREF_TIME_COMP");
        if (this.timeCompressionSelectionColor != null) {
            this.timeCompressionSelectionColor.dispose();
        }
        this.timeCompressionSelectionColor = new ColorImpl(display, rGB.red, rGB.green, rGB.blue);
    }

    public void addPropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.prefStore.addPropertyChangeListener(iPropertyChangeListener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.prefStore.removePropertyChangeListener(iPropertyChangeListener);
    }
}

