/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ui.view;

import java.text.MessageFormat;
import org.eclipse.hyades.uml2sd.ui.SDViewerPlugin;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DrawableToolTip
implements PaintListener {
    private Composite parent = null;
    private Shell toolTipShell = null;
    private double min;
    private double max;
    private double currentValue;
    private static int H_MARGIN = 10;
    private static int V_MARGIN = 10;
    private static int TEXT_SCALE_MARGIN = 20;
    private static int SCALE_LENGTH = 100;
    private String unitName = null;
    private Color[] col;

    public DrawableToolTip(Composite composite) {
        this.parent = composite;
        this.toolTipShell = new Shell(this.parent.getShell(), 0);
        this.toolTipShell.setLayout((Layout)new RowLayout());
        this.toolTipShell.setBackground(Display.getDefault().getSystemColor(29));
        this.toolTipShell.addPaintListener((PaintListener)this);
        this.toolTipShell.setSize(200, 50);
        this.col = new Color[10];
        this.col[0] = new Color((Device)Display.getDefault(), 255, 229, 229);
        this.col[1] = new Color((Device)Display.getDefault(), 255, 204, 204);
        this.col[2] = new Color((Device)Display.getDefault(), 255, 178, 178);
        this.col[3] = new Color((Device)Display.getDefault(), 255, 153, 153);
        this.col[4] = new Color((Device)Display.getDefault(), 255, 127, 127);
        this.col[5] = new Color((Device)Display.getDefault(), 255, 102, 102);
        this.col[6] = new Color((Device)Display.getDefault(), 255, 76, 76);
        this.col[7] = new Color((Device)Display.getDefault(), 255, 51, 51);
        this.col[8] = new Color((Device)Display.getDefault(), 255, 25, 25);
        this.col[9] = new Color((Device)Display.getDefault(), 255, 0, 0);
    }

    public void showToolTip(double d, double d2, double d3, String string) {
        this.min = d2;
        this.max = d3;
        this.currentValue = d;
        this.unitName = string;
        int n = this.toolTipShell.getBounds().width;
        int n2 = this.toolTipShell.getBounds().height;
        Point point = Display.getDefault().getCursorLocation();
        this.toolTipShell.setBounds(point.x, point.y + 26, n, n2);
        this.toolTipShell.setVisible(true);
    }

    public void hideToolTip() {
        this.toolTipShell.setVisible(false);
    }

    public void paintControl(PaintEvent paintEvent) {
        String string;
        Object[] objectArray;
        Point point = paintEvent.gc.textExtent(Double.toString(this.currentValue));
        if (point.x < SCALE_LENGTH) {
            point.x = SCALE_LENGTH;
        }
        if (this.unitName == null || this.unitName.equals("")) {
            objectArray = new Object[]{new Double(this.currentValue)};
            string = MessageFormat.format(SDViewerPlugin.getResourceString("POPUP_FORMAT_NO_UNIT"), objectArray);
            paintEvent.gc.drawText(string, H_MARGIN, V_MARGIN, true);
        } else {
            objectArray = new Object[]{new Double(this.currentValue), this.unitName};
            string = MessageFormat.format(SDViewerPlugin.getResourceString("POPUP_FORMAT"), objectArray);
            paintEvent.gc.drawText(string, H_MARGIN, V_MARGIN, true);
        }
        paintEvent.gc.drawLine(H_MARGIN, V_MARGIN + TEXT_SCALE_MARGIN + point.y, H_MARGIN + SCALE_LENGTH, V_MARGIN + TEXT_SCALE_MARGIN + point.y);
        int n = SCALE_LENGTH / 10;
        double d = (this.max - this.min) / 10.0;
        double d2 = Math.abs(this.currentValue + Math.abs(this.min));
        int n2 = 0;
        if (d2 <= Math.abs(this.max + Math.abs(this.min))) {
            n2 = Math.round((float)(d2 / d));
            int n3 = 0;
            while (n3 <= 10) {
                int n4;
                if (n3 < 10) {
                    paintEvent.gc.setBackground(this.col[n3]);
                }
                if (n3 < n2 && n3 < 10) {
                    paintEvent.gc.fillRectangle(H_MARGIN + n3 * n, V_MARGIN + TEXT_SCALE_MARGIN + point.y - 5, n, 11);
                }
                if (n3 == 0) {
                    paintEvent.gc.drawText(SDViewerPlugin.getResourceString("MIN_LABEL"), H_MARGIN, point.y + 2 * V_MARGIN + TEXT_SCALE_MARGIN, true);
                }
                if (n3 == 0) {
                    n4 = paintEvent.gc.textExtent((String)SDViewerPlugin.getResourceString((String)"MAX_LABEL")).x;
                    paintEvent.gc.drawText(SDViewerPlugin.getResourceString("MAX_LABEL"), H_MARGIN + SCALE_LENGTH - n4 + 1, point.y + 2 * V_MARGIN + TEXT_SCALE_MARGIN, true);
                }
                n4 = 10;
                if (n3 == 0 || n3 == 10) {
                    n4 = 14;
                }
                paintEvent.gc.drawLine(H_MARGIN + n3 * n, V_MARGIN + TEXT_SCALE_MARGIN + point.y - n4 / 2, H_MARGIN + n3 * n, V_MARGIN + TEXT_SCALE_MARGIN + point.y + n4 / 2);
                ++n3;
            }
        }
        this.toolTipShell.setSize(point.x + 2 * H_MARGIN + 2, 2 * point.y + 3 * V_MARGIN + TEXT_SCALE_MARGIN);
    }

    public void dispose() {
        int n = 0;
        while (n < this.col.length) {
            this.col[n].dispose();
            ++n;
        }
    }
}

