/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ui.view;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.hyades.uml2sd.ui.SDViewerPlugin;
import org.eclipse.hyades.uml2sd.ui.core.AsyncMessage;
import org.eclipse.hyades.uml2sd.ui.core.BaseMessage;
import org.eclipse.hyades.uml2sd.ui.core.BasicExecutionOccurrence;
import org.eclipse.hyades.uml2sd.ui.core.ExecutionOccurrence;
import org.eclipse.hyades.uml2sd.ui.core.Frame;
import org.eclipse.hyades.uml2sd.ui.core.GraphNode;
import org.eclipse.hyades.uml2sd.ui.core.ITimeRange;
import org.eclipse.hyades.uml2sd.ui.core.Metrics;
import org.eclipse.hyades.uml2sd.ui.core.SyncMessage;
import org.eclipse.hyades.uml2sd.ui.core.TimeEvent;
import org.eclipse.hyades.uml2sd.ui.drawings.impl.ColorImpl;
import org.eclipse.hyades.uml2sd.ui.view.DrawableToolTip;
import org.eclipse.hyades.uml2sd.ui.view.ITimeCompressionListener;
import org.eclipse.hyades.uml2sd.ui.view.SDWidget;
import org.eclipse.hyades.uml2sd.ui.view.ScrollView;
import org.eclipse.hyades.uml2sd.util.TimeEventComparator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class TimeCompressionBar
extends ScrollView
implements DisposeListener {
    private ArrayList listenerList = null;
    private Frame frame = null;
    private List nodeList = null;
    private double min = 0.0;
    private double max = 0.0;
    private float zoomValue = 1.0f;
    private DrawableToolTip c = null;
    private SDWidget sd = null;
    private ColorImpl[] col;

    public TimeCompressionBar(Composite composite, int n) {
        super(composite, n | 0x40000);
        this.setVScrollBarMode(2);
        this.setHScrollBarMode(2);
        this.listenerList = new ArrayList();
        this.col = new ColorImpl[10];
        this.col[0] = new ColorImpl(Display.getDefault(), 255, 229, 229);
        this.col[1] = new ColorImpl(Display.getDefault(), 255, 204, 204);
        this.col[2] = new ColorImpl(Display.getDefault(), 255, 178, 178);
        this.col[3] = new ColorImpl(Display.getDefault(), 255, 153, 153);
        this.col[4] = new ColorImpl(Display.getDefault(), 255, 127, 127);
        this.col[5] = new ColorImpl(Display.getDefault(), 255, 102, 102);
        this.col[6] = new ColorImpl(Display.getDefault(), 255, 76, 76);
        this.col[7] = new ColorImpl(Display.getDefault(), 255, 51, 51);
        this.col[8] = new ColorImpl(Display.getDefault(), 255, 25, 25);
        this.col[9] = new ColorImpl(Display.getDefault(), 255, 0, 0);
        super.addDisposeListener((DisposeListener)this);
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
        this.min = this.frame.getMinTime();
        this.max = this.frame.getMaxTime();
    }

    protected void drawContents(GC gC, int n, int n2, int n3, int n4) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        int n5;
        if (this.frame == null) {
            return;
        }
        this.nodeList = new ArrayList();
        int n6 = 1;
        if ((float)(Metrics.getMessageFontHeigth() + 20) * this.zoomValue < 2.0f) {
            n6 = Math.round(1.0f + 1.0f / ((float)(Metrics.getMessageFontHeigth() + 20) * this.zoomValue));
        }
        if ((n5 = this.frame.getFirstVisibleSyncMessage()) > 0) {
            --n5;
        }
        int n7 = n5;
        while (n7 < this.frame.syncMessageCount()) {
            SyncMessage syncMessage = this.frame.getSyncMessage(n7);
            if (syncMessage.hasTimeInfo()) {
                object4 = new TimeEvent(syncMessage.getFirstTime(), syncMessage.getEventOccurrence(), syncMessage);
                this.nodeList.add(object4);
                if ((float)syncMessage.getY() * this.zoomValue > (float)(this.getContentsY() + this.getVisibleHeight())) break;
            }
            n7 += n6;
        }
        n5 = this.frame.getFirstVisibleSyncMessageReturn();
        if (n5 > 0) {
            --n5;
        }
        int n8 = n5;
        while (n8 < this.frame.syncMessageReturnCount()) {
            object4 = this.frame.getSyncMessageReturn(n8);
            if (((SyncMessage)object4).hasTimeInfo()) {
                object3 = new TimeEvent(((SyncMessage)object4).getFirstTime(), ((BaseMessage)object4).getEventOccurrence(), (ITimeRange)object4);
                this.nodeList.add(object3);
                if ((float)((BaseMessage)object4).getY() * this.zoomValue > (float)(this.getContentsY() + this.getVisibleHeight())) break;
            }
            n8 += n6;
        }
        n5 = this.frame.getFirstVisibleAsyncMessage();
        if (n5 > 0) {
            --n5;
        }
        int n9 = n5;
        while (n9 < this.frame.asyncMessageCount()) {
            object3 = this.frame.getAsyncMessage(n9);
            if (((AsyncMessage)object3).hasTimeInfo()) {
                object2 = new TimeEvent(((AsyncMessage)object3).getFirstTime(), ((AsyncMessage)object3).getStartOccurrence(), (ITimeRange)object3);
                this.nodeList.add(object2);
                object2 = new TimeEvent(((AsyncMessage)object3).getLastTime(), ((AsyncMessage)object3).getEndOccurrence(), (ITimeRange)object3);
                this.nodeList.add(object2);
                if ((float)((AsyncMessage)object3).getY() * this.zoomValue > (float)(this.getContentsY() + this.getVisibleHeight())) break;
            }
            n9 += n6;
        }
        n5 = this.frame.getFirstVisibleAsyncMessageReturn();
        if (n5 > 0) {
            --n5;
        }
        int n10 = n5;
        while (n10 < this.frame.asyncMessageReturnCount()) {
            object2 = this.frame.getAsyncMessageReturn(n10);
            if (((AsyncMessage)object2).hasTimeInfo()) {
                object = new TimeEvent(((AsyncMessage)object2).getFirstTime(), ((AsyncMessage)object2).getStartOccurrence(), (ITimeRange)object2);
                this.nodeList.add(object);
                object = new TimeEvent(((AsyncMessage)object2).getLastTime(), ((AsyncMessage)object2).getEndOccurrence(), (ITimeRange)object2);
                this.nodeList.add(object);
                if ((float)((AsyncMessage)object2).getY() * this.zoomValue > (float)(this.getContentsY() + this.getVisibleHeight())) break;
            }
            n10 += n6;
        }
        object2 = this.frame.getExecutionOccurrencesWithTime();
        if (object2 != null) {
            this.nodeList.addAll(object2);
        }
        object = this.nodeList.toArray();
        Arrays.sort(object, new TimeEventComparator());
        this.nodeList = Arrays.asList(object);
        Image image = null;
        GC gC2 = null;
        if (!SDViewerPlugin.debugDoubleBuffer()) {
            try {
                image = new Image((Device)this.getDisplay(), this.getClientArea().width, this.getClientArea().height);
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
            }
            gC2 = new GC(image);
        } else {
            gC2 = gC;
        }
        int n11 = 0;
        while (n11 < this.nodeList.size() - 1) {
            GraphNode graphNode;
            int n12;
            TimeEvent timeEvent = (TimeEvent)this.nodeList.get(n11);
            TimeEvent timeEvent2 = (TimeEvent)this.nodeList.get(n11 + 1);
            double d = (this.max - this.min) / 10.0;
            double d2 = timeEvent2.getTime() - timeEvent.getTime() - this.min;
            ColorImpl colorImpl = d != 0.0 ? ((n12 = Math.round((float)((d2 /= (double)n6) / d))) < this.col.length && n12 >= 0 ? this.col[n12] : (n12 < 0 ? this.col[0] : this.col[this.col.length - 1])) : this.col[0];
            if (colorImpl.getColor() instanceof Color) {
                gC2.setBackground((Color)colorImpl.getColor());
            }
            n12 = ((GraphNode)((Object)timeEvent.getGraphNode())).getY();
            int n13 = ((GraphNode)((Object)timeEvent2.getGraphNode())).getY();
            if (timeEvent.getGraphNode() instanceof AsyncMessage && ((AsyncMessage)(graphNode = (AsyncMessage)timeEvent.getGraphNode())).getLastTime() == timeEvent.getTime()) {
                n12 += ((AsyncMessage)graphNode).getHeight();
            }
            if (timeEvent2.getGraphNode() instanceof AsyncMessage && ((AsyncMessage)(graphNode = (AsyncMessage)timeEvent2.getGraphNode())).getLastTime() == timeEvent2.getTime()) {
                n13 += ((AsyncMessage)graphNode).getHeight();
            }
            if (timeEvent.getGraphNode() instanceof ExecutionOccurrence) {
                graphNode = (ExecutionOccurrence)timeEvent.getGraphNode();
                if (timeEvent.getEvent() == ((BasicExecutionOccurrence)graphNode).getEndOccurrence()) {
                    n12 += ((BasicExecutionOccurrence)graphNode).getHeight();
                }
                if (timeEvent2.getGraphNode() instanceof ExecutionOccurrence) {
                    ExecutionOccurrence executionOccurrence = (ExecutionOccurrence)timeEvent2.getGraphNode();
                    if (timeEvent2.getEvent() == executionOccurrence.getEndOccurrence()) {
                        n13 += executionOccurrence.getHeight();
                    }
                }
            }
            gC2.fillRectangle(this.contentsToViewX(0), this.contentsToViewY(Math.round((float)n12 * this.zoomValue)), 10, Math.round((float)(n13 - n12) * this.zoomValue) + 1);
            if (n6 == 1) {
                graphNode = gC2.getForeground();
                gC2.setForeground(Display.getDefault().getSystemColor(1));
                gC2.drawRectangle(this.contentsToViewX(0), this.contentsToViewY(Math.round((float)n12 * this.zoomValue)), 9, Math.round((float)(n13 - n12) * this.zoomValue));
                gC2.setForeground((Color)graphNode);
            }
            ++n11;
        }
        if (!SDViewerPlugin.debugDoubleBuffer()) {
            try {
                gC.drawImage(image, 0, 0, this.getClientArea().width, this.getClientArea().height, 0, 0, this.getClientArea().width, this.getClientArea().height);
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
            gC2.dispose();
            image.dispose();
        }
        gC.dispose();
    }

    protected void contentsMouseMoveEvent(MouseEvent mouseEvent) {
        if (this.c != null) {
            this.c.hideToolTip();
        }
        super.contentsMouseMoveEvent(mouseEvent);
    }

    protected void contentsMouseHover(MouseEvent mouseEvent) {
        if (this.c == null) {
            this.c = new DrawableToolTip(this);
        }
        if (this.frame != null) {
            int n = 0;
            while (n < this.nodeList.size() - 1) {
                GraphNode graphNode;
                TimeEvent timeEvent = (TimeEvent)this.nodeList.get(n);
                TimeEvent timeEvent2 = (TimeEvent)this.nodeList.get(n + 1);
                int n2 = ((GraphNode)((Object)timeEvent.getGraphNode())).getY();
                int n3 = ((GraphNode)((Object)timeEvent2.getGraphNode())).getY();
                if (timeEvent.getGraphNode() instanceof AsyncMessage && ((AsyncMessage)(graphNode = (AsyncMessage)timeEvent.getGraphNode())).getLastTime() == timeEvent.getTime()) {
                    n2 += ((AsyncMessage)graphNode).getHeight();
                }
                if (timeEvent2.getGraphNode() instanceof AsyncMessage && ((AsyncMessage)(graphNode = (AsyncMessage)timeEvent2.getGraphNode())).getLastTime() == timeEvent2.getTime()) {
                    n3 += ((AsyncMessage)graphNode).getHeight();
                }
                if (timeEvent.getGraphNode() instanceof ExecutionOccurrence) {
                    graphNode = (ExecutionOccurrence)timeEvent.getGraphNode();
                    if (timeEvent.getEvent() == ((BasicExecutionOccurrence)graphNode).getEndOccurrence()) {
                        n2 += ((BasicExecutionOccurrence)graphNode).getHeight();
                    }
                    if (timeEvent2.getGraphNode() instanceof ExecutionOccurrence) {
                        ExecutionOccurrence executionOccurrence = (ExecutionOccurrence)timeEvent2.getGraphNode();
                        if (timeEvent2.getEvent() == executionOccurrence.getEndOccurrence()) {
                            n3 += executionOccurrence.getHeight();
                        }
                    }
                }
                int n4 = Math.round((float)n2 * this.zoomValue);
                int n5 = Math.round((float)n3 * this.zoomValue);
                if (n4 < mouseEvent.y && n5 >= mouseEvent.y) {
                    double d = timeEvent2.getTime() - timeEvent.getTime();
                    if (this.frame != null) {
                        this.c.showToolTip(d, this.min, this.max, this.frame.getTimeUnitName());
                    } else {
                        this.c.showToolTip(d, this.min, this.max, "");
                    }
                }
                ++n;
            }
        }
    }

    protected void contentsMouseExit(MouseEvent mouseEvent) {
        if (this.c != null) {
            this.c.hideToolTip();
        }
    }

    protected void contentsMouseUpEvent(MouseEvent mouseEvent) {
        if (this.frame != null) {
            int n = 0;
            while (n < this.nodeList.size() - 1) {
                GraphNode graphNode;
                TimeEvent timeEvent = (TimeEvent)this.nodeList.get(n);
                TimeEvent timeEvent2 = (TimeEvent)this.nodeList.get(n + 1);
                int n2 = ((GraphNode)((Object)timeEvent.getGraphNode())).getY();
                int n3 = ((GraphNode)((Object)timeEvent2.getGraphNode())).getY();
                if (timeEvent.getGraphNode() instanceof AsyncMessage && ((AsyncMessage)(graphNode = (AsyncMessage)timeEvent.getGraphNode())).getLastTime() == timeEvent.getTime()) {
                    n2 += ((AsyncMessage)graphNode).getHeight();
                }
                if (timeEvent2.getGraphNode() instanceof AsyncMessage && ((AsyncMessage)(graphNode = (AsyncMessage)timeEvent2.getGraphNode())).getLastTime() == timeEvent2.getTime()) {
                    n3 += ((AsyncMessage)graphNode).getHeight();
                }
                if (timeEvent.getGraphNode() instanceof ExecutionOccurrence) {
                    graphNode = (ExecutionOccurrence)timeEvent.getGraphNode();
                    if (timeEvent.getEvent() == ((BasicExecutionOccurrence)graphNode).getEndOccurrence()) {
                        n2 += ((BasicExecutionOccurrence)graphNode).getHeight();
                    }
                    if (timeEvent2.getGraphNode() instanceof ExecutionOccurrence) {
                        ExecutionOccurrence executionOccurrence = (ExecutionOccurrence)timeEvent2.getGraphNode();
                        if (timeEvent2.getEvent() == executionOccurrence.getEndOccurrence()) {
                            n3 += executionOccurrence.getHeight();
                        }
                    }
                }
                int n4 = Math.round((float)n2 * this.zoomValue);
                int n5 = Math.round((float)n3 * this.zoomValue);
                if (n4 < mouseEvent.y && n5 >= mouseEvent.y) {
                    double d = (this.max - this.min) / 10.0;
                    double d2 = Math.abs(timeEvent2.getTime() - timeEvent.getTime() - this.min);
                    int n6 = 0;
                    if (d != 0.0) {
                        n6 = Math.round((float)(d2 / d));
                        if (n6 >= this.col.length) {
                            n6 = this.col.length - 1;
                        } else if (n6 < 0) {
                            n6 = 0;
                        }
                    } else {
                        n6 = 0;
                    }
                    int n7 = 0;
                    while (n7 < this.listenerList.size()) {
                        GraphNode graphNode2;
                        ITimeCompressionListener iTimeCompressionListener = (ITimeCompressionListener)this.listenerList.get(n7);
                        if (timeEvent.getGraphNode() instanceof BaseMessage) {
                            graphNode2 = (BaseMessage)((Object)timeEvent.getGraphNode());
                            if (((BaseMessage)graphNode2).getEndLifeline() != null) {
                                iTimeCompressionListener.deltaSelected(((BaseMessage)graphNode2).getEndLifeline(), timeEvent.getEvent(), timeEvent2.getEvent() - timeEvent.getEvent(), this.col[n6]);
                            } else {
                                iTimeCompressionListener.deltaSelected(((BaseMessage)graphNode2).getStartLifeline(), timeEvent.getEvent(), timeEvent2.getEvent() - timeEvent.getEvent(), this.col[n6]);
                            }
                        } else if (timeEvent.getGraphNode() instanceof ExecutionOccurrence) {
                            if (timeEvent2.getGraphNode() instanceof ExecutionOccurrence) {
                                graphNode2 = (ExecutionOccurrence)timeEvent.getGraphNode();
                                iTimeCompressionListener.deltaSelected(((BasicExecutionOccurrence)graphNode2).getLifeline(), timeEvent.getEvent(), timeEvent2.getEvent() - timeEvent.getEvent(), this.col[n6]);
                            } else {
                                graphNode2 = (ExecutionOccurrence)timeEvent.getGraphNode();
                                iTimeCompressionListener.deltaSelected(((BasicExecutionOccurrence)graphNode2).getLifeline(), timeEvent.getEvent(), timeEvent2.getEvent() - timeEvent.getEvent(), this.col[n6]);
                            }
                        }
                        ++n7;
                    }
                }
                ++n;
            }
        }
        super.contentsMouseUpEvent(mouseEvent);
    }

    public void scrollBy(int n, int n2) {
    }

    public void setZoom(float f) {
        this.zoomValue = f;
        this.redraw();
    }

    public void addTimeCompressionListener(ITimeCompressionListener iTimeCompressionListener) {
        if (!this.listenerList.contains(iTimeCompressionListener)) {
            this.listenerList.add(iTimeCompressionListener);
        }
    }

    public void removeSelectionChangedListener(ITimeCompressionListener iTimeCompressionListener) {
        ((AbstractCollection)this.listenerList).remove(iTimeCompressionListener);
    }

    public void widgetDisposed(DisposeEvent disposeEvent) {
        if (this.c != null) {
            this.c.dispose();
        }
        super.removeDisposeListener((DisposeListener)this);
        int n = 0;
        while (n < this.col.length) {
            this.col[n].dispose();
            ++n;
        }
    }
}

