/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.provider;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.hyades.ui.util.ILabelAndDescriptionProvider;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;

public class LabelProviderPicker
implements ILabelAndDescriptionProvider {
    private ListenerList listenerList = new ListenerList();
    private List providers = new ArrayList();
    private int currentProvider = -1;

    public void dispose() {
        this.currentProvider = -1;
        Iterator iterator = this.providers.iterator();
        while (iterator.hasNext()) {
            ILabelProvider iLabelProvider = (ILabelProvider)iterator.next();
            iLabelProvider.dispose();
        }
        this.providers.clear();
    }

    public void addProvider(ILabelProvider iLabelProvider) {
        if (this.providers.add(iLabelProvider)) {
            if (this.currentProvider < 0) {
                this.currentProvider = this.providers.size() - 1;
            }
            Object[] objectArray = this.listenerList.getListeners();
            int n = 0;
            int n2 = objectArray.length;
            while (n < n2) {
                iLabelProvider.addListener((ILabelProviderListener)objectArray[n]);
                ++n;
            }
        }
    }

    public void clearProviders() {
        Object[] objectArray = this.listenerList.getListeners();
        Iterator iterator = this.providers.iterator();
        while (iterator.hasNext()) {
            ILabelProvider iLabelProvider = (ILabelProvider)iterator.next();
            int n = 0;
            int n2 = objectArray.length;
            while (n < n2) {
                iLabelProvider.addListener((ILabelProviderListener)objectArray[n]);
                ++n;
            }
        }
        this.currentProvider = -1;
        this.listenerList.clear();
        this.providers.clear();
    }

    public void removeProvider(int n) {
        if (n == this.currentProvider) {
            this.currentProvider = -1;
        } else if (n < this.currentProvider) {
            --this.currentProvider;
        }
        ILabelProvider iLabelProvider = (ILabelProvider)this.providers.remove(n);
        if (iLabelProvider != null) {
            Object[] objectArray = this.listenerList.getListeners();
            int n2 = 0;
            int n3 = objectArray.length;
            while (n2 < n3) {
                iLabelProvider.removeListener((ILabelProviderListener)objectArray[n2]);
                ++n2;
            }
        }
    }

    public boolean setCurrentProvider(int n) {
        if (n < 0 || n >= this.providers.size()) {
            return false;
        }
        if (n == this.currentProvider) {
            return true;
        }
        this.currentProvider = n;
        return true;
    }

    public ILabelProvider getCurrentProvider() {
        if (this.currentProvider < 0) {
            return null;
        }
        return (ILabelProvider)this.providers.get(this.currentProvider);
    }

    public int getCurrentProviderIndex() {
        return this.currentProvider;
    }

    public void addListener(ILabelProviderListener iLabelProviderListener) {
        this.listenerList.add((Object)iLabelProviderListener);
        Iterator iterator = this.providers.iterator();
        while (iterator.hasNext()) {
            ((ILabelProvider)iterator.next()).addListener(iLabelProviderListener);
        }
    }

    public void removeListener(ILabelProviderListener iLabelProviderListener) {
        this.listenerList.remove((Object)iLabelProviderListener);
        Iterator iterator = this.providers.iterator();
        while (iterator.hasNext()) {
            ((ILabelProvider)iterator.next()).removeListener(iLabelProviderListener);
        }
    }

    public String getDescription(Object object) {
        if (this.getCurrentProviderIndex() < 0) {
            return null;
        }
        ILabelProvider iLabelProvider = this.getCurrentProvider();
        if (iLabelProvider instanceof ILabelAndDescriptionProvider) {
            return ((ILabelAndDescriptionProvider)iLabelProvider).getDescription(object);
        }
        return null;
    }

    public Image getImage(Object object) {
        if (this.getCurrentProviderIndex() < 0) {
            return null;
        }
        return this.getCurrentProvider().getImage(object);
    }

    public String getText(Object object) {
        if (this.getCurrentProviderIndex() < 0) {
            return null;
        }
        return this.getCurrentProvider().getText(object);
    }

    public boolean isLabelProperty(Object object, String string) {
        if (this.getCurrentProviderIndex() < 0) {
            return false;
        }
        return this.getCurrentProvider().isLabelProperty(object, string);
    }
}

