/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.security.AccessController;
import java.util.Hashtable;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import sun.security.action.GetPropertyAction;

public class FileUtil {
    public static String normalizePath(String string) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim().replace('\\', '/')).endsWith("/") && !string.endsWith("//")) {
            string = string.substring(0, string.length() - "/".length());
        }
        return string;
    }

    public static String appendPath(String string, String string2) {
        string = FileUtil.normalizePath(string);
        string2 = FileUtil.normalizePath(string2);
        if (string == null || string.trim().length() == 0) {
            return string2;
        }
        if (string2 == null || string2.trim().length() == 0) {
            return string;
        }
        if (string.endsWith("//")) {
            if (string2.startsWith("/") && string2.length() > 1) {
                string2 = string2.substring(1);
            }
        } else if (!string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        return string + string2;
    }

    public static int streamCopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        InputStream inputStream2 = inputStream;
        synchronized (inputStream2) {
            OutputStream outputStream2 = outputStream;
            synchronized (outputStream2) {
                int n = 0;
                int n2 = 0;
                byte[] byArray = new byte[256];
                while ((n2 = inputStream.read(byArray)) != -1) {
                    n += n2;
                    outputStream.write(byArray, 0, n2);
                }
                int n3 = n;
                return n3;
            }
        }
    }

    public static String removeLastSegment(String string) {
        int n = (string = FileUtil.normalizePath(string)).lastIndexOf("/");
        if (n < 0) {
            return "";
        }
        return string.substring(0, n);
    }

    public static String getLastSegment(String string) {
        int n = (string = FileUtil.normalizePath(string)).lastIndexOf("/");
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public static File getValidFileOrDirectory(File file) {
        if (file == null || !file.exists()) {
            return null;
        }
        try {
            return file.getAbsoluteFile().getCanonicalFile();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static boolean writeToFile(String string, File file, boolean bl, String string2) {
        File file2;
        if (file == null) {
            return false;
        }
        if (!bl && (file2 = FileUtil.getValidFileOrDirectory(file)) != null && file.isFile() && file.exists()) {
            file2.delete();
            file = file2;
        }
        if (string2 == null || string2.length() == 0) {
            return true;
        }
        try {
            return FileUtil.writeToOutputStream(string, new FileOutputStream(file.toString(), bl), string2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean writeToOutputStream(String string, OutputStream outputStream, String string2) {
        try {
            OutputStreamWriter outputStreamWriter = null;
            try {
                outputStreamWriter = string != null ? new OutputStreamWriter(outputStream, string) : new OutputStreamWriter(outputStream);
                outputStreamWriter.write(string2);
                ((Writer)outputStreamWriter).flush();
                Object var5_5 = null;
                if (outputStream == null) return true;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (outputStream == null) throw throwable;
                outputStream.close();
                throw throwable;
            }
            outputStream.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static String readFromFile(String string, File file, boolean bl) throws IOException {
        if (file == null) {
            return null;
        }
        if (!file.exists()) {
            return null;
        }
        return FileUtil.readFromInputStream(string, new FileInputStream(file), bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String readFromInputStream(String string, InputStream inputStream, boolean bl) throws IOException {
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n;
            InputStreamReader inputStreamReader = null;
            inputStreamReader = string != null ? new InputStreamReader(inputStream, string) : new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            while ((n = ((Reader)bufferedReader).read()) > -1) {
                stringBuffer.append((char)n);
            }
            string2 = stringBuffer.toString();
            Object var9_8 = null;
            if (bl) return string2;
            if (inputStream == null) return string2;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (bl || inputStream == null) throw throwable;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map getZipEntryDataByZipEntryName(String string) {
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        Hashtable<String, byte[]> hashtable2 = new Hashtable<String, byte[]>();
        try {
            ZipEntry zipEntry;
            byte[] byArray;
            Object object;
            block13: {
                ZipFile zipFile = null;
                try {
                    zipFile = new ZipFile(string);
                    object = zipFile.entries();
                    while (true) {
                        if (!object.hasMoreElements()) {
                            byArray = null;
                            if (zipFile == null) break block13;
                            break;
                        }
                        zipEntry = object.nextElement();
                        hashtable.put(zipEntry.getName(), new Integer((int)zipEntry.getSize()));
                    }
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    if (zipFile == null) throw throwable;
                    zipFile.close();
                    throw throwable;
                }
                zipFile.close();
            }
            object = null;
            try {
                object = new ZipInputStream(new BufferedInputStream(new FileInputStream(string)));
                zipEntry = ((ZipInputStream)object).getNextEntry();
                while (true) {
                    if (zipEntry == null) {
                        Object var11_13 = null;
                        if (object == null) return hashtable2;
                        break;
                    }
                    if (!zipEntry.isDirectory()) {
                        int n = (int)zipEntry.getSize();
                        if (n == -1) {
                            n = (Integer)hashtable.get(zipEntry.getName());
                        }
                        byArray = new byte[n];
                        int n2 = 0;
                        int n3 = 0;
                        while (n - n2 > 0 && (n3 = ((ZipInputStream)object).read(byArray, n2, n - n2)) != -1) {
                            n2 += n3;
                        }
                        hashtable2.put(zipEntry.getName(), byArray);
                    }
                    zipEntry = ((ZipInputStream)object).getNextEntry();
                }
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                if (object == null) throw throwable;
                ((ZipInputStream)object).close();
                throw throwable;
            }
            ((ZipInputStream)object).close();
            return hashtable2;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hashtable2;
    }

    public static String getFileExtension(File file) {
        if (file == null || file.isDirectory()) {
            return "";
        }
        return FileUtil.getFileExtension(file.getName());
    }

    public static String getFileExtension(String string) {
        if (string == null) {
            return "";
        }
        int n = string.lastIndexOf(".");
        if (n < 0) {
            return "";
        }
        if (n == string.length() - 1) {
            return "";
        }
        return string.substring(n + 1);
    }

    public static boolean isParent(File file, File file2) {
        if (file2 == null || file == null) {
            return false;
        }
        file = file.getAbsoluteFile();
        file2 = file2.getAbsoluteFile();
        while (file2 != null) {
            if (file.equals(file2)) {
                return true;
            }
            file2 = file2.getParentFile();
        }
        return false;
    }

    public static File getTempDir() {
        GetPropertyAction getPropertyAction = new GetPropertyAction("java.io.tmpdir");
        String string = AccessController.doPrivileged(getPropertyAction);
        return new File(string);
    }

    public static int delete(File file) {
        if (file.isFile()) {
            return file.delete() ? 1 : 0;
        }
        if (file.isDirectory()) {
            int n = 0;
            File[] fileArray = file.listFiles();
            int n2 = 0;
            while (n2 < fileArray.length) {
                n += FileUtil.delete(fileArray[n2]);
                ++n2;
            }
            return n += file.delete() ? 1 : 0;
        }
        return 0;
    }

    public static int copyFiles(File[] fileArray, File file, boolean bl) throws IOException {
        if (fileArray == null || fileArray.length == 0 || file == null) {
            return 0;
        }
        if (file.exists()) {
            if (!file.isDirectory()) {
                return 0;
            }
        } else {
            file.mkdirs();
        }
        int n = 0;
        int n2 = 0;
        int n3 = fileArray.length;
        while (n2 < n3) {
            block11: {
                Object var10_9;
                File file2;
                block13: {
                    block12: {
                        if (fileArray[n2] == null || !fileArray[n2].exists() || !fileArray[n2].isFile()) break block11;
                        file2 = new File(file, fileArray[n2].getName());
                        if (file2.exists() && file2.isFile()) break block12;
                        file2.createNewFile();
                        break block13;
                    }
                    if (!bl) break block11;
                }
                FileInputStream fileInputStream = new FileInputStream(fileArray[n2]);
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                try {
                    FileUtil.streamCopy(fileInputStream, fileOutputStream);
                    ++n;
                    var10_9 = null;
                }
                catch (Throwable throwable) {
                    var10_9 = null;
                    fileInputStream.close();
                    fileOutputStream.close();
                    throw throwable;
                }
                fileInputStream.close();
                fileOutputStream.close();
                {
                }
            }
            ++n2;
        }
        return n;
    }
}

