/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.internal.ui;

import java.util.Iterator;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.models.hierarchy.util.IUnresolvedResourceHelper;
import org.eclipse.hyades.trace.internal.ui.PDContentProvider;
import org.eclipse.hyades.trace.internal.ui.PDLabelProvider;
import org.eclipse.hyades.trace.internal.ui.PDProjectViewer;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.IProfileEventListener;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.actions.TraceNavigatorActionGroup;
import org.eclipse.hyades.trace.ui.internal.core.TraceAssociationManager;
import org.eclipse.hyades.trace.ui.internal.launcher.AttachTraceAction;
import org.eclipse.hyades.trace.ui.internal.launcher.LaunchTraceAction;
import org.eclipse.hyades.trace.ui.internal.util.UnresolvedResourceHelper;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.ui.internal.navigator.Navigator;
import org.eclipse.hyades.ui.internal.navigator.action.NavigatorActionGroup;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class PDProjectExplorer
extends Navigator
implements IProfileEventListener,
IPropertyListener {
    private final String TRACE_SECTION = "TraceNavigator";
    protected TraceNavigatorActionGroup actionGroup;

    public PDProjectExplorer() {
        IUnresolvedResourceHelper iUnresolvedResourceHelper = HierarchyResourceSetImpl.getInstance().getUnresolvedException();
        if (iUnresolvedResourceHelper != null && iUnresolvedResourceHelper instanceof UnresolvedResourceHelper) {
            ((UnresolvedResourceHelper)iUnresolvedResourceHelper).setPDProjectExplorer(this);
        }
    }

    public void createPartControl(Composite composite) {
        TraceAssociationManager.getTraceViewMappingRegistry().addCommitChangeListener((IPropertyListener)this);
        super.createPartControl(composite);
        this.initListeners();
        UIPlugin.getDefault().addSelectionProvider((ISelectionProvider)this.getViewer(), (IWorkbenchPart)this);
        UIPlugin.getDefault().addProfileEventListener(this);
        new RefreshUI().start();
    }

    protected void updateActionBars(IStructuredSelection iStructuredSelection) {
        TraceNavigatorActionGroup traceNavigatorActionGroup = (TraceNavigatorActionGroup)this.getActionGroup(false);
        if (traceNavigatorActionGroup != null) {
            traceNavigatorActionGroup.setContext(new ActionContext((ISelection)iStructuredSelection));
            traceNavigatorActionGroup.updateActionBars();
        }
    }

    public void updateActionBars() {
        TraceNavigatorActionGroup traceNavigatorActionGroup = (TraceNavigatorActionGroup)this.getActionGroup(false);
        if (traceNavigatorActionGroup != null) {
            traceNavigatorActionGroup.updateActionBars();
        }
    }

    public void dispose() {
        TraceAssociationManager.getTraceViewMappingRegistry().removeCommitChangeListener((IPropertyListener)this);
        if (this.getActionGroup(true) != null) {
            this.getActionGroup(true).dispose();
            this.actionGroup = null;
        }
        UIPlugin.getDefault().removeProfileEventListener(this);
        if (this.getViewer() != null) {
            UIPlugin.getDefault().removeSelectionProvider((ISelectionProvider)this.getViewer(), (IWorkbenchPart)this);
        }
        HyadesUtil.cleanupResources("org.eclipse.hyades.trace.internal.ui.PDProjectExplorer");
        super.dispose();
    }

    public final boolean hasFilter(int n) {
        return ((PDProjectViewer)this.getViewer()).hasFilter(n);
    }

    public Control getControl() {
        return this.getViewer().getControl();
    }

    public void refresh() {
        this.getViewer().refresh();
    }

    protected void initContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                PDProjectExplorer.this.fillContextMenu(iMenuManager);
            }
        });
        Menu menu = menuManager.createContextMenu((Control)((PDProjectViewer)this.getViewer()).getTree());
        ((PDProjectViewer)this.getViewer()).getTree().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.getViewer());
    }

    protected void initListeners() {
        this.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                PDProjectExplorer.this.handleDoubleClick(doubleClickEvent);
            }
        });
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getViewer().getSelection();
        this.getActionGroup(false).setContext(new ActionContext((ISelection)iStructuredSelection));
        this.getActionGroup(false).fillContextMenu(iMenuManager);
    }

    public static PDProjectExplorer getFromActivePerspective() {
        IViewPart iViewPart = UIPlugin.getActivePage().findView("org.eclipse.hyades.trace.internal.ui.PDProjectExplorer");
        if (iViewPart instanceof PDProjectExplorer) {
            return (PDProjectExplorer)iViewPart;
        }
        return null;
    }

    protected String getToolTipText() {
        return UIPlugin.getResourceString("PDPROEXPTOOLTIP");
    }

    protected NavigatorActionGroup getActionGroup() {
        return this.actionGroup;
    }

    protected NavigatorActionGroup getActionGroup(boolean bl) {
        if (!bl && this.actionGroup == null) {
            this.createActions();
        }
        return this.getActionGroup();
    }

    protected void setActionGroup(TraceNavigatorActionGroup traceNavigatorActionGroup) {
        this.actionGroup = traceNavigatorActionGroup;
    }

    protected void handleDoubleClick(DoubleClickEvent doubleClickEvent) {
        ((TraceNavigatorActionGroup)this.getActionGroup(false)).handleDoubleClick(doubleClickEvent);
    }

    public void refreshView(Object object) {
        this.getViewer().refresh();
        ((PDProjectViewer)this.getViewer()).selectObject(object);
    }

    public void selectObject(Object object) {
        ((PDProjectViewer)this.getViewer()).selectObject(object);
    }

    public void setFocus() {
        if (this.getViewer() != null) {
            ((PDProjectViewer)this.getViewer()).getTree().setFocus();
        }
    }

    private void addLaunchOptions(IMenuManager iMenuManager) {
        iMenuManager.add((IAction)new LaunchTraceAction());
        iMenuManager.add((IAction)new AttachTraceAction());
    }

    public void handleProfileEvent(ProfileEvent profileEvent) {
        switch (profileEvent.getType()) {
            case 1: {
                ((PDProjectViewer)this.getViewer()).selectObject(profileEvent.getSource());
                break;
            }
            case 4: {
                ((PDProjectViewer)this.getViewer()).selectObject(profileEvent.getSource());
                break;
            }
            case 4096: {
                break;
            }
            case 4608: {
                break;
            }
            default: {
                ((PDProjectViewer)this.getViewer()).refresh(profileEvent.getSource());
            }
        }
    }

    public void propertyChanged(Object object, int n) {
        ((TraceNavigatorActionGroup)this.getActionGroup(false)).propertyChanged(object, n);
    }

    public void setLinkingEnabled(boolean bl) {
        super.setLinkingEnabled(bl);
        if (bl && this.getViewer() != null) {
            this.getViewer().setSelection(this.getViewer().getSelection());
        }
    }

    public AbstractUIPlugin getPlugin() {
        return UIPlugin.getDefault();
    }

    public String getStoreSection() {
        return "TraceNavigator";
    }

    protected void createActions() {
        this.setActionGroup(new TraceNavigatorActionGroup((INavigator)this));
    }

    protected Object createViewerInput() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    protected StructuredViewer createViewer(Composite composite) {
        PDProjectViewer pDProjectViewer = new PDProjectViewer(composite);
        pDProjectViewer.setContentProvider((IContentProvider)new PDContentProvider(this));
        pDProjectViewer.setLabelProvider((IBaseLabelProvider)new PDLabelProvider());
        return pDProjectViewer;
    }

    protected boolean editorActivated(IEditorPart iEditorPart) {
        return false;
    }

    protected void linkToEditor(IStructuredSelection iStructuredSelection) {
    }

    public boolean isShowingFolders() {
        return false;
    }

    public Shell getShell() {
        return this.getViewSite().getShell();
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
    }

    public void clear() {
        Iterator iterator = HierarchyResourceSetImpl.getInstance().getResources().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            ++n;
            iterator.next();
        }
        if (n < 2) {
            if (this.getActionGroup(true) != null) {
                this.getActionGroup(true).dispose();
                this.actionGroup = null;
            }
            ProfileEvent profileEvent = new ProfileEvent();
            profileEvent.setSource(null);
            profileEvent.setType(4096);
            UIPlugin.getDefault().notifyProfileEventListener(profileEvent);
        }
        this.refresh();
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
    }

    public void partActivated(IWorkbenchPart iWorkbenchPart) {
        super.partActivated(iWorkbenchPart);
        if (iWorkbenchPart == this) {
            this.getViewer().setSelection((ISelection)((Navigator)iWorkbenchPart).getStructuredSelection());
        }
    }

    public void partBroughtToTop(IWorkbenchPart iWorkbenchPart) {
        super.partBroughtToTop(iWorkbenchPart);
        if (iWorkbenchPart == this) {
            this.getViewer().setSelection((ISelection)((Navigator)iWorkbenchPart).getStructuredSelection());
        }
    }

    class RefreshUI
    extends Thread {
        public RefreshUI() {
            super("Profile_Refresh");
        }

        public void run() {
            while (PDProjectExplorer.this.getViewer() != null) {
                try {
                    IPreferenceStore iPreferenceStore = UIPlugin.getDefault().getPreferenceStore();
                    int n = iPreferenceStore.getInt("refresh_type");
                    Display display = Display.getDefault();
                    if (n == 1 && display != null && !display.isDisposed()) {
                        display.asyncExec(new Runnable(this){
                            private final /* synthetic */ RefreshUI this$1;
                            {
                                this.this$1 = refreshUI;
                            }

                            public void run() {
                                EObject eObject;
                                TreeItem treeItem = ((PDProjectViewer)RefreshUI.access$000(this.this$1).getViewer()).getTreeSelection();
                                if (treeItem != null && treeItem.getData() instanceof EObject && RefreshUI.access$100(this.this$1, eObject = (EObject)treeItem.getData())) {
                                    ProfileEvent profileEvent = UIPlugin.getDefault().getUpdateModelEvent(eObject);
                                    UIPlugin.getDefault().notifyProfileEventListener(profileEvent);
                                }
                            }
                        });
                    }
                    Thread.sleep(iPreferenceStore.getInt("refresh_int") * 1000);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        private boolean isModified(Object object) {
            if (object != null) {
                if (object instanceof TRCAgentProxy) {
                    return this.isAgentModified((TRCAgentProxy)object);
                }
                if (object instanceof TRCProcessProxy) {
                    Object[] objectArray = ((TRCProcessProxy)object).getAgentProxies().toArray();
                    int n = 0;
                    while (n < objectArray.length) {
                        boolean bl = this.isAgentModified((TRCAgentProxy)objectArray[n]);
                        if (bl) {
                            return true;
                        }
                        ++n;
                    }
                    return false;
                }
                if (object instanceof TRCNode) {
                    Object[] objectArray = ((TRCNode)object).getProcessProxies().toArray();
                    int n = 0;
                    while (n < objectArray.length) {
                        Object[] objectArray2 = ((TRCProcessProxy)objectArray[n]).getAgentProxies().toArray();
                        int n2 = 0;
                        while (n2 < objectArray2.length) {
                            boolean bl = this.isAgentModified((TRCAgentProxy)objectArray2[n2]);
                            if (bl) {
                                return true;
                            }
                            ++n2;
                        }
                        ++n;
                    }
                    return false;
                }
                if (object instanceof TRCMonitor) {
                    Object[] objectArray = ((TRCMonitor)object).getNodes().toArray();
                    int n = 0;
                    while (n < objectArray.length) {
                        Object[] objectArray3 = ((TRCNode)objectArray[n]).getProcessProxies().toArray();
                        int n3 = 0;
                        while (n3 < objectArray3.length) {
                            Object[] objectArray4 = ((TRCProcessProxy)objectArray3[n3]).getAgentProxies().toArray();
                            int n4 = 0;
                            while (n4 < objectArray4.length) {
                                boolean bl = this.isAgentModified((TRCAgentProxy)objectArray4[n4]);
                                if (bl) {
                                    return true;
                                }
                                ++n4;
                            }
                            ++n3;
                        }
                        ++n;
                    }
                    return false;
                }
            }
            return false;
        }

        private boolean isAgentModified(TRCAgentProxy tRCAgentProxy) {
            if (tRCAgentProxy.getType().equals("Profiler")) {
                if (tRCAgentProxy.isCollectionData()) {
                    return true;
                }
                if (tRCAgentProxy.getAgent() != null && tRCAgentProxy.getAgent().eResource() != null && tRCAgentProxy.getAgent().eResource().isModified()) {
                    tRCAgentProxy.getAgent().eResource().setModified(false);
                    return true;
                }
                return false;
            }
            if (tRCAgentProxy.getAgent() != null && tRCAgentProxy.getAgent().eResource() != null && tRCAgentProxy.getAgent().eResource().isModified()) {
                tRCAgentProxy.getAgent().eResource().setModified(false);
                return true;
            }
            return false;
        }

        static /* synthetic */ PDProjectExplorer access$000(RefreshUI refreshUI) {
            return refreshUI.PDProjectExplorer.this;
        }

        static /* synthetic */ boolean access$100(RefreshUI refreshUI, Object object) {
            return refreshUI.isModified(object);
        }
    }
}

