/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.internal.execution.local.control.Application;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.models.hierarchy.util.SaveUtil;
import org.eclipse.hyades.security.util.ConnectUtil;
import org.eclipse.hyades.trace.internal.ui.TraceUIManager;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.ui.internal.navigator.Navigator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

public class HyadesUtil {
    public static final int CONNECTION_SUCCESS = 0;
    public static final int CONNECTION_CONTROLLER_ERROR = 1;
    public static final int CONNECTION_HOST_ERROR = 2;
    public static final int CONNECTION_PORT_ERROR = 3;
    private static StringBuffer tmpBuffer = new StringBuffer();

    public static String change(String string, String string2, String string3) {
        if (string2.length() == 0) {
            return string;
        }
        if (string2.length() == 1 && string3.length() == 1) {
            return string.replace(string2.charAt(0), string3.charAt(0));
        }
        int n = 0;
        int n2 = 0;
        tmpBuffer.setLength(0);
        while ((n2 = string.indexOf(string2, n)) != -1) {
            tmpBuffer.append(string.substring(n, n2)).append(string3);
            n = n2 + string2.length();
        }
        tmpBuffer.append(string.substring(n));
        return tmpBuffer.toString();
    }

    public static String getAgentName(TRCAgentProxy tRCAgentProxy) {
        String string = tRCAgentProxy.getType();
        String string2 = tRCAgentProxy.getName();
        if (string2 == null) {
            string2 = "";
        }
        if (string.equals("Profiler")) {
            if (!string2.equals("J2EE Request Profiler")) {
                string2 = UIPlugin.getResourceString("TRACE_NAME");
            }
        } else if (string.equals("Logging") && string2.equals("")) {
            string2 = UIPlugin.getResourceString("LOG_NAME");
        }
        if (tRCAgentProxy.getStartTime() > 0.0) {
            Date date = new Date((long)tRCAgentProxy.getStartTime() * 1000L);
            String string3 = DateFormat.getDateTimeInstance(3, 2).format(date);
            string2 = string2 + " (" + string3 + ")";
        }
        return string2;
    }

    public static String getProcessName(TRCProcessProxy tRCProcessProxy) {
        tmpBuffer.setLength(0);
        return tmpBuffer.append(tRCProcessProxy.getName()).append(" [ PID:").append(tRCProcessProxy.getPid()).append(" ]").toString();
    }

    public static String getAgentLabel(TRCAgentProxy tRCAgentProxy) {
        tmpBuffer.setLength(0);
        if (tRCAgentProxy.isActive() && tRCAgentProxy.isMonitored()) {
            tmpBuffer.append("<").append(UIPlugin.getResourceString("AGENT_MONITORED"));
        } else if (tRCAgentProxy.isActive() && tRCAgentProxy.isAttached()) {
            tmpBuffer.append("<").append(UIPlugin.getResourceString("AGENT_ATTACHED"));
        } else if (tRCAgentProxy.isActive()) {
            tmpBuffer.append("<").append(UIPlugin.getResourceString("AGENT_DETACTED"));
        } else {
            tmpBuffer.append("<").append(UIPlugin.getResourceString("AGENT_TERMINATED"));
        }
        if (tRCAgentProxy.isCollectionData()) {
            tmpBuffer.append(UIPlugin.getResourceString("STR_COLLECTING")).append(">");
        } else {
            tmpBuffer.append(">");
        }
        return tmpBuffer.toString();
    }

    public static int testConnection(String string, String string2, boolean bl, Shell shell) {
        if (string == null || string.trim() == "" || string2 == null || string2.trim() == "") {
            String string3 = UIPlugin.getResourceString("INVALID_HOST");
            Status status = new Status(2, "org.eclipse.core.resources", 2, string3, null);
            ErrorDialog.openError((Shell)shell, (String)UIPlugin.getResourceString("STR_TITLE_MSG"), (String)UIPlugin.getResourceString("CONNECT_ERROR_"), (IStatus)status);
            return 2;
        }
        IPreferenceStore iPreferenceStore = UIPlugin.getDefault().getPreferenceStore();
        ConnectUtil connectUtil = new ConnectUtil(string, string2, iPreferenceStore.getString("user_id"), (Application)UIPlugin.getDefault());
        int n = connectUtil.connect();
        if (n == 0) {
            iPreferenceStore.setValue("user_id", connectUtil.getUserId());
            if (bl) {
                String string4 = UIPlugin.getResourceString("CONNECTION_SUCCESS_TEXT");
                MessageDialog.openInformation((Shell)shell, (String)UIPlugin.getResourceString("STR_HYADES_MSG"), (String)string4);
            }
        }
        return n;
    }

    public static IResource getSelectionFolder(Object object) {
        if (object != null) {
            if (object instanceof IResource) {
                return (IResource)object;
            }
            if (object instanceof EObject) {
                String string = TString.resourcePath(((EObject)object).eResource().getURI());
                return UIPlugin.getPluginWorkbench().getRoot().findMember(new Path(string).removeLastSegments(1));
            }
        }
        return null;
    }

    public static IResource getSelectionFolder(INavigator iNavigator) {
        if (!iNavigator.getStructuredSelection().isEmpty()) {
            return HyadesUtil.getSelectionFolder(iNavigator.getStructuredSelection().getFirstElement());
        }
        return null;
    }

    public static void cleanupResources(String string) {
        Object object;
        IWorkbenchWindow iWorkbenchWindow;
        ProfileEvent profileEvent = new ProfileEvent();
        profileEvent.setSource(null);
        profileEvent.setType(4096);
        UIPlugin.getDefault().notifyProfileEventListener(profileEvent);
        Object object2 = null;
        IWorkbenchWindow[] iWorkbenchWindowArray = UIPlugin.getDefault().getWorkbench().getWorkbenchWindows();
        int n = 0;
        while (n < iWorkbenchWindowArray.length) {
            iWorkbenchWindow = iWorkbenchWindowArray[n];
            object = iWorkbenchWindow.getPages();
            int n2 = 0;
            while (n2 < ((IWorkbenchPage[])object).length) {
                object2 = object[n2];
                if (object2 != null && object2.getPerspective() != null && object2.getPerspective().getId().equals("org.eclipse.hyades.trace.internal.ui.tracePerspective")) break;
                ++n2;
            }
            ++n;
        }
        if (object2 != null && (string.equals("org.eclipse.hyades.trace.internal.ui.PDProjectExplorer") ? (iWorkbenchWindow = object2.findView("org.eclipse.hyades.log.ui.internal.navigator.LogNavigator")) != null : string.equals("org.eclipse.hyades.log.ui.internal.navigator.LogNavigator") && (iWorkbenchWindow = object2.findView("org.eclipse.hyades.trace.internal.ui.PDProjectExplorer")) != null)) {
            return;
        }
        try {
            boolean bl = false;
            if (HierarchyResourceSetImpl.getInstance().getResources().size() > 0) {
                String string2;
                String string3;
                object = HierarchyResourceSetImpl.getInstance().getResources().iterator();
                while (object.hasNext()) {
                    Resource resource = (Resource)object.next();
                    if (resource == null || !resource.isLoaded() || !resource.isModified()) continue;
                    bl = true;
                    break;
                }
                if (bl && MessageDialog.openQuestion(null, (String)(string3 = UIPlugin.getResourceString("TRACE_MSG")), (String)(string2 = UIPlugin.getResourceString("SAVE_PROJECT_SQ")))) {
                    SaveUtil.saveDocuments();
                    IWorkspaceRoot iWorkspaceRoot = UIPlugin.getPluginWorkbench().getRoot();
                    iWorkspaceRoot.refreshLocal(2, null);
                }
                HierarchyResourceSetImpl.getInstance().getResources().clear();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        TraceUIManager.getTraceUIManager().dispose();
    }

    public static EObject getMofObject() {
        return HyadesUtil.getNavigatorSelection(HyadesUtil.getActiveNavigator());
    }

    public static INavigator getActiveNavigator() {
        IWorkbenchPage iWorkbenchPage = UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (iWorkbenchPage == null || !iWorkbenchPage.getPerspective().getId().equals("org.eclipse.hyades.trace.internal.ui.tracePerspective")) {
            return null;
        }
        IViewPart iViewPart = iWorkbenchPage.findView("org.eclipse.hyades.trace.internal.ui.PDProjectExplorer");
        if (iViewPart != null && ((Navigator)iViewPart).isActiveNavigator()) {
            return (INavigator)iViewPart;
        }
        iViewPart = iWorkbenchPage.findView("org.eclipse.hyades.log.ui.internal.navigator.LogNavigator");
        if (iViewPart != null && ((Navigator)iViewPart).isActiveNavigator()) {
            return (INavigator)iViewPart;
        }
        return null;
    }

    public static EObject getNavigatorSelection(INavigator iNavigator) {
        Object object;
        if (iNavigator == null) {
            return null;
        }
        IStructuredSelection iStructuredSelection = iNavigator.getStructuredSelection();
        if (!iStructuredSelection.isEmpty() && (object = iStructuredSelection.getFirstElement()) != null && object instanceof EObject) {
            return (EObject)object;
        }
        return null;
    }

    public static EObject getObjectToView(EObject eObject) {
        if (eObject == null) {
            return eObject;
        }
        List list = null;
        if (eObject instanceof TRCMonitor) {
            list = HyadesUtil.getLogObjectInMonitor((EObject)((TRCMonitor)eObject));
        } else if (eObject instanceof TRCNode) {
            list = HyadesUtil.getLogObjectInNode((EObject)((TRCNode)eObject));
        } else if (eObject instanceof TRCProcessProxy) {
            list = HyadesUtil.getLogAgentInProcess((EObject)((TRCProcessProxy)eObject));
        }
        if (list != null && list.size() == 1) {
            return (EObject)list.get(0);
        }
        return eObject;
    }

    public static List getLogObjectInMonitor(EObject eObject) {
        List list;
        EList eList = ((TRCMonitor)eObject).getNodes();
        TRCNode tRCNode = null;
        int n = eList.size();
        int n2 = 0;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n3 = 0;
        while (n3 < n && n2 < 2) {
            tRCNode = (TRCNode)eList.get(n3);
            if (tRCNode != null && (list = HyadesUtil.getLogObjectInNode((EObject)tRCNode)).size() >= 1) {
                ++n2;
                arrayList.add(tRCNode);
            }
            ++n3;
        }
        if (arrayList.size() == 1 && (list = HyadesUtil.getLogObjectInNode((EObject)((TRCNode)arrayList.get(0)))).size() == 1) {
            arrayList.clear();
            arrayList.add(list.get(0));
        }
        return arrayList;
    }

    public static List getLogObjectInNode(EObject eObject) {
        List list;
        EList eList = ((TRCNode)eObject).getProcessProxies();
        TRCProcessProxy tRCProcessProxy = null;
        int n = 0;
        int n2 = eList.size();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n3 = 0;
        while (n3 < n2 && n < 2) {
            tRCProcessProxy = (TRCProcessProxy)eList.get(n3);
            if (tRCProcessProxy != null && (list = HyadesUtil.getLogAgentInProcess((EObject)tRCProcessProxy)).size() >= 1) {
                ++n;
                arrayList.add(tRCProcessProxy);
            }
            ++n3;
        }
        if (arrayList.size() == 1 && (list = HyadesUtil.getLogAgentInProcess((EObject)((TRCProcessProxy)arrayList.get(0)))).size() == 1) {
            arrayList.clear();
            arrayList.add(list.get(0));
        }
        return arrayList;
    }

    public static List getLogAgentInProcess(EObject eObject) {
        int n = 0;
        EList eList = ((TRCProcessProxy)eObject).getAgentProxies();
        int n2 = eList.size();
        TRCAgentProxy tRCAgentProxy = null;
        ArrayList<TRCAgentProxy> arrayList = new ArrayList<TRCAgentProxy>();
        int n3 = 0;
        while (n3 < n2 && n < 2) {
            tRCAgentProxy = (TRCAgentProxy)eList.get(n3);
            if (tRCAgentProxy != null && !tRCAgentProxy.eIsProxy() && tRCAgentProxy.getType().equals("Logging")) {
                ++n;
                arrayList.add(tRCAgentProxy);
            }
            ++n3;
        }
        return arrayList;
    }

    public static Collection getLogAgents(EObject eObject) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<EObject> arrayList2 = null;
        if (eObject instanceof TRCMonitor) {
            arrayList2 = HyadesUtil.getProcesses((TRCMonitor)eObject);
        } else if (eObject instanceof TRCNode) {
            arrayList2 = ((TRCNode)eObject).getProcessProxies();
        } else if (eObject instanceof TRCProcessProxy) {
            arrayList2 = new ArrayList<EObject>(1);
            arrayList2.add(eObject);
        } else if (eObject instanceof TRCAgentProxy && ((TRCAgentProxy)eObject).getType().equals("Logging")) {
            arrayList.add(eObject);
        }
        if (arrayList2 != null) {
            TRCProcessProxy tRCProcessProxy = null;
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                tRCProcessProxy = (TRCProcessProxy)iterator.next();
                if (tRCProcessProxy == null) continue;
                EList eList = tRCProcessProxy.getAgentProxies();
                TRCAgentProxy tRCAgentProxy = null;
                Iterator iterator2 = eList.iterator();
                while (iterator2.hasNext()) {
                    tRCAgentProxy = (TRCAgentProxy)iterator2.next();
                    if (tRCAgentProxy == null || !tRCAgentProxy.getType().equals("Logging")) continue;
                    arrayList.add(tRCAgentProxy);
                }
            }
        }
        return arrayList;
    }

    public static Collection getProcesses(TRCMonitor tRCMonitor) {
        EList eList = tRCMonitor.getNodes();
        ArrayList arrayList = new ArrayList();
        int n = eList.size();
        int n2 = 0;
        while (n2 < n) {
            EList eList2 = ((TRCNode)eList.get(n2)).getProcessProxies();
            arrayList.addAll(eList2);
            ++n2;
        }
        return arrayList;
    }

    public static List getResources(IProject iProject) {
        ArrayList<IResource> arrayList = new ArrayList<IResource>();
        try {
            IResource[] iResourceArray = iProject.members();
            int n = 0;
            while (n < iResourceArray.length) {
                IResource iResource = iResourceArray[n];
                if (iResource != null && iResource.exists() && iResource instanceof IFile && ((IFile)iResource).getFileExtension() != null && ((IFile)iResource).getFileExtension().equals("trcmxmi")) {
                    arrayList.add(iResource);
                }
                ++n;
            }
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        return arrayList;
    }

    public static List getMonitors(IResource iResource, ResourceSet resourceSet) {
        ArrayList arrayList = new ArrayList();
        Resource resource = null;
        try {
            String string;
            String string2 = string = iResource.getFullPath().toString();
            resource = resourceSet.getResource(URI.createURI((String)("platform:/resource" + string2)), true);
            EList eList = resource.getContents();
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof TRCMonitor)) continue;
                arrayList.add(e);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }
}

