/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.actions;

import org.eclipse.hyades.trace.ui.IProfileEventListener;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.actions.AbstractProfileActionDelegate;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public abstract class AbstractListenerActionDelegate
extends AbstractProfileActionDelegate
implements IProfileEventListener,
IPartListener,
IPageListener {
    private IWorkbenchWindow fWindow;

    public void partActivated(IWorkbenchPart iWorkbenchPart) {
    }

    public void partBroughtToTop(IWorkbenchPart iWorkbenchPart) {
    }

    public void partClosed(IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart.equals(this.getView())) {
            this.dispose();
        }
    }

    public void partDeactivated(IWorkbenchPart iWorkbenchPart) {
    }

    public void partOpened(IWorkbenchPart iWorkbenchPart) {
    }

    public void dispose() {
        UIPlugin.getDefault().removeProfileEventListener(this);
        this.getWindow().removePageListener((IPageListener)this);
        if (this.getView() != null) {
            this.getView().getViewSite().getPage().removePartListener((IPartListener)this);
        }
        this.fWindow = null;
        super.dispose();
    }

    public void handleProfileEvent(final ProfileEvent profileEvent) {
        if (this.getPage() == null || this.getAction() == null) {
            return;
        }
        final Shell shell = this.getWindow().getShell();
        if (shell == null || shell.isDisposed()) {
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                if (shell == null || shell.isDisposed()) {
                    return;
                }
                AbstractListenerActionDelegate.this.doHandleProfileEvent(profileEvent);
            }
        };
        this.getPage().getWorkbenchWindow().getShell().getDisplay().asyncExec(runnable);
    }

    protected IWorkbenchPage getPage() {
        if (this.getWindow() != null) {
            return this.getWindow().getActivePage();
        }
        return UIPlugin.getActiveWorkbenchWindow().getActivePage();
    }

    protected IWorkbenchWindow getWindow() {
        return this.fWindow;
    }

    protected void setWindow(IWorkbenchWindow iWorkbenchWindow) {
        this.fWindow = iWorkbenchWindow;
    }

    protected void doHandleProfileEvent(ProfileEvent profileEvent) {
        switch (profileEvent.getType()) {
            case 16: {
                this.update(this.getAction(), (ISelection)this.getSelection());
                break;
            }
            case 4: {
                this.update(this.getAction(), (ISelection)this.getSelection());
                break;
            }
            case 8: {
                this.update(this.getAction(), (ISelection)this.getSelection());
                break;
            }
            case 1: {
                this.update(this.getAction(), (ISelection)this.getSelection());
                break;
            }
            case 2: {
                this.update(this.getAction(), (ISelection)this.getSelection());
                break;
            }
            case 4096: {
                this.update(this.getAction(), (ISelection)StructuredSelection.EMPTY);
            }
        }
    }

    public void init(IWorkbenchWindow iWorkbenchWindow) {
        super.init(iWorkbenchWindow);
        UIPlugin.getDefault().addProfileEventListener(this);
        this.setWindow(iWorkbenchWindow);
        iWorkbenchWindow.addPageListener((IPageListener)this);
    }

    public void init(IViewPart iViewPart) {
        super.init(iViewPart);
        UIPlugin.getDefault().addProfileEventListener(this);
        this.setWindow(iViewPart.getViewSite().getWorkbenchWindow());
        iViewPart.getViewSite().getPage().addPartListener((IPartListener)this);
        iViewPart.getViewSite().getWorkbenchWindow().addPageListener((IPageListener)this);
    }

    public void pageActivated(final IWorkbenchPage iWorkbenchPage) {
        if (this.getPage() != null && this.getPage().equals(iWorkbenchPage)) {
            Runnable runnable = new Runnable(){

                public void run() {
                    IWorkbenchWindow iWorkbenchWindow;
                    if (AbstractListenerActionDelegate.this.getPage() != null && (iWorkbenchWindow = AbstractListenerActionDelegate.this.getPage().getWorkbenchWindow()) != null && iWorkbenchWindow.getShell() != null && !iWorkbenchWindow.getShell().isDisposed()) {
                        ISelection iSelection = iWorkbenchPage.getSelection("org.eclipse.hyades.trace.internal.ui.PDProjectExplorer");
                        AbstractListenerActionDelegate.this.update(AbstractListenerActionDelegate.this.getAction(), iSelection);
                    }
                }
            };
            this.getPage().getWorkbenchWindow().getShell().getDisplay().asyncExec(runnable);
        }
    }

    public void pageClosed(IWorkbenchPage iWorkbenchPage) {
        if (iWorkbenchPage.equals(this.getPage())) {
            this.dispose();
        }
    }

    public void pageOpened(IWorkbenchPage iWorkbenchPage) {
    }
}

