/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.console;

import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.console.TraceConsoleDocument;
import org.eclipse.hyades.trace.ui.internal.preferences.TraceConsolePreferencePage;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.help.WorkbenchHelp;

public class TraceConsoleViewer
extends TextViewer
implements IPropertyChangeListener {
    protected Font fFont;
    protected InternalDocumentListener fInternalDocumentListener = new InternalDocumentListener();

    public TraceConsoleViewer(Composite composite) {
        super(composite, 768);
        this.getTextWidget().setDoubleClickEnabled(true);
        this.getTextWidget().addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent verifyEvent) {
                TraceConsoleDocument traceConsoleDocument = (TraceConsoleDocument)TraceConsoleViewer.this.getDocument();
                if (traceConsoleDocument != null && traceConsoleDocument.getStartOfEditableContent() > verifyEvent.start) {
                    verifyEvent.doit = false;
                }
            }
        });
        UIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        FontData fontData = TraceConsolePreferencePage.getConsoleFontData();
        this.fFont = new Font((Device)this.getControl().getDisplay(), fontData);
        this.getTextWidget().setFont(this.fFont);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)(UIPlugin.getPluginId() + ".trcv0000"));
    }

    protected boolean canPerformFind() {
        return this.getTextWidget() != null && this.getVisibleDocument() != null && this.getVisibleDocument().getLength() > 0;
    }

    public void clearDocument() {
        IDocument iDocument = this.getDocument();
        if (iDocument != null) {
            ((TraceConsoleDocument)iDocument).clearDocument();
        }
    }

    protected void dispose() {
        this.fFont.dispose();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getProperty();
        if (!string.equals("Console.font")) {
            return;
        }
        FontData fontData = TraceConsolePreferencePage.getConsoleFontData();
        Font font = this.fFont;
        this.fFont = new Font((Device)this.getControl().getDisplay(), fontData);
        this.getTextWidget().setFont(this.fFont);
        font.dispose();
    }

    protected void revealEndOfDocument() {
        IDocument iDocument = this.getDocument();
        int n = iDocument.getLength();
        if (n > 0) {
            this.revealRange(n - 1, 1);
            StyledText styledText = this.getTextWidget();
            styledText.setCaretOffset(n);
        }
    }

    public void setDocument(IDocument iDocument) {
        TraceConsoleDocument traceConsoleDocument = (TraceConsoleDocument)this.getDocument();
        TraceConsoleDocument traceConsoleDocument2 = (TraceConsoleDocument)iDocument;
        if (traceConsoleDocument == null && traceConsoleDocument2 == null) {
            return;
        }
        if (traceConsoleDocument != null) {
            traceConsoleDocument.removeDocumentListener(this.fInternalDocumentListener);
            traceConsoleDocument.setConsoleViewer(null);
            if (traceConsoleDocument.equals((Object)traceConsoleDocument2)) {
                traceConsoleDocument2.addDocumentListener(this.fInternalDocumentListener);
                traceConsoleDocument2.setConsoleViewer(this);
                return;
            }
        }
        super.setDocument((IDocument)traceConsoleDocument2);
        if (traceConsoleDocument2 != null) {
            this.getTextWidget().setEditable(!traceConsoleDocument2.isReadOnly());
            this.updateStyleRanges(traceConsoleDocument2);
            this.revealEndOfDocument();
            traceConsoleDocument2.addDocumentListener(this.fInternalDocumentListener);
            traceConsoleDocument2.setConsoleViewer(this);
        }
    }

    protected void updateStyleRanges(TraceConsoleDocument traceConsoleDocument) {
        StyledText styledText = this.getTextWidget();
        StyleRange[] styleRangeArray = traceConsoleDocument.getStyleRanges();
        int n = traceConsoleDocument.getStore().getLength();
        int n2 = styleRangeArray.length;
        if (n2 > 0 && n - 1 >= styleRangeArray[n2 - 1].start) {
            styledText.setStyleRanges(styleRangeArray);
        }
    }

    class InternalDocumentListener
    implements IDocumentListener {
        InternalDocumentListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent documentEvent) {
        }

        public void documentChanged(DocumentEvent documentEvent) {
            TraceConsoleDocument traceConsoleDocument = (TraceConsoleDocument)TraceConsoleViewer.this.getDocument();
            if (traceConsoleDocument == null || traceConsoleDocument.isClosed()) {
                return;
            }
            TraceConsoleViewer.this.revealEndOfDocument();
            if (traceConsoleDocument.isReadOnly()) {
                StyledText styledText = TraceConsoleViewer.this.getTextWidget();
                styledText.setEditable(false);
            }
            TraceConsoleViewer.this.updateStyleRanges(traceConsoleDocument);
        }
    }
}

