/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.launcher;

import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.TraceArguments;
import org.eclipse.hyades.trace.ui.internal.wizard.RelaunchWizard;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IWorkbenchWindow;

public class RelaunchTraceAction
extends Action {
    private PDProjectExplorer fViewer;
    private TraceArguments _trace;

    public RelaunchTraceAction(PDProjectExplorer pDProjectExplorer) {
        super(UIPlugin.getResourceString("RLNCHTRCACTN_RELAUNCH_TRACE"));
        this.setToolTipText(UIPlugin.getResourceString("RLNCHTRCACTN_RELAUNCH_TRACE"));
        this.fViewer = pDProjectExplorer;
    }

    public RelaunchTraceAction(TraceArguments traceArguments) {
        super(traceArguments.toString());
        this.setToolTipText(UIPlugin.getResourceString("RLNCHTRCACTN_RELAUNCH_TRACE"));
        this._trace = traceArguments;
    }

    public void run() {
        IStructuredSelection iStructuredSelection;
        Object object;
        IWorkbenchWindow iWorkbenchWindow;
        IType iType = null;
        if (this._trace != null && this._trace.getType() != null) {
            iType = this._trace.getType();
        } else {
            iWorkbenchWindow = null;
            object = null;
            if (this.fViewer == null) {
                object = this._trace.getAgent();
                iWorkbenchWindow = this._trace.getProcess();
            } else {
                iStructuredSelection = (IStructuredSelection)this.fViewer.getViewer().getSelection();
                if (iStructuredSelection == null || iStructuredSelection.isEmpty()) {
                    return;
                }
                Object e = iStructuredSelection.iterator().next();
                if (e instanceof TRCProcessProxy) {
                    iWorkbenchWindow = (TRCProcessProxy)e;
                } else if (e instanceof TRCAgentProxy) {
                    object = (TRCAgentProxy)e;
                }
            }
            if (iWorkbenchWindow != null && object == null) {
                iType = iWorkbenchWindow;
            } else if (object != null) {
                iType = object;
            }
        }
        iWorkbenchWindow = UIPlugin.getActiveWorkbenchWindow();
        object = new RelaunchWizard(iType);
        iStructuredSelection = new WizardDialog(iWorkbenchWindow.getShell(), (IWizard)object);
        iStructuredSelection.open();
    }
}

