/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.wizard;

import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.wizard.AgentCollectionsPage;
import org.eclipse.hyades.trace.ui.internal.wizard.AgentOptionsPage;
import org.eclipse.hyades.trace.ui.internal.wizard.AttachLocalPage;
import org.eclipse.hyades.trace.ui.internal.wizard.AttachLocalWizard;
import org.eclipse.hyades.trace.ui.internal.wizard.DestinationFolderPage;
import org.eclipse.hyades.trace.ui.internal.wizard.HostDataPage;
import org.eclipse.hyades.trace.ui.internal.wizard.ProfileOptionsPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbench;

public class AttachRemoteWizard
extends AttachLocalWizard {
    private HostDataPage fHostPage;
    private boolean fShowHostPage;

    public AttachRemoteWizard() {
        this(true, "");
    }

    public AttachRemoteWizard(boolean bl, String string) {
        this.setNeedsProgressMonitor(true);
        this.fShowHostPage = bl;
        this.fNodeName = string;
    }

    public void addPages() {
        this.setWindowTitle(UIPlugin.getResourceString("ATTACH_RJAVA_APP_TITLE"));
        if (this.fShowHostPage) {
            this.fHostPage = new HostDataPage("hostPage");
        }
        this.fNamePage = new AttachLocalPage("namePage");
        this.fFolderPage = new DestinationFolderPage("folderPage");
        if (this.fShowHostPage) {
            this.addPage((IWizardPage)this.fHostPage);
        }
        this.addPage((IWizardPage)this.fNamePage);
        this.addPage((IWizardPage)this.fFolderPage);
        if (this.isProfilingEnabled()) {
            this.fProfilePage = new ProfileOptionsPage("optionsPage", "AttachRemoteWizard");
            this.fOptionsPage = new AgentOptionsPage("agentPage", "AttachRemoteWizard");
            this.fCollectionsPage = new AgentCollectionsPage("collentionsPage", "AttachRemoteWizard");
            this.addPage((IWizardPage)this.fProfilePage);
            this.addPage((IWizardPage)this.fOptionsPage);
            this.addPage((IWizardPage)this.fCollectionsPage);
            this.fProfilePage.setImageDescriptor(UIPlugin.getImageDescriptor("attach_wiz.gif"));
            this.fOptionsPage.setImageDescriptor(UIPlugin.getImageDescriptor("attach_wiz.gif"));
            this.fCollectionsPage.setImageDescriptor(UIPlugin.getImageDescriptor("attach_wiz.gif"));
        }
        if (this.fShowHostPage) {
            this.fHostPage.setImageDescriptor(UIPlugin.getImageDescriptor("attach_wiz.gif"));
        }
        this.fNamePage.setImageDescriptor(UIPlugin.getImageDescriptor("attach_wiz.gif"));
        this.fFolderPage.setImageDescriptor(UIPlugin.getImageDescriptor("attach_wiz.gif"));
    }

    public String getNodeSelected() {
        if (this.fShowHostPage) {
            return this.fHostPage.getNodeName();
        }
        return this.fNodeName;
    }

    public int getPortSelection() {
        if (this.fShowHostPage) {
            return this.fHostPage.getPortNumber();
        }
        return this.fPortNumber;
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.fSelection = iStructuredSelection;
        this.setDefaultPageImageDescriptor(UIPlugin.getImageDescriptor("attach_wiz.gif"));
    }

    public boolean isComplete() {
        return this.fNamePage.isComplete();
    }

    public String pageDetails() {
        return this.fNamePage.pageDetails();
    }

    public boolean performFinish() {
        if (!(this.fFolderPage.getFile().equals("") || PDCoreUtil.isPathExists(this.fFolderPage.getFile()) || PDCoreUtil.createDirectoryMessage(this.fFolderPage.getFile(), this.getShell()))) {
            return false;
        }
        if (this.isProfilingEnabled()) {
            this.fProfilePage.finish();
            this.fOptionsPage.finish();
        }
        this.fFolderPage.finish();
        if (this.fShowHostPage) {
            this.fHostPage.finish();
        }
        return this.fNamePage.finish(this.fFolderPage.getProject(), this.fFolderPage.getMonitor(), this.fFolderPage.getFile());
    }
}

