/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.wizard;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.wizard.AgentCollectionsPage;
import org.eclipse.hyades.trace.ui.internal.wizard.AgentOptionsPage;
import org.eclipse.hyades.trace.ui.internal.wizard.DestinationFolderPage;
import org.eclipse.hyades.trace.ui.internal.wizard.ProcessLocalDataPage;
import org.eclipse.hyades.trace.ui.internal.wizard.ProfileOptionsPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;

public class LaunchLocalWizard
extends Wizard
implements INewWizard,
IRunnableWithProgress {
    private ProcessLocalDataPage fProcessPage;
    private DestinationFolderPage fFolderPage;
    private ProfileOptionsPage fProfilePage;
    private AgentOptionsPage fOptionsPage;
    private AgentCollectionsPage fCollectionsPage;
    private IStatus error;
    private boolean success = true;
    private boolean isProfilingEnabled = UIPlugin.getDefault().getPreferenceStore().getBoolean("prof_option");

    public LaunchLocalWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.setWindowTitle(UIPlugin.getResourceString("LAUNCH_JAVA_APP_TITLE"));
        this.fProcessPage = new ProcessLocalDataPage("processData");
        this.fFolderPage = new DestinationFolderPage("folderPage");
        if (this.isProfilingEnabled) {
            this.fProfilePage = new ProfileOptionsPage("profilePage", "LaunchLocalWizard");
            this.fOptionsPage = new AgentOptionsPage("agentPage", "LaunchLocalWizard");
            this.fCollectionsPage = new AgentCollectionsPage("collentionsPage", "LaunchLocalWizard");
            this.fProfilePage.setImageDescriptor(UIPlugin.getImageDescriptor("launch_wiz.gif"));
            this.fOptionsPage.setImageDescriptor(UIPlugin.getImageDescriptor("launch_wiz.gif"));
            this.fCollectionsPage.setImageDescriptor(UIPlugin.getImageDescriptor("launch_wiz.gif"));
        }
        this.addPage((IWizardPage)this.fProcessPage);
        this.addPage((IWizardPage)this.fFolderPage);
        if (this.isProfilingEnabled) {
            this.addPage((IWizardPage)this.fProfilePage);
            this.addPage((IWizardPage)this.fOptionsPage);
            this.addPage((IWizardPage)this.fCollectionsPage);
        }
        this.fFolderPage.setImageDescriptor(UIPlugin.getImageDescriptor("launch_wiz.gif"));
    }

    public ArrayList getFilterSet() {
        return this.fProfilePage.getFilterSet();
    }

    public DestinationFolderPage getFolderPage() {
        return this.fFolderPage;
    }

    public boolean getAutoMonitoring() {
        return this.fCollectionsPage.getAutoMonitoring();
    }

    public Vector getOptions() {
        if (this.isProfilingEnabled) {
            Vector vector = this.fOptionsPage.getOptions();
            Vector vector2 = this.fCollectionsPage.getOptions();
            vector.addAll(vector2);
            return vector;
        }
        return new Vector();
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.setDefaultPageImageDescriptor(UIPlugin.getImageDescriptor("mon_prop_wiz.gif"));
    }

    public boolean performFinish() {
        if (!(this.fFolderPage.getFile().equals("") || PDCoreUtil.isPathExists(this.fFolderPage.getFile()) || PDCoreUtil.createDirectoryMessage(this.fFolderPage.getFile(), this.getShell()))) {
            return false;
        }
        WorkspaceModifyDelegatingOperation workspaceModifyDelegatingOperation = new WorkspaceModifyDelegatingOperation((IRunnableWithProgress)this);
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)workspaceModifyDelegatingOperation);
        }
        catch (InvocationTargetException invocationTargetException) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)invocationTargetException.getTargetException().getMessage());
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return this.success;
    }

    public void run(IProgressMonitor iProgressMonitor) {
        if (this.isProfilingEnabled) {
            this.fProfilePage.finish();
            this.fOptionsPage.finish();
            this.fCollectionsPage.finish();
        }
        this.success = this.fFolderPage.finish();
        if (this.success) {
            this.success = this.fProcessPage.finish(this.fFolderPage.getProject(), this.fFolderPage.getMonitor(), this.fFolderPage.getFile());
        }
        if (!this.success) {
            this.error = new Status(4, UIPlugin.getPluginId(), 566, UIPlugin.getResourceString("ERROR_CREATING_ERROR_"), (Throwable)new Exception());
        }
    }

    public boolean isProfilingEnabled() {
        return this.isProfilingEnabled;
    }
}

