/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.wizard;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.LaunchProcessUI;
import org.eclipse.hyades.trace.ui.internal.util.FilterSetElement;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.util.TraceArguments;
import org.eclipse.hyades.trace.ui.internal.wizard.LaunchLocalWizard;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;

public class ProcessLocalDataPage
extends WizardPage
implements SelectionListener,
ModifyListener {
    private LaunchProcessUI _processUI;
    private Button _workbenchBtn;
    private Button _systemBtn;
    private HashMap _classArgs = new HashMap();
    private IType _oldSelection;
    private String _selectedProject;
    private String _selectedMonitor;
    private String _profileFile;
    private Text fProjText;
    private Button fProjButton;
    private Text fMainText;
    private Button fSearchButton;
    private boolean success = true;

    public ProcessLocalDataPage(String string) {
        super(string);
        this.setTitle(UIPlugin.getResourceString("PROCESS_WIZARD_TITLE"));
        String string2 = UIPlugin.getResourceString("PROCESSLOCALDATAPAGE_DESC");
        this.setDescription(string2);
        this.setImageDescriptor(UIPlugin.getImageDescriptor("launch_wiz.gif"));
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)GridUtil.createFill());
        Label label = new Label(composite2, 0);
        label.setText(UIPlugin.getResourceString("STR_CLASS_GROUP_TEXT"));
        Composite composite3 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 0;
        composite3.setLayout((Layout)gridLayout);
        GridData gridData = GridUtil.createFill();
        gridData.horizontalIndent = 20;
        composite3.setLayoutData((Object)gridData);
        this._workbenchBtn = new Button(composite3, 16);
        this._workbenchBtn.setText(UIPlugin.getResourceString("PROCESSLOCALDATAPAGE_WB_BTN_TEXT"));
        Composite composite4 = new Composite(composite3, 0);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 1;
        gridLayout2.makeColumnsEqualWidth = true;
        gridLayout2.marginWidth = 20;
        gridLayout.verticalSpacing = 0;
        composite4.setLayout((Layout)gridLayout2);
        composite4.setLayoutData((Object)new GridData(272));
        this.createElementsFinderGroup(composite4);
        this._systemBtn = new Button(composite3, 16);
        this._systemBtn.setText(UIPlugin.getResourceString("PROCESSLOCALDATAPAGE_SYS_BTN_TEXT"));
        Composite composite5 = new Composite(composite3, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth = 10;
        gridLayout.verticalSpacing = 0;
        composite5.setLayout((Layout)gridLayout);
        composite5.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._processUI = new LaunchProcessUI();
        Composite composite6 = this._processUI.createClassControl(composite5);
        Label label2 = new Label(composite2, 0);
        label2.setText(UIPlugin.getResourceString("STR_ARGU_GROUP_TEXT"));
        Composite composite7 = new Composite(composite2, 0x1000008);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 0;
        composite7.setLayout((Layout)gridLayout);
        gridData = GridUtil.createFill();
        gridData.horizontalIndent = 20;
        composite7.setLayoutData((Object)gridData);
        this._processUI.createArgumentsControl(composite7);
        this._processUI.setShell(this.getShell());
        this._workbenchBtn.setSelection(true);
        this.enableWorkbench(true);
        this._workbenchBtn.addSelectionListener((SelectionListener)this);
        this._systemBtn.addSelectionListener((SelectionListener)this);
        this._processUI.getClassUI().addModifyListener((ModifyListener)this);
        this.setPageComplete(false);
        this.setControl((Control)composite2);
        WorkbenchHelp.setHelp((Control)this._workbenchBtn, (String)(UIPlugin.getPluginId() + ".pldp0000"));
    }

    public void createElementsFinderGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        composite2.setLayoutData((Object)gridData);
        Label label = new Label(composite2, 0);
        label.setText(UIPlugin.getResourceString("STR_WB_PROJECT"));
        this.fProjText = new Text(composite2, 2052);
        gridData = new GridData(768);
        this.fProjText.setLayoutData((Object)gridData);
        this.fProjText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ProcessLocalDataPage.this.displayProjectMessage();
                ProcessLocalDataPage.this.setPageComplete(ProcessLocalDataPage.this.isWorkbenchValid());
            }
        });
        this.fProjButton = new Button(composite2, 0x1000008);
        this.fProjButton.setText(UIPlugin.getResourceString("STR_WB_BROWSE_BTN"));
        this.fProjButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ProcessLocalDataPage.this.handleProjectButtonSelected();
            }
        });
        Label label2 = new Label(composite2, 0);
        label2.setText(UIPlugin.getResourceString("STR_WB_MAIN_CLASS"));
        this.fMainText = new Text(composite2, 2052);
        gridData = new GridData(768);
        this.fMainText.setLayoutData((Object)gridData);
        this.fMainText.addModifyListener((ModifyListener)this);
        this.fSearchButton = new Button(composite2, 0x1000008);
        this.fSearchButton.setText(UIPlugin.getResourceString("STR_WB_SEARCH_BTN"));
        this.fSearchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ProcessLocalDataPage.this.handleSearchButtonSelected();
            }
        });
        Label label3 = new Label(composite2, 0);
    }

    private void enableWorkbench(boolean bl) {
        this.fProjText.setEnabled(bl);
        this.fProjButton.setEnabled(bl);
        this.fMainText.setEnabled(bl);
        this.fSearchButton.setEnabled(bl);
        this._processUI.enable(!bl, true, !bl, true, true);
        if (bl) {
            this.fProjText.setFocus();
        }
    }

    public boolean finish(String string, String string2, String string3) {
        this._selectedProject = string;
        this._selectedMonitor = string2;
        this._profileFile = string3;
        return this.finish();
    }

    public boolean finish() {
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                TraceArguments traceArguments = null;
                String string = "";
                string = ProcessLocalDataPage.this._systemBtn.getSelection() ? ProcessLocalDataPage.this._processUI.getClassUI().getText().trim() : ProcessLocalDataPage.this.fMainText.getText().trim();
                traceArguments = new TraceArguments(string);
                if (ProcessLocalDataPage.this._profileFile != null || ProcessLocalDataPage.this._profileFile.trim().equals("")) {
                    traceArguments.setProfileFile(ProcessLocalDataPage.this._profileFile);
                }
                traceArguments.setHostName("localhost");
                traceArguments.setClassPath(ProcessLocalDataPage.this._processUI.getClassPath());
                traceArguments.setVMArguments(ProcessLocalDataPage.this._processUI.getVMArgs().trim());
                traceArguments.setParameters(ProcessLocalDataPage.this._processUI.getParametersUI().getText().trim());
                traceArguments.setPortNumber(Integer.parseInt(UIPlugin.getDefault().getPreferenceStore().getString("localhost_port")));
                traceArguments.setEnvironmentVariable(ProcessLocalDataPage.this._processUI.getEnvData());
                ArrayList arrayList = new ArrayList();
                if (((LaunchLocalWizard)ProcessLocalDataPage.this.getWizard()).isProfilingEnabled()) {
                    traceArguments.setAutoMonitoring(((LaunchLocalWizard)ProcessLocalDataPage.this.getWizard()).getAutoMonitoring());
                    ArrayList arrayList2 = ((LaunchLocalWizard)ProcessLocalDataPage.this.getWizard()).getFilterSet();
                    int n = 0;
                    while (n < arrayList2.size()) {
                        FilterSetElement filterSetElement = (FilterSetElement)arrayList2.get(n);
                        if (filterSetElement.getEnabled()) {
                            UIPlugin.getDefault().getPluginPreferences().setValue("filter_name", filterSetElement.getName());
                            arrayList = filterSetElement.getChildren();
                            break;
                        }
                        ++n;
                    }
                }
                if (traceArguments.getType() != null) {
                    UIPlugin.getDefault().getTraceManager().registerTrace(traceArguments.getType());
                }
                ProcessLocalDataPage.this.success = PDCoreUtil.launchTrace(traceArguments, arrayList, ((LaunchLocalWizard)ProcessLocalDataPage.this.getWizard()).getOptions(), ProcessLocalDataPage.this._selectedProject, ProcessLocalDataPage.this._selectedMonitor);
            }
        });
        return this.success;
    }

    public String getClassName() {
        return this._processUI.getClassName();
    }

    public String getClassPath() {
        return this._processUI.getClassPath();
    }

    public void modifyText(ModifyEvent modifyEvent) {
        if (this._systemBtn.getSelection()) {
            this.setPageComplete(!this._processUI.getClassUI().getText().trim().equals(""));
        } else {
            this.setPageComplete(this.isWorkbenchValid());
        }
    }

    private void saveData(Object object) {
        if (object == null) {
            return;
        }
        ArgumentData argumentData = new ArgumentData(this._processUI.getClassPath(), this._processUI.getParameters(), this._processUI.getVMArgs());
        this._classArgs.put(object, argumentData);
    }

    private void showClassArguments(IType iType) {
        String string = "";
        if (iType != null) {
            try {
                IJavaProject iJavaProject = iType.getJavaProject();
                string = iType.getFullyQualifiedName();
                IWorkspace iWorkspace = UIPlugin.getPluginWorkbench();
                IPath iPath = iWorkspace.getRoot().getLocation();
                String string2 = iJavaProject.getProject().getLocation().toOSString();
                String string3 = "";
                if (!string2.startsWith(iPath.toOSString())) {
                    string3 = string2 + File.pathSeparator;
                }
                String[] stringArray = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)iJavaProject);
                int n = 0;
                while (n < stringArray.length) {
                    string3 = string3 + stringArray[n] + File.pathSeparator;
                    ++n;
                }
                this._processUI.getClassPathUI().setText(string3.trim());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void showClassArguments(String string) {
        if (string == null || string.equals("")) {
            this._processUI.getClassPathUI().setText("");
            return;
        }
        Object v = this._classArgs.get(string);
        if (v != null) {
            ArgumentData argumentData = (ArgumentData)v;
            this._processUI.getClassPathUI().setText(argumentData.getClasspath());
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this._workbenchBtn && this._workbenchBtn.getSelection()) {
            String string = this._processUI.getClassUI().getText().trim();
            if (!string.equals("")) {
                this.saveData(string);
            }
            this.showClassArguments(this.fMainText.getText().trim());
            this.enableWorkbench(true);
            this.displayProjectMessage();
            this.setPageComplete(this.isWorkbenchValid());
        } else if (selectionEvent.widget == this._systemBtn && this._systemBtn.getSelection()) {
            String string = this.fMainText.getText().trim();
            if (!string.equals("")) {
                this.saveData(string);
            }
            this.showClassArguments(this._processUI.getClassUI().getText().trim());
            this.enableWorkbench(false);
            this.setErrorMessage(null);
            this.setPageComplete(!this._processUI.getClassUI().getText().trim().equals(""));
            this.setMessage(null);
        }
    }

    protected void handleProjectButtonSelected() {
        IJavaProject iJavaProject = this.chooseJavaProject();
        if (iJavaProject == null) {
            return;
        }
        String string = iJavaProject.getElementName();
        this.fProjText.setText(string);
        this.setPageComplete(this.isWorkbenchValid());
    }

    protected IJavaProject chooseJavaProject() {
        Object[] objectArray;
        try {
            objectArray = JavaCore.create((IWorkspaceRoot)UIPlugin.getPluginWorkbench().getRoot()).getJavaProjects();
        }
        catch (JavaModelException javaModelException) {
            objectArray = new IJavaProject[]{};
        }
        JavaElementLabelProvider javaElementLabelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementListSelectionDialog elementListSelectionDialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)javaElementLabelProvider);
        elementListSelectionDialog.setTitle(UIPlugin.getResourceString("TITLE_PROJECT_SELECT"));
        elementListSelectionDialog.setMessage(UIPlugin.getResourceString("STR_PROJECT_SELECT"));
        elementListSelectionDialog.setElements(objectArray);
        IJavaProject iJavaProject = this.getJavaProject();
        if (iJavaProject != null) {
            elementListSelectionDialog.setInitialSelections(new Object[]{iJavaProject});
        }
        if (elementListSelectionDialog.open() == 0) {
            return (IJavaProject)elementListSelectionDialog.getFirstResult();
        }
        return null;
    }

    protected IJavaProject getJavaProject() {
        String string = this.fProjText.getText().trim();
        if (string.length() < 1) {
            return null;
        }
        return this.getJavaModel().getJavaProject(string);
    }

    private IJavaModel getJavaModel() {
        return JavaCore.create((IWorkspaceRoot)UIPlugin.getPluginWorkbench().getRoot());
    }

    protected void handleSearchButtonSelected() {
        IJavaProject iJavaProject = this.getJavaProject();
        IJavaSearchScope iJavaSearchScope = null;
        iJavaSearchScope = iJavaProject == null || !iJavaProject.exists() ? SearchEngine.createWorkspaceScope() : SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{iJavaProject}, (boolean)false);
        int n = 8;
        Shell shell = this.getShell();
        SelectionDialog selectionDialog = JavaUI.createMainTypeDialog((Shell)shell, (IRunnableContext)((WizardDialog)this.getWizard().getContainer()), (IJavaSearchScope)iJavaSearchScope, (int)n, (boolean)false, (String)this.fMainText.getText());
        selectionDialog.setTitle(UIPlugin.getResourceString("TITLE_MAIN_SELECT"));
        selectionDialog.setMessage(UIPlugin.getResourceString("STR_MAIN_SELECT"));
        if (selectionDialog.open() == 1) {
            this.setWorkbenchBtnSelection(true);
            return;
        }
        Object[] objectArray = selectionDialog.getResult();
        if (objectArray == null || objectArray.length < 1) {
            this.setWorkbenchBtnSelection(true);
            return;
        }
        IType iType = (IType)objectArray[0];
        if (iType != null) {
            this.fMainText.setText(iType.getFullyQualifiedName());
            iJavaProject = iType.getJavaProject();
            this.fProjText.setText(iJavaProject.getElementName());
            this.showClassArguments(iType);
        }
        this.setWorkbenchBtnSelection(true);
    }

    private void displayProjectMessage() {
        IJavaProject iJavaProject = this.getJavaProject();
        if (this.fProjText.getText().trim().equals("")) {
            this.setErrorMessage(UIPlugin.getResourceString("WIZ_ERR_EMPTY_PROJECT"));
        } else if (iJavaProject == null || !iJavaProject.exists()) {
            this.setErrorMessage(UIPlugin.getResourceString("WIZ_ERR_NOT_EXIST_PROJECT"));
        } else {
            this.setErrorMessage(null);
        }
    }

    private void setWorkbenchBtnSelection(boolean bl) {
        this._systemBtn.setSelection(!bl);
        this._workbenchBtn.setSelection(bl);
        this.setPageComplete(this.isWorkbenchValid());
    }

    private boolean isWorkbenchValid() {
        boolean bl = false;
        IJavaProject iJavaProject = this.getJavaProject();
        bl = (iJavaProject != null && iJavaProject.exists()) & !this.fMainText.getText().trim().equals("");
        return bl;
    }

    class ArgumentData {
        protected String _classpath = "";
        protected String _param = "";
        protected String _vmArgs = "";

        public ArgumentData(String string, String string2, String string3) {
            this._classpath = string;
            this._param = string2;
            this._vmArgs = string3;
        }

        public String getClasspath() {
            return this._classpath;
        }

        public String getParams() {
            return this._param;
        }

        public String getVMArgs() {
            return this._vmArgs;
        }
    }
}

