/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.wizard;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCConfiguration;
import org.eclipse.hyades.models.hierarchy.TRCFilter;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceLocationUI;
import org.eclipse.hyades.trace.ui.internal.core.TraceNodeUI;
import org.eclipse.hyades.trace.ui.internal.util.FilterSetElement;
import org.eclipse.hyades.trace.ui.internal.util.FilterTableElement;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.hyades.trace.ui.internal.util.TraceArguments;
import org.eclipse.hyades.trace.ui.internal.wizard.AgentCollectionsPage;
import org.eclipse.hyades.trace.ui.internal.wizard.AgentOptionsPage;
import org.eclipse.hyades.trace.ui.internal.wizard.DestinationFolderPage;
import org.eclipse.hyades.trace.ui.internal.wizard.ProfileOptionsPage;
import org.eclipse.hyades.trace.ui.internal.wizard.RelaunchDataPage;
import org.eclipse.hyades.trace.ui.internal.wizard.RelaunchNodeWizardPage;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;

public class RelaunchWizard
extends Wizard
implements INewWizard,
IRunnableWithProgress {
    private RelaunchDataPage fProcessPage;
    private DestinationFolderPage fFolderPage;
    private ProfileOptionsPage fProfilePage;
    private AgentOptionsPage fOptionsPage;
    private AgentCollectionsPage fCollectionsPage;
    private Object fSelection;
    private TRCProcessProxy fProcess;
    private RelaunchNodeWizardPage fHostPage;
    private boolean isProfilingEnabled = UIPlugin.getDefault().getPreferenceStore().getBoolean("prof_option");

    public RelaunchWizard(Object object) {
        this.setNeedsProgressMonitor(true);
        this.fSelection = object;
    }

    public void addPages() {
        this.setWindowTitle(UIPlugin.getResourceString("RELAUNCH_DLG_TITLE"));
        this.fHostPage = new RelaunchNodeWizardPage("nodeData");
        this.fProcessPage = new RelaunchDataPage("processData");
        this.fFolderPage = new DestinationFolderPage("folderPage");
        this.addPage((IWizardPage)this.fProcessPage);
        this.addPage((IWizardPage)this.fHostPage);
        this.addPage((IWizardPage)this.fFolderPage);
        if (this.isProfilingEnabled()) {
            this.fProfilePage = new ProfileOptionsPage("profilePage", "RelaunchWizard");
            this.fOptionsPage = new AgentOptionsPage("agentPage", "RelaunchWizard");
            this.fCollectionsPage = new AgentCollectionsPage("collectionsPage", "RelaunchWizard");
            this.addPage((IWizardPage)this.fProfilePage);
            this.addPage((IWizardPage)this.fOptionsPage);
            this.addPage((IWizardPage)this.fCollectionsPage);
            this.fProfilePage.setImageDescriptor(UIPlugin.getImageDescriptor("launch_wiz.gif"));
            this.fOptionsPage.setImageDescriptor(UIPlugin.getImageDescriptor("launch_wiz.gif"));
            this.fCollectionsPage.setImageDescriptor(UIPlugin.getImageDescriptor("launch_wiz.gif"));
        }
        this.fHostPage.setImageDescriptor(UIPlugin.getImageDescriptor("launch_wiz.gif"));
        this.fFolderPage.setImageDescriptor(UIPlugin.getImageDescriptor("launch_wiz.gif"));
    }

    public TraceNodeUI getNodeUI() {
        return this.fHostPage.getNodeUI();
    }

    public ArrayList getFilterSet() {
        return this.fProfilePage.getFilterSet();
    }

    public TraceLocationUI getLocation() {
        return this.fFolderPage.getLocation();
    }

    public boolean getAutoMonitoring() {
        return this.fCollectionsPage.getAutoMonitoring();
    }

    public Vector getOptions() {
        if (this.isProfilingEnabled) {
            Vector vector = this.fOptionsPage.getOptions();
            Vector vector2 = this.fCollectionsPage.getOptions();
            vector.addAll(vector2);
            return vector;
        }
        return new Vector();
    }

    public TRCProcessProxy getProcess() {
        return this.fProcess;
    }

    public TRCNode getNode() {
        this.initfProcess();
        return this.fProcess.getNode();
    }

    public Object getSelection() {
        return this.fSelection;
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.setDefaultPageImageDescriptor(UIPlugin.getImageDescriptor("mon_prop_wiz.gif"));
    }

    private void initfProcess() {
        if (this.fSelection instanceof IType) {
            IType iType = (IType)this.fSelection;
            TraceArguments traceArguments = UIPlugin.getDefault().getTraceManager().findTrace(iType);
            if (traceArguments != null) {
                this.fProcess = traceArguments.getProcess();
            }
        } else if (this.fSelection instanceof TRCAgentProxy) {
            this.fProcess = ((TRCAgentProxy)this.fSelection).getProcessProxy();
        } else if (this.fSelection instanceof TRCProcessProxy) {
            this.fProcess = (TRCProcessProxy)this.fSelection;
        }
    }

    public void initializeLocation() {
        this.initfProcess();
        TraceLocationUI traceLocationUI = this.getLocation();
        Path path = new Path(TString.resourcePath(this.fProcess.eResource().getURI()));
        traceLocationUI.setLocation(path.uptoSegment(path.segmentCount() - 1).toString());
        traceLocationUI.setMonitor(this.fProcess.getNode().getMonitor().getName());
    }

    public boolean performFinish() {
        if (!(this.fFolderPage.getFile().equals("") || PDCoreUtil.isPathExists(this.fFolderPage.getFile()) || PDCoreUtil.createDirectoryMessage(this.fFolderPage.getFile(), this.getShell()))) {
            return false;
        }
        WorkspaceModifyDelegatingOperation workspaceModifyDelegatingOperation = new WorkspaceModifyDelegatingOperation((IRunnableWithProgress)this);
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)workspaceModifyDelegatingOperation);
        }
        catch (InvocationTargetException invocationTargetException) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)invocationTargetException.getTargetException().getMessage());
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    public void run(IProgressMonitor iProgressMonitor) {
        boolean bl = this.fFolderPage.finish();
        if (this.isProfilingEnabled) {
            this.fProfilePage.finish();
            this.fOptionsPage.finish();
            this.fCollectionsPage.finish();
        }
        if (bl) {
            bl = this.fProcessPage.finish(this.fFolderPage.getProject(), this.fFolderPage.getMonitor(), this.fFolderPage.getFile());
        }
    }

    public void setAgentFilters() {
        Object object;
        Object object2;
        Object object3;
        if (this.fSelection == null) {
            return;
        }
        TRCProcessProxy tRCProcessProxy = null;
        TRCAgentProxy tRCAgentProxy = null;
        if (this.fSelection instanceof IType) {
            object3 = (IType)this.fSelection;
            object2 = UIPlugin.getDefault().getTraceManager().findTrace((IType)object3);
            if (object2 != null) {
                tRCProcessProxy = ((TraceArguments)object2).getProcess();
                tRCAgentProxy = ((TraceArguments)object2).getAgent();
            }
        } else if (this.fSelection instanceof TRCAgentProxy) {
            tRCAgentProxy = (TRCAgentProxy)this.fSelection;
            tRCProcessProxy = tRCAgentProxy.getProcessProxy();
        } else if (this.fSelection instanceof TRCProcessProxy) {
            tRCProcessProxy = (TRCProcessProxy)this.fSelection;
        }
        object3 = null;
        if (tRCAgentProxy != null) {
            object3 = tRCAgentProxy;
        } else {
            object2 = tRCProcessProxy.getAgentProxies().iterator();
            while (object2.hasNext()) {
                object = (TRCAgentProxy)object2.next();
                if (object.eIsProxy() || !object.getType().equals("Profiler")) continue;
                object3 = object;
                break;
            }
        }
        if (object3 == null) {
            object2 = UIPlugin.getDefault().getPreferenceStore();
            if (object2.getBoolean("prof_option")) {
                object = object2.getString("set_filters");
                this.fProfilePage.setFilters((String)object);
            }
            return;
        }
        this.fProfilePage.setFilters(UIPlugin.getDefault().getPreferenceStore().getString("set_filters"));
        object2 = object3.getConfigurations();
        object = object2.iterator();
        if (object.hasNext()) {
            Object object4;
            Object object5;
            TRCConfiguration tRCConfiguration = (TRCConfiguration)object.next();
            EList eList = tRCConfiguration.getFilters();
            ArrayList<FilterTableElement> arrayList = new ArrayList<FilterTableElement>();
            if (eList != null) {
                object5 = eList.iterator();
                while (object5.hasNext()) {
                    TRCFilter tRCFilter = (TRCFilter)object5.next();
                    object4 = tRCFilter.getOperation();
                    if (object4 != null) {
                        arrayList.add(new FilterTableElement(tRCFilter.getPattern(), (String)object4, tRCFilter.getMode().equals("INCLUDE") ? UIPlugin.getResourceString("STR_INCLUDE") : UIPlugin.getResourceString("STR_EXCLUDE")));
                        continue;
                    }
                    arrayList.add(new FilterTableElement(tRCFilter.getPattern(), "*", tRCFilter.getMode().equals("INCLUDE") ? UIPlugin.getResourceString("STR_INCLUDE") : UIPlugin.getResourceString("STR_EXCLUDE")));
                }
            }
            object5 = this.fProfilePage.getFilterSet();
            int n = 0;
            while (n < ((ArrayList)object5).size()) {
                object4 = (FilterSetElement)((ArrayList)object5).get(n);
                if (((FilterSetElement)object4).getName().equals(tRCConfiguration.getName())) {
                    this.fProfilePage.alterFilterSetChildren((FilterSetElement)object4, arrayList);
                    break;
                }
                ++n;
            }
        }
    }

    public void setAgentOptions() {
        TRCAgentProxy tRCAgentProxy;
        Object object;
        IType iType;
        if (this.fSelection == null) {
            return;
        }
        TRCProcessProxy tRCProcessProxy = null;
        TRCAgentProxy tRCAgentProxy2 = null;
        if (this.fSelection instanceof IType) {
            iType = (IType)this.fSelection;
            object = UIPlugin.getDefault().getTraceManager().findTrace(iType);
            if (object != null) {
                tRCProcessProxy = ((TraceArguments)object).getProcess();
                tRCAgentProxy2 = ((TraceArguments)object).getAgent();
                this.fCollectionsPage.setAutoMonitoring(((TraceArguments)object).isAutoMonitoring());
            }
        } else if (this.fSelection instanceof TRCAgentProxy) {
            tRCAgentProxy2 = (TRCAgentProxy)this.fSelection;
            tRCProcessProxy = tRCAgentProxy2.getProcessProxy();
        } else if (this.fSelection instanceof TRCProcessProxy) {
            tRCProcessProxy = (TRCProcessProxy)this.fSelection;
        }
        iType = null;
        if (tRCAgentProxy2 != null) {
            iType = tRCAgentProxy2;
        } else {
            object = tRCProcessProxy.getAgentProxies().iterator();
            while (object.hasNext()) {
                tRCAgentProxy = (TRCAgentProxy)object.next();
                if (tRCAgentProxy.eIsProxy() || !tRCAgentProxy.getType().equals("Profiler")) continue;
                iType = tRCAgentProxy;
                break;
            }
        }
        if (iType == null) {
            return;
        }
        object = iType.getConfigurations();
        tRCAgentProxy = object.iterator();
        if (tRCAgentProxy.hasNext()) {
            TRCConfiguration tRCConfiguration = (TRCConfiguration)tRCAgentProxy.next();
            EList eList = tRCConfiguration.getOptions();
            if (this.fOptionsPage.getControl() != null) {
                this.fOptionsPage.initializeValues(eList);
            }
            if (this.fCollectionsPage.getControl() != null) {
                this.fCollectionsPage.initializeValues(eList);
            }
        }
    }

    public boolean isProfilingEnabled() {
        return this.isProfilingEnabled;
    }
}

