/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.parsers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.eclipse.hyades.logging.events.ICommonBaseEvent;
import org.eclipse.hyades.logging.events.IExtendedDataElement;
import org.eclipse.hyades.logging.events.ISimpleEventFactory;
import org.eclipse.hyades.logging.events.SimpleEventFactoryImpl;
import org.eclipse.hyades.logging.parsers.IParser;
import org.eclipse.hyades.logging.parsers.LogParserException;
import org.eclipse.hyades.logging.parsers.ParserConstants;
import org.eclipse.hyades.logging.parsers.ParserUtilities;

public abstract class Parser
implements IParser {
    protected static final String UNKNOWN_HOST = "Unknown Host";
    public static final int defaultArraySize = 50;
    protected int MessageArraySize = 50;
    protected ICommonBaseEvent[] messages;
    protected int arrayIndex;
    protected int recordCount = 0;
    protected String originLocale;
    protected String localHostId;
    protected String localHostIdFormat;
    protected String localHostName;
    protected String file_path;
    protected BufferedReader logFile;
    protected String curLine = "";
    protected static ISimpleEventFactory eventFactory = SimpleEventFactoryImpl.getInstance();
    protected Log logger;
    protected long curLineNumber = 0L;

    public void parse(Log log) throws LogParserException {
        try {
            this.logger = log;
            this.preParse();
            ICommonBaseEvent[] iCommonBaseEventArray = this.parseNext();
            while (iCommonBaseEventArray != null) {
                int n = 0;
                while (n < iCommonBaseEventArray.length) {
                    if (iCommonBaseEventArray[n] != null) {
                        this.logger.trace((Object)iCommonBaseEventArray[n]);
                    }
                    ++n;
                }
                iCommonBaseEventArray = this.parseNext();
            }
            this.postParse();
        }
        catch (Throwable throwable) {
            this.postParse();
            LogParserException logParserException = new LogParserException(throwable);
            logParserException.fillInStackTrace();
            throw logParserException;
        }
    }

    public abstract ICommonBaseEvent[] parseNext() throws LogParserException;

    public abstract String getName();

    public abstract String getVersion();

    public ICommonBaseEvent[] getMessages() {
        return this.messages;
    }

    public void preParse() throws LogParserException {
        this.getLocalHostId();
        this.originLocale = this.getLocale();
    }

    public void setUserInput(Hashtable hashtable) throws LogParserException {
        this.setConfiguration(hashtable);
    }

    public void setConfiguration(Hashtable hashtable) throws LogParserException {
        this.file_path = null;
        try {
            Integer n;
            this.file_path = (String)hashtable.get("file_path");
            if (this.file_path != null) {
                this.file_path = ParserConstants.FILE_SEPARATOR_CHARACTER == '/' ? this.file_path.replace('\\', ParserConstants.FILE_SEPARATOR_CHARACTER) : this.file_path.replace('\\', ParserConstants.FILE_SEPARATOR_CHARACTER);
                File file = new File(this.file_path);
                if (!file.isFile()) {
                    throw new FileNotFoundException("The file: " + this.file_path + " does not exist");
                }
                if (!file.canRead()) {
                    throw new IOException("The file: " + this.file_path + " cannot be read");
                }
                this.logFile = new BufferedReader(new FileReader(file));
            }
            if ((n = (Integer)hashtable.get("array_size")) != null) {
                this.MessageArraySize = n;
            }
            this.messages = new ICommonBaseEvent[this.MessageArraySize];
            int n2 = 0;
            while (n2 < this.MessageArraySize) {
                this.messages[n2] = eventFactory.createCommonBaseEvent();
                ++n2;
            }
        }
        catch (Throwable throwable) {
            ParserUtilities.exceptionHandler(throwable, ParserUtilities.getResourceString("REMOTE_LOG_PARSER_CONFIG_PARAMETER_ERROR_"));
        }
    }

    protected void increaseMsgArraySize() {
        ICommonBaseEvent[] iCommonBaseEventArray = new ICommonBaseEvent[++this.MessageArraySize];
        System.arraycopy(this.messages, 0, iCommonBaseEventArray, 0, this.messages.length);
        this.messages = iCommonBaseEventArray;
        this.messages[this.MessageArraySize - 1] = eventFactory.createCommonBaseEvent();
    }

    protected void getLocalHostId() {
        try {
            this.localHostId = InetAddress.getLocalHost().getHostAddress();
            this.localHostIdFormat = this.localHostId.indexOf(58) != -1 ? "IPV6" : "IPV4";
        }
        catch (Exception exception) {
            this.localHostId = UNKNOWN_HOST;
            this.localHostIdFormat = "None";
        }
        try {
            this.localHostName = InetAddress.getByName(this.localHostId).getHostName();
        }
        catch (Exception exception) {
            this.localHostName = null;
        }
    }

    protected String getLocale() {
        String string = System.getProperty("user.language");
        String string2 = System.getProperty("user.region");
        if (string != null && string2 != null) {
            return string.concat("-").concat(string2);
        }
        return "";
    }

    protected boolean isNum(String string, int n) {
        try {
            return Character.isDigit(string.charAt(n));
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean isNum(String string, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            if (!this.isNum(string, n + n3)) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    protected boolean isLet(String string, int n) {
        try {
            return Character.isLetter(string.charAt(n));
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean isLet(String string, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            if (!this.isLet(string, n + n3)) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    protected boolean isChar(String string, int n, char c) {
        try {
            return string.charAt(n) == c;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void postParse() throws LogParserException {
        try {
            if (this.logFile != null) {
                this.logFile.close();
            }
        }
        catch (Exception exception) {
            ParserUtilities.exceptionHandler(exception, "");
        }
    }

    protected String readLine() {
        String string = null;
        try {
            string = this.logFile.readLine();
            ++this.curLineNumber;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    protected static IExtendedDataElement createStringEDE(String string, String string2) {
        IExtendedDataElement iExtendedDataElement = eventFactory.createExtendedDataElement();
        iExtendedDataElement.setName(string);
        int n = 0;
        if (string2 != null && (n = string2.trim().length()) > 1024) {
            iExtendedDataElement.setType(15);
            ArrayList<String> arrayList = new ArrayList<String>();
            int n2 = 0;
            while (n2 < n) {
                arrayList.add(string2.substring(n2, Math.min(n2 + 1024, n)));
                n2 += 1024;
            }
            iExtendedDataElement.setValues(arrayList.toArray(new String[arrayList.size()]));
        } else {
            iExtendedDataElement.setType(6);
            iExtendedDataElement.setValues(new String[]{string2});
        }
        return iExtendedDataElement;
    }
}

