/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.parsers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Substitution;
import org.apache.oro.text.regex.Substitution;
import org.apache.oro.text.regex.Util;
import org.eclipse.hyades.logging.adapter.AdapterException;
import org.eclipse.hyades.logging.adapter.IDirectedGraph;
import org.eclipse.hyades.logging.adapter.internal.util.SubstitutionExtensionLoaderUtil;
import org.eclipse.hyades.logging.adapter.parsers.DirectedGraphImpl;
import org.eclipse.hyades.logging.adapter.parsers.IStatefulSubstitutionExtension;
import org.eclipse.hyades.logging.adapter.parsers.IStatement;
import org.eclipse.hyades.logging.adapter.parsers.ISubstitutionExtension;
import org.eclipse.hyades.logging.adapter.parsers.Parser;
import org.eclipse.hyades.logging.adapter.parsers.PositionParser;
import org.eclipse.hyades.logging.adapter.parsers.PreparationException;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.adapter.util.TimeParser;
import org.w3c.dom.Element;

public class SubstituteStatement
implements IStatement {
    private static Substitution substitution = new Perl5Substitution();
    String name;
    private String positions;
    private String match;
    private String substitute;
    private Pattern pattern;
    private List positionsList;
    private boolean processTime;
    private TimeParser timeParser;
    private String substitutionExtensionClass;
    private IStatefulSubstitutionExtension statefulExtension = null;
    boolean callout = false;
    boolean calloutNewInstance = true;
    Class substitutionExtensionClassClass = null;
    boolean useBuiltin;
    private List path;
    private IDirectedGraph resultGraph;

    public void prepare(Element element, String string) throws PreparationException {
        Object object;
        this.positions = element.getAttribute(Messages.getString("HyadesGAPositionsAttributeName"));
        this.match = element.getAttribute(Messages.getString("HyadesGAMatchAttributeName"));
        this.substitute = element.getAttribute(Messages.getString("HyadesGASubstituteAttributeName"));
        this.substitutionExtensionClass = element.getAttribute(Messages.getString("HyadesGAsubstitutionExtensionClassAttributeName"));
        String string2 = element.getAttribute(Messages.getString("HyadesGAtimeFormatAttributeName"));
        String string3 = element.getAttribute(Messages.getString("HyadesGAuseBuiltInFunctionAttributeName"));
        this.useBuiltin = string3 != null && !string3.equals("") ? string3.equals("true") : false;
        this.name = string;
        if (string2 != null && !string2.equals("") && !this.useBuiltin) {
            this.processTime = true;
            try {
                this.timeParser = new TimeParser(string2);
            }
            catch (AdapterException adapterException) {
                PreparationException preparationException = new PreparationException(Messages.getString("HyadesGA_CBE_Parser_Preparation_Invalid_Time_Format_Error", string2), adapterException);
                preparationException.setDigraph(this.name);
                throw preparationException;
            }
        }
        if (!(this.substitutionExtensionClass == null || this.substitutionExtensionClass.equals("") || this.useBuiltin || this.processTime)) {
            this.callout = true;
            object = null;
            try {
                this.substitutionExtensionClassClass = Class.forName(this.substitutionExtensionClass);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                object = SubstitutionExtensionLoaderUtil.instantiate(this.substitutionExtensionClassClass, this.substitutionExtensionClass);
            }
            catch (ClassCastException classCastException) {
                PreparationException preparationException = new PreparationException(Messages.getString("HyadesGA_CBE_Parser_Run_SubstitutionExtensionClass_Invalid_Error", this.substitutionExtensionClass), classCastException);
                preparationException.setDigraph(this.name);
                throw preparationException;
            }
            catch (ClassNotFoundException classNotFoundException) {
                PreparationException preparationException = new PreparationException(Messages.getString("HyadesGA_CBE_Parser_Preparation_SubstitutionExtensionClass_NotFound_Error", this.substitutionExtensionClass), classNotFoundException);
                preparationException.setDigraph(this.name);
                throw preparationException;
            }
            catch (Exception exception) {
                PreparationException preparationException = new PreparationException(Messages.getString("HyadesGA_CBE_Parser_Preparation_SubstitutionExtensionClass_Exception_Error", this.substitutionExtensionClass), exception);
                preparationException.setDigraph(this.name);
                throw preparationException;
            }
            try {
                this.statefulExtension = (IStatefulSubstitutionExtension)object;
                this.calloutNewInstance = false;
            }
            catch (ClassCastException classCastException) {
                this.calloutNewInstance = true;
            }
        }
        this.resultGraph = null;
        this.path = new ArrayList();
        object = new StringTokenizer(string, ".");
        while (((StringTokenizer)object).hasMoreTokens()) {
            String string4 = ((StringTokenizer)object).nextToken();
            int n = string4.indexOf(91);
            if (n > 0) {
                String string5 = string4.substring(n + 1, string4.length() - 1);
                string4 = string4.substring(0, n);
                this.path.add(string4);
                this.path.add(string5);
                continue;
            }
            this.path.add(string4);
        }
        if (this.positions != null && !this.positions.equals("")) {
            this.positionsList = PositionParser.getPositionedString(this.positions, true);
        }
        if (this.match != null && !this.match.equals("")) {
            try {
                this.pattern = Parser.getCompiler().compile(this.match);
            }
            catch (MalformedPatternException malformedPatternException) {
                PreparationException preparationException = new PreparationException(Messages.getString("HyadesGAMalformedParserExpression"), malformedPatternException);
                preparationException.setDetails("\"" + this.match + "\"|");
                preparationException.setDigraph(this.name);
                throw preparationException;
            }
        }
    }

    public boolean run(String string, HashMap hashMap, List list) throws AdapterException {
        String string2 = string;
        boolean bl = false;
        if (this.useBuiltin) {
            this.resultGraph = new DirectedGraphImpl();
            this.resultGraph.setPath(this.path);
            this.resultGraph.setValue("##BUILTIN");
            list.add(this.resultGraph);
            return true;
        }
        if (this.positions != null && !this.positions.equals("")) {
            string2 = this.positionsToString(string, hashMap);
        }
        if (string2 != null) {
            String string3;
            if (this.pattern != null && !this.pattern.equals("")) {
                string3 = this.matchAndSubstitute(string2);
                if (string3 != null && string2.length() == string3.length() && !Parser.getPatternMatcher().contains(string2, this.pattern)) {
                    bl = false;
                }
                bl = string3 != null;
            } else {
                string3 = this.substitute != null && !this.substitute.equals("") ? this.substitute : string2;
                bl = true;
            }
            if (bl) {
                if (this.processTime) {
                    long l = this.timeParser.parse(string3);
                    if (l == 0L) {
                        this.resultGraph = null;
                        return false;
                    }
                    list.add(this.createResultGraph(new Long(l)));
                    return true;
                }
                if (this.callout) {
                    if (this.calloutNewInstance) {
                        ISubstitutionExtension iSubstitutionExtension;
                        try {
                            iSubstitutionExtension = this.substitutionExtensionClassClass == null ? SubstitutionExtensionLoaderUtil.instantiate(this.substitutionExtensionClass) : (ISubstitutionExtension)this.substitutionExtensionClassClass.newInstance();
                        }
                        catch (Throwable throwable) {
                            throw new AdapterException(Messages.getString("HyadesGA_CBE_Parser_Preparation_SubstitutionExtensionClass_Exception_Error", this.substitutionExtensionClass), throwable);
                        }
                        try {
                            if (string3 == string) {
                                string3 = iSubstitutionExtension.processRecord(string3);
                            }
                            string3 = iSubstitutionExtension.processMatchResult(string3);
                        }
                        catch (Exception exception) {
                            throw new AdapterException(Messages.getString("HyadesGA_CBE_Parser_Run_StatelessSubstitutionExtensionClass_Exception_Error", this.substitutionExtensionClass), exception);
                        }
                    } else {
                        try {
                            string3 = string3 == string ? this.statefulExtension.processRecord(string3) : this.statefulExtension.processMatchResult(string3);
                        }
                        catch (Exception exception) {
                            throw new AdapterException(Messages.getString("HyadesGA_CBE_Parser_Run_StatefulSubstitutionExtensionClass_Exception_Error", this.substitutionExtensionClass), exception);
                        }
                    }
                    if (string3 == null) {
                        this.resultGraph = null;
                        return false;
                    }
                }
                list.add(this.createResultGraph(string3));
                return true;
            }
        }
        this.resultGraph = null;
        return false;
    }

    private String matchAndSubstitute(String string) {
        if (this.substitute != null && !this.substitute.equals("")) {
            if (!Parser.getPatternMatcher().contains(string, this.pattern)) {
                return null;
            }
            ((Perl5Substitution)substitution).setSubstitution(this.substitute);
            String string2 = Util.substitute((PatternMatcher)Parser.getPatternMatcher(), (Pattern)this.pattern, (Substitution)substitution, (String)string, (int)-1);
            return string2.trim();
        }
        return null;
    }

    private String positionsToString(String string, HashMap hashMap) {
        if (this.positionsList != null) {
            StringBuffer stringBuffer = new StringBuffer();
            ListIterator listIterator = this.positionsList.listIterator();
            boolean bl = true;
            boolean bl2 = false;
            while (listIterator.hasNext()) {
                Object object;
                Object e = listIterator.next();
                if (bl) {
                    bl = !bl;
                } else {
                    stringBuffer.append("@@");
                }
                if (e instanceof String) {
                    object = (String)hashMap.get(e);
                    if (object != null && ((String)object).length() > 0) {
                        stringBuffer.append((String)object);
                        continue;
                    }
                    return null;
                }
                if (!(e instanceof Long)) continue;
                object = (Long)e;
                String string2 = null;
                int n = ((Long)object).intValue() - 1;
                string2 = (String)hashMap.get(new Long(n));
                if (string2 != null && string2.length() > 0) {
                    stringBuffer.append(string2);
                    continue;
                }
                return null;
            }
            return stringBuffer.toString();
        }
        return string;
    }

    public IDirectedGraph getResultGraph() {
        return this.resultGraph;
    }

    public IDirectedGraph createResultGraph(Object object) {
        this.resultGraph = new DirectedGraphImpl();
        this.resultGraph.setPath(this.path);
        this.resultGraph.setValue(object);
        return this.resultGraph;
    }
}

