/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.sensors;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.util.Hashtable;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.impl.Sensor;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SingleOSFileSensor
extends Sensor {
    private String directory = null;
    private String fileName = null;
    private String converterCommand = null;
    private String converterShell = null;
    private String rawLogFileName = null;
    private BufferedPeriodicReader input = null;
    private String[] lastLine = new String[this.maximumBlocking];
    private Object currentThreadLock = new Object();
    private int childThreadsDone = 0;
    private String pathSeparator = System.getProperty("file.separator");

    public void stop() {
        super.stop();
        this.clean();
    }

    public void update() throws AdapterInvalidConfig {
        super.update();
        this.lastLine = new String[this.maximumBlocking];
        String string = null;
        String string2 = null;
        String string3 = null;
        Element element = null;
        Element element2 = this.getConfiguration();
        Hashtable hashtable = this.getProperties();
        if (hashtable != null && !hashtable.isEmpty()) {
            string = (String)hashtable.get(Messages.getString("HyadesGAdirectoryAttributeName"));
            string2 = (String)hashtable.get(Messages.getString("HyadesGAfileNameAttributeName"));
            string3 = (String)hashtable.get(Messages.getString("HyadesGAconverterCmdAttributeName"));
            this.converterShell = (String)hashtable.get(Messages.getString("HyadesGAconverterShellAttributeName"));
        } else {
            NodeList nodeList = element2.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                Element element3;
                if (nodeList.item(n).getNodeType() == 1 && (element3 = (Element)nodeList.item(n)).getTagName().equals(Messages.getString("HyadesGASingleFileSensorTagName"))) {
                    element = element3;
                    if (element.hasAttribute(Messages.getString("HyadesGAdirectoryAttributeName"))) {
                        string = element.getAttribute(Messages.getString("HyadesGAdirectoryAttributeName"));
                    }
                    if (element.hasAttribute(Messages.getString("HyadesGAfileNameAttributeName"))) {
                        string2 = element.getAttribute(Messages.getString("HyadesGAfileNameAttributeName"));
                    }
                    if (element.hasAttribute(Messages.getString("HyadesGAconverterCmdAttributeName"))) {
                        string3 = element.getAttribute(Messages.getString("HyadesGAconverterCmdAttributeName"));
                    }
                    if (element.hasAttribute(Messages.getString("HyadesGAconverterShellAttributeName"))) {
                        this.converterShell = element.getAttribute(Messages.getString("HyadesGAconverterShellAttributeName"));
                        if (this.converterShell.length() == 0) {
                            this.converterShell = null;
                        }
                    }
                }
                ++n;
            }
        }
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            throw new AdapterInvalidConfig(Messages.getString("HyadesGA_CBE_SingleFileSensor_Invalid_Config_File_Error"));
        }
        this.setDirectory(string);
        this.setFileName(string2);
        this.setConverterCommand(string3);
    }

    public Object[] testGetNext() {
        return this.testGetNextLine();
    }

    public String[] testGetNextLine() {
        String[] stringArray = new String[2];
        stringArray[0] = "test string";
        return stringArray;
    }

    public Object[] getNext() {
        if (this.rawLogFileName == null) {
            this.rawLogFileName = this.getDirectory().endsWith(this.pathSeparator) ? this.getDirectory() + this.getFileName() : this.getDirectory() + this.pathSeparator + this.getFileName();
            if (this.rawLogFileName != null) {
                try {
                    if (this.input == null) {
                        this.input = new BufferedPeriodicReader(this.rawLogFileName, this.converterCommand, this.converterShell);
                    }
                    this.input.prepare();
                }
                catch (Exception exception) {
                    this.log(exception.toString(), (short)50);
                }
            }
        }
        if (this.input != null) {
            int n = 0;
            while (n < this.maximumBlocking) {
                try {
                    this.lastLine[n] = this.input.readLine();
                }
                catch (Exception exception) {
                    this.log(exception.toString(), (short)30);
                }
                if (this.lastLine[n] == null) {
                    n = this.maximumBlocking;
                    this.rawLogFileName = null;
                }
                ++n;
            }
        }
        if (this.lastLine[0] != null) {
            return this.lastLine;
        }
        return null;
    }

    public void clean() {
        try {
            if (this.input != null) {
                this.input.close();
            }
        }
        catch (Exception exception) {
            this.log(exception.toString(), (short)20);
        }
    }

    public final String getDirectory() {
        return this.directory;
    }

    public final String getFileName() {
        return this.fileName;
    }

    public final String getConverterCommand() {
        return this.converterCommand;
    }

    public final void setDirectory(String string) {
        this.directory = string;
    }

    public final void setFileName(String string) {
        this.fileName = string;
    }

    public final void setConverterCommand(String string) {
        this.converterCommand = string;
    }

    class ConverterOutputReader
    extends Thread {
        private BufferedReader reader;

        public ConverterOutputReader(InputStream inputStream) {
            this.reader = new BufferedReader(new InputStreamReader(inputStream));
        }

        public void run() {
            try {
                while (this.reader.read() != -1) {
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Object object = SingleOSFileSensor.this.currentThreadLock;
            synchronized (object) {
                if (++SingleOSFileSensor.this.childThreadsDone == 2) {
                    SingleOSFileSensor.this.currentThreadLock.notify();
                }
            }
        }
    }

    private class BufferedPeriodicReader {
        private String filename = null;
        private String converter = null;
        private static final long VALIDATION_COMPARE_SIZE = 1024L;
        private static final long VALIDATION_COMPARE_OFFSET = 90L;
        private String shell = null;
        private RandomAccessFile currentFile = null;
        private File currentFileStat = null;
        long lastBookmark = 0L;
        long lastModified = 0L;
        byte[] historicInfo = null;
        private String machine = System.getProperty("os.name", "Windows");
        private boolean zOSMachine = this.machine.equals("z/OS") || this.machine.equals("OS/390");

        public BufferedPeriodicReader(String string) {
            this(string, null, null);
        }

        public BufferedPeriodicReader(String string, String string2) {
            this(string, string2, null);
        }

        public BufferedPeriodicReader(String string, String string2, String string3) {
            this.filename = string;
            this.converter = string2;
            this.shell = string3;
        }

        public void prepare() {
            if (this.converter != null) {
                try {
                    Process process;
                    Object object = SingleOSFileSensor.this.currentThreadLock;
                    synchronized (object) {
                        String[] stringArray;
                        SingleOSFileSensor.this.childThreadsDone = 0;
                        String string = System.getProperty("os.name", null);
                        if (string.startsWith("Windows")) {
                            process = Runtime.getRuntime().exec(this.converter);
                        } else if (string.startsWith("AIX")) {
                            if (this.shell == null) {
                                this.shell = "sh";
                            }
                            stringArray = new String[]{this.shell, this.converter};
                            process = Runtime.getRuntime().exec(stringArray);
                        } else {
                            if (this.shell == null) {
                                this.shell = "sh";
                            }
                            stringArray = this.shell + " " + this.converter;
                            process = Runtime.getRuntime().exec((String)stringArray);
                        }
                        new ConverterOutputReader(process.getErrorStream()).start();
                        new ConverterOutputReader(process.getInputStream()).start();
                        try {
                            SingleOSFileSensor.this.currentThreadLock.wait(300000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    int n = -1;
                    try {
                        n = process.waitFor();
                    }
                    catch (InterruptedException interruptedException) {
                        process.destroy();
                    }
                    if (n != 0) {
                        throw new Exception();
                    }
                }
                catch (Exception exception) {
                    SingleOSFileSensor.this.log(exception.toString(), (short)50);
                }
            }
            try {
                this.currentFileStat = new File(this.filename);
                if (this.currentFileStat.lastModified() > this.lastModified) {
                    this.currentFile = new RandomAccessFile(this.filename, "r");
                    this.lastModified = this.currentFileStat.lastModified();
                }
            }
            catch (Exception exception) {
                this.currentFile = null;
            }
            if (this.lastBookmark != 0L && this.currentFile != null) {
                try {
                    int n;
                    long l = this.lastBookmark;
                    long l2 = this.currentFile.length();
                    long l3 = Math.min(Math.min(1024L, l), l2);
                    if (l2 >= l) {
                        boolean bl = true;
                        int n2 = 90;
                        while ((long)n2 < l3) {
                            this.currentFile.seek(l - 1L - (long)n2);
                            n = (char)this.currentFile.read();
                            if (this.historicInfo[n2] != (byte)n) {
                                bl = false;
                                break;
                            }
                            ++n2;
                        }
                        if (bl) {
                            this.currentFile.seek(l - 90L);
                            n = 89;
                            while (n >= 0) {
                                int n3 = this.currentFile.read();
                                if (this.historicInfo[n] != (byte)n3) break;
                                --n;
                            }
                            this.historicInfo = null;
                            this.lastBookmark = this.currentFile.getFilePointer();
                            return;
                        }
                    }
                    long l4 = 0L;
                    n = 90;
                    long l5 = l2 -= 90L;
                    do {
                        this.currentFile.seek(--l5);
                        if (this.historicInfo[n++] == this.currentFile.read()) {
                            ++l4;
                            continue;
                        }
                        l5 = --l2;
                        n = 90;
                        l4 = 0L;
                    } while (l4 < l3 - 90L && l2 > 0L);
                    if (l4 == l3 - 90L) {
                        this.currentFile.seek(l2);
                        int n4 = 89;
                        while (n4 >= 0) {
                            int n5 = this.currentFile.read();
                            if (this.historicInfo[n4] != (byte)n5) {
                                this.historicInfo = null;
                                this.lastBookmark = this.currentFile.getFilePointer();
                                return;
                            }
                            --n4;
                        }
                        this.historicInfo = null;
                        this.lastBookmark = l2 + 90L;
                        return;
                    }
                    this.historicInfo = null;
                    this.lastBookmark = 0L;
                    return;
                }
                catch (IOException iOException) {
                    SingleOSFileSensor.this.log(iOException.toString(), (short)30);
                }
            }
        }

        public void close() {
            try {
                if (this.currentFile != null) {
                    this.currentFile.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.currentFile = null;
        }

        public String readLine() throws IOException {
            if (this.currentFile != null) {
                String string = null;
                this.currentFile.seek(this.lastBookmark);
                if (this.currentFile != null) {
                    int n;
                    try {
                        if (this.zOSMachine) {
                            n = (int)(this.currentFile.length() - this.lastBookmark) + 1;
                            byte[] byArray = new byte[n];
                            int n2 = 0;
                            int n3 = 0;
                            while (n3 < n) {
                                byte by = (byte)this.currentFile.read();
                                if (by == -1) {
                                    n2 = -1;
                                    break;
                                }
                                if (by == 21) break;
                                byArray[n3] = by;
                                ++n2;
                                ++n3;
                            }
                            string = n2 == -1 ? null : new String(byArray, 0, n2);
                        } else {
                            string = this.currentFile.readLine();
                        }
                    }
                    catch (EOFException eOFException) {
                        string = null;
                    }
                    catch (NullPointerException nullPointerException) {
                        string = null;
                    }
                    if (string != null) {
                        this.lastBookmark = this.currentFile.getFilePointer();
                        return string;
                    }
                    n = (int)Math.min(this.currentFile.length(), 1024L);
                    this.currentFile.seek(this.currentFile.length() - (long)n);
                    this.historicInfo = new byte[n];
                    int n4 = n - 1;
                    while (n4 >= 0) {
                        this.historicInfo[n4] = (byte)this.currentFile.read();
                        --n4;
                    }
                    this.close();
                }
            }
            return null;
        }
    }
}

