/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.collection.threadanalyzer.dumpparser;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.SwingUtilities;
import org.eclipse.hyades.collection.threadanalyzer.DumpData;
import org.eclipse.hyades.collection.threadanalyzer.TAUtils;
import org.eclipse.hyades.collection.threadanalyzer.ThreadDump;
import org.eclipse.hyades.collection.threadanalyzer.dumpparser.DumpParserHP;
import org.eclipse.hyades.collection.threadanalyzer.dumpparser.DumpParserLinux;
import org.eclipse.hyades.collection.threadanalyzer.dumpparser.DumpParserLinux131;
import org.eclipse.hyades.collection.threadanalyzer.dumpparser.DumpParserLinux131_Suse_cxppc;
import org.eclipse.hyades.collection.threadanalyzer.dumpparser.DumpParserNT;
import org.eclipse.hyades.collection.threadanalyzer.dumpparser.DumpParserSolaris;
import org.eclipse.hyades.collection.threadanalyzer.dumpparser.DumpParserSolaris40;
import org.eclipse.hyades.collection.threadanalyzer.dumpparser.DumpParser_a118_20010215a;
import org.eclipse.hyades.collection.threadanalyzer.dumpparser.DumpParser_ca122_20001026b;
import org.eclipse.hyades.collection.threadanalyzer.dumpparser.DumpParser_ca131_20020722;
import org.eclipse.hyades.collection.threadanalyzer.dumpparser.DumpParser_ca1411_20031011;
import org.eclipse.hyades.collection.threadanalyzer.dumpparser.DumpParser_cn130_20010502;
import org.eclipse.hyades.collection.threadanalyzer.dumpparser.DumpParser_cn131_20020223;
import org.eclipse.hyades.collection.threadanalyzer.dumpparser.DumpParser_cn131_20021012;
import org.eclipse.hyades.collection.threadanalyzer.dumpparser.DumpParser_cxia32131_20021023;

public class DumpParser {
    private static DumpParser instance = null;
    private boolean cmdLine = false;
    protected boolean newDump = false;
    protected boolean recordLineFlag = true;
    protected static String[] _validArgNames = new String[]{"streamIn", "streamOut", "dumpIn", "detailXML", "logLevel", "reportOut", "reportType", "analyze", "dumpInType"};
    public static final int DEBUG = 4;
    public static final int DETAIL = 3;
    public static final int INFO = 2;
    public static final int WARNING = 1;
    public static final int ERROR = 0;
    protected static int _logLevel = 2;
    private static final int LINUX130 = 1;
    private static final int AIX = 2;
    private static final int SOLARIS35 = 3;
    private static final int NT = 4;
    private static final int HPUX = 5;
    private static final int INTERNAL = 6;
    private static final int ca122_20001026b = 7;
    private static final int a118_20010215a = 8;
    private static final int a118_20000411 = 9;
    private static final int cn130_20010502 = 10;
    private static final int cn122_20001026 = 11;
    private static final int cn131_20020223 = 12;
    private static final int ca131_20020722 = 13;
    private static final int cn131_20021012 = 14;
    private static final int ca1411_20031011 = 18;
    private static final int cn1411_20031011 = 19;
    private static final int LINUX131 = 15;
    private static final int LINUX131_2 = 16;
    private static final int LINUX131_CXPPC = 17;
    private static final int UNKNOWN = 99;
    protected int _lineNo = 0;
    protected BufferedReader _r;
    protected static Hashtable _args = new Hashtable();
    protected static String _dumpInName;
    protected static String _dumpingJvmName;

    public DumpParser() {
        this.cmdLine = false;
    }

    public DumpParser(boolean bl) {
        this.cmdLine = bl;
    }

    public static void main(String[] stringArray) {
        instance = new DumpParser(true);
        instance.doIt(stringArray);
    }

    public void doIt(String[] stringArray) {
        DumpParser dumpParser = null;
        this.parseArgs(stringArray);
        boolean bl = !DumpParser.getArg("reportType").equalsIgnoreCase("none");
        String string = DumpParser.getArg("streamIn");
        String string2 = DumpParser.getArg("dumpIn");
        if (string != null && string2 != null) {
            DumpParser.logErr(TAUtils.getNLSValue("ta.errmsg.SpecifyOnlyOne", "Must specify only one of { streamIn or dumpIn }"));
            DumpParser.syntax();
        }
        if (string == null && string2 == null) {
            DumpParser.logErr(TAUtils.getNLSValue("ta.errmsg.MustSpecifyDumpIn", "Must specify dumpIn"));
            DumpParser.syntax();
        }
        String string3 = DumpParser.getArg("reportOut");
        String string4 = DumpParser.getArg("streamOut");
        String string5 = DumpParser.getArg("reportType");
        if (!(string5.equalsIgnoreCase("html") || string5.equalsIgnoreCase("text") || string5.equalsIgnoreCase("none"))) {
            DumpParser.logErr(TAUtils.getNLSValue("ta.errmsg.ReportTypeMustBe", "reportType must be either 'html', 'text' or 'none'"));
            DumpParser.syntax();
        }
        if (string2 != null) {
            DumpData dumpData = null;
            try {
                dumpParser = DumpParser.create(string2);
                DumpParser.logDebug("dumpName=\t" + string2);
                DumpParser.logDebug("DumpParser=\t" + dumpParser.getClass().getName());
                _dumpInName = new String(string2);
                dumpData = new DumpData();
                dumpData.setDumpParserClassName(dumpParser.getClass().getName());
                dumpData.setInputFilename(string2);
                dumpData.setLogLevel(DumpParser.logLevelFromArgs());
                if (DumpParser.extraCarriageReturns(string2)) {
                    String string6 = string2;
                    Runnable runnable = new Runnable(){

                        public void run() {
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                    return;
                }
                dumpParser.parse(dumpData);
                if (!this.cmdLine) {
                    if (string4 != null) {
                        // empty if block
                    }
                } else {
                    DumpParser.logInfo("Successfully parsed: " + string2);
                }
            }
            catch (Exception exception) {
                if (_logLevel >= 4) {
                    exception.printStackTrace();
                }
                String string7 = string2;
                String string8 = exception.getMessage();
                if (!this.cmdLine) {
                    Runnable runnable = new Runnable(){

                        public void run() {
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                } else {
                    DumpParser.logErr("Errors occurred parsing: " + string7);
                }
                return;
            }
            if (dumpParser._r != null) {
                try {
                    dumpParser._r.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (string4 == null && bl) {
                DumpParser.logDebug("streamOutName == null & fWriteReport");
                if (DumpParser.getArg("reportOut").equalsIgnoreCase("DEFAULT")) {
                    dumpData.print();
                } else {
                    dumpData.print(DumpParser.getArg("reportOut"));
                }
            } else if (string4 != null) {
                try {
                    DumpParser.logDebug("DumpParser.main()  trying to write to: " + string4);
                    dumpData.writeTo(string4);
                }
                catch (Throwable throwable) {
                    DumpParser.logErr(TAUtils.getNLSValue("ta.errmsg.ExceptionOccurred", "an exception occurred."));
                    throwable.printStackTrace();
                }
            }
        } else {
            try {
                DumpData dumpData = DumpData.readFrom(string);
                dumpData.setLogLevel(DumpParser.logLevelFromArgs());
                if (bl) {
                    dumpData.print();
                }
            }
            catch (Exception exception) {
                DumpParser.logErr(TAUtils.getNLSValue("ta.errmsg.ExceptionOccurred", "an exception occurred."));
                exception.printStackTrace();
            }
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static boolean extraCarriageReturns(String string) throws FileNotFoundException, IOException {
        boolean bl = false;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        DumpParser.logDebug("[DumpParser] detecting first EOL");
        char c = '\u0000';
        while ((c = (char)bufferedReader.read()) != '\r') {
            if (_logLevel >= 4) {
                System.err.print(c);
            }
            if (c != '\n') continue;
            bl = true;
            break;
        }
        DumpParser.logDebug("\n[DumpParser] Found EOL !!!");
        if (!bl && bufferedReader.read() == 13) {
            DumpParser.logDebug("[DumpParser] extra carriage returns detected.  quitting...");
            return true;
        }
        return false;
    }

    public static DumpParser create(String string) throws Exception {
        BufferedReader bufferedReader;
        int n = 99;
        n = DumpParser.getDumpParserTypeFromFile(string);
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
        }
        catch (Exception exception) {
            DumpParser.logErr(TAUtils.getNLSValue("ta.errmsg.ErrOpeningFile", "Error Opening File ") + string);
            throw exception;
        }
        DumpParser dumpParser = null;
        dumpParser = DumpParser.createParser(n, bufferedReader);
        return dumpParser;
    }

    public static int getDumpParserTypeFromFile(String string) throws Exception {
        int n = 99;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
        }
        catch (Exception exception) {
            DumpParser.logErr("dumpparser: " + TAUtils.getNLSValue("ta.errmsg.ErrOpeningFile", "Error Opening File ") + string);
            throw exception;
        }
        int n2 = 0;
        while (n2 < 75) {
            String string2 = bufferedReader.readLine();
            if (string2 == null) break;
            n = DumpParser.getDumpParserType(string2);
            if (n != 99) {
                _dumpingJvmName = string2.substring(string2.indexOf(" ") + 1);
                break;
            }
            ++n2;
        }
        return n;
    }

    public static int getDumpParserTypeFromDumpData(DumpData dumpData) {
        int n = 99;
        ThreadDump threadDump = null;
        threadDump = dumpData.getThreadDump();
        Enumeration enumeration = threadDump.getEnumerator();
        int n2 = 0;
        while (n2 < 75) {
            String string = threadDump.getNextLine(enumeration);
            n = DumpParser.getDumpParserType(string);
            if (n != 99) break;
            ++n2;
        }
        return n;
    }

    private static int getDumpParserType(String string) {
        int n = 99;
        if (string.indexOf("IBM build a118") != -1) {
            DumpParser.logDebug("jdk build: a118...");
            n = 8;
        }
        if (string.indexOf("IBM AIX build") != -1) {
            if (string.indexOf("IBM AIX build ca131") != -1) {
                DumpParser.logDebug("jdk AIX build: ca131...");
                n = 7;
            }
            if (string.indexOf("IBM AIX build ca131-20021") != -1 || string.indexOf("IBM AIX build ca131-2003") != -1) {
                DumpParser.logDebug("jdk AIX build: ca131-20021...");
                n = 16;
            }
            if (string.indexOf("IBM AIX build ca1411") != -1) {
                DumpParser.logDebug("jdk AIX build: ca1411...");
                n = 18;
            }
        }
        if (string.indexOf("IBM build ca130") != -1) {
            DumpParser.logDebug("jdk build: ca130...");
            n = 7;
        }
        if (string.indexOf("IBM build ca122") != -1) {
            DumpParser.logDebug("jdk build: ca122...");
            n = 7;
        }
        if (string.indexOf("IBM build cx130") != -1) {
            DumpParser.logDebug("jdk build: cx130...");
            n = 1;
        }
        if (string.indexOf("IBM build cn122") != -1) {
            DumpParser.logDebug("jdk build: cn122...");
            n = 11;
        }
        if (string.indexOf("IBM build cn130") != -1) {
            DumpParser.logDebug("jdk build: cn130...");
            n = 10;
        }
        if (string.indexOf("IBM Windows 32 build cn131") != -1) {
            DumpParser.logDebug("jdk build: cn131...");
            n = 12;
        }
        if (string.indexOf("A SIGQUIT has been received. Do you want to:") != -1) {
            DumpParser.logDebug(TAUtils.getNLSValue("ta.errmsg.FileTypeWs35ForSolaris", "File type ws 35 for solaris"));
            n = 3;
        }
        if (string.indexOf("cn130-20010925") != -1) {
            DumpParser.logDebug("jdk build: cn130-20010925");
            n = 10;
        }
        if (string.indexOf("cn130-20010914") != -1) {
            DumpParser.logDebug("jdk build: cn130-20010914");
            n = 10;
            if (string.indexOf("Classic VM") != -1) {
                n = 11;
            }
        }
        if (string.indexOf("cn130-20010609") != -1) {
            DumpParser.logDebug("jdk build: cn130-20010609");
            n = 10;
        }
        if (string.indexOf("cn130-20010502") != -1) {
            DumpParser.logDebug("jdk build: cn130-20010502");
            n = 10;
        }
        if (string.indexOf("cn1411-20031011") != -1) {
            DumpParser.logDebug("jdk build: cn1411-20031011");
            n = 19;
        }
        if (string.indexOf("ca122-20010629") != -1) {
            DumpParser.logDebug("jdk build: ca122-20010629");
            n = 7;
        }
        if (string.indexOf("ca122-20001026b") != -1) {
            DumpParser.logDebug("jdk build: ca122-20001026b");
            n = 7;
        }
        if (string.indexOf("c390_x122-20010316") != -1) {
            DumpParser.logDebug("jdk build: c390_x122-20010316");
            n = 11;
        }
        if (string.indexOf("cn122-20010629") != -1) {
            DumpParser.logDebug("jdk build: cn122-20010629");
            n = 11;
            if (string.indexOf("Classic VM") == -1) {
                n = 10;
            }
        }
        if (string.indexOf("cn122-20010503a") != -1) {
            DumpParser.logDebug("jdk build: cn130...");
            n = 10;
        }
        if (string.indexOf("cn122-20010929") != -1) {
            DumpParser.logDebug("jdk build: cn130...");
            n = 10;
        }
        if (string.indexOf("cn122-20010308") != -1) {
            DumpParser.logDebug("jdk build: cn122-20010308");
            n = 11;
        }
        if (string.indexOf("cn122-20001026") != -1) {
            DumpParser.logDebug("jdk build: cn122-20001026");
            n = 11;
        }
        if (string.indexOf("ca122-20001026") != -1) {
            DumpParser.logDebug("jdk build: ca122-20001026");
            n = 7;
        }
        if (string.indexOf("ca130-20010713") != -1) {
            DumpParser.logDebug("jdk build: ca130-20010713");
            n = 7;
        }
        if (string.indexOf("ca130-20010615") != -1) {
            DumpParser.logDebug("jdk build: ca130-20010615");
            n = 7;
        }
        if (string.indexOf("ca130-20010330") != -1) {
            DumpParser.logDebug("jdk build: ca130-20010330");
            n = 7;
        }
        if (string.indexOf("ca122-20010313") != -1) {
            DumpParser.logDebug("jdk build: ca122-20010313");
            n = 7;
        }
        if (string.indexOf("a118-20010804") != -1) {
            DumpParser.logDebug("jdk build: a118-20010804");
            n = 8;
        }
        if (string.indexOf("a118-20010215a") != -1) {
            DumpParser.logDebug("jdk build: a118-20010215a");
            n = 8;
        }
        if (string.indexOf("a118-20000411") != -1) {
            DumpParser.logDebug("jdk build: a118-20000411");
            n = 8;
        }
        if (string.indexOf("lwp_id") != -1) {
            DumpParser.logDebug("lwp_id...indicates HP");
            n = 5;
        }
        if (string.indexOf("cx390130") != -1 || string.indexOf("cxia32130") != -1) {
            DumpParser.logDebug("J2RE 1.3.0 IBM build for Linux");
            n = 1;
        }
        if (string.indexOf("cx3901411-20031011") != -1) {
            DumpParser.logDebug("jdk build:  cx3901411-20031011");
            n = 16;
        }
        if (string.indexOf("IBM build cxppc") != -1) {
            DumpParser.logDebug("IBM build cxppc - Linux/Suse");
            n = 17;
        }
        if (string.indexOf("cx390131") != -1 || string.indexOf("cxia32131") != -1) {
            DumpParser.logDebug("J2RE 1.3.1 IBM build for Linux");
            n = 15;
        }
        if (string.indexOf("cxia32131-20021") != -1 || string.indexOf("cxia32131-2003") != -1 || string.indexOf("cx390131-20021") != -1 || string.indexOf("cx390131-2003") != -1) {
            DumpParser.logDebug("J2RE 1.3.1 IBM build for Linux");
            n = 16;
        }
        if (string.indexOf("cn131w-20020223") != -1) {
            DumpParser.logDebug("J2RE 1.3.1 IBM Windows 32 build cn131w-20020223 ORB130");
            n = 12;
        }
        if (string.indexOf("cn131-20021") != -1 || string.indexOf("cn131-2003") != -1 || string.indexOf("cn131w-20021") != -1 || string.indexOf("cndev-2003") != -1 || string.indexOf("cndev-2004") != -1 || string.indexOf("cn142-2004") != -1 || string.indexOf("cn131w-2003") != -1) {
            DumpParser.logDebug("Compatible with parser for IBM Windows 32 build cn131-20021012");
            n = 14;
        }
        return n;
    }

    public static DumpParser createParser(int n, BufferedReader bufferedReader) {
        DumpParser dumpParser = null;
        dumpParser = n == 11 ? new DumpParserNT() : (n == 13 ? new DumpParser_ca131_20020722() : (n == 19 ? new DumpParser_cn131_20021012() : (n == 14 ? new DumpParser_cn131_20021012() : (n == 12 ? new DumpParser_cn131_20020223() : (n == 10 ? new DumpParser_cn130_20010502() : (n == 7 ? new DumpParser_ca122_20001026b() : (n == 18 ? new DumpParser_ca1411_20031011() : (n == 8 || n == 9 ? new DumpParser_a118_20010215a() : (n == 3 ? new DumpParserSolaris() : (n == 5 ? new DumpParserHP() : (n == 1 ? new DumpParserLinux() : (n == 15 ? new DumpParserLinux131() : (n == 16 ? new DumpParser_cxia32131_20021023() : (n == 17 ? new DumpParserLinux131_Suse_cxppc() : new DumpParserSolaris40()))))))))))))));
        dumpParser._r = bufferedReader;
        _logLevel = DumpParser.logLevelFromArgs();
        return dumpParser;
    }

    private static int logLevelFromArgs() {
        int n = 2;
        String string = DumpParser.getArg("logLevel");
        if (string != null) {
            if (string.equalsIgnoreCase("error")) {
                n = 0;
            }
            if (string.equalsIgnoreCase("warn")) {
                n = 1;
            }
            if (string.equalsIgnoreCase("info")) {
                n = 2;
            }
            if (string.equalsIgnoreCase("detail")) {
                n = 3;
            }
            if (string.equalsIgnoreCase("debug")) {
                n = 4;
            }
        }
        return n;
    }

    protected String getLine() throws Exception {
        String string = null;
        if (this._r.ready()) {
            ++this._lineNo;
            string = this._r.readLine();
        }
        DumpParser.logDebug("line " + this._lineNo + ": " + string);
        return string;
    }

    protected String getLine(DumpData dumpData) throws Exception {
        String string = null;
        string = this.getLine();
        if (this.recordLineFlag) {
            dumpData.addDumpTextLine(string, this._lineNo);
        }
        if (this.newDump && string != null) {
            int n = string.indexOf(32);
            String string2 = string.substring(n);
            string2.trim();
            return string2;
        }
        return string;
    }

    protected void resetFileReader() throws Exception {
        try {
            this._r.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this._r = new BufferedReader(new FileReader(_dumpInName));
            this._lineNo = 0;
        }
        catch (Exception exception) {
            DumpParser.logErr(TAUtils.getNLSValue("ta.errmsg.ErrOpeningFile", "Error Opening File ") + _dumpInName);
            throw exception;
        }
    }

    protected static void syntax() {
        DumpParser.logErr("DumpParser " + TAUtils.getNLSValue("ta.string.syntax", "syntax") + ":");
        DumpParser.logErr("   { dumpIn=filename }");
        DumpParser.logErr("   [ logLevel={ERROR | WARN | INFO | DETAIL | DEBUG} (default:INFO) ]");
        DumpParser.logErr("   [ reportType={ TEXT | HTML | NONE } ( default is HTML ) ] ");
        DumpParser.logErr("   [ dumpInType={ SERVEROUT | JAVACORE } ( default is JAVACORE ) ] ");
    }

    public void parseArgs(String[] stringArray) {
        Object object;
        int n = 0;
        while (n < _validArgNames.length) {
            object = null;
            if (_validArgNames[n].equals("detailXML")) {
                object = "./threadanalyzerdetail.xml";
            }
            if (_validArgNames[n].equals("reportOut")) {
                object = "default";
            }
            if (_validArgNames[n].equals("reportType")) {
                object = "html";
            }
            if (_validArgNames[n].equals("analyze")) {
                object = "was";
            }
            if (_validArgNames[n].equals("dumpInType")) {
                object = "javaCore";
            }
            _args.put(_validArgNames[n].toUpperCase(), new Arg((String)object));
            ++n;
        }
        object = null;
        object = _args.keys();
        block1: while (object.hasMoreElements()) {
            String string = (String)object.nextElement();
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (stringArray[n2].toUpperCase().startsWith(string.toUpperCase())) {
                    String string2 = null;
                    int n3 = stringArray[n2].toUpperCase().indexOf(string.toUpperCase() + "=");
                    if (n3 == -1) {
                        DumpParser.syntax();
                    }
                    if ((string2 = stringArray[n2].substring((n3 = stringArray[n2].indexOf("=")) + 1)).length() <= 0) {
                        DumpParser.syntax();
                    }
                    if (!(!string.equalsIgnoreCase("logLevel") || string2.equalsIgnoreCase("ERROR") || string2.equalsIgnoreCase("WARN") || string2.equalsIgnoreCase("INFO") || string2.equalsIgnoreCase("DETAIL") || string2.equalsIgnoreCase("DEBUG"))) {
                        DumpParser.syntax();
                    }
                    if (!(!string.equalsIgnoreCase("analyze") || string2.equalsIgnoreCase("WAS") || string2.equalsIgnoreCase("EJB") || string2.equalsIgnoreCase("SERVLET") || string2.equalsIgnoreCase("ALL"))) {
                        DumpParser.syntax();
                    }
                    _args.put(string.toUpperCase(), new Arg(string2));
                    continue block1;
                }
                ++n2;
            }
        }
    }

    public void parse(DumpData dumpData) throws Exception {
    }

    protected static void logErr(String string) {
        System.err.println(string);
    }

    protected static void logWarn(String string) {
        if (_logLevel >= 1) {
            System.err.println(string);
        }
    }

    protected static void logInfo(String string) {
        if (_logLevel >= 2) {
            System.err.println(TAUtils.getNLSValue("ta.button.Info", "INFO") + ": " + string);
        }
    }

    protected static void logDetail(String string) {
        if (_logLevel >= 3) {
            System.err.println(string);
        }
    }

    protected static void logDebug(String string) {
        if (_logLevel >= 4) {
            System.err.println(string);
        }
    }

    public int getLogLevel() {
        return _logLevel;
    }

    public static String getArg(String string) {
        String string2 = null;
        Arg arg = (Arg)_args.get(string.toUpperCase());
        if (arg != null) {
            string2 = arg.get();
        } else {
            DumpParser.logErr(TAUtils.getNLSValue("ta.errmsg.CantFindArg", "can't find argument") + ": " + string.toUpperCase());
        }
        return string2;
    }

    public static void setDumpInName(String string) {
        _dumpInName = string;
    }

    public String getDumpingJvmName() {
        return _dumpingJvmName;
    }

    class Arg {
        public String _arg;

        public Arg(String string) {
            this._arg = string;
        }

        public String get() {
            return this._arg;
        }
    }
}

