/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.collection.threadanalyzer.dumpparser;

import org.eclipse.hyades.collection.threadanalyzer.DumpData;
import org.eclipse.hyades.collection.threadanalyzer.Monitor;
import org.eclipse.hyades.collection.threadanalyzer.StkEntry;
import org.eclipse.hyades.collection.threadanalyzer.TAUtils;
import org.eclipse.hyades.collection.threadanalyzer.TaException;
import org.eclipse.hyades.collection.threadanalyzer.Thd;
import org.eclipse.hyades.collection.threadanalyzer.dumpparser.DumpParser;

public class DumpParserNT
extends DumpParser {
    public void parse(DumpData dumpData) throws Exception {
        DumpParser.logDebug(TAUtils.getNLSValue("ta.string.parse", "parse"));
        try {
            if (this._r.ready()) {
                String string = this._r.readLine();
                this.getThreadData(dumpData);
                this.getMonitorPoolStats(dumpData);
                this.getMonitors(dumpData);
                this.getHeapLockWaiters(dumpData);
            }
        }
        catch (Exception exception) {
            DumpParser.logErr(TAUtils.getNLSValue("ta.errmsg.ExceptionWhileParsing", "exception while parsing line") + ": " + this._lineNo + " -- " + DumpParser._dumpInName);
            throw new TaException("" + this._lineNo, exception);
        }
    }

    private void getHeapLockWaiters(DumpData dumpData) throws Exception {
        String string = this.getLine(dumpData);
        while (string != null && string.indexOf("Heap lock:") < 0) {
            DumpParser.logDebug(string);
            string = this.getLine(dumpData);
        }
        string = this.getLine(dumpData);
        if (string == null) {
            return;
        }
        if (string.indexOf("Waiting to enter:") >= 0) {
            Monitor monitor = dumpData.addMonitor("HEAP_LOCK", 1);
            string = this.getLine(dumpData);
            DumpParser.logDebug(TAUtils.getNLSValue("ta.logdebug.HeapLockWaiters", "Heap lock waiters") + ": ");
            while (string.charAt(0) == '\t') {
                DumpParser.logDebug(" -- " + string);
                String string2 = null;
                int n = string.indexOf(40);
                string2 = string.substring(n + 1, string.indexOf(41));
                Thd thd = dumpData.getThd(string2);
                monitor.addWaiter(thd);
                DumpParser.logDebug("  *" + string2 + "*");
                string = this.getLine(dumpData);
            }
        }
    }

    private void getMonitorPoolStats(DumpData dumpData) throws Exception {
        String string = null;
        string = this.getLine(dumpData);
        while (string != null && string.length() > 0) {
            string = this.getLine(dumpData);
        }
    }

    private void getMonitors(DumpData dumpData) throws Exception {
        boolean bl = false;
        String string = null;
        string = this.getLine(dumpData);
        string = this.getLine(dumpData);
        while (!bl) {
            string = this.getLine(dumpData);
            if (string == null) {
                bl = true;
                continue;
            }
            int n = string.indexOf(58);
            String string2 = string.substring(0, n);
            string2.trim();
            Monitor monitor = dumpData.addMonitor(string2, 1);
            DumpParser.logDebug(" -" + TAUtils.getNLSValue("ta.string.monitor", "monitor") + " " + string2);
            string = this.getLine(dumpData);
            string = this.getLine(dumpData);
            while (string.length() > 0 && string.charAt(0) == '\t') {
                if (string.indexOf("Waiting to be notified:") == -1) {
                    DumpParser.logDebug(" -- " + TAUtils.getNLSValue("ta.string.waiter", "waiter") + " " + string);
                    String string3 = null;
                    n = string.indexOf(40);
                    string3 = string.substring(n + 1, string.indexOf(41));
                    Thd thd = dumpData.getThd(string3);
                    monitor.addWaiter(thd);
                }
                string = this.getLine(dumpData);
            }
            if (string.length() != 0) continue;
            bl = true;
        }
    }

    private void getThreadData(DumpData dumpData) throws Exception {
        String string = null;
        char c = '\u0000';
        string = this.getLine(dumpData);
        Thd thd = null;
        while (string.length() > 0 && string.indexOf("Monitor pool info") == -1) {
            String string2;
            String string3;
            String string4;
            String string5;
            boolean bl;
            c = string.charAt(0);
            if (c == ' ') {
                int n = string.indexOf(34);
                bl = string.indexOf(34, n + 1);
                string5 = string.substring(n + 1, bl ? 1 : 0);
                n = string.indexOf("sys_thread_t:");
                string4 = string.substring(n);
                bl = string4.indexOf(44);
                String string6 = string4.substring(13, bl ? 1 : 0);
                n = string.indexOf("state:") + 6;
                bl = string.indexOf(44, n);
                string3 = string.substring(n, bl ? 1 : 0);
                n = string.indexOf("prio=");
                string2 = string.substring(n + 5);
                DumpParser.logDebug(string5 + " - " + string6 + " - " + string3 + " - " + string2);
                thd = dumpData.addThd(string5, string6, string3, string2);
            } else if (string.indexOf("...") == -1 && string.indexOf(", sp =") == -1 && string.indexOf("javacore") == -1) {
                String string7 = string.substring(4);
                bl = false;
                string5 = null;
                string4 = null;
                int n = string7.indexOf("(Native Method)");
                if (n > 0) {
                    bl = true;
                    string7 = string7.substring(0, n);
                } else {
                    n = string7.indexOf("(Unknown Source)");
                    if (n > 0) {
                        string7 = string7.substring(0, n);
                    } else {
                        n = string7.indexOf("(");
                        string3 = string7.substring(++n);
                        DumpParser.logDebug(TAUtils.getNLSValue("ta.logdebug.ModuleInfo", "Moduleinfo") + ": " + string3);
                        string7 = string7.substring(0, n - 1);
                        int n2 = string3.indexOf(58);
                        if (n2 > -1) {
                            string4 = string3.substring(n2 + 1, string3.indexOf(41, n2));
                            string5 = string3.substring(0, n2);
                        } else {
                            n2 = string3.indexOf(40);
                            if (n2 == -1) {
                                n2 = string3.indexOf(41);
                            }
                            string5 = string3.substring(0, n2);
                        }
                    }
                }
                string3 = string7.substring(string7.lastIndexOf(46) + 1);
                string2 = string7.substring(0, string7.lastIndexOf(46));
                int n3 = -1;
                if (string4 != null) {
                    n3 = Integer.parseInt(string4);
                }
                StkEntry stkEntry = new StkEntry(string3, string2, string5, n3, bl);
                DumpParser.logDebug("  -- " + string2 + " . " + string3 + " - " + " - " + string5 + " - " + string4 + " - " + bl);
                thd.addStackEntry(stkEntry);
            }
            string = this.getLine(dumpData);
            if (string.length() != 0) continue;
            string = this.getLine(dumpData);
        }
    }
}

