/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.util;

import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.loaders.hierarchy.IgnoredXMLFragmentLoader;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.IXMLLoader;
import org.eclipse.hyades.loaders.util.InvalidXMLException;
import org.eclipse.hyades.loaders.util.LoaderExtensions;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.loaders.util.SAXFragmentHandler;
import org.eclipse.hyades.loaders.util.XMLFragmentHandler;
import org.eclipse.hyades.loaders.util.XMLFragmentHandlerExtensions;
import org.eclipse.hyades.loaders.util.XMLFragmentLoader;
import org.eclipse.hyades.models.hierarchy.CorrelationSourceInfo;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCCollectionMode;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.UnresolvedCorrelation;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.models.hierarchy.util.SaveUtil;
import org.eclipse.hyades.models.hierarchy.util.StringUtil;
import org.xml.sax.SAXParseException;

public class XMLLoader
implements IXMLLoader {
    protected FileWriter file;
    protected HierarchyContext context;
    protected InvalidXMLException error;
    protected Map loaders = new HashMap();
    protected String currentAttributeName;
    protected String currentElementName;
    protected XMLFragmentHandler scanner;
    protected XMLFragmentLoader currentLoader;
    protected XMLFragmentLoader defaultLoader = new IgnoredXMLFragmentLoader();
    protected boolean startDocument;
    protected int depth = 0;
    protected int fragmentsCount;

    public XMLLoader(TRCAgentProxy tRCAgentProxy) {
        this.makeScanner();
        TRCAgent tRCAgent = tRCAgentProxy.getAgent();
        if (tRCAgent != null && tRCAgent.eResource() != null) {
            this.context = LoadersUtils.locateHierarchyContext(tRCAgent);
        }
        if (this.context == null) {
            this.context = new HierarchyContext();
            if (tRCAgentProxy != null) {
                this.context.setMonitor(tRCAgentProxy.getProcessProxy().getNode().getMonitor());
                this.context.setNode(tRCAgentProxy.getProcessProxy().getNode());
                this.context.setProcessProxy(tRCAgentProxy.getProcessProxy());
                this.context.setAgentProxy(tRCAgentProxy);
            }
            LookupServiceExtensions.getInstance().register(null, this.context);
        } else {
            if (this.context.getAgentProxy() == null) {
                this.context.setAgentProxy(tRCAgentProxy);
            }
            if (this.context.getProcessProxy() == null) {
                this.context.setProcessProxy(tRCAgentProxy.getProcessProxy());
            }
            if (this.context.getMonitor() == null) {
                this.context.setMonitor(tRCAgentProxy.getProcessProxy().getNode().getMonitor());
            }
            if (this.context.getNode() == null) {
                this.context.setNode(tRCAgentProxy.getProcessProxy().getNode());
            }
        }
        this.defaultLoader = this.getLoader("DefaultXMLFragmentLoader");
    }

    public XMLLoader(TRCAgent tRCAgent) {
        this.makeScanner();
        if (tRCAgent != null) {
            this.context = LoadersUtils.locateHierarchyContext(tRCAgent);
        }
        if (this.context == null) {
            this.context = new HierarchyContext();
            this.context.setMonitor(tRCAgent.getAgentProxy().getProcessProxy().getNode().getMonitor());
            this.context.setNode(tRCAgent.getAgentProxy().getProcessProxy().getNode());
            this.context.setProcessProxy(tRCAgent.getAgentProxy().getProcessProxy());
            this.context.setAgentProxy(tRCAgent.getAgentProxy());
            this.context.setAgent(tRCAgent);
            if (tRCAgent.eResource() == null) {
                try {
                    this.addToResource(tRCAgent, this.context);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            LookupServiceExtensions.getInstance().register(null, this.context);
        } else if (this.context.getAgentProxy() == null) {
            this.context.setAgentProxy(tRCAgent.getAgentProxy());
            if (this.context.getProcessProxy() == null) {
                this.context.setProcessProxy(tRCAgent.getAgentProxy().getProcessProxy());
            }
            if (this.context.getMonitor() == null) {
                this.context.setMonitor(tRCAgent.getAgentProxy().getProcessProxy().getNode().getMonitor());
            }
            if (this.context.getNode() == null) {
                this.context.setNode(tRCAgent.getAgentProxy().getProcessProxy().getNode());
            }
        }
        this.defaultLoader = this.getLoader("DefaultXMLFragmentLoader");
    }

    public XMLLoader(TRCMonitor tRCMonitor) {
        if (this.context == null) {
            this.context = new HierarchyContext();
            this.context.setMonitor(tRCMonitor);
        }
        this.makeScanner();
        this.defaultLoader = this.getLoader("DefaultXMLFragmentLoader");
    }

    public void setCollectionMode(int n) {
        this.context.setCollectionMode(TRCCollectionMode.get(n));
    }

    public HierarchyContext getContext() {
        return this.context;
    }

    public int getProcessedFragments() {
        return this.fragmentsCount;
    }

    public void attributeName(String string) {
        if (this.isIgnoredElement()) {
            return;
        }
        this.currentAttributeName = string;
    }

    public void attributeValueCharacters(String string) {
        if (this.isIgnoredElement()) {
            return;
        }
        try {
            this.currentLoader.addAttribute(this.currentAttributeName, string);
        }
        catch (Exception exception) {
            this.log(exception);
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        if (this.isIgnoredElement()) {
            return;
        }
        try {
            if (this.currentLoader != null) {
                this.currentLoader.addCharacters(cArray, n, n2);
            }
        }
        catch (Exception exception) {
            this.log(exception);
        }
    }

    public synchronized void cleanUp() {
        if (this.scanner == null) {
            return;
        }
        try {
            this.scanner.terminateParser();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.scanner = null;
        if (this.file != null) {
            try {
                this.file.close();
            }
            catch (IOException iOException) {
                this.log(iOException);
            }
        }
        this.file = null;
        this.error = null;
        this.depth = 0;
        this.startDocument = true;
        this.fragmentsCount = 0;
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.loaders.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (arrayList.contains(entry.getValue())) continue;
            ((XMLFragmentLoader)entry.getValue()).cleanUp();
            arrayList.add(entry.getValue());
        }
        this.loaders.clear();
        if (this.getContext().getGlobalForwardReferences().size() > 0) {
            this.processGlobalForwardReferences();
        }
    }

    public void endDocument(Object object, int n) {
    }

    public void endElement(String string, int n) {
        this.currentElementName = string;
        try {
            if (this.currentLoader != null) {
                this.currentLoader.endChild(this.currentElementName);
            }
            --this.depth;
            if (this.depth == 0) {
                this.currentLoader.addYourselfInContext();
            }
        }
        catch (Exception exception) {
            this.log(exception);
        }
    }

    public void error(InvalidXMLException invalidXMLException) {
        this.error = invalidXMLException;
        this.error.fillInStackTrace();
    }

    public void loadEvent(byte[] byArray, int n, boolean bl, boolean bl2) throws InvalidXMLException {
        if (this.error != null || this.scanner == null) {
            return;
        }
        if (bl2) {
            this.writeToProfileFile(LoadersUtils.makeString(byArray, 0, n));
        } else {
            this.loadEvent(byArray, n, bl);
        }
    }

    public void loadEvent(byte[] byArray, int n, boolean bl) throws InvalidXMLException {
        block5: {
            if (this.error != null || this.scanner == null) {
                return;
            }
            if (this.getContext().getAgent() != null && this.getContext().getAgent().eResource() != null && !this.getContext().getAgent().eResource().isModified()) {
                this.getContext().getAgent().eResource().setModified(true);
            }
            this.setLoadToModel(bl);
            try {
                this.scanner.scanContent(byArray, 0, n);
            }
            catch (Exception exception) {
                if (this.error != null) break block5;
                this.log(exception);
            }
        }
        if (this.error != null) {
            throw this.error;
        }
    }

    public void loadEvent(byte[] byArray, int n) throws InvalidXMLException {
        this.loadEvent(byArray, n, true);
    }

    public void restartParser() {
        if (this.scanner != null) {
            this.scanner.terminateParser();
        }
        this.error = null;
        this.startDocument = true;
        this.depth = 0;
        this.makeScanner();
    }

    public void startDocument() {
        this.startDocument = true;
    }

    public void startElement(String string, boolean bl, boolean bl2) {
        this.currentElementName = string;
        if (this.isIgnoredElement()) {
            return;
        }
        if (this.depth == 0) {
            this.currentLoader = this.getLoader(this.getName(this.currentElementName));
            this.currentLoader.initialize(this.getContext(), this.currentElementName);
            ++this.fragmentsCount;
        } else {
            try {
                this.currentLoader.startChild(this.currentElementName);
            }
            catch (Exception exception) {
                this.log(exception);
            }
        }
        ++this.depth;
    }

    protected boolean isIgnoredElement() {
        if (this.startDocument) {
            if (this.currentElementName == null) {
                return true;
            }
            if (this.currentElementName.equals("TRACE") || this.currentElementName.equals("CommonBaseEvents") || this.currentElementName.equals("Statistic")) {
                return true;
            }
            this.startDocument = false;
        }
        return false;
    }

    protected XMLFragmentLoader getLoader(String string) {
        XMLFragmentLoader xMLFragmentLoader = (XMLFragmentLoader)this.loaders.get(string);
        if (xMLFragmentLoader == null) {
            xMLFragmentLoader = (XMLFragmentLoader)LoaderExtensions.getInstance().get(string);
            if (xMLFragmentLoader != null) {
                try {
                    xMLFragmentLoader = (XMLFragmentLoader)xMLFragmentLoader.getClass().newInstance();
                    this.loaders.put(string, xMLFragmentLoader);
                    return xMLFragmentLoader;
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            xMLFragmentLoader = this.defaultLoader;
        }
        return xMLFragmentLoader;
    }

    protected String getName(String string) {
        int n = string.lastIndexOf(":");
        if (n != -1) {
            return string.substring(n);
        }
        return string;
    }

    protected void log(Exception exception) {
        if (exception instanceof SAXParseException) {
            SAXParseException sAXParseException = (SAXParseException)exception;
            System.err.println(sAXParseException.getLocalizedMessage());
            System.err.println("at line: " + sAXParseException.getLineNumber());
            System.err.println("at column: " + sAXParseException.getColumnNumber());
            sAXParseException.fillInStackTrace();
            sAXParseException.printStackTrace(System.err);
        } else {
            LoadersUtils.log(exception);
        }
    }

    protected void makeScanner() {
        this.scanner = (XMLFragmentHandler)XMLFragmentHandlerExtensions.getInstance().get("handler");
        if (this.scanner != null) {
            try {
                this.scanner = (XMLFragmentHandler)this.scanner.getClass().newInstance();
                this.scanner.setXMLLoader(this);
            }
            catch (Exception exception) {
                this.log(exception);
                this.scanner = new SAXFragmentHandler();
                this.scanner.setXMLLoader(this);
            }
        } else {
            this.scanner = new SAXFragmentHandler();
            this.scanner.setXMLLoader(this);
        }
    }

    protected void processGlobalForwardReferences() {
        Iterator iterator = this.context.getAgent().getUnresolvedCorrelations().iterator();
        while (iterator.hasNext()) {
            UnresolvedCorrelation unresolvedCorrelation = (UnresolvedCorrelation)iterator.next();
            Iterator iterator2 = unresolvedCorrelation.getSourceInfos().iterator();
            while (iterator2.hasNext()) {
                CorrelationSourceInfo correlationSourceInfo = (CorrelationSourceInfo)iterator2.next();
                EObject eObject = correlationSourceInfo.getOwner();
                EReference eReference = correlationSourceInfo.getReference();
                EObject eObject2 = (EObject)LookupServiceExtensions.getInstance().locate(null, eReference.getEReferenceType().getInstanceClass(), LoadersUtils.getLookUpKey(unresolvedCorrelation.getContextId()));
                if (eObject2 == null) continue;
                if (eReference.isMany()) {
                    ((EList)eObject.eGet((EStructuralFeature)eReference)).add(eObject2);
                } else {
                    eObject.eSet((EStructuralFeature)eReference, (Object)eObject2);
                }
                iterator2.remove();
            }
            if (unresolvedCorrelation.getSourceInfos().size() != 0) continue;
            iterator.remove();
        }
    }

    private void setLoadToModel(boolean bl) {
        if (this.context.isLoadToModel() != bl) {
            this.context.setLoadToModel(bl);
        }
    }

    private void addToResource(TRCAgent tRCAgent, HierarchyContext hierarchyContext) {
        String string = LoadersUtils.getMonitorFolder(hierarchyContext.getMonitor());
        Resource resource = null;
        if (tRCAgent.getName() == null) {
            tRCAgent.setName("unknown");
        }
        String string2 = StringUtil.change(hierarchyContext.getMonitor().getName().trim(), " ", "") + "_" + hierarchyContext.getNode().getName().trim() + "_" + hierarchyContext.getProcessProxy().getPid() + "_" + hierarchyContext.getProcessProxy().getRuntimeId() + "_" + StringUtil.change(tRCAgent.getName().trim(), " ", "");
        String string3 = string + string2;
        resource = Resource.Factory.Registry.INSTANCE.getFactory(SaveUtil.createURI(string3 + ".trcaxmi")).createResource(SaveUtil.createURI(string3 + ".trcaxmi"));
        resource.setModified(true);
        HierarchyResourceSetImpl.getInstance().getResources().add(resource);
        if (resource != null) {
            resource.getContents().add(tRCAgent);
        }
    }

    private void writeToProfileFile(String string) {
        if (this.context.getAgentProxy() != null && this.context.getAgentProxy().getProfileFile() != null) {
            try {
                if (this.file == null) {
                    this.file = new FileWriter(this.context.getAgentProxy().getProfileFile());
                }
                this.file.write(string);
            }
            catch (IOException iOException) {
                this.error = new InvalidXMLException(iOException);
                throw this.error;
            }
        }
    }
}

