/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sdb.internal.preferences;

import java.util.ArrayList;
import org.eclipse.hyades.sdb.internal.SDbPlugin;
import org.eclipse.hyades.sdb.internal.SDbPluginImages;
import org.eclipse.hyades.sdb.internal.help.ContextIds;
import org.eclipse.hyades.sdb.internal.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class SymptomDBurl
implements SelectionListener {
    private Composite result;
    private Table _list;
    private Button _moveUp;
    private Button _moveDown;
    private Button _restoreDefaults;
    private ArrayList _data = new ArrayList();
    private Item _oldSelection;
    private Button _add;
    private Button _edit;
    private Button _delete;
    private static final int _restoreDefaultsButtonId = 1025;

    public Composite createControl(Composite composite) {
        this.result = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.verticalSpacing = 15;
        this.result.setLayout((Layout)gridLayout);
        GridData gridData = GridUtil.createFill();
        gridData.heightHint = 400;
        gridData.widthHint = 400;
        this.result.setLayoutData((Object)gridData);
        Label label = new Label(this.result, 0);
        gridData = GridUtil.createHorizontalFill();
        gridData.horizontalSpan = 3;
        gridData.heightHint = 10;
        label.setLayoutData((Object)gridData);
        Label label2 = new Label(this.result, 0);
        label2.setText(SDbPlugin.getResourceString("STR_DB_URL_LOCATIONS"));
        Composite composite2 = new Composite(this.result, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        gridData = GridUtil.createFill();
        gridData.heightHint = 250;
        gridData.horizontalSpan = 3;
        composite2.setLayoutData((Object)gridData);
        this._list = new Table(composite2, 2304);
        gridData = GridUtil.createFill();
        this._list.setLayoutData((Object)gridData);
        Composite composite3 = new Composite(composite2, 0);
        gridData = new GridData();
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        composite3.setLayoutData((Object)gridData);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 1;
        composite3.setLayout((Layout)gridLayout2);
        this._moveUp = new Button(composite3, 0);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this._moveUp.setLayoutData((Object)gridData);
        this._moveUp.setText(SDbPlugin.getResourceString("STR_COL_DLG_UP"));
        this._moveDown = new Button(composite3, 0);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this._moveDown.setLayoutData((Object)gridData);
        this._moveDown.setText(SDbPlugin.getResourceString("STR_COL_DLG_DOWN"));
        label = new Label(composite3, 0);
        this._edit = new Button(composite3, 0);
        gridData = GridUtil.createHorizontalFill();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 2;
        this._edit.setLayoutData((Object)gridData);
        this._edit.setText(SDbPlugin.getResourceString(SDbPlugin.getResourceString("STR_EDIT_LOCATION")));
        this._add = new Button(composite3, 0);
        gridData = GridUtil.createHorizontalFill();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 2;
        this._add.setLayoutData((Object)gridData);
        this._add.setText(SDbPlugin.getResourceString(SDbPlugin.getResourceString("STR_ADD_LOCATION")));
        this._delete = new Button(composite3, 0);
        gridData = GridUtil.createHorizontalFill();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 2;
        this._delete.setLayoutData((Object)gridData);
        this._delete.setText(SDbPlugin.getResourceString(SDbPlugin.getResourceString("STR_DEL_LOCATION")));
        this._list.addSelectionListener((SelectionListener)this);
        this._moveUp.addSelectionListener((SelectionListener)this);
        this._moveDown.addSelectionListener((SelectionListener)this);
        this._add.addSelectionListener((SelectionListener)this);
        this._edit.addSelectionListener((SelectionListener)this);
        this._delete.addSelectionListener((SelectionListener)this);
        this._moveUp.setEnabled(false);
        this._moveDown.setEnabled(false);
        WorkbenchHelp.setHelp((Control)this._list, (String)ContextIds.SYMDB_PREF_URL);
        return this.result;
    }

    public ArrayList getData() {
        return this._data;
    }

    protected void moveDown(int n) {
        TableItem tableItem = this._list.getItem(n);
        ColumnData columnData = (ColumnData)tableItem.getData();
        TableItem tableItem2 = new TableItem(this._list, 32, n + 2);
        tableItem2.setImage(SDbPluginImages.getImage("symptomdb_desc_obj.gif"));
        tableItem2.setChecked(tableItem.getChecked());
        tableItem2.setText(tableItem.getText());
        tableItem2.setData((Object)columnData);
        tableItem2.setGrayed(tableItem.getGrayed());
        this._list.remove(n);
        this._list.select(n + 1);
    }

    protected void moveUp(int n) {
        TableItem tableItem;
        TableItem tableItem2 = this._list.getItem(n);
        ColumnData columnData = (ColumnData)tableItem2.getData();
        if (n > 0) {
            tableItem = this._list.getItem(n - 1);
            ColumnData columnData2 = (ColumnData)tableItem.getData();
        }
        tableItem = new TableItem(this._list, 32, n - 1);
        tableItem.setChecked(tableItem2.getChecked());
        tableItem.setText(tableItem2.getText());
        tableItem.setImage(SDbPluginImages.getImage("symptomdb_desc_obj.gif"));
        tableItem.setData((Object)columnData);
        tableItem.setGrayed(tableItem2.getGrayed());
        this._list.remove(n + 1);
        this._list.select(n - 1);
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        this.widgetSelected(selectionEvent);
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        ColumnData columnData;
        int n;
        if (selectionEvent.widget == this._moveUp) {
            n = this._list.getSelectionIndex();
            if (n > 0) {
                this.moveUp(n);
            }
        } else if (selectionEvent.widget == this._moveDown) {
            n = this._list.getSelectionIndex();
            if (n != -1 && n < this._list.getItemCount() - 1) {
                this.moveDown(n);
            }
        } else if (selectionEvent.widget == this._add) {
            this.showUrlDialog(SDbPlugin.getResourceString("STR_URL_LOCATION_DLG"), null, null);
        } else if (selectionEvent.widget == this._edit) {
            n = this._list.getSelectionIndex();
            if (n != -1 && (columnData = (ColumnData)this._list.getItem(n).getData()) != null) {
                this.showUrlDialog(SDbPlugin.getResourceString("STR_EURL_LOCATION_DLG"), columnData.name(), columnData.url());
            }
        } else if (selectionEvent.widget == this._delete && (n = this._list.getSelectionIndex()) != -1) {
            this._list.getItem(n).dispose();
        }
        n = this._list.getSelectionIndex();
        columnData = null;
        ColumnData columnData2 = null;
        if (n > 0) {
            columnData2 = (ColumnData)this._list.getItem(n - 1).getData();
        }
        if (n != -1) {
            columnData = (ColumnData)this._list.getItem(n).getData();
        }
        this._moveUp.setEnabled(columnData != null && columnData2 != null);
        this._moveDown.setEnabled(columnData != null && n < this._list.getItemCount() - 1);
        this._delete.setEnabled(n != -1);
        this._edit.setEnabled(n != -1);
    }

    public void storeValues(IPreferenceStore iPreferenceStore) {
        String string = "";
        int n = 0;
        while (n < this._list.getItemCount()) {
            TableItem tableItem = this._list.getItem(n);
            ColumnData columnData = (ColumnData)tableItem.getData();
            if (string != null) {
                string = string + "\n" + columnData.name() + "\t" + columnData.url();
            }
            ++n;
        }
        if (string.startsWith("\n") && string.length() > 1) {
            string = string.substring(1);
        }
        iPreferenceStore.setValue("symptom_db_url", string);
    }

    private void showUrlDialog(String string, String string2, String string3) {
        EditDialog editDialog = new EditDialog(this.result.getShell(), string, string2, string3);
        editDialog.open();
        if (editDialog.getReturnCode() == 0) {
            if (string2 == null) {
                ColumnData columnData = new ColumnData(editDialog.name(), editDialog.value());
                TableItem tableItem = new TableItem(this._list, 0);
                tableItem.setText(columnData.name() + "[" + columnData.url() + "]");
                tableItem.setImage(SDbPluginImages.getImage("symptomdb_desc_obj.gif"));
                tableItem.setData((Object)columnData);
            } else {
                TableItem tableItem;
                ColumnData columnData;
                int n = this._list.getSelectionIndex();
                if (n != -1 && (columnData = (ColumnData)(tableItem = this._list.getItem(n)).getData()) != null) {
                    columnData.name(editDialog.name());
                    columnData.url(editDialog.value());
                    tableItem.setText(columnData.name() + " [ " + columnData.url() + " ] ");
                }
            }
        }
    }

    public void initializeValues(String string) {
        int n;
        while (this._list.getItemCount() > 0) {
            this._list.getItem(0).dispose();
        }
        if (string != null && !string.equals("")) {
            ColumnData columnData;
            n = string.indexOf("\n");
            while (n != -1) {
                String string2 = string.substring(0, n);
                int n2 = string2.indexOf("\t");
                if (n2 != -1) {
                    columnData = new ColumnData(string2.substring(0, n2), string2.substring(n2 + 1));
                    TableItem tableItem = new TableItem(this._list, 0);
                    tableItem.setText(columnData.name() + " [ " + columnData.url() + " ] ");
                    tableItem.setImage(SDbPluginImages.getImage("symptomdb_desc_obj.gif"));
                    tableItem.setData((Object)columnData);
                }
                string = string.substring(n + 1);
                n = string.indexOf("\n");
            }
            int n3 = string.indexOf("\t");
            if (n3 != -1) {
                ColumnData columnData2 = new ColumnData(string.substring(0, n3), string.substring(n3 + 1));
                columnData = new TableItem(this._list, 0);
                columnData.setText(columnData2.name() + " [ " + columnData2.url() + " ] ");
                columnData.setImage(SDbPluginImages.getImage("symptomdb_desc_obj.gif"));
                columnData.setData(columnData2);
            }
        }
        this._delete.setEnabled((n = this._list.getSelectionIndex()) != -1);
        this._edit.setEnabled(n != -1);
    }

    class ColumnData {
        private String _name;
        private String _url;

        public ColumnData(String string, String string2) {
            this._name = string;
            this._url = string2;
        }

        public String name() {
            return this._name;
        }

        public String url() {
            return this._url;
        }

        public void name(String string) {
            this._name = string;
        }

        public void url(String string) {
            this._url = string;
        }
    }

    class EditDialog
    extends Dialog
    implements ModifyListener {
        private String _name;
        private String _value;
        private Text _nameText;
        private Text _valueText;
        private String _title;

        public EditDialog(Shell shell, String string, String string2, String string3) {
            super(shell);
            this._name = string2;
            this._value = string3;
            this._title = string;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(this._title);
        }

        public void name(String string) {
            this._name = string;
        }

        public String name() {
            return this._name;
        }

        public void value(String string) {
            this._value = string;
        }

        public String value() {
            return this._value;
        }

        protected Control createDialogArea(Composite composite) {
            Composite composite2 = (Composite)super.createDialogArea(composite);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            composite2.setLayout((Layout)gridLayout);
            GridData gridData = GridUtil.createFill();
            gridData.widthHint = 400;
            composite2.setLayoutData((Object)gridData);
            Label label = new Label(composite2, 0);
            label.setText(SDbPlugin.getResourceString("STR_URL_DB_NAME"));
            this._nameText = new Text(composite2, 2048);
            this._nameText.setLayoutData((Object)GridUtil.createHorizontalFill());
            label = new Label(composite2, 0);
            label.setText(SDbPlugin.getResourceString("STR_URL_DB_URL"));
            this._valueText = new Text(composite2, 2048);
            this._valueText.setLayoutData((Object)GridUtil.createHorizontalFill());
            this._nameText.addModifyListener((ModifyListener)this);
            this._valueText.addModifyListener((ModifyListener)this);
            if (this._name != null) {
                this._nameText.setText(this._name);
            }
            if (this._value != null) {
                this._valueText.setText(this._value);
            }
            if (this._title.equals(SDbPlugin.getResourceString("STR_URL_LOCATION_DLG"))) {
                WorkbenchHelp.setHelp((Control)this._nameText, (String)ContextIds.SYMDB_PREF_URL_ADD_DIALOG_NAME);
                WorkbenchHelp.setHelp((Control)this._valueText, (String)ContextIds.SYMDB_PREF_URL_ADD_DIALOG_URL);
            } else if (this._title.equals(SDbPlugin.getResourceString("STR_EURL_LOCATION_DLG"))) {
                WorkbenchHelp.setHelp((Control)this._nameText, (String)ContextIds.SYMDB_PREF_URL_EDIT_DIALOG_NAME);
                WorkbenchHelp.setHelp((Control)this._valueText, (String)ContextIds.SYMDB_PREF_URL_EDIT_DIALOG_URL);
            }
            return composite2;
        }

        public void modifyText(ModifyEvent modifyEvent) {
            if ((modifyEvent.widget == this._nameText || modifyEvent.widget == this._valueText) && this.getButton(0) != null) {
                this.getButton(0).setEnabled(this._nameText.getText().trim() != "");
            }
        }

        protected void okPressed() {
            this._name = this._nameText.getText().trim();
            this._value = this._valueText.getText().trim();
            super.okPressed();
        }
    }
}

