/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.util;

import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.loaders.cbe.CBEUtils;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.util.FeatureNode;
import org.eclipse.hyades.log.ui.internal.util.FilterTableElement;
import org.eclipse.hyades.log.ui.internal.util.LogUIConstants;
import org.eclipse.hyades.log.ui.internal.util.TerminalNode;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.cbe.CBEPackage;
import org.eclipse.jface.preference.IPreferenceStore;

public class RecordFilterSearchUtil {
    private HashMap _methods = new HashMap();
    private ElementFilter _filter = new ElementFilter();
    static /* synthetic */ Class class$java$lang$String;

    public void dispose() {
        this._methods.clear();
    }

    public boolean isAdvFilterApply(EObject eObject, ArrayList arrayList) {
        if (arrayList == null) {
            return true;
        }
        EClass eClass = eObject.eClass();
        EList eList = eClass.getEAllAttributes();
        boolean bl = true;
        int n = 0;
        while (n < arrayList.size()) {
            FilterTableElement filterTableElement = (FilterTableElement)arrayList.get(n);
            String string = filterTableElement.getAtrribute().toLowerCase();
            EAttribute eAttribute = this.findAttributeInList(string, eList);
            bl = eAttribute != null ? (bl &= this.matchFilter(eObject, eAttribute, filterTableElement)) : (bl &= this.checkChildren(eObject, string, filterTableElement));
            ++n;
        }
        return bl;
    }

    private EAttribute findAttributeInList(String string, EList eList) {
        int n = 0;
        while (n < eList.size()) {
            EAttribute eAttribute = (EAttribute)eList.get(n);
            if (eAttribute.getName().toLowerCase().equals(string)) {
                return eAttribute;
            }
            ++n;
        }
        return null;
    }

    private boolean matchFilter(EObject eObject, EAttribute eAttribute, FilterTableElement filterTableElement) {
        Object object = eObject.eGet((EStructuralFeature)eAttribute);
        String string = filterTableElement.getValue();
        String string2 = filterTableElement.getOperator();
        if (object == null) {
            object = new String("");
        }
        if (string == null) {
            string = new String("");
        }
        if (eAttribute.getName().equals("creationTime")) {
            object = this.formatCreationTime(object, eObject.getClass(), eObject);
        }
        if (string2.equals(LogUIPlugin.getResourceString("STR_EQUAL"))) {
            return this.checkEqual(object.toString(), string);
        }
        if (string2.equals(LogUIPlugin.getResourceString("STR_NOT_EQUAL"))) {
            return this.checkNotEqual(object.toString(), string);
        }
        if (string2.equals(LogUIPlugin.getResourceString("STR_LARGER_THAN"))) {
            return this.checkLargerThan(object.toString(), string);
        }
        if (string2.equals(LogUIPlugin.getResourceString("STR_SMALLER_THAN"))) {
            return this.checkSmallerThan(object.toString(), string);
        }
        return false;
    }

    private Object formatCreationTime(Object object, Class clazz, Object object2) {
        String string = "0";
        CBECommonBaseEvent cBECommonBaseEvent = (CBECommonBaseEvent)object2;
        if (cBECommonBaseEvent.getCreationTime() != 0.0) {
            try {
                short s = 0;
                try {
                    Method method = this.getMethod(clazz, "getTimeZone");
                    if (method != null) {
                        s = (Short)method.invoke(object2, null);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                double d = CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)cBECommonBaseEvent);
                Double d2 = new Double(d);
                SimpleDateFormat simpleDateFormat = this.getDateTimeFormat();
                string = simpleDateFormat.format(new Date(d2.longValue() / 1000L + (long)(s * 60 * 1000)));
                String string2 = "" + d2.longValue() % 1000000L;
                string = string + "." + "000000".substring(0, 6 - string2.length()) + string2;
                string = string + (s > 0 ? "+00" : "-00").substring(0, 3 - ("" + Math.abs(s / 60)).length()) + Math.abs(s / 60);
                string = string + ":00".substring(0, 3 - ("" + Math.abs(s % 60)).length()) + Math.abs(s % 60);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    private boolean checkChildren(EObject eObject, String string, FilterTableElement filterTableElement) {
        boolean bl = true;
        boolean bl2 = true;
        if (eObject instanceof EObject && eObject.eClass().getEPackage() == CBEPackage.eINSTANCE) {
            bl2 = false;
            EClass eClass = eObject.eClass();
            Iterator iterator = eClass.getEAllStructuralFeatures().iterator();
            while (iterator.hasNext()) {
                Object object;
                EStructuralFeature eStructuralFeature = (EStructuralFeature)iterator.next();
                if ((!(eStructuralFeature instanceof EReference) || eStructuralFeature.getFeatureID() == 3) && (!(eStructuralFeature instanceof EAttribute) || !eStructuralFeature.isMany() || eStructuralFeature.getEType().getInstanceClass() == (class$java$lang$String == null ? RecordFilterSearchUtil.class$("java.lang.String") : class$java$lang$String)) || (object = eObject.eGet(eStructuralFeature, true)) == null) continue;
                if (object instanceof EList) {
                    if (((EList)object).size() <= 0) continue;
                    Object[] objectArray = ((EList)object).toArray();
                    int n = 0;
                    while (n < objectArray.length) {
                        int n2 = this.containsAttribute((EObject)objectArray[n], string, filterTableElement);
                        if (n2 > 0) {
                            bl2 = true;
                            bl |= n2 == 1;
                        }
                        ++n;
                    }
                    continue;
                }
                int n = this.containsAttribute((EObject)object, string, filterTableElement);
                if (n <= 0) continue;
                bl2 = true;
                bl &= n == 1;
            }
        } else if (eObject instanceof FeatureNode) {
            EStructuralFeature eStructuralFeature = ((FeatureNode)eObject).getFeature();
            EObject eObject2 = ((FeatureNode)eObject).getElement();
            bl2 = false;
            if (eStructuralFeature instanceof EReference) {
                if (eStructuralFeature.isMany()) {
                    EList eList = (EList)eObject2.eGet(eStructuralFeature, true);
                    if (eList.size() > 0) {
                        Object[] objectArray = eList.toArray();
                        int n = 0;
                        while (n < objectArray.length) {
                            int n3 = this.containsAttribute((EObject)objectArray[n], string, filterTableElement);
                            if (n3 > 0) {
                                bl2 = true;
                                bl |= n3 == 1;
                            }
                            ++n;
                        }
                    }
                } else {
                    Object object = eObject2.eGet(eStructuralFeature, true);
                    int n = this.containsAttribute((EObject)object, string, filterTableElement);
                    if (n > 0) {
                        bl2 = true;
                        bl &= n == 1;
                    }
                }
            }
        } else if (eObject instanceof TerminalNode) {
            // empty if block
        }
        return bl2 && bl;
    }

    private int containsAttribute(EObject eObject, String string, FilterTableElement filterTableElement) {
        EClass eClass = eObject.eClass();
        EList eList = eClass.getEAllAttributes();
        EAttribute eAttribute = this.findAttributeInList(string, eList);
        if (eAttribute != null) {
            return this.matchFilter(eObject, eAttribute, filterTableElement) ? 1 : -1;
        }
        return 0;
    }

    private Method getMethod(Class clazz, String string) throws Exception {
        Method method = (Method)this._methods.get(clazz.getName() + string);
        if (method == null) {
            method = clazz.getMethod(string, null);
            this._methods.put(clazz.getName() + string, method);
        }
        return method;
    }

    private SimpleDateFormat getDateTimeFormat() {
        IPreferenceStore iPreferenceStore = LogUIPlugin.getDefault().getPreferenceStore();
        String string = iPreferenceStore.getString("LogAnalyzer.DateFormat");
        boolean bl = false;
        int n = 0;
        while (n < LogUIConstants.LOG_ANALYZER_FORMAT_DATE_LIST.length) {
            if (string.equals(LogUIConstants.LOG_ANALYZER_FORMAT_DATE_LIST[n])) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            string = LogUIConstants.LOG_ANALYZER_FORMAT_DATE_DEFAULT;
        }
        String string2 = iPreferenceStore.getString("LogAnalyzer.TimeFormat");
        bl = false;
        int n2 = 0;
        while (n2 < LogUIConstants.LOG_ANALYZER_FORMAT_TIME_LIST.length) {
            if (string2.equals(LogUIConstants.LOG_ANALYZER_FORMAT_TIME_LIST[n2])) {
                bl = true;
                break;
            }
            ++n2;
        }
        if (!bl) {
            string2 = LogUIConstants.LOG_ANALYZER_FORMAT_TIME_DEFAULT;
        }
        if (string2.startsWith("h")) {
            string2 = string2 + " a";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string + " " + string2);
        return simpleDateFormat;
    }

    private boolean checkEqual(String string, String string2) {
        try {
            float f = Float.parseFloat(string);
            float f2 = Float.parseFloat(string2);
            return f == f2;
        }
        catch (NumberFormatException numberFormatException) {
            return this._filter.match(string, string2);
        }
    }

    private boolean checkNotEqual(String string, String string2) {
        return !this.checkEqual(string, string2);
    }

    private boolean checkLargerThan(String string, String string2) {
        try {
            float f = Float.parseFloat(string);
            float f2 = Float.parseFloat(string2);
            return f > f2;
        }
        catch (NumberFormatException numberFormatException) {
            int n = string.compareTo(string2);
            return n > 0;
        }
    }

    private boolean checkSmallerThan(String string, String string2) {
        return !this.checkLargerThan(string, string2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class ElementFilter {
        protected String _pattern;
        protected String _prefix = "";
        protected String _suffix = "";
        protected ArrayList _textList;
        protected boolean _caseSensitive = true;
        protected boolean _exactMatch;
        protected boolean _noPattern = true;

        private void setPattern(String string, boolean bl) {
            this._caseSensitive = bl;
            this._pattern = this._caseSensitive ? string : string.toLowerCase();
            this._noPattern = string == "*" || string == "";
            this._exactMatch = this._pattern.indexOf("*") == -1;
            StringTokenizer stringTokenizer = new StringTokenizer(this._pattern, "*");
            this._textList = new ArrayList();
            while (stringTokenizer.hasMoreTokens()) {
                this._textList.add(stringTokenizer.nextToken());
            }
            if (this._pattern.startsWith("*")) {
                this._prefix = "";
            } else if (this._textList.size() > 0) {
                this._prefix = (String)this._textList.get(0);
                this._textList.remove(0);
            }
            if (this._pattern.endsWith("*")) {
                this._suffix = "";
            } else if (this._textList.size() > 0) {
                this._suffix = (String)this._textList.get(this._textList.size() - 1);
                this._textList.remove(this._textList.size() - 1);
            }
        }

        public boolean match(String string, String string2) {
            this.setPattern(string2, true);
            boolean bl = true;
            String string3 = "";
            if (this._noPattern) {
                return true;
            }
            string3 = string;
            if (!this._caseSensitive) {
                string3 = string3.toLowerCase();
            }
            if (this._exactMatch) {
                return string3.compareTo(this._prefix) == 0;
            }
            if (this._prefix != "") {
                bl = string3.startsWith(this._prefix);
            }
            if (bl && this._suffix != "") {
                bl = string3.endsWith(this._suffix);
            }
            if (bl) {
                int n = 0;
                while (n < this._textList.size()) {
                    String string4 = (String)this._textList.get(n);
                    int n2 = string3.indexOf(string4);
                    if (n2 == -1) {
                        bl = false;
                        break;
                    }
                    string3 = string3.substring(n2 + string4.length());
                    ++n;
                }
            }
            return bl;
        }
    }
}

