/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.wizards;

import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.wizards.LogFileDetailsUI;
import org.eclipse.hyades.log.ui.internal.wizards.LogFileElement;
import org.eclipse.hyades.log.ui.internal.wizards.LogParserItem;
import org.eclipse.hyades.log.ui.internal.wizards.LogParserUI;
import org.eclipse.hyades.log.ui.internal.wizards.LogSetDialog;
import org.eclipse.hyades.log.ui.internal.wizards.ParserField;
import org.eclipse.hyades.log.ui.internal.wizards.ParserParameter;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.security.util.TString;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.ui.internal.util.XMLUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.help.WorkbenchHelp;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ImportLogWizardPage
extends WizardPage
implements SelectionListener {
    public static final int NEW_LOGSET = 0;
    public static final int OPEN_LOGSET = 1;
    public static final int EDIT_LOGSET = 2;
    public static final int RENAME_LOGSET = 3;
    private final String LOGSETS_KEY = "logsets";
    private final String LOGSET_TAG = "logset";
    private final String LOGELEMENT_TAG = "LogFileElement";
    private final String DEFAULT_LOGSET = "default";
    public static final int ADD = 4;
    public static final int EDIT = 5;
    private LogParserUI _parserUI;
    private Table logsTable;
    private TableViewer fTableViewer;
    private List logElements = new ArrayList();
    private Button addBtn;
    private Button removeBtn;
    private Button editBtn;
    private Button newLogSetBtn;
    private Button openLogSetBtn;
    private Button editLogSetBtn;
    private LogFileElement selection;
    private LogFileDetailsUI dialog;
    private LogSetDialog logSetDialog;
    private Label logset_desc;
    private Label type_label;
    private LogSetManager lsMgr;
    private int dialog_type;

    public ImportLogWizardPage() {
        super("ImportLogWizardPage");
        this.setTitle(LogUIPlugin.getResourceString("LOG_PARSER_PAGE_TITLE"));
        this.setDescription(LogUIPlugin.getResourceString("LOG_PARSER_PAGE_DESC"));
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)GridUtil.createFill());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        this.logset_desc = new Label(composite2, 0);
        GridData gridData = GridUtil.createHorizontalFill();
        gridData.horizontalSpan = 2;
        this.logset_desc.setLayoutData((Object)gridData);
        this.logset_desc.setFont(JFaceResources.getBannerFont());
        Label label = new Label(composite2, 0);
        gridData = GridUtil.createHorizontalFill();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label.setText(LogUIPlugin.getResourceString("STR_LOG_PDESC"));
        this.createLogTable(composite2);
        Composite composite3 = new Composite(composite2, 0);
        GridData gridData2 = GridUtil.createFill();
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 1;
        gridData2.verticalAlignment = 1;
        composite3.setLayout((Layout)gridLayout2);
        composite3.setLayoutData((Object)gridData2);
        this.createLogButtons(composite3);
        this.createLogSetButtons(composite3);
        this.type_label = new Label(composite2, 64);
        gridData = GridUtil.createHorizontalFill();
        gridData.horizontalSpan = 2;
        gridData.heightHint = 30;
        this.type_label.setLayoutData((Object)gridData);
        this.loadDefaultLogSet();
        this.setControl((Control)composite2);
        this.setPageComplete(false);
        WorkbenchHelp.setHelp((Control)composite, (String)(LogUIPlugin.getPluginId() + ".pp0000"));
        composite.setFocus();
    }

    protected void loadDefaultLogSet() {
        this.lsMgr = new LogSetManager();
        this.lsMgr.initDefault();
        this.lsMgr.loadLogSets();
    }

    private void createLogTable(Composite composite) {
        this.logsTable = new Table(composite, 68354);
        GridData gridData = GridUtil.createFill();
        gridData.heightHint = 75;
        gridData.widthHint = 330;
        this.logsTable.setLayoutData((Object)gridData);
        TableColumn tableColumn = new TableColumn(this.logsTable, 0);
        TableColumn tableColumn2 = new TableColumn(this.logsTable, 0);
        tableColumn2.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_HOST"));
        TableColumn tableColumn3 = new TableColumn(this.logsTable, 0);
        tableColumn3.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_PATH"));
        ColumnWeightData columnWeightData = new ColumnWeightData(10, false);
        ColumnWeightData columnWeightData2 = new ColumnWeightData(50, true);
        ColumnWeightData columnWeightData3 = new ColumnWeightData(125, true);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)columnWeightData);
        tableLayout.addColumnData((ColumnLayoutData)columnWeightData2);
        tableLayout.addColumnData((ColumnLayoutData)columnWeightData3);
        this.logsTable.setLayout((Layout)tableLayout);
        this.logsTable.setHeaderVisible(true);
        this.logsTable.setLinesVisible(true);
        this.fTableViewer = new TableViewer(this.logsTable);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.fTableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.fTableViewer.setInput((Object)this.logElements);
        this.logsTable.addSelectionListener((SelectionListener)this);
        WorkbenchHelp.setHelp((Control)this.logsTable, (String)(LogUIPlugin.getPluginId() + ".pp0000"));
    }

    private void createLogButtons(Composite composite) {
        this.addBtn = new Button(composite, 8);
        this.addBtn.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_ADD"));
        GridData gridData = GridUtil.createHorizontalFill();
        gridData.widthHint = 90;
        gridData.horizontalAlignment = 2;
        this.addBtn.setLayoutData((Object)gridData);
        this.editBtn = new Button(composite, 8);
        this.editBtn.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_EDIT"));
        gridData = GridUtil.createHorizontalFill();
        gridData.widthHint = 90;
        gridData.horizontalAlignment = 2;
        this.editBtn.setLayoutData((Object)gridData);
        this.removeBtn = new Button(composite, 8);
        this.removeBtn.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_REMOVE"));
        gridData = GridUtil.createHorizontalFill();
        gridData.widthHint = 90;
        gridData.horizontalAlignment = 2;
        this.removeBtn.setLayoutData((Object)gridData);
        this.addBtn.addSelectionListener((SelectionListener)this);
        this.editBtn.addSelectionListener((SelectionListener)this);
        this.removeBtn.addSelectionListener((SelectionListener)this);
        this.updateButtons();
        WorkbenchHelp.setHelp((Control)this.addBtn, (String)(LogUIPlugin.getPluginId() + ".pp0010"));
        WorkbenchHelp.setHelp((Control)this.editBtn, (String)(LogUIPlugin.getPluginId() + ".pp0020"));
        WorkbenchHelp.setHelp((Control)this.removeBtn, (String)(LogUIPlugin.getPluginId() + ".pp0030"));
    }

    private void createLogSetButtons(Composite composite) {
        Label label = new Label(composite, 0);
        GridData gridData = GridUtil.createVerticalFill();
        gridData.heightHint = 120;
        label.setLayoutData((Object)gridData);
        this.newLogSetBtn = new Button(composite, 8);
        this.newLogSetBtn.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_NEW_SET"));
        GridData gridData2 = GridUtil.createHorizontalFill();
        gridData2.widthHint = 90;
        gridData2.horizontalAlignment = 2;
        this.newLogSetBtn.setLayoutData((Object)gridData2);
        this.openLogSetBtn = new Button(composite, 8);
        this.openLogSetBtn.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_OPEN_SET"));
        gridData2 = GridUtil.createHorizontalFill();
        gridData2.widthHint = 90;
        gridData2.horizontalAlignment = 2;
        this.openLogSetBtn.setLayoutData((Object)gridData2);
        this.editLogSetBtn = new Button(composite, 8);
        this.editLogSetBtn.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_EDIT_SET"));
        gridData2 = GridUtil.createHorizontalFill();
        gridData2.widthHint = 90;
        gridData2.horizontalAlignment = 2;
        this.editLogSetBtn.setLayoutData((Object)gridData2);
        this.newLogSetBtn.addSelectionListener((SelectionListener)this);
        this.openLogSetBtn.addSelectionListener((SelectionListener)this);
        this.editLogSetBtn.addSelectionListener((SelectionListener)this);
        this.updateButtons();
        WorkbenchHelp.setHelp((Control)this.newLogSetBtn, (String)(LogUIPlugin.getPluginId() + ".ls0000"));
        WorkbenchHelp.setHelp((Control)this.openLogSetBtn, (String)(LogUIPlugin.getPluginId() + ".ls0010"));
        WorkbenchHelp.setHelp((Control)this.editLogSetBtn, (String)(LogUIPlugin.getPluginId() + ".ls0020"));
    }

    private void updateButtons() {
        if (this.logElements.size() == 0) {
            this.editBtn.setEnabled(false);
            this.removeBtn.setEnabled(false);
            return;
        }
        this.editBtn.setEnabled(this.logsTable.getSelectionCount() > 0);
        this.removeBtn.setEnabled(this.logsTable.getSelectionCount() > 0);
    }

    public void refresh() {
        this.fTableViewer.refresh();
    }

    public boolean finish() {
        this.lsMgr.saveLogSets();
        this.lsMgr.getLogSets().clear();
        this.lsMgr.getLogSetsClone().clear();
        return true;
    }

    public void dispose() {
        super.dispose();
    }

    public void addElement(LogFileElement logFileElement) {
        this.logElements.add(logFileElement);
        ArrayList<LogFileElement> arrayList = (ArrayList<LogFileElement>)this.lsMgr.getLogSets().get(this.lsMgr.getDefaultLogSet());
        if (arrayList == null) {
            arrayList = new ArrayList<LogFileElement>();
            arrayList.add(logFileElement);
            this.lsMgr.getLogSets().put(this.lsMgr.getDefaultLogSet(), arrayList);
        } else {
            arrayList.add(logFileElement);
        }
    }

    public void removeElement(LogFileElement logFileElement) {
        this.logElements.remove(logFileElement);
        List list = (List)this.lsMgr.getLogSets().get(this.lsMgr.getDefaultLogSet());
        if (list != null) {
            list.remove(logFileElement);
        }
    }

    public LogFileElement getSelectedElement() {
        return this.selection;
    }

    public void setSelectedElement(LogFileElement logFileElement) {
        this.selection = logFileElement;
    }

    public List getLogFileElements() {
        return this.logElements;
    }

    public boolean isPageComplete() {
        List list = this.getLogFileElements();
        boolean bl = list.size() > 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            LogFileElement logFileElement = (LogFileElement)iterator.next();
            logFileElement.setValid(this.isLogElementValid(logFileElement));
            boolean bl2 = bl = bl && logFileElement.isValid();
        }
        return bl;
    }

    public LogFileDetailsUI getDialog(int n) {
        if (this.dialog == null || n != this.dialog_type) {
            this.dialog_type = n;
            this.dialog = new LogFileDetailsUI(this.getShell(), this, n);
        }
        return this.dialog;
    }

    public LogFileDetailsUI getDialog() {
        return this.dialog;
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.addBtn) {
            this.selection = new LogFileElement();
            this.addElement(this.selection);
            this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)this.selection));
            this.getDialog(4).setWindowTitle(LogUIPlugin.getResourceString("STR_ADD_LOG_FILE"));
            if (this.getDialog(4).open() == 0) {
                this.refresh();
            } else {
                this.removeElement(this.selection);
            }
            this.dialog = null;
        } else if (selectionEvent.widget == this.editBtn) {
            this.getDialog(5).setWindowTitle(LogUIPlugin.getResourceString("STR_EDIT_LOG_FILE"));
            if (this.getDialog(5).open() == 0) {
                this.refresh();
            }
            this.dialog = null;
        } else if (selectionEvent.widget == this.removeBtn) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fTableViewer.getSelection();
            if (!iStructuredSelection.isEmpty()) {
                Iterator iterator = iStructuredSelection.iterator();
                while (iterator.hasNext()) {
                    LogFileElement logFileElement = (LogFileElement)iterator.next();
                    this.removeElement(logFileElement);
                }
            }
            this.type_label.setText("");
            this.refresh();
        } else if (selectionEvent.widget == this.logsTable) {
            int n = this.logsTable.getSelectionIndex();
            this.selection = (LogFileElement)this.logElements.get(n);
            this.type_label.setText(this.selection.getParser().getDescription());
        } else if (selectionEvent.widget == this.newLogSetBtn) {
            this.onNewLogSetAction();
        } else if (selectionEvent.widget == this.openLogSetBtn) {
            this.onOpenLogSetAction();
        } else if (selectionEvent.widget == this.editLogSetBtn) {
            this.onEditLogSetsAction();
        }
        this.setPageComplete(this.isPageComplete());
        this.updateButtons();
    }

    private void onNewLogSetAction() {
        this.logSetDialog = new LogSetDialog(this.getShell(), 0);
        this.logSetDialog.setLogSets(this.lsMgr.getLogSets());
        this.type_label.setText("");
        if (this.logSetDialog.open() == 0) {
            this.lsMgr.setDefaultLogSet(this.logSetDialog.getDefaultLogSet());
            this.lsMgr.getLogSets().put(this.lsMgr.getDefaultLogSet(), null);
            this.updateLogSetDescription(this.lsMgr.getDefaultLogSet());
            this.getLogFileElements().clear();
            this.refresh();
            this.setPageComplete(this.isPageComplete());
        }
    }

    private void onOpenLogSetAction() {
        this.logSetDialog = new LogSetDialog(this.getShell(), 1, this);
        this.logSetDialog.setLogSets(this.lsMgr.getLogSets());
        this.logSetDialog.setDefaultLogSet(this.lsMgr.getDefaultLogSet());
        if (this.logSetDialog.open() == 0 && this.logSetDialog.hasLogSetSelectionChanged()) {
            this.lsMgr.setDefaultLogSet(this.logSetDialog.getDefaultLogSet());
            this.updateLogSetDescription(this.logSetDialog.getDefaultLogSet());
            this.lsMgr.openLogSet(this.logSetDialog.getDefaultLogSet());
            this.setPageComplete(this.isPageComplete());
        }
    }

    private void onEditLogSetsAction() {
        this.logSetDialog = new LogSetDialog(this.getShell(), 2, this);
        this.logSetDialog.setLogSets(this.lsMgr.getLogSetsClone());
        this.logSetDialog.setDefaultLogSet(this.lsMgr.getDefaultLogSet());
        if (this.logSetDialog.open() == 0) {
            this.lsMgr.getLogSets().clear();
            this.lsMgr.getLogSets().putAll(this.logSetDialog.getLogSets());
            this.lsMgr.getLogSetsClone().clear();
            if (this.logSetDialog.getDefaultLogSet() == null) {
                this.lsMgr.setDefaultLogSet("default");
                this.getLogFileElements().clear();
                this.refresh();
            } else if (this.logSetDialog.hasCurrentLogSetChanged()) {
                this.lsMgr.setDefaultLogSet(this.logSetDialog.getDefaultLogSet());
                this.lsMgr.openLogSet(this.logSetDialog.getDefaultLogSet());
            }
            this.setPageComplete(this.isPageComplete());
            this.updateLogSetDescription(this.lsMgr.getDefaultLogSet());
        }
    }

    public boolean isLogElementValid(LogFileElement logFileElement) {
        boolean bl = logFileElement.getHost() != null && logFileElement.getHost().length() > 0 && logFileElement.getMonitor() != null && logFileElement.getMonitor().length() > 0 && logFileElement.getProject() != null && logFileElement.getProject().length() > 0;
        boolean bl2 = true;
        List list = logFileElement.getValues();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string.length() != 0) continue;
            bl2 = false;
            break;
        }
        return bl2 && bl;
    }

    public void initLocation() {
        this.dialog.initializeLocation();
    }

    public void updateLogSetDescription(String string) {
        String string2 = LogUIPlugin.getResourceString("STR_IMPORT_LOG_SET_DESC");
        string2 = TString.change((String)string2, (String)"%1", (String)string);
        this.logset_desc.setText(string2);
    }

    public LogSetManager getLogSetManager() {
        return this.lsMgr;
    }

    public class LogSetManager {
        private IPreferenceStore preferenceStore = LogUIPlugin.getDefault().getPreferenceStore();
        private String defaultLogSet;
        private Map logSetsList = new HashMap();
        private Map parsers = new HashMap();
        private Map logSetsClone;

        LogSetManager() {
        }

        public void initDefault() {
            this.defaultLogSet = "default";
            this.loadParserRegistry();
        }

        public void loadLogSets() {
            String string = this.preferenceStore.getString("logsets");
            if (string.length() == 0) {
                this.logSetsList.put("default", null);
                ImportLogWizardPage.this.updateLogSetDescription(this.defaultLogSet);
                return;
            }
            Element element = XMLUtil.loadDom((String)string, (String)"logsets");
            if (element == null) {
                this.logSetsList.put("default", null);
                ImportLogWizardPage.this.updateLogSetDescription(this.defaultLogSet);
                return;
            }
            NodeList nodeList = XMLUtil.getChildrenByName((Element)element, (String)"logset");
            int n = 0;
            int n2 = nodeList.getLength();
            while (n < n2) {
                if (nodeList.item(n) instanceof Element) {
                    this.loadLogSet((Element)nodeList.item(n));
                }
                ++n;
            }
            List list = (List)this.logSetsList.get(this.defaultLogSet);
            if (list != null) {
                ImportLogWizardPage.this.logElements.addAll(list);
            }
            ImportLogWizardPage.this.updateLogSetDescription(this.defaultLogSet);
            ImportLogWizardPage.this.refresh();
        }

        private void loadLogSet(Element element) {
            if (XMLUtil.getValue((Element)element, (String)"default").equals("1")) {
                this.defaultLogSet = XMLUtil.getValue((Element)element, (String)"name");
            }
            ArrayList<LogFileElement> arrayList = new ArrayList<LogFileElement>();
            NodeList nodeList = XMLUtil.getChildrenByName((Element)element, (String)"LogFileElement");
            Element element2 = null;
            int n = 0;
            int n2 = nodeList.getLength();
            while (n < n2) {
                if (nodeList.item(n) instanceof Element) {
                    element2 = (Element)nodeList.item(n);
                }
                arrayList.add(this.loadElement(element2));
                ++n;
            }
            this.logSetsList.put(XMLUtil.getValue((Element)element, (String)"name"), arrayList);
        }

        private LogFileElement loadElement(Element element) {
            NodeList nodeList;
            LogFileElement logFileElement = new LogFileElement();
            logFileElement.setHost(XMLUtil.getValue((Element)element, (String)"host"));
            logFileElement.setMonitor(XMLUtil.getValue((Element)element, (String)"monitor"));
            logFileElement.setProject(XMLUtil.getValue((Element)element, (String)"project"));
            logFileElement.setValid(XMLUtil.getValue((Element)element, (String)"isValid").equals("true"));
            String string = XMLUtil.getValue((Element)element, (String)"mergedAgent");
            logFileElement.setParser((LogParserItem)this.parsers.get(XMLUtil.getValue((Element)element, (String)"parserId")));
            logFileElement.setUseLargeLogSupport("true".equals(XMLUtil.getValue((Element)element, (String)"useLargeLogSupport")));
            if (string != null && string.trim().length() > 0) {
                nodeList = null;
                try {
                    nodeList = (TRCAgentProxy)UIPlugin.getDefault().getResourceSet().getEObject(URI.createURI((String)string), true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                logFileElement.setMergedAgent((TRCAgentProxy)nodeList);
            }
            XMLUtil.getChildrenByName((Element)element, (String)"value");
            nodeList = XMLUtil.getChildrenByName((Element)element, (String)"value");
            int n = 0;
            int n2 = nodeList.getLength();
            while (n < n2) {
                if (nodeList.item(n) instanceof Element) {
                    logFileElement.getValues().add(XMLUtil.getValue((Element)((Element)nodeList.item(n)), (String)"val"));
                }
                ++n;
            }
            return logFileElement;
        }

        public void openLogSet(String string) {
            List list = (List)this.logSetsList.get(string);
            ImportLogWizardPage.this.logElements.clear();
            ImportLogWizardPage.this.logElements.addAll(list);
            ImportLogWizardPage.this.refresh();
        }

        public Map getLogSets() {
            return this.logSetsList;
        }

        public Map getLogSetsClone() {
            if (this.logSetsClone == null) {
                this.logSetsClone = new HashMap();
            }
            this.logSetsClone.clear();
            this.logSetsClone.putAll(this.logSetsList);
            return this.logSetsClone;
        }

        private void loadParserRegistry() {
            IPluginRegistry iPluginRegistry = Platform.getPluginRegistry();
            boolean bl = true;
            IConfigurationElement[] iConfigurationElementArray = iPluginRegistry.getConfigurationElementsFor("org.eclipse.hyades.logging.parsers", "logParser");
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                block6: {
                    IConfigurationElement iConfigurationElement;
                    Object object;
                    IConfigurationElement iConfigurationElement2 = iConfigurationElementArray[n];
                    LogParserItem logParserItem = new LogParserItem(iConfigurationElement2.getAttribute("id"), iConfigurationElement2.getAttribute("name"), iConfigurationElement2.getAttribute("ui_name"), iConfigurationElement2.getAttribute("description"));
                    logParserItem.setConfigurationElement(iConfigurationElement2);
                    logParserItem.setClass(iConfigurationElement2.getAttribute("class"));
                    logParserItem.setUIType(iConfigurationElement2.getAttribute("ui_type"));
                    String string = iConfigurationElement2.getAttribute("icon");
                    if (string != null && !string.equals("")) {
                        object = iConfigurationElement2.getDeclaringExtension().getDeclaringPluginDescriptor().getInstallURL();
                        try {
                            URL uRL = new URL((URL)object, string);
                            iConfigurationElement = ImageDescriptor.createFromURL((URL)uRL);
                            logParserItem.setImageDescriptor((ImageDescriptor)iConfigurationElement);
                        }
                        catch (Exception exception) {
                            iConfigurationElement = new Status(4, LogUIPlugin.getPluginId(), 2, "exception.malformedURL", (Throwable)exception);
                            LogUIPlugin.getDefault().getLog().log((IStatus)iConfigurationElement);
                            break block6;
                        }
                    }
                    object = iConfigurationElement2.getChildren("field");
                    int n2 = 0;
                    while (n2 < ((IConfigurationElement[])object).length) {
                        iConfigurationElement = object[n2];
                        ParserField parserField = new ParserField(iConfigurationElement.getAttribute("id"), iConfigurationElement.getAttribute("name"));
                        parserField.setConfigurationElement(iConfigurationElement);
                        parserField.setDefaultValue(iConfigurationElement.getAttribute("defaultValue"));
                        parserField.setContextId(iConfigurationElement.getAttribute("helpContextId"));
                        parserField.setTooltip(iConfigurationElement.getAttribute("tooltip"));
                        parserField.setFilters(iConfigurationElement.getAttribute("browseType"));
                        parserField.useBrowse(iConfigurationElement.getAttribute("useBrowse").equals("true"));
                        parserField.setUiType(iConfigurationElement.getAttribute("ui_type"));
                        parserField.setListener(iConfigurationElement.getAttribute("listener"));
                        logParserItem.addEntry(parserField);
                        ++n2;
                    }
                    iConfigurationElement = iConfigurationElement2.getChildren("parserParameter");
                    int n3 = 0;
                    while (n3 < ((IConfigurationElement)iConfigurationElement).length) {
                        IConfigurationElement iConfigurationElement3 = iConfigurationElement[n3];
                        ParserParameter parserParameter = new ParserParameter(iConfigurationElement3.getAttribute("name"), iConfigurationElement3.getAttribute("value"));
                        logParserItem.addParameter(parserParameter);
                        ++n3;
                    }
                    this.parsers.put(logParserItem.getId(), logParserItem);
                }
                ++n;
            }
        }

        public LogParserItem getLogParser(String string) {
            return (LogParserItem)this.parsers.get(string);
        }

        public Map getParserRegistry() {
            return this.parsers;
        }

        public void saveLogSets() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<?xml");
            stringBuffer.append((Object)XMLUtil.createXMLAttribute((String)"version", (String)"1.0", (boolean)false)).append((Object)XMLUtil.createXMLAttribute((String)"encoding", (String)"UTF-8", (boolean)false));
            stringBuffer.append("?>");
            stringBuffer.append(" <");
            stringBuffer.append("logsets");
            stringBuffer.append("> ");
            Set set = this.logSetsList.keySet();
            String string = "";
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                stringBuffer.append(this.generateLogSetPrefEntry(string));
            }
            stringBuffer.append(" </");
            stringBuffer.append("logsets");
            stringBuffer.append(">");
            this.preferenceStore.setValue("logsets", stringBuffer.toString());
        }

        private String generateLogSetPrefEntry(String string) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(" <");
            stringBuffer.append("logset");
            stringBuffer.append((Object)XMLUtil.createXMLAttribute((String)"name", (String)string, (boolean)false));
            stringBuffer.append((Object)XMLUtil.createXMLAttribute((String)"default", (String)(string.equals(this.defaultLogSet) ? "1" : "0"), (boolean)false));
            stringBuffer.append("> ");
            List list = (List)this.logSetsList.get(string);
            if (list != null) {
                LogFileElement logFileElement = null;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    logFileElement = (LogFileElement)iterator.next();
                    stringBuffer.append(this.generateLogElementPrefEntry(logFileElement));
                }
            }
            stringBuffer.append(" </");
            stringBuffer.append("logset");
            stringBuffer.append("> ");
            return stringBuffer.toString();
        }

        private String generateLogElementPrefEntry(LogFileElement logFileElement) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<LogFileElement ");
            stringBuffer.append((Object)XMLUtil.createXMLAttribute((String)"host", (String)logFileElement.getHost(), (boolean)false));
            stringBuffer.append((Object)XMLUtil.createXMLAttribute((String)"monitor", (String)logFileElement.getMonitor(), (boolean)false));
            stringBuffer.append((Object)XMLUtil.createXMLAttribute((String)"project", (String)logFileElement.getProject(), (boolean)false));
            stringBuffer.append((Object)XMLUtil.createXMLAttribute((String)"isValid", (String)(logFileElement.isValid() ? "true" : "false"), (boolean)false));
            stringBuffer.append((Object)XMLUtil.createXMLAttribute((String)"useLargeLogSupport", (String)(logFileElement.isUseLargeLogSupport() ? "true" : "false"), (boolean)false));
            stringBuffer.append((Object)XMLUtil.createXMLAttribute((String)"parserId", (String)logFileElement.getParser().getId(), (boolean)false));
            stringBuffer.append((Object)XMLUtil.createXMLAttribute((String)"mergedAgent", (String)(logFileElement.getMergedAgent() != null ? EcoreUtil.getURI((EObject)logFileElement.getMergedAgent()).toString() : ""), (boolean)false));
            stringBuffer.append(">");
            int n = 0;
            while (n < logFileElement.getValues().size()) {
                stringBuffer.append(" <value ");
                stringBuffer.append((Object)XMLUtil.createXMLAttribute((String)"val", (String)((String)logFileElement.getValues().get(n)), (boolean)false));
                stringBuffer.append("/> ");
                ++n;
            }
            stringBuffer.append("</LogFileElement>");
            return stringBuffer.toString();
        }

        public void setDefaultLogSet(String string) {
            this.defaultLogSet = string;
        }

        public String getDefaultLogSet() {
            if (this.defaultLogSet == null) {
                this.initDefault();
            }
            return this.defaultLogSet;
        }
    }

    class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private Hashtable images = new Hashtable();

        TableLabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            if (n == 0) {
                return this.getImageHelper(((LogFileElement)object).getParser());
            }
            return null;
        }

        private Image getImageHelper(LogParserItem logParserItem) {
            Image image = (Image)this.images.get(logParserItem.getDescription());
            if (image == null) {
                if (logParserItem.getImageDescriptor() == null) {
                    return null;
                }
                image = logParserItem.getImageDescriptor().createImage();
                this.images.put(logParserItem.getDescription(), image);
            }
            return image;
        }

        public String getColumnText(Object object, int n) {
            if (n == 1) {
                return ((LogFileElement)object).getHost();
            }
            if (n == 2) {
                ArrayList arrayList = ((LogFileElement)object).getParser().getFields();
                int n2 = arrayList.size();
                ParserField parserField = null;
                int n3 = 0;
                while (n3 < n2) {
                    parserField = (ParserField)arrayList.get(n3);
                    if (parserField != null && parserField.getId().equals("file_path")) break;
                    ++n3;
                }
                if (n3 >= 0 && n3 < ((LogFileElement)object).getValues().size()) {
                    return (String)((LogFileElement)object).getValues().get(n3);
                }
            }
            return "";
        }

        public void dispose() {
            Enumeration enumeration = this.images.elements();
            while (enumeration.hasMoreElements()) {
                Image image = (Image)enumeration.nextElement();
                if (image.isDisposed()) continue;
                image.dispose();
            }
            this.images.clear();
            super.dispose();
        }
    }

    class TableContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public Object[] getElements(Object object) {
            return ImportLogWizardPage.this.logElements.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }
}

