/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.wizards;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.util.TraceMergeUI;
import org.eclipse.hyades.log.ui.internal.wizards.ImportLogWizardPage;
import org.eclipse.hyades.log.ui.internal.wizards.LogFileElement;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.internal.core.TraceLocationUI;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeItem;

public class LogDestinationUI
implements Listener {
    private TraceLocationUI locationUI;
    private TraceMergeUI mergeUI;
    private TRCAgentProxy currentAgentProxy;
    private ImportLogWizardPage page;
    private boolean bTextHasChanged = true;

    public LogDestinationUI(ImportLogWizardPage importLogWizardPage) {
        this.page = importLogWizardPage;
    }

    public Composite createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)GridUtil.createFill());
        this.locationUI = new TraceLocationUI();
        this.locationUI.createControl(composite2);
        this.locationUI.setLocation("LogAnalyzerProject");
        this.locationUI.getLocationLabel().setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_FILE_DES_PROJECT"));
        this.locationUI.getLocation().addListener(24, (Listener)this);
        this.locationUI.getMonitor().addListener(24, (Listener)this);
        Label label = new Label(composite2, 0);
        GridData gridData = new GridData(768);
        this.mergeUI = new TraceMergeUI();
        this.mergeUI.createControl(composite2);
        this.mergeUI.getTree().addListener(13, (Listener)this);
        this.mergeUI.getMergeButton().addListener(13, (Listener)this);
        return composite2;
    }

    public void handleEvent(Event event) {
        LogFileElement logFileElement = this.page.getSelectedElement();
        if (event.type == 24) {
            if (this.bTextHasChanged) {
                this.page.setPageComplete(this.isTabItemComplete());
            }
        } else if (event.widget == this.mergeUI.getMergeButton()) {
            TreeItem treeItem;
            TreeItem[] treeItemArray;
            this.mergeUI.getTree().setEnabled(this.mergeUI.getMergeButton().getSelection());
            if (this.mergeUI.getMergeButton().getSelection() && (treeItemArray = this.mergeUI.getTree().getSelection()).length > 0 && (treeItem = treeItemArray[0]) != null && treeItem.getData() != null && treeItem.getData() instanceof TRCAgentProxy) {
                this.currentAgentProxy = (TRCAgentProxy)treeItem.getData();
                return;
            }
            this.currentAgentProxy = null;
        } else {
            TreeItem treeItem;
            TreeItem[] treeItemArray = this.mergeUI.getTree().getSelection();
            if (treeItemArray.length > 0 && (treeItem = treeItemArray[0]) != null && treeItem.getData() != null && treeItem.getData() instanceof TRCAgentProxy) {
                TRCMonitor tRCMonitor = ((TRCAgentProxy)treeItem.getData()).getProcessProxy().getNode().getMonitor();
                this.locationUI.setMonitor(tRCMonitor.getName());
                String string = this.resourcePath(tRCMonitor.eResource().getURI());
                IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
                Path path = new Path(string);
                IResource iResource = iWorkspace.getRoot().findMember((IPath)path);
                if (iResource != null && iResource.exists()) {
                    this.locationUI.setLocation(iResource.getProject().getName());
                }
                this.currentAgentProxy = (TRCAgentProxy)treeItem.getData();
                return;
            }
            this.currentAgentProxy = null;
        }
        this.bTextHasChanged = true;
    }

    public void initialize() {
        this.locationUI.initialize();
        this.setMergedAgent(null);
        this.setUseLargeLogSupport(false);
    }

    public void initializeUIFromLogElement(LogFileElement logFileElement) {
        if (logFileElement.getProject() == null || logFileElement.getMonitor() == null) {
            this.locationUI.initialize();
        } else {
            this.setProject(logFileElement.getProject());
            this.setMonitor(logFileElement.getMonitor());
        }
        this.setMergedAgent(this.page.getSelectedElement().getMergedAgent());
        this.setUseLargeLogSupport(this.page.getSelectedElement().isUseLargeLogSupport());
    }

    public String getProject() {
        return this.locationUI.getLocation().getText().trim();
    }

    public String getMonitor() {
        return this.locationUI.getMonitor().getText().trim();
    }

    public TRCAgentProxy getAgentProxy() {
        return this.currentAgentProxy;
    }

    public boolean getSelection() {
        return this.mergeUI.getMergeButton().getSelection();
    }

    private String resourcePath(URI uRI) {
        String string = uRI.path();
        if (string.startsWith("/resource")) {
            return string.substring(9);
        }
        if (string.startsWith("platform:/resource")) {
            return string.substring(18);
        }
        return string;
    }

    public void setProject(String string) {
        this.bTextHasChanged = false;
        this.locationUI.setLocation(string);
    }

    public void setMonitor(String string) {
        this.bTextHasChanged = false;
        this.locationUI.setMonitor(string);
    }

    public void setMergedAgent(TRCAgentProxy tRCAgentProxy) {
        if (tRCAgentProxy == null) {
            this.mergeUI.getMergeButton().setSelection(false);
            this.mergeUI.getTree().setEnabled(false);
        } else {
            this.mergeUI.getMergeButton().setSelection(true);
            this.mergeUI.getTree().setEnabled(true);
            this.mergeUI.selectMergedAgent(tRCAgentProxy);
            this.currentAgentProxy = tRCAgentProxy;
        }
    }

    public boolean isTabItemComplete() {
        return this.locationUI.getMonitor().getText().length() != 0 && this.locationUI.getLocation().getText().length() != 0;
    }

    public boolean finish() {
        LogFileElement logFileElement = this.page.getSelectedElement();
        logFileElement.setMonitor(this.locationUI.getMonitor().getText());
        logFileElement.setProject(this.locationUI.getLocation().getText());
        logFileElement.setMergedAgent(this.currentAgentProxy);
        logFileElement.setUseLargeLogSupport(this.mergeUI.getLargeLogSupport());
        return this.locationUI.getMonitor().getText().length() > 0 && this.locationUI.getLocation().getText().length() > 0;
    }

    public void setUseLargeLogSupport(boolean bl) {
        if (this.mergeUI != null) {
            this.mergeUI.setUseLargeLogSupport(bl);
        }
    }
}

