/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.wizards;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.LogUIPluginImages;
import org.eclipse.hyades.log.ui.internal.navigator.EMFUtil;
import org.eclipse.hyades.log.ui.internal.navigator.LogContentProvider;
import org.eclipse.hyades.log.ui.internal.navigator.LogLabelProvider;
import org.eclipse.hyades.log.ui.internal.navigator.LogNavigator;
import org.eclipse.hyades.log.ui.internal.util.ContextIds;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.ui.internal.util.ResourceUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.help.WorkbenchHelp;

public class LogSelectionWizardPage
extends WizardPage
implements SelectionListener {
    private DoubleList doubleList;
    private IStructuredSelection sel;
    private Text txtName;
    private Set existingCorrNames;

    protected LogSelectionWizardPage(String string, IStructuredSelection iStructuredSelection) {
        super(string);
        this.setTitle(LogUIPlugin.getResourceString("STR_LOGSEL_PAGE_TITLE"));
        this.setDescription(LogUIPlugin.getResourceString("STR_LOGSEL_PAGE_DESC"));
        this.setImageDescriptor(LogUIPluginImages.getImageDescriptor("newcorrelation.gif"));
        this.sel = iStructuredSelection;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        GridData gridData = GridUtil.createFill();
        gridData.widthHint = 370;
        composite2.setLayoutData((Object)gridData);
        this.createNameGroup(composite2);
        this.doubleList = new DoubleList(composite2, 0, LogUIPlugin.getResourceString("STR_AVAILABLE_LOGS"), LogUIPlugin.getResourceString("STR_SELECTED_LOGS"));
        this.doubleList.createControl();
        this.initializeValues();
        this.doubleList.addSelectionListener(this);
        this.setControl((Control)composite2);
    }

    public String getName() {
        return this.txtName.getText();
    }

    public List getLogFiles() {
        return this.doubleList.getTargetItems();
    }

    private void createNameGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.verticalSpacing = 2;
        GridData gridData = GridUtil.createHorizontalFill();
        gridData.widthHint = 300;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)gridData);
        Label label = new Label(composite2, 0);
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        label.setText(LogUIPlugin.getResourceString("STR_NEW_CORR_NAME"));
        this.txtName = new Text(composite2, 2048);
        gridData = GridUtil.createHorizontalFill();
        this.txtName.setLayoutData((Object)gridData);
        IPreferenceStore iPreferenceStore = LogUIPlugin.getDefault().getPreferenceStore();
        this.txtName.setText("NewCorrelation (" + (iPreferenceStore.getInt("corr_nr") + 1) + ")");
        this.txtName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                if (LogSelectionWizardPage.this.existingCorrNames != null && LogSelectionWizardPage.this.existingCorrNames.contains(LogSelectionWizardPage.this.txtName.getText())) {
                    LogSelectionWizardPage.this.setErrorMessage(LogUIPlugin.getResourceString("STR_CORR_EXISTS_MSG"));
                } else {
                    LogSelectionWizardPage.this.setErrorMessage(null);
                }
                LogSelectionWizardPage.this.setPageComplete(LogSelectionWizardPage.this.isPageComplete());
            }
        });
        WorkbenchHelp.setHelp((Control)this.txtName, (String)ContextIds.NEW_CORR_WIZARD_CORRNAME);
    }

    private void initializeValues() {
        List list = new ArrayList();
        ArrayList arrayList = new ArrayList();
        list = this.populateLogFilesList();
        this.doubleList.removeAll();
        this.doubleList.initializeSourceList(list);
        this.doubleList.initializeTargetList(arrayList);
        if (this.sel != null && !this.sel.isEmpty()) {
            Object e = null;
            Iterator iterator = this.sel.iterator();
            while (iterator.hasNext()) {
                e = iterator.next();
                if (e == null || !(e instanceof TRCAgentProxy)) continue;
                this.doubleList.getSourceItems().remove(e);
                this.doubleList.getTargetItems().add(e);
            }
            this.doubleList.refreshViews();
        }
    }

    private List populateLogFilesList() {
        IWorkbenchWindow iWorkbenchWindow;
        IWorkbenchPage iWorkbenchPage = null;
        IViewPart iViewPart = null;
        IWorkbenchWindow[] iWorkbenchWindowArray = LogUIPlugin.getDefault().getWorkbench().getWorkbenchWindows();
        int n = 0;
        while (n < iWorkbenchWindowArray.length) {
            iWorkbenchWindow = iWorkbenchWindowArray[n];
            IWorkbenchPage[] iWorkbenchPageArray = iWorkbenchWindow.getPages();
            int n2 = 0;
            while (n2 < iWorkbenchPageArray.length) {
                iWorkbenchPage = iWorkbenchPageArray[n2];
                if (iWorkbenchPage != null && (iViewPart = iWorkbenchPage.findView("org.eclipse.hyades.log.ui.internal.navigator.LogNavigator")) != null) break;
                ++n2;
            }
            ++n;
        }
        iWorkbenchWindow = new ArrayList();
        if (iViewPart != null && iViewPart instanceof LogNavigator) {
            iWorkbenchWindow.addAll(EMFUtil.getLogAgentsFromResourceSet((ResourceSet)HierarchyResourceSetImpl.getInstance()));
            this.loadCorrelationContainerProxyNames(((LogNavigator)iViewPart).getContentProvider());
        } else {
            iWorkbenchWindow.addAll(this.loadLogFiles());
        }
        return iWorkbenchWindow;
    }

    private void loadCorrelationContainerProxyNames(LogContentProvider logContentProvider) {
        if (this.existingCorrNames == null) {
            this.existingCorrNames = new HashSet();
        }
        if (logContentProvider != null) {
            Object[] objectArray = logContentProvider.getChildren(logContentProvider.getCorrelationFolder());
            int n = 0;
            while (n < objectArray.length) {
                this.existingCorrNames.add(((CorrelationContainerProxy)objectArray[n]).getName());
                ++n;
            }
        }
    }

    private List loadLogFiles(Object[] objectArray) {
        int n = objectArray.length;
        ArrayList<TRCAgentProxy> arrayList = new ArrayList<TRCAgentProxy>();
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof TRCMonitor) {
                this.appendCorrelationContainerProxyNames((List)((TRCMonitor)object).getCorrelationContainerProxies());
                EList eList = ((TRCMonitor)object).getNodes();
                int n3 = eList.size();
                int n4 = 0;
                while (n4 < n3) {
                    EList eList2 = ((TRCNode)eList.get(n4)).getProcessProxies();
                    int n5 = 0;
                    while (n5 < eList2.size()) {
                        EList eList3 = ((TRCProcessProxy)eList2.get(n5)).getAgentProxies();
                        int n6 = 0;
                        while (n6 < eList3.size()) {
                            TRCAgentProxy tRCAgentProxy = (TRCAgentProxy)eList3.get(n6);
                            if (tRCAgentProxy.getType().equals("Logging")) {
                                arrayList.add(tRCAgentProxy);
                            }
                            ++n6;
                        }
                        ++n5;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return arrayList;
    }

    private void appendCorrelationContainerProxyNames(List list) {
        if (this.existingCorrNames == null) {
            this.existingCorrNames = new HashSet();
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            CorrelationContainerProxy correlationContainerProxy = (CorrelationContainerProxy)iterator.next();
            if (this.existingCorrNames.contains(correlationContainerProxy.getName())) continue;
            this.existingCorrNames.add(correlationContainerProxy.getName());
        }
    }

    private List loadLogFiles() {
        String[] stringArray = new String[]{"trcmxmi"};
        Map map = ResourceUtil.getFiles((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot(), (String[])stringArray, null);
        Object[] objectArray = EMFUtil.loadMonitorsFromResourceSet((ResourceSet)HierarchyResourceSetImpl.getInstance());
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.loadLogFiles(objectArray));
        Iterator iterator = ((List)map.get("trcmxmi")).iterator();
        while (iterator.hasNext()) {
            Object[] objectArray2 = EMFUtil.load((ResourceSet)HierarchyResourceSetImpl.getInstance(), (IFile)iterator.next());
            Iterator iterator2 = this.loadLogFiles(objectArray2).iterator();
            while (iterator2.hasNext()) {
                Object e = iterator2.next();
                if (arrayList.contains(e)) continue;
                arrayList.add(e);
            }
        }
        return arrayList;
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        this.setPageComplete(this.isPageComplete());
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public boolean isPageComplete() {
        return this.doubleList.getTargetItems().size() > 0 && this.txtName.getText().length() > 0 && this.existingCorrNames != null && !this.existingCorrNames.contains(this.txtName.getText());
    }

    public void dispose() {
        this.doubleList.removeSelectionListener(this);
        if (this.existingCorrNames != null) {
            this.existingCorrNames.clear();
        }
        super.dispose();
    }

    class DoubleList {
        Group group;
        Composite groupWidget;
        private TableViewer sourceList;
        private TableViewer targetList;
        private Label targetListLabel;
        private Label sourceListLabel;
        private List sourceContent = new ArrayList();
        private List targetContent = new ArrayList();
        private Button add;
        private Button remove;
        private Button addAll;
        private Button removeAll;
        private List listeners = new ArrayList(2);
        private TableLabelProvider labelProvider;
        private Composite parent;
        private int style;
        private String sourceText;
        private String targetText;

        public DoubleList(Composite composite, int n, String string, String string2) {
            this.parent = composite;
            this.style = n;
            this.sourceText = string;
            this.targetText = string2;
        }

        public Control createControl() {
            this.group = new Group(this.parent, this.style);
            this.group.setText("");
            GridLayout gridLayout = new GridLayout();
            gridLayout.horizontalSpacing = 0;
            this.group.setLayout((Layout)gridLayout);
            this.group.setLayoutData((Object)GridUtil.createFill());
            this.createDoubleList((Composite)this.group, this.sourceText, this.targetText);
            WidgetListener widgetListener = new WidgetListener();
            this.add.addSelectionListener((SelectionListener)widgetListener);
            this.remove.addSelectionListener((SelectionListener)widgetListener);
            this.addAll.addSelectionListener((SelectionListener)widgetListener);
            this.removeAll.addSelectionListener((SelectionListener)widgetListener);
            this.sourceList.getTable().addSelectionListener((SelectionListener)widgetListener);
            this.targetList.getTable().addSelectionListener((SelectionListener)widgetListener);
            WorkbenchHelp.setHelp((Control)this.sourceList.getTable(), (String)ContextIds.NEW_CORR_WIZARD_LOGS);
            WorkbenchHelp.setHelp((Control)this.targetList.getTable(), (String)ContextIds.NEW_CORR_WIZARD_LOGS);
            return this.group;
        }

        public void refreshViews() {
            this.sourceList.refresh();
            this.targetList.refresh();
        }

        public void createDoubleList(Composite composite, String string, String string2) {
            this.groupWidget = composite;
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 3;
            this.groupWidget.setLayout((Layout)gridLayout);
            this.createTableGroup(this.groupWidget, string, true);
            this.createButtonGroup(this.groupWidget);
            this.createTableGroup(this.groupWidget, string2, false);
            this.labelProvider = new TableLabelProvider();
        }

        public void initializeSourceList(List list) {
            this.sourceContent.addAll(list);
            this.sourceList.setContentProvider((IContentProvider)new TableContentProvider());
            this.sourceList.setLabelProvider((IBaseLabelProvider)this.labelProvider);
            this.sourceList.setInput((Object)this.sourceContent);
            if (list.size() > 0) {
                this.sourceList.setSelection((ISelection)new StructuredSelection(list.get(0)));
            }
        }

        public void initializeTargetList(List list) {
            this.targetContent.addAll(list);
            this.targetList.setContentProvider((IContentProvider)new TableContentProvider());
            this.targetList.setLabelProvider((IBaseLabelProvider)this.labelProvider);
            this.targetList.setInput((Object)this.targetContent);
        }

        public void removeAll() {
            this.targetContent.clear();
            this.sourceContent.clear();
        }

        public List getSourceItems() {
            return this.sourceContent;
        }

        public List getTargetItems() {
            return this.targetContent;
        }

        public void addSelectionListener(SelectionListener selectionListener) {
            if (!this.listeners.contains(selectionListener)) {
                this.listeners.add(selectionListener);
            }
        }

        public void removeSelectionListener(SelectionListener selectionListener) {
            this.listeners.remove(selectionListener);
        }

        public void fireSelectionNotification(SelectionEvent selectionEvent) {
            int n = 0;
            while (n < this.listeners.size()) {
                ((SelectionListener)this.listeners.get(n)).widgetSelected(selectionEvent);
                ++n;
            }
        }

        private void createTableGroup(Composite composite, String string, boolean bl) {
            Composite composite2 = new Composite(composite, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 1;
            composite2.setLayout((Layout)gridLayout);
            GridData gridData = GridUtil.createFill();
            gridData.widthHint = 150;
            composite2.setLayoutData((Object)gridData);
            Label label = new Label(composite2, 0);
            label.setText(string);
            GridData gridData2 = new GridData();
            gridData2.horizontalAlignment = 4;
            label.setLayoutData((Object)gridData2);
            if (bl) {
                this.sourceList = new TableViewer(this.createTable(composite2));
                this.sourceList.getTable().setLayoutData((Object)GridUtil.createFill());
            } else {
                this.targetList = new TableViewer(this.createTable(composite2));
                this.targetList.getTable().setLayoutData((Object)GridUtil.createFill());
            }
        }

        private Table createTable(Composite composite) {
            Table table = new Table(composite, 68356);
            GridData gridData = GridUtil.createFill();
            gridData.heightHint = 75;
            gridData.widthHint = 150;
            table.setLayoutData((Object)gridData);
            TableColumn tableColumn = new TableColumn(table, 0);
            TableColumn tableColumn2 = new TableColumn(table, 0);
            ColumnWeightData columnWeightData = new ColumnWeightData(0, false);
            ColumnWeightData columnWeightData2 = new ColumnWeightData(1, true);
            TableLayout tableLayout = new TableLayout();
            tableLayout.addColumnData((ColumnLayoutData)columnWeightData);
            tableLayout.addColumnData((ColumnLayoutData)columnWeightData2);
            table.setLayout((Layout)tableLayout);
            table.setHeaderVisible(true);
            table.setLinesVisible(true);
            return table;
        }

        private void createButtonGroup(Composite composite) {
            Composite composite2 = new Composite(composite, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 1;
            composite2.setLayout((Layout)gridLayout);
            Label label = new Label(composite2, 8);
            label.setText("");
            GridData gridData = new GridData();
            gridData.grabExcessVerticalSpace = true;
            gridData.verticalAlignment = 4;
            label.setLayoutData((Object)gridData);
            this.add = new Button(composite2, 8);
            this.add.setText(LogUIPlugin.getResourceString("LEFT_TO_RIGHT"));
            gridData = new GridData();
            gridData.horizontalAlignment = 4;
            this.add.setLayoutData((Object)gridData);
            this.remove = new Button(composite2, 8);
            this.remove.setText(LogUIPlugin.getResourceString("RIGHT_TO_LEFT"));
            gridData = new GridData();
            gridData.horizontalAlignment = 4;
            this.remove.setLayoutData((Object)gridData);
            new Label(composite2, 0);
            this.addAll = new Button(composite2, 8);
            this.addAll.setText(LogUIPlugin.getResourceString("LEFT_ALL_TO_RIGHT"));
            gridData = new GridData();
            gridData.horizontalAlignment = 4;
            this.addAll.setLayoutData((Object)gridData);
            this.removeAll = new Button(composite2, 8);
            this.removeAll.setText(LogUIPlugin.getResourceString("RIGHT_ALL_TO_LEFT"));
            gridData = new GridData();
            gridData.horizontalAlignment = 4;
            this.removeAll.setLayoutData((Object)gridData);
            Label label2 = new Label(composite2, 8);
            label2.setText("");
            gridData = new GridData();
            gridData.grabExcessVerticalSpace = true;
            gridData.verticalAlignment = 4;
            label.setLayoutData((Object)gridData);
            WorkbenchHelp.setHelp((Control)this.add, (String)ContextIds.NEW_CORR_WIZARD_LOGS);
            WorkbenchHelp.setHelp((Control)this.remove, (String)ContextIds.NEW_CORR_WIZARD_LOGS);
            WorkbenchHelp.setHelp((Control)this.addAll, (String)ContextIds.NEW_CORR_WIZARD_LOGS);
            WorkbenchHelp.setHelp((Control)this.removeAll, (String)ContextIds.NEW_CORR_WIZARD_LOGS);
        }

        class TableLabelProvider
        extends LabelProvider
        implements ITableLabelProvider {
            private LogLabelProvider logLabelProvider = new LogLabelProvider();

            public Image getColumnImage(Object object, int n) {
                if (n == 0) {
                    return this.logLabelProvider.getImage(object);
                }
                return null;
            }

            public String getColumnText(Object object, int n) {
                if (n == 1) {
                    return this.logLabelProvider.getText(object);
                }
                return "";
            }

            public void dispose() {
                super.dispose();
            }
        }

        class TableContentProvider
        implements IStructuredContentProvider {
            private List tableContents = new ArrayList(0);

            TableContentProvider() {
            }

            public Object[] getElements(Object object) {
                return this.tableContents.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
                this.tableContents = (List)object2;
            }
        }

        class WidgetListener
        implements SelectionListener {
            WidgetListener() {
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                Object e;
                Iterator iterator;
                IStructuredSelection iStructuredSelection;
                if (selectionEvent.widget == DoubleList.this.sourceList.getTable() && !DoubleList.this.sourceList.getSelection().isEmpty()) {
                    iStructuredSelection = (IStructuredSelection)DoubleList.this.sourceList.getSelection();
                    iterator = iStructuredSelection.iterator();
                    while (iterator.hasNext()) {
                        e = iterator.next();
                        DoubleList.this.targetContent.add(e);
                        DoubleList.this.sourceContent.remove(e);
                    }
                    DoubleList.this.sourceList.setSelection((ISelection)StructuredSelection.EMPTY);
                    DoubleList.this.refreshViews();
                    DoubleList.this.fireSelectionNotification(selectionEvent);
                }
                if (selectionEvent.widget == DoubleList.this.targetList.getTable() && !DoubleList.this.targetList.getSelection().isEmpty()) {
                    iStructuredSelection = (IStructuredSelection)DoubleList.this.targetList.getSelection();
                    iterator = iStructuredSelection.iterator();
                    while (iterator.hasNext()) {
                        e = iterator.next();
                        DoubleList.this.sourceContent.add(e);
                        DoubleList.this.targetContent.remove(e);
                    }
                    DoubleList.this.targetList.setSelection((ISelection)StructuredSelection.EMPTY);
                    DoubleList.this.refreshViews();
                    DoubleList.this.fireSelectionNotification(selectionEvent);
                }
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                TableItem[] tableItemArray;
                if (selectionEvent.widget == DoubleList.this.add) {
                    IStructuredSelection iStructuredSelection = (IStructuredSelection)DoubleList.this.sourceList.getSelection();
                    Iterator iterator = iStructuredSelection.iterator();
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        DoubleList.this.targetContent.add(e);
                        DoubleList.this.sourceContent.remove(e);
                    }
                    DoubleList.this.sourceList.setSelection((ISelection)StructuredSelection.EMPTY);
                } else if (selectionEvent.widget == DoubleList.this.addAll) {
                    int n = 0;
                    while (n < DoubleList.this.sourceContent.size()) {
                        Object e = DoubleList.this.sourceContent.get(n);
                        DoubleList.this.targetContent.add(e);
                        ++n;
                    }
                    DoubleList.this.sourceContent.clear();
                } else if (selectionEvent.widget == DoubleList.this.remove) {
                    IStructuredSelection iStructuredSelection = (IStructuredSelection)DoubleList.this.targetList.getSelection();
                    Iterator iterator = iStructuredSelection.iterator();
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        DoubleList.this.sourceContent.add(e);
                        DoubleList.this.targetContent.remove(e);
                    }
                    DoubleList.this.targetList.setSelection((ISelection)StructuredSelection.EMPTY);
                } else if (selectionEvent.widget == DoubleList.this.removeAll) {
                    int n = 0;
                    while (n < DoubleList.this.targetContent.size()) {
                        Object e = DoubleList.this.targetContent.get(n);
                        DoubleList.this.sourceContent.add(e);
                        ++n;
                    }
                    DoubleList.this.targetContent.clear();
                } else if (selectionEvent.widget instanceof Table && (tableItemArray = ((Table)selectionEvent.widget).getSelection()) != null && tableItemArray.length > 0) {
                    ((Table)selectionEvent.widget).setToolTipText(tableItemArray[0].getText());
                }
                DoubleList.this.refreshViews();
                DoubleList.this.fireSelectionNotification(selectionEvent);
            }
        }
    }
}

