/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.wizards;

import java.util.Map;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.wizards.ImportLogWizardPage;
import org.eclipse.hyades.log.ui.internal.wizards.LogSetUI;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.help.WorkbenchHelp;

public class LogSetDialog
extends Dialog {
    private LogSetUI logSetUI;
    private int type;
    private ImportLogWizardPage page;
    private Map logSets;
    private String defaultLogSet;
    private boolean logSetSelChanged = false;
    private boolean currentLogSetChanged = false;
    private String logSetName;

    public LogSetDialog(Shell shell, int n) {
        super(shell);
        this.type = n;
    }

    public LogSetDialog(Shell shell, int n, ImportLogWizardPage importLogWizardPage) {
        super(shell);
        this.type = n;
        this.page = importLogWizardPage;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridData gridData = GridUtil.createFill();
        composite2.setLayoutData((Object)gridData);
        composite2.setLayout((Layout)new GridLayout());
        this.logSetUI = new LogSetUI(this);
        this.setTitle();
        this.logSetUI.createContent(composite2, this.type);
        switch (this.type) {
            case 0: {
                WorkbenchHelp.setHelp((Control)composite2, (String)(LogUIPlugin.getPluginId() + ".ls0000"));
                break;
            }
            case 1: {
                WorkbenchHelp.setHelp((Control)composite2, (String)(LogUIPlugin.getPluginId() + ".ls0010"));
                break;
            }
            case 2: {
                WorkbenchHelp.setHelp((Control)composite2, (String)(LogUIPlugin.getPluginId() + ".ls0020"));
            }
        }
        return composite2;
    }

    private void setTitle() {
        switch (this.type) {
            case 0: {
                this.getShell().setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_NEW_TITLE"));
                break;
            }
            case 1: {
                this.getShell().setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_OPEN_TITLE"));
                break;
            }
            case 2: {
                this.getShell().setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_EDIT_TITLE"));
                break;
            }
            case 3: {
                this.getShell().setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_REN_TITLE"));
            }
        }
    }

    public void setOKButtonEnabled(boolean bl) {
        Button button = this.getButton(0);
        if (button != null) {
            button.setEnabled(bl);
        }
    }

    public Map getLogSets() {
        return this.logSets;
    }

    public void setLogSets(Map map) {
        this.logSets = map;
    }

    public String getDefaultLogSet() {
        return this.defaultLogSet;
    }

    public void setDefaultLogSet(String string) {
        this.defaultLogSet = string;
    }

    public void setLogSetSelectionChanged(boolean bl) {
        this.logSetSelChanged = bl;
    }

    public boolean hasLogSetSelectionChanged() {
        return this.logSetSelChanged;
    }

    public boolean hasCurrentLogSetChanged() {
        return this.currentLogSetChanged;
    }

    public void setCurrentLogSetChanged(boolean bl) {
        this.currentLogSetChanged = bl;
    }

    public String getCurrentLogSet() {
        return this.page.getLogSetManager().getDefaultLogSet();
    }

    public String getLogSetName() {
        return this.logSetName;
    }

    public void setLogSetName(String string) {
        this.logSetName = string;
    }
}

