/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sd.logc.internal.loader;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.sd.logc.SDLogcPlugin;
import org.eclipse.hyades.sd.logc.SDLogcPluginImages;
import org.eclipse.hyades.sd.logc.internal.loader.LogInteractions;
import org.eclipse.hyades.uml2sd.ui.core.LifelineCategories;

public class LogThreadInteractions
extends LogInteractions {
    private List threadIDs = new UniqueEList();

    protected void loadEvents() {
        if (!this.isDisplayingOnlyCorrelations()) {
            this.loadThreadIdsFromAgentList(true);
        } else {
            this.loadThreadIdsFromAgentList(false);
            this.loadEventsFromCorrelations();
        }
    }

    private void loadThreadIdsFromAgentList(boolean bl) {
        Iterator iterator = this.agentsList.iterator();
        while (iterator.hasNext()) {
            TRCAgentProxy tRCAgentProxy = (TRCAgentProxy)iterator.next();
            if (tRCAgentProxy == null || tRCAgentProxy.eIsProxy()) continue;
            this.loadThreadIdsFromAgent(tRCAgentProxy);
            if (!bl) continue;
            this.addEvents(tRCAgentProxy);
        }
    }

    private void loadThreadIdsFromAgent(TRCAgentProxy tRCAgentProxy) {
        EList eList = tRCAgentProxy.getAgent().getDefaultEvents();
        CBECommonBaseEvent cBECommonBaseEvent = null;
        String string = null;
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            cBECommonBaseEvent = (CBECommonBaseEvent)iterator.next();
            string = cBECommonBaseEvent.getSourceComponentId().getThreadId();
            if (string == null) {
                string = "-1";
            }
            this.threadIDs.add(tRCAgentProxy.getName() + " - " + "TID:" + string);
        }
    }

    protected void generateLifelines() {
        String string = null;
        Iterator iterator = this.getLifelineArtifactsList().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            LogInteractions.TraceLifeline traceLifeline = new LogInteractions.TraceLifeline();
            traceLifeline.setName(string);
            traceLifeline.setCategory(0);
            this.frame.addLifeLine(traceLifeline);
            this.lifelinesMap.put(string, traceLifeline);
        }
    }

    protected Object getLifelinesMapKey(CBECommonBaseEvent cBECommonBaseEvent) {
        String string = cBECommonBaseEvent.getSourceComponentId().getThreadId();
        if (string == null) {
            string = "-1";
        }
        return cBECommonBaseEvent.getAgent().getAgentProxy().getName() + " - " + "TID:" + string;
    }

    public String getTitleString() {
        String string = SDLogcPlugin.getString("STR_VIEW_TITLE") + ": " + SDLogcPlugin.getString("STR_MENU_LOT");
        if (this.correlationContainerProxy != null) {
            string = string + " <" + this.correlationContainerProxy.getCorrelationEngine().getName() + "> ";
        }
        return string;
    }

    protected List getLifelineArtifactsList() {
        return this.threadIDs;
    }

    protected void clearDiagramCaches() {
        this.threadIDs.clear();
        super.clearDiagramCaches();
    }

    protected String getFrameTitle() {
        return SDLogcPlugin.getString("STR_MENU_LOT") + ":      " + this.getFrameName();
    }

    static {
        LogInteractions.traceCategories = new LifelineCategories[1];
        LogInteractions.traceCategories[0] = new LifelineCategories();
        LogInteractions.traceCategories[0].setName("");
        LogInteractions.image = SDLogcPluginImages.getImage("thread_obj.gif");
        LogInteractions.traceCategories[0].setImage(LogInteractions.image);
    }
}

