/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sd.logc.internal.uml2sd;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.loaders.cbe.CBEUtils;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.sd.logc.SDLogcPlugin;
import org.eclipse.hyades.sd.logc.SDLogcPluginImages;
import org.eclipse.hyades.sd.logc.internal.util.LogcUtil;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.hyades.uml2sd.ui.core.ExecutionOccurrence;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class LogGraphNode
extends ExecutionOccurrence
implements IPropertySource,
IActionFilter {
    private EObject element;
    private List elements = null;
    private boolean expanded = false;
    private IPropertyDescriptor[] propertyDescriptors;
    private static String PROPERTY = "cbe.node.";

    protected LogGraphNode() {
    }

    public LogGraphNode(EObject eObject) {
        this.element = eObject;
    }

    public EObject getElement() {
        if (!this.hasElements() || this.hasElements() && this.isExpanded()) {
            return this.element;
        }
        return (EObject)this.elements.get(0);
    }

    public List getElements() {
        return this.elements;
    }

    public void addElement(EObject eObject) {
        if (this.elements == null) {
            this.elements = new ArrayList();
            if (this.element != null) {
                this.elements.add(this.element);
            }
        }
        this.elements.add(eObject);
    }

    public boolean hasElements() {
        return this.elements != null && this.elements.size() > 0;
    }

    public void setBackgroundColor() {
        short s = 0;
        if (!this.hasElements() || this.isExpanded()) {
            s = ((CBECommonBaseEvent)this.element).getSeverity();
        } else {
            CBECommonBaseEvent cBECommonBaseEvent = (CBECommonBaseEvent)Collections.max(this.elements, new Comparator(){

                public int compare(Object object, Object object2) {
                    if (((CBECommonBaseEvent)object).getSeverity() > ((CBECommonBaseEvent)object2).getSeverity()) {
                        return 1;
                    }
                    if (((CBECommonBaseEvent)object).getSeverity() == ((CBECommonBaseEvent)object2).getSeverity()) {
                        return 0;
                    }
                    return -1;
                }
            });
            s = cBECommonBaseEvent.getSeverity();
        }
        if (s >= 0 && s <= 70) {
            if (s >= 50) {
                this.setFillColor(LogcUtil.redFill[0], LogcUtil.redFill[1], LogcUtil.redFill[2]);
                this.setStrokeColor(LogcUtil.redStroke[0], LogcUtil.redStroke[1], LogcUtil.redStroke[2]);
            } else if (s >= 30 && s < 50) {
                this.setFillColor(LogcUtil.yellowFill[0], LogcUtil.yellowFill[1], LogcUtil.yellowFill[2]);
                this.setStrokeColor(LogcUtil.yellowStroke[0], LogcUtil.yellowStroke[1], LogcUtil.yellowStroke[2]);
            } else if (s < 30) {
                this.setFillColor(LogcUtil.blueFill[0], LogcUtil.blueFill[1], LogcUtil.blueFill[2]);
                this.setStrokeColor(LogcUtil.blueStroke[0], LogcUtil.blueStroke[1], LogcUtil.blueStroke[2]);
            }
        }
        if (this.hasElements()) {
            if (this.isExpanded()) {
                this.setImage(SDLogcPluginImages.getImage("collapse_ovr.gif"));
            } else {
                this.setImage(SDLogcPluginImages.getImage("expand_ovr.gif"));
            }
        }
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (!this.hasElements() || this.isExpanded()) {
            if (this.propertyDescriptors == null) {
                this.propertyDescriptors = new IPropertyDescriptor[1];
                PropertyDescriptor propertyDescriptor = new PropertyDescriptor((Object)PROPERTY, "[" + CBEUtils.formatCreationTime((CBECommonBaseEvent)((CBECommonBaseEvent)this.element), (SimpleDateFormat)LogUIPlugin.getDateTimeFormat()) + "] " + ((CBECommonBaseEvent)this.element).getMsg());
                propertyDescriptor.setLabelProvider((ILabelProvider)new LabelProvider(){

                    public String getText(Object object) {
                        return TString.change((String)SDLogcPlugin.getString("STR_SEVERITY_A"), (String)"%1", (String)("" + ((CBECommonBaseEvent)object).getSeverity()));
                    }
                });
                this.propertyDescriptors[0] = propertyDescriptor;
            }
        } else if (this.propertyDescriptors == null) {
            this.propertyDescriptors = new IPropertyDescriptor[this.elements.size()];
            int n = 0;
            while (n < this.elements.size()) {
                PropertyDescriptor propertyDescriptor = new PropertyDescriptor((Object)(PROPERTY + n), n + ": [" + CBEUtils.formatCreationTime((CBECommonBaseEvent)((CBECommonBaseEvent)this.elements.get(n)), (SimpleDateFormat)LogUIPlugin.getDateTimeFormat()) + "] " + ((CBECommonBaseEvent)this.elements.get(n)).getMsg());
                final int n2 = n;
                propertyDescriptor.setLabelProvider((ILabelProvider)new LabelProvider(){

                    public String getText(Object object) {
                        return TString.change((String)SDLogcPlugin.getString("STR_SEVERITY_A"), (String)"%1", (String)("" + ((CBECommonBaseEvent)LogGraphNode.this.elements.get(n2)).getSeverity()));
                    }
                });
                propertyDescriptor.setCategory(TString.change((String)SDLogcPlugin.getString("STR_CBES"), (String)"%1", (String)("" + this.elements.size())));
                this.propertyDescriptors[n] = propertyDescriptor;
                ++n;
            }
        }
        return this.propertyDescriptors;
    }

    public Object getPropertyValue(Object object) {
        if (!this.hasElements() || this.isExpanded()) {
            return this.element;
        }
        return this.elements;
    }

    public boolean isPropertySet(Object object) {
        return false;
    }

    public void resetPropertyValue(Object object) {
    }

    public void setPropertyValue(Object object, Object object2) {
    }

    public boolean testAttribute(Object object, String string, String string2) {
        if (object instanceof LogGraphNode) {
            if (string.equals("isExpanded") && string2.equals("true")) {
                return ((LogGraphNode)((Object)object)).isExpanded();
            }
            if (string.equals("isExpanded") && string2.equals("false")) {
                return ((LogGraphNode)((Object)object)).hasElements() && !((LogGraphNode)((Object)object)).isExpanded();
            }
        }
        return false;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean bl) {
        this.expanded = bl;
    }
}

