/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sd.logc.internal.util;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.hyades.sd.logc.SDLogcPlugin;
import org.eclipse.hyades.sd.logc.internal.util.ContextIds;
import org.eclipse.hyades.trace.ui.internal.util.CorrelationUI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.help.WorkbenchHelp;

public class LogCorrelationSelectionDialog
extends Dialog {
    private IExtension[] extensions;
    private CorrelationUI correlationUI;

    public LogCorrelationSelectionDialog(Shell shell, IExtension[] iExtensionArray) {
        super(shell);
        this.extensions = iExtensionArray;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(SDLogcPlugin.getString("STR_SELECT_CORRELATION"));
    }

    protected Control createDialogArea(Composite composite) {
        this.correlationUI = new CorrelationUI(this.extensions);
        Control control = this.correlationUI.createControl(composite);
        WorkbenchHelp.setHelp((Control)control, (String)ContextIds.CORRELATION_DIALOG);
        return control;
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.correlationUI.getCorrelationNames()) {
            this.selectCorrelation(this.correlationUI.getCorrelationNames().getSelectionIndex());
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        this.okPressed();
    }

    protected void okPressed() {
        this.correlationUI.setCorrelation(this.correlationUI.getSelectedCorrelation());
        super.okPressed();
    }

    public IConfigurationElement getSelectedCorrelation() {
        return this.correlationUI.getCorrelation();
    }

    public void selectCorrelation(int n) {
        this.correlationUI.selectCorrelation(n);
    }
}

