/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.common.datapool.test;

import java.io.File;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.hyades.edit.datapool.IDatapoolEquivalenceClass;
import org.eclipse.hyades.edit.datapool.IDatapoolListener;
import org.eclipse.hyades.edit.datapool.IDatapoolRecord;
import org.eclipse.hyades.execution.runtime.datapool.IDatapool;
import org.eclipse.hyades.execution.runtime.datapool.IDatapoolCell;
import org.eclipse.hyades.execution.runtime.datapool.IDatapoolFactory;
import org.eclipse.hyades.execution.runtime.datapool.IDatapoolIterator;
import org.eclipse.hyades.execution.runtime.datapool.IDatapoolVariable;
import org.eclipse.hyades.models.common.datapool.impl.Common_DatapoolFactoryImpl;
import org.eclipse.hyades.models.common.datapool.impl.DPLDatapoolImpl;
import org.eclipse.hyades.models.common.datapool.impl.DPLLogImpl;

public class DatapoolAPITest
extends TestCase {
    IDatapoolListener lis = null;
    org.eclipse.hyades.edit.datapool.IDatapoolFactory editFactory = null;
    IDatapoolFactory runtimeFactory = null;
    org.eclipse.hyades.edit.datapool.IDatapool edp = null;
    IDatapool rdp = null;

    public DatapoolAPITest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("Datapool API Test");
        testSuite.addTest((Test)new DatapoolAPITest("testDatapoolSetup"));
        testSuite.addTest((Test)new DatapoolAPITest("testIDatapoolFactoryEdit"));
        testSuite.addTest((Test)new DatapoolAPITest("testIDatapoolEdit"));
        testSuite.addTest((Test)new DatapoolAPITest("testIDatapoolEquivalenceClassEdit"));
        testSuite.addTest((Test)new DatapoolAPITest("testIDatapoolFactoryRuntime"));
        testSuite.addTest((Test)new DatapoolAPITest("testRuntimeAPIs"));
        return testSuite;
    }

    public void setUp() {
        this.lis = new IDatapoolListener(){

            public void variableAdded(org.eclipse.hyades.edit.datapool.IDatapool iDatapool, int n) {
                DPLLogImpl.log("***Listener: variableAdded: " + n);
            }

            public void variableRemoved(org.eclipse.hyades.edit.datapool.IDatapool iDatapool, int n) {
                DPLLogImpl.log("***Listener: variableRemoved: " + n);
            }

            public void variableMoved(org.eclipse.hyades.edit.datapool.IDatapool iDatapool, int n, int n2) {
                DPLLogImpl.log("***Listener: variableMoved: " + n + " " + n2);
            }

            public void variableChanged(org.eclipse.hyades.edit.datapool.IDatapool iDatapool, int n) {
                DPLLogImpl.log("***Listener: variableChanged: " + n);
            }

            public void recordAdded(org.eclipse.hyades.edit.datapool.IDatapool iDatapool, int n, int n2) {
                DPLLogImpl.log("***Listener: recordAdded: " + n + " " + n2);
            }

            public void recordRemoved(org.eclipse.hyades.edit.datapool.IDatapool iDatapool, int n, int n2) {
                DPLLogImpl.log("***Listener: recordRemoved: " + n + " " + n2);
            }

            public void recordMoved(org.eclipse.hyades.edit.datapool.IDatapool iDatapool, int n, int n2, int n3) {
                DPLLogImpl.log("***Listener: recordMoved: " + n + " " + n2 + " " + n3);
            }

            public void recordChanged(org.eclipse.hyades.edit.datapool.IDatapool iDatapool, int n, int n2) {
                DPLLogImpl.log("***Listener: recordMoved: " + n + " " + n2);
            }

            public void cellChanged(org.eclipse.hyades.edit.datapool.IDatapool iDatapool, int n, int n2, int n3) {
                DPLLogImpl.log("***Listener: cellChanged: " + n + " " + n2 + " " + n3);
            }

            public void equivalenceClassReordered(org.eclipse.hyades.edit.datapool.IDatapool iDatapool, int n) {
                DPLLogImpl.log("***Listener: equivalenceClassReordered");
            }

            public void equivalenceClassAdded(org.eclipse.hyades.edit.datapool.IDatapool iDatapool, int n) {
                DPLLogImpl.log("***Listener: equivalenceClassAdded: " + n);
            }

            public void equivalenceClassRemoved(org.eclipse.hyades.edit.datapool.IDatapool iDatapool, int n) {
                DPLLogImpl.log("***Listener: equivalenceClassRemoved: " + n);
            }

            public void equivalenceClassMoved(org.eclipse.hyades.edit.datapool.IDatapool iDatapool, int n, int n2) {
                DPLLogImpl.log("***Listener: equivalenceClassMoved: " + n + " " + n2);
            }

            public void equivalenceClassChanged(org.eclipse.hyades.edit.datapool.IDatapool iDatapool, int n) {
                DPLLogImpl.log("***Listener: equivalenceClassChanged: " + n);
            }

            public void save(org.eclipse.hyades.edit.datapool.IDatapool iDatapool) {
                DPLLogImpl.log("***Listener: datapoolSaved");
            }
        };
        this.editFactory = new Common_DatapoolFactoryImpl();
        this.runtimeFactory = new Common_DatapoolFactoryImpl();
    }

    public void tearDown() {
    }

    public void testDatapoolSetup() {
        DPLLogImpl.log("\n########## Hello to Datapool Setup (edit) Test!");
        this.edp = this.editFactory.constructDatapool();
        this.edp.setName("DP1");
        this.edp.addDatapoolListener(this.lis);
        org.eclipse.hyades.edit.datapool.IDatapoolVariable iDatapoolVariable = this.edp.constructVariable();
        iDatapoolVariable.setName("LoginId");
        this.edp.appendVariable(iDatapoolVariable);
        org.eclipse.hyades.edit.datapool.IDatapoolVariable iDatapoolVariable2 = this.edp.constructVariable();
        iDatapoolVariable2.setName("Password");
        this.edp.appendVariable(iDatapoolVariable2);
        IDatapoolEquivalenceClass iDatapoolEquivalenceClass = this.edp.constructEquivalenceClass();
        iDatapoolEquivalenceClass.setName("EC1");
        this.edp.appendEquivalenceClass(iDatapoolEquivalenceClass);
        IDatapoolRecord iDatapoolRecord = iDatapoolEquivalenceClass.constructRecord(new Object[]{"<DatapoolExpression><LiteralData>myLoginId</LiteralData></DatapoolExpression>", "<DatapoolExpression><LiteralData>myPassword</LiteralData></DatapoolExpression>"});
        IDatapoolRecord iDatapoolRecord2 = iDatapoolEquivalenceClass.constructRecord(new Object[]{"<DatapoolExpression><LiteralData>yourLoginId</LiteralData></DatapoolExpression>", "<DatapoolExpression><LiteralData>yourPassword</LiteralData></DatapoolExpression>"});
        IDatapoolRecord iDatapoolRecord3 = iDatapoolEquivalenceClass.constructRecord(new Object[]{"<DatapoolExpression><LiteralData>hisLoginId</LiteralData></DatapoolExpression>", "<DatapoolExpression><LiteralData>hisPassword</LiteralData></DatapoolExpression>"});
        ((DPLDatapoolImpl)this.edp).logDatapoolAsStrings();
        Assert.assertTrue((this.edp.getEquivalenceClassCount() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((this.edp.getEquivalenceClass(0).getRecordCount() == 3 ? 1 : 0) != 0);
        this.rdp = this.edp;
        DPLLogImpl.log("########## Bye from Datapool Setup (edit) Test!");
    }

    public void testIDatapoolFactoryEdit() {
        DPLLogImpl.log("\n########## Hello to IDatapoolFactory (edit) Test!");
        DPLLogImpl.setLoggingStatus(false);
        this.testDatapoolSetup();
        DPLLogImpl.setLoggingStatus(true);
        ((DPLDatapoolImpl)this.edp).logDatapoolAsStrings();
        this.editFactory.saveAs(this.edp, new File("c:\\temp\\myDatapool.xmi"));
        this.edp = this.editFactory.loadForEdit(new File("c:\\temp\\myDatapool.xmi"), false);
        ((DPLDatapoolImpl)this.edp).logDatapoolAsStrings();
        DPLLogImpl.log("########## bye from IDatapool (edit) Test!");
    }

    public void testIDatapoolEdit() {
        DPLLogImpl.log("\n########## Hello to IDatapool (edit) Test!");
        DPLLogImpl.setLoggingStatus(false);
        this.testDatapoolSetup();
        DPLLogImpl.setLoggingStatus(true);
        ((DPLDatapoolImpl)this.edp).logDatapoolAsStrings();
        org.eclipse.hyades.edit.datapool.IDatapoolVariable iDatapoolVariable = this.edp.constructVariable();
        iDatapoolVariable.setName("MachineName");
        this.edp.appendVariable(iDatapoolVariable);
        Assert.assertTrue((this.edp.getVariableCount() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.edp.getVariable(2).getName().equals("MachineName"));
        this.edp.moveVariable(1, 0);
        Assert.assertTrue((boolean)this.edp.getVariable(0).getName().equals("Password"));
        Assert.assertTrue((boolean)this.edp.getVariable(1).getName().equals("LoginId"));
        this.edp.removeVariable(2);
        Assert.assertTrue((this.edp.getVariableCount() == 2 ? 1 : 0) != 0);
        this.edp.updateVariable(iDatapoolVariable, 0);
        ((DPLDatapoolImpl)this.edp).logDatapoolAsStrings();
        Assert.assertTrue((boolean)this.edp.getVariable(0).getName().equals("MachineName"));
        DPLLogImpl.log("########## Bye from IDatapool (edit) Test!");
    }

    public void testIDatapoolEquivalenceClassEdit() {
        DPLLogImpl.log("\n########## Hello to IDatapoolEquivalenceClass (edit) Test!");
        DPLLogImpl.setLoggingStatus(false);
        this.testDatapoolSetup();
        DPLLogImpl.setLoggingStatus(true);
        IDatapoolEquivalenceClass iDatapoolEquivalenceClass = this.edp.constructEquivalenceClass();
        iDatapoolEquivalenceClass.setName("EC2");
        this.edp.appendEquivalenceClass(iDatapoolEquivalenceClass);
        IDatapoolRecord iDatapoolRecord = iDatapoolEquivalenceClass.constructRecord(new Object[]{"<DatapoolExpression><ExcelData>LoginId1</ExcelData></DatapoolExpression>", "<DatapoolExpression><ExcelData>Password1</ExcelData></DatapoolExpression>"});
        IDatapoolRecord iDatapoolRecord2 = iDatapoolEquivalenceClass.constructRecord(new Object[]{"<DatapoolExpression><LiteralData>LoginId2</LiteralData></DatapoolExpression>", "<DatapoolExpression><LiteralData>Password2</LiteralData></DatapoolExpression>"});
        IDatapoolRecord iDatapoolRecord3 = iDatapoolEquivalenceClass.constructRecord(new Object[]{"<DatapoolExpression><LiteralData>LoginId3</LiteralData></DatapoolExpression>", "<DatapoolExpression><LiteralData>Password3</LiteralData></DatapoolExpression>"});
        ((DPLDatapoolImpl)this.edp).logDatapoolAsStrings();
        Assert.assertTrue((this.edp.getEquivalenceClassCount() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((this.edp.getEquivalenceClass(1).getRecordCount() == 3 ? 1 : 0) != 0);
        IDatapoolCell iDatapoolCell = this.rdp.getEquivalenceClass(1).getRecord(0).getCell("LoginId");
        Assert.assertTrue((boolean)iDatapoolCell.getCellVariable().getName().equals("LoginId"));
        Assert.assertTrue((boolean)iDatapoolCell.getStringValue().equals("LoginId1 (Excel)"));
        this.edp.moveEquivalenceClass(1, 0);
        Assert.assertTrue((boolean)this.edp.getEquivalenceClass(0).getName().equals("EC2"));
        Assert.assertTrue((boolean)this.edp.getEquivalenceClass(1).getName().equals("EC1"));
        this.edp.removeEquivalenceClass(1);
        Assert.assertTrue((this.edp.getEquivalenceClassCount() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.edp.getEquivalenceClass(0).getName().equals("EC2"));
        ((IDatapoolEquivalenceClass)this.edp.getEquivalenceClass(0)).reorder(new int[]{1, 0, 2});
        Assert.assertTrue((boolean)this.edp.getEquivalenceClass(0).getRecord(0).getCell("LoginId").getStringValue().equals("LoginId2"));
        DPLLogImpl.log("########## bye from IDatapoolEquivalenceClass (edit) Test!");
    }

    public void testIDatapoolFactoryRuntime() {
        DPLLogImpl.log("\n########## Hello to IDatapool (runtime) Test!");
        DPLLogImpl.setLoggingStatus(false);
        this.testDatapoolSetup();
        DPLLogImpl.setLoggingStatus(true);
        ((DPLDatapoolImpl)this.rdp).logDatapoolAsStrings();
        this.rdp = this.runtimeFactory.load(new File("c:\\temp\\myDatapool.xmi"), true);
        this.rdp = this.runtimeFactory.load(new File("c:\\temp\\myDatapool.xmi"), true);
        this.rdp = this.runtimeFactory.load(new File("c:\\temp\\myDatapool.xmi"), true);
        this.runtimeFactory.unload(this.rdp);
        this.runtimeFactory.unload(this.rdp);
        this.runtimeFactory.unload(this.rdp);
        this.rdp = this.runtimeFactory.load(new File("c:\\temp\\myDatapool.xmi"), true);
        ((DPLDatapoolImpl)this.rdp).logDatapoolAsStrings();
        IDatapoolIterator iDatapoolIterator = this.runtimeFactory.open(this.rdp, "org.eclipse.hyades.datapool.iterator.DatapoolIteratorSequentialShared");
        iDatapoolIterator.dpInitialize(this.rdp, -1);
        DPLLogImpl.log("");
        while (!iDatapoolIterator.dpDone()) {
            DPLLogImpl.log("Iterator: " + iDatapoolIterator.dpString("LoginId"));
            iDatapoolIterator.dpNext();
        }
        this.runtimeFactory.close(iDatapoolIterator);
        DPLLogImpl.log("########## Bye from IDatapool (runtime) Test!");
    }

    public void testRuntimeAPIs() {
        DPLLogImpl.log("\n########## Hello to Runtime APIs Test!");
        DPLLogImpl.setLoggingStatus(false);
        this.testDatapoolSetup();
        DPLLogImpl.setLoggingStatus(true);
        IDatapoolCell iDatapoolCell = this.rdp.getEquivalenceClass(0).getRecord(0).getCell("LoginId");
        Assert.assertTrue((boolean)iDatapoolCell.getCellVariable().getName().equals("LoginId"));
        Assert.assertTrue((boolean)iDatapoolCell.getStringValue().equals("myLoginId"));
        int n = this.rdp.getVariableIndex("LoginId");
        IDatapoolVariable iDatapoolVariable = this.rdp.getVariable(n);
        Assert.assertTrue((n == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)iDatapoolVariable.getName().equals("LoginId"));
        DPLLogImpl.log("########## Bye from Runtime APIs Test!");
    }
}

