/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.editor.internal;

import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.editor.internal.ControlTableEditorListener;
import org.eclipse.hyades.statistical.ui.variableloader.internal.SDModifiableVariableRepresentation;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomControlBar;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class ControlTableEditor
extends Composite
implements DisposeListener {
    public static final int VAL_CONTROL = 0;
    public static final int VAL_NAME = 1;
    public static final int VAL_DESC = 2;
    public static final int VAL_IMAGE = 3;
    public static final int VAL_SLIDER = 4;
    public static final int VAL_MODIFY = 5;
    private int style;
    private TableViewer tableViewer = null;
    private Vector datas = new Vector();
    private boolean editable = true;
    private Vector listeners = new Vector();
    private ComboBoxCellEditor comboBoxSliderCellEditor;
    private Integer[] sliderChoices = new Integer[]{new Integer(1)};
    private String[] sliderChoicesString = new String[]{"1"};
    ArrayList disposables = new ArrayList();

    public void addListener(ControlTableEditorListener newListener) {
        this.listeners.add(newListener);
    }

    public void notifyListeners(ZoomControlBar b) {
        int v = 0;
        while (v < this.listeners.size()) {
            ControlTableEditorListener TCL = (ControlTableEditorListener)this.listeners.elementAt(v);
            TCL.barEdited(b);
            ++v;
        }
    }

    public void setEditable(boolean newValue) {
        this.editable = newValue;
    }

    public void widgetDisposed(DisposeEvent e) {
        this.dispose();
    }

    public ControlTableEditor(Composite parent, int style, Object[][] values) {
        super(parent, style);
        parent.addDisposeListener((DisposeListener)this);
        this.style = style;
        int i = 0;
        while (i < this.datas.size()) {
            try {
                BarElement ge = (BarElement)this.datas.get(i);
            }
            catch (Throwable e) {
                // empty catch block
            }
            ++i;
        }
        this.datas = new Vector();
        int i2 = 0;
        while (i2 < values.length) {
            this.datas.add(new BarElement((ZoomControlBar)values[i2][0], (String)values[i2][1], (String)values[i2][2], (Image)values[i2][3], (Integer)values[i2][4], (SDModifiableVariableRepresentation)values[i2][5]));
            ++i2;
        }
        this.instantiate();
    }

    public void ensureControlsValid() {
        int i = 0;
        while (i < this.datas.size()) {
            BarElement element = (BarElement)this.datas.get(i);
            if (element.slider >= this.sliderChoices.length) {
                element.slider = new Integer(0);
            }
            ++i;
        }
        if (this.tableViewer != null) {
            this.tableViewer.refresh(true);
        }
    }

    public void setSliderChoices(Integer[] values, String[] names) {
        this.sliderChoices = values;
        this.sliderChoicesString = names;
        this.comboBoxSliderCellEditor.setItems(names);
        this.ensureControlsValid();
        this.redraw();
    }

    public void setValues(Object[][] values) {
        int i = 0;
        while (i < this.datas.size()) {
            try {
                BarElement ge = (BarElement)this.datas.get(i);
            }
            catch (Throwable e) {
                // empty catch block
            }
            ++i;
        }
        this.datas.clear();
        int i2 = 0;
        while (i2 < values.length) {
            this.datas.add(new BarElement((ZoomControlBar)values[i2][0], (String)values[i2][1], (String)values[i2][2], (Image)values[i2][3], (Integer)values[i2][4], (SDModifiableVariableRepresentation)values[i2][5]));
            ++i2;
        }
        System.err.println("GRAPH THINGY - SET VALUES");
        try {
            this.tableViewer.setInput((Object)this.datas);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public Object[][] getValues() {
        Object[][] result = new Object[this.datas.size()][6];
        int v = 0;
        while (v < this.datas.size()) {
            result[v][0] = ((BarElement)this.datas.get((int)v)).bar;
            result[v][1] = ((BarElement)this.datas.get((int)v)).name;
            result[v][2] = ((BarElement)this.datas.get((int)v)).description;
            result[v][3] = ((BarElement)this.datas.get((int)v)).image;
            result[v][4] = ((BarElement)this.datas.get((int)v)).slider;
            result[v][5] = ((BarElement)this.datas.get((int)v)).rep;
            ++v;
        }
        return result;
    }

    public void dispose() {
        super.dispose();
        this.disposables.addAll(this.datas);
        EditorPlugin.DBG.info(((Object)((Object)this)).getClass() + ":disposed");
        int i = 0;
        while (i < this.disposables.size()) {
            try {
                Object o = this.disposables.get(i);
                if (o != null) {
                    if (o instanceof Widget) {
                        ((Widget)o).dispose();
                    } else if (o instanceof Color) {
                        ((Color)o).dispose();
                    } else if (o instanceof Image) {
                        ((Image)o).dispose();
                    } else {
                        try {
                            EditorPlugin.disposeObject(o);
                        }
                        catch (Throwable e) {
                            EditorPlugin.DBG.info("Class not found when disposing of " + o.getClass() + "/" + o + " (" + e + ")");
                        }
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public void instantiate() {
        GridLayout glayout = new GridLayout(1, false);
        glayout.marginWidth = 0;
        glayout.marginHeight = 0;
        glayout.horizontalSpacing = 0;
        glayout.verticalSpacing = 0;
        this.setLayout((Layout)glayout);
        GridData gdata = new GridData();
        gdata.horizontalAlignment = 4;
        gdata.verticalAlignment = 4;
        gdata.grabExcessHorizontalSpace = true;
        gdata.grabExcessVerticalSpace = true;
        Table table = new Table((Composite)this, 98304);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.setLayoutData((Object)gdata);
        this.disposables.add(table);
        TableColumn tc = null;
        tc = new TableColumn(table, 16384);
        tc.setText(EditorPlugin.getString("TABLE_COLUMN_NAME"));
        this.disposables.add(tc);
        tc = new TableColumn(table, 16384);
        tc.setText(EditorPlugin.getString("TABLE_COLUMN_DESCRIPTION"));
        this.disposables.add(tc);
        tc = new TableColumn(table, 0x1000000);
        tc.setText(EditorPlugin.getString("TABLE_COLUMN_IMAGE"));
        this.disposables.add(tc);
        tc = new TableColumn(table, 0x1000000);
        tc.setText(EditorPlugin.getString("TABLE_COLUMN_SLIDER"));
        this.disposables.add(tc);
        this.comboBoxSliderCellEditor = new ComboBoxCellEditor((Composite)table, this.sliderChoicesString);
        CellEditor[] cellEditors = new CellEditor[]{new TextCellEditor((Composite)table), new TextCellEditor((Composite)table), new TextCellEditor((Composite)table), this.comboBoxSliderCellEditor};
        int i = 0;
        while (i < cellEditors.length) {
            this.disposables.add(cellEditors[i]);
            ++i;
        }
        ICellEditorListener cellListener = new ICellEditorListener(){

            public void applyEditorValue() {
                ControlTableEditor.this.tableViewer.getTable().setFocus();
            }

            public void cancelEditor() {
                ControlTableEditor.this.tableViewer.getTable().setFocus();
            }

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
            }
        };
        int i2 = 0;
        while (i2 < cellEditors.length) {
            cellEditors[i2].addListener(cellListener);
            ++i2;
        }
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(32, 50, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(28, 50, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(16, 30, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(16, 30, true));
        table.setLayout((Layout)tableLayout);
        this.tableViewer = new TableViewer(table);
        this.tableViewer.setColumnProperties(new String[]{"name", "description", "image", "slider"});
        this.tableViewer.setContentProvider((IContentProvider)new BarContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new BarLabelProvider());
        this.tableViewer.setCellEditors(cellEditors);
        this.tableViewer.setCellModifier((ICellModifier)new BarCellModifier());
    }

    public class BarCellModifier
    implements ICellModifier {
        public boolean canModify(Object element, String property) {
            new Throwable("").printStackTrace();
            BarElement e = (BarElement)element;
            if ("name".equals(property)) {
                return false;
            }
            if ("description".equals(property)) {
                return false;
            }
            return !"image".equals(property);
        }

        public Object getValue(Object element, String property) {
            BarElement e = (BarElement)element;
            if ("name".equals(property)) {
                return e.name;
            }
            if ("description".equals(property)) {
                return e.description;
            }
            if ("image".equals(property)) {
                return e.image;
            }
            if ("slider".equals(property)) {
                return e.slider;
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            Item item = (Item)element;
            BarElement e = (BarElement)item.getData();
            boolean changed = false;
            if (!"name".equals(property) && !"description".equals(property) && !"image".equals(property) && "slider".equals(property)) {
                int thisSelection;
                Control control = ControlTableEditor.this.comboBoxSliderCellEditor.getControl();
                if (control instanceof CCombo) {
                    value = new Integer(((CCombo)control).getSelectionIndex());
                }
                if ((thisSelection = ((Integer)value).intValue()) > -1 && !ControlTableEditor.this.sliderChoices[thisSelection].equals(e.slider)) {
                    changed = true;
                    e.slider = ControlTableEditor.this.sliderChoices[thisSelection];
                }
            }
            if (changed) {
                ControlTableEditor.this.notifyListeners(e.bar);
                ControlTableEditor.this.tableViewer.refresh((Object)e);
            }
        }
    }

    public static class BarContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object input) {
            return ((Vector)input).toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class BarLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 2) {
                BarElement barElement = (BarElement)element;
                return barElement.image;
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String columnText = "";
            BarElement barElement = (BarElement)element;
            switch (columnIndex) {
                case 0: {
                    columnText = barElement.name;
                    break;
                }
                case 1: {
                    columnText = barElement.description;
                    break;
                }
                case 2: {
                    if (barElement.image != null) break;
                    columnText = "none";
                    break;
                }
                case 3: {
                    int index = barElement.slider;
                    columnText = ControlTableEditor.this.sliderChoicesString[index];
                }
            }
            return columnText;
        }
    }

    public class BarElement {
        public ZoomControlBar bar;
        public String name;
        public String description;
        public Integer slider;
        public Image image;
        public SDModifiableVariableRepresentation rep;

        public BarElement(ZoomControlBar bar, String name, String description, Image image, Integer slider, SDModifiableVariableRepresentation rep) {
            this.bar = bar;
            this.name = name;
            this.description = description;
            this.image = image;
            this.slider = slider;
            this.rep = rep;
        }

        public void update() {
        }
    }
}

