/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.editor.internal;

import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.editor.internal.GraphTableEditorListener;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.Graph;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.GraphSelectionSource;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColorCellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class GraphTableEditor
extends Composite
implements ControlListener,
DisposeListener,
GraphSelectionSource,
SelectionListener,
FocusListener {
    public static final int VAL_GRAPH = 0;
    public static final int VAL_NAME = 1;
    public static final int VAL_DESC = 2;
    public static final int VAL_RGB = 3;
    public static final int VAL_WIDTH = 4;
    public static final int VAL_STYLE = 5;
    public static final int VAL_XSLIDER = 6;
    public static final int VAL_YSLIDER = 7;
    public static final int VAL_SCALING = 8;
    private static double[] weights = new double[]{20.0, 10.0, 4.0, 7.0, 7.0, 12.0, 12.0, 6.0};
    private Control graph_control;
    private Table table;
    private int style;
    private TableViewer tableViewer = null;
    private Vector datas = new Vector();
    private boolean editable = true;
    private Vector listeners = new Vector();
    private ComboBoxCellEditor comboBoxWidthCellEditor;
    private ComboBoxCellEditor comboBoxStyleCellEditor;
    private ComboBoxCellEditor comboBoxSliderXCellEditor;
    private ComboBoxCellEditor comboBoxSliderYCellEditor;
    private ColorCellEditor colorCellEditor;
    private Integer[] sliderXChoices = new Integer[]{new Integer(1)};
    private String[] sliderXChoicesString = new String[]{"1"};
    private Integer[] sliderYChoices = new Integer[]{new Integer(1)};
    private String[] sliderYChoicesString = new String[]{"1"};
    private Integer[] widthChoices = new Integer[]{new Integer(1), new Integer(2), new Integer(3), new Integer(4), new Integer(5), new Integer(6), new Integer(7), new Integer(8), new Integer(9), new Integer(10)};
    private String[] widthChoicesString = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
    private Integer[] styleChoices = new Integer[]{new Integer(1), new Integer(3), new Integer(2), new Integer(4), new Integer(5)};
    private String[] styleChoicesString = new String[]{EditorPlugin.getString("GRAPH_LINE_SOLID"), EditorPlugin.getString("GRAPH_LINE_DOT"), EditorPlugin.getString("GRAPH_LINE_DASH"), EditorPlugin.getString("GRAPH_LINE_DASH_DOT"), EditorPlugin.getString("GRAPH_LINE_DASH_DOT_DOT")};
    ArrayList disposables = new ArrayList();
    boolean has_focus = false;

    public void addListener(GraphTableEditorListener newListener) {
        this.listeners.add(newListener);
    }

    public void notifyListeners(Graph g) {
        int v = 0;
        while (v < this.listeners.size()) {
            GraphTableEditorListener TCL = (GraphTableEditorListener)this.listeners.elementAt(v);
            TCL.graphEdited(g);
            ++v;
        }
    }

    public void setEditable(boolean newValue) {
        this.editable = newValue;
    }

    public void widgetDisposed(DisposeEvent e) {
        this.dispose();
    }

    public GraphTableEditor(Composite parent, int style, Object[][] values, Control graph_control) {
        super(parent, style);
        this.graph_control = graph_control;
        parent.addDisposeListener((DisposeListener)this);
        this.style = style;
        int i = 0;
        while (i < this.datas.size()) {
            try {
                GraphElement ge = (GraphElement)this.datas.get(i);
                if (ge != null) {
                    ge.dispose();
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            ++i;
        }
        this.datas = new Vector();
        int i2 = 0;
        while (i2 < values.length) {
            this.datas.add(new GraphElement((Graph)values[i2][0], (String)values[i2][1], (String)values[i2][2], (RGB)values[i2][3], (Integer)values[i2][4], (Integer)values[i2][5], (Integer)values[i2][6], (Integer)values[i2][7], (Double)values[i2][8]));
            ++i2;
        }
        this.instantiate();
        this.addControlListener(this);
    }

    public void ensureGraphsValid() {
        int i = 0;
        while (i < this.datas.size()) {
            GraphElement element = (GraphElement)this.datas.get(i);
            if (element.xslider >= this.sliderXChoices.length) {
                element.xslider = new Integer(0);
            }
            if (element.yslider >= this.sliderYChoices.length) {
                element.yslider = new Integer(0);
            }
            ++i;
        }
        if (this.tableViewer != null) {
            this.tableViewer.refresh(true);
        }
    }

    public void setXSliderChoices(Integer[] values, String[] names) {
        this.sliderXChoices = values;
        this.sliderXChoicesString = names;
        this.comboBoxSliderXCellEditor.setItems(names);
        this.ensureGraphsValid();
        this.redraw();
    }

    public void setYSliderChoices(Integer[] values, String[] names) {
        this.sliderYChoices = values;
        this.sliderYChoicesString = names;
        this.comboBoxSliderYCellEditor.setItems(names);
        this.ensureGraphsValid();
        this.redraw();
    }

    public void setValues(Object[][] values) {
        int i = 0;
        while (i < this.datas.size()) {
            try {
                GraphElement ge = (GraphElement)this.datas.get(i);
                if (ge != null) {
                    ge.dispose();
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            ++i;
        }
        this.datas.clear();
        int i2 = 0;
        while (i2 < values.length) {
            this.datas.add(new GraphElement((Graph)values[i2][0], (String)values[i2][1], (String)values[i2][2], (RGB)values[i2][3], (Integer)values[i2][4], (Integer)values[i2][5], (Integer)values[i2][6], (Integer)values[i2][7], (Double)values[i2][8]));
            ++i2;
        }
        this.tableViewer.setInput((Object)this.datas);
    }

    public Object[][] getValues() {
        Object[][] result = new Object[this.datas.size()][9];
        int v = 0;
        while (v < this.datas.size()) {
            result[v][0] = ((GraphElement)this.datas.get((int)v)).graph;
            result[v][1] = ((GraphElement)this.datas.get((int)v)).name;
            result[v][2] = ((GraphElement)this.datas.get((int)v)).description;
            result[v][3] = ((GraphElement)this.datas.get((int)v)).color;
            result[v][4] = ((GraphElement)this.datas.get((int)v)).line_width;
            result[v][5] = ((GraphElement)this.datas.get((int)v)).line_style;
            result[v][6] = ((GraphElement)this.datas.get((int)v)).xslider;
            result[v][7] = ((GraphElement)this.datas.get((int)v)).yslider;
            result[v][8] = ((GraphElement)this.datas.get((int)v)).scaling;
            ++v;
        }
        return result;
    }

    public void dispose() {
        super.dispose();
        this.disposables.addAll(this.datas);
        int i = 0;
        while (i < this.disposables.size()) {
            try {
                Object o = this.disposables.get(i);
                if (o != null) {
                    if (o instanceof Widget) {
                        ((Widget)o).dispose();
                    } else if (o instanceof Color) {
                        ((Color)o).dispose();
                    } else if (o instanceof Image) {
                        ((Image)o).dispose();
                    } else {
                        try {
                            EditorPlugin.disposeObject(o);
                        }
                        catch (Throwable e) {
                            EditorPlugin.DBG.warning("Class not found when disposing of " + o.getClass() + "/" + o + " (" + e + ")");
                        }
                    }
                }
            }
            catch (Throwable e) {
                EditorPlugin.DBG.error("Problem disposing of objects", e);
            }
            ++i;
        }
    }

    public void instantiate() {
        GridLayout glayout = new GridLayout(1, false);
        glayout.marginWidth = 0;
        glayout.marginHeight = 0;
        glayout.horizontalSpacing = 0;
        glayout.verticalSpacing = 0;
        this.setLayout((Layout)glayout);
        GridData gdata = new GridData();
        gdata.horizontalAlignment = 4;
        gdata.verticalAlignment = 4;
        gdata.grabExcessHorizontalSpace = true;
        gdata.grabExcessVerticalSpace = true;
        this.table = new Table((Composite)this, 98304);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.setLayoutData((Object)gdata);
        this.table.addSelectionListener((SelectionListener)this);
        this.table.addFocusListener((FocusListener)this);
        this.disposables.add(this.table);
        TableColumn tc = null;
        tc = new TableColumn(this.table, 16384);
        tc.setText(EditorPlugin.getString("TABLE_COLUMN_NAME"));
        this.disposables.add(tc);
        tc = new TableColumn(this.table, 16384);
        tc.setText(EditorPlugin.getString("TABLE_COLUMN_DESCRIPTION"));
        this.disposables.add(tc);
        tc = new TableColumn(this.table, 0x1000000);
        tc.setText(EditorPlugin.getString("TABLE_COLUMN_COLOR"));
        this.disposables.add(tc);
        tc = new TableColumn(this.table, 0x1000000);
        tc.setText(EditorPlugin.getString("TABLE_COLUMN_WIDTH"));
        this.disposables.add(tc);
        tc = new TableColumn(this.table, 16384);
        tc.setText(EditorPlugin.getString("TABLE_COLUMN_STYLE"));
        this.disposables.add(tc);
        tc = new TableColumn(this.table, 0x1000000);
        tc.setText(EditorPlugin.getString("TABLE_COLUMN_HSLIDER"));
        this.disposables.add(tc);
        tc = new TableColumn(this.table, 0x1000000);
        tc.setText(EditorPlugin.getString("TABLE_COLUMN_VSLIDER"));
        this.disposables.add(tc);
        tc = new TableColumn(this.table, 0x1000000);
        tc.setText(EditorPlugin.getString("TABLE_COLUMN_MULTIPLIER"));
        this.disposables.add(tc);
        this.comboBoxWidthCellEditor = new ComboBoxCellEditor((Composite)this.table, this.widthChoicesString);
        this.comboBoxStyleCellEditor = new ComboBoxCellEditor((Composite)this.table, this.styleChoicesString);
        this.comboBoxSliderXCellEditor = new ComboBoxCellEditor((Composite)this.table, this.sliderXChoicesString);
        this.comboBoxSliderYCellEditor = new ComboBoxCellEditor((Composite)this.table, this.sliderYChoicesString);
        this.colorCellEditor = new ColorCellEditor((Composite)this.table);
        CellEditor[] cellEditors = new CellEditor[]{new TextCellEditor((Composite)this.table), new TextCellEditor((Composite)this.table), this.colorCellEditor, this.comboBoxWidthCellEditor, this.comboBoxStyleCellEditor, this.comboBoxSliderXCellEditor, this.comboBoxSliderYCellEditor, new TextCellEditor((Composite)this.table)};
        int i = 0;
        while (i < cellEditors.length) {
            this.disposables.add(cellEditors[i]);
            ++i;
        }
        ICellEditorListener cellListener = new ICellEditorListener(){

            public void applyEditorValue() {
                GraphTableEditor.this.tableViewer.getTable().setFocus();
            }

            public void cancelEditor() {
                GraphTableEditor.this.tableViewer.getTable().setFocus();
            }

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
            }
        };
        int i2 = 0;
        while (i2 < cellEditors.length) {
            cellEditors[i2].addListener(cellListener);
            ++i2;
        }
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(32, 50, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(28, 50, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(6, 10, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(6, 20, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(8, 30, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(16, 30, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(16, 30, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(12, 30, true));
        this.table.setLayout((Layout)tableLayout);
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setColumnProperties(new String[]{"name", "description", "color", "line width", "line style", "xslider", "yslider", "scaling"});
        this.tableViewer.setContentProvider((IContentProvider)new GraphContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new GraphLabelProvider());
        this.tableViewer.setCellEditors(cellEditors);
        this.tableViewer.setCellModifier((ICellModifier)new GraphCellModifier());
    }

    public void expandColumns() {
        double weightTotal = 0.0;
        int i = 0;
        while (i < this.tableViewer.getTable().getColumnCount()) {
            weightTotal += weights[i];
            ++i;
        }
        double multiplier = (double)this.getSize().x / weightTotal;
        int i2 = 0;
        while (i2 < this.tableViewer.getTable().getColumnCount()) {
            int size = (int)(weights[i2] * multiplier);
            this.tableViewer.getTable().getColumn(i2).setWidth(size);
            ++i2;
        }
    }

    public void controlResized(ControlEvent event) {
        this.expandColumns();
    }

    public void controlMoved(ControlEvent e) {
        this.expandColumns();
    }

    public Graph getSelectedGraph() {
        if (!this.has_focus) {
            return null;
        }
        int n = this.table.getSelectionIndex();
        if (n == -1) {
            return null;
        }
        GraphElement element = (GraphElement)this.datas.get(n);
        return element.graph;
    }

    public void redrawGraphs() {
        this.graph_control.redraw();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        this.redrawGraphs();
    }

    public void focusLost(FocusEvent e) {
        this.has_focus = false;
        this.redrawGraphs();
    }

    public void focusGained(FocusEvent e) {
        this.has_focus = true;
        this.redrawGraphs();
    }

    public class GraphCellModifier
    implements ICellModifier {
        public boolean canModify(Object element, String property) {
            GraphElement e = (GraphElement)element;
            if ("name".equals(property)) {
                return false;
            }
            if ("description".equals(property)) {
                return false;
            }
            return GraphTableEditor.this.editable;
        }

        public Object getValue(Object element, String property) {
            GraphElement e = (GraphElement)element;
            if ("name".equals(property)) {
                return e.name;
            }
            if ("description".equals(property)) {
                return e.description;
            }
            if ("color".equals(property)) {
                return e.color;
            }
            if ("line width".equals(property)) {
                return e.line_width;
            }
            if ("line style".equals(property)) {
                return e.line_style;
            }
            if ("xslider".equals(property)) {
                return e.xslider;
            }
            if ("yslider".equals(property)) {
                return e.yslider;
            }
            if ("scaling".equals(property)) {
                return "" + e.scaling;
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            Item item = (Item)element;
            GraphElement e = (GraphElement)item.getData();
            boolean changed = false;
            if (!"name".equals(property) && !"description".equals(property)) {
                if ("color".equals(property)) {
                    Control control = GraphTableEditor.this.colorCellEditor.getControl();
                    value = GraphTableEditor.this.colorCellEditor.getValue();
                    if (value != null && !value.equals(e.color)) {
                        changed = true;
                        e.color = (RGB)value;
                        e.update();
                    }
                } else if ("line width".equals(property)) {
                    int thisSelection;
                    Control control = GraphTableEditor.this.comboBoxWidthCellEditor.getControl();
                    if (control instanceof CCombo) {
                        value = new Integer(((CCombo)control).getSelectionIndex());
                    }
                    if ((thisSelection = ((Integer)value).intValue()) > -1 && !GraphTableEditor.this.widthChoices[thisSelection].equals(e.line_width)) {
                        changed = true;
                        e.line_width = GraphTableEditor.this.widthChoices[thisSelection];
                    }
                } else if ("line style".equals(property)) {
                    int thisSelection;
                    Control control = GraphTableEditor.this.comboBoxStyleCellEditor.getControl();
                    if (control instanceof CCombo) {
                        value = new Integer(((CCombo)control).getSelectionIndex());
                    }
                    if ((thisSelection = ((Integer)value).intValue()) > -1 && !GraphTableEditor.this.styleChoices[thisSelection].equals(e.line_style)) {
                        changed = true;
                        e.line_style = GraphTableEditor.this.styleChoices[thisSelection];
                    }
                } else if ("xslider".equals(property)) {
                    int thisSelection;
                    Control control = GraphTableEditor.this.comboBoxSliderXCellEditor.getControl();
                    if (control instanceof CCombo) {
                        value = new Integer(((CCombo)control).getSelectionIndex());
                    }
                    if ((thisSelection = ((Integer)value).intValue()) > -1 && !GraphTableEditor.this.sliderXChoices[thisSelection].equals(e.xslider)) {
                        changed = true;
                        e.xslider = GraphTableEditor.this.sliderXChoices[thisSelection];
                    }
                } else if ("yslider".equals(property)) {
                    int thisSelection;
                    Control control = GraphTableEditor.this.comboBoxSliderYCellEditor.getControl();
                    if (control instanceof CCombo) {
                        value = new Integer(((CCombo)control).getSelectionIndex());
                    }
                    if ((thisSelection = ((Integer)value).intValue()) > -1 && !GraphTableEditor.this.sliderYChoices[thisSelection].equals(e.yslider)) {
                        changed = true;
                        e.yslider = GraphTableEditor.this.sliderYChoices[thisSelection];
                    }
                } else if ("scaling".equals(property)) {
                    if (value == null) {
                        value = "1.0";
                    }
                    try {
                        Double d;
                        e.scaling = d = new Double(value.toString());
                        changed = true;
                    }
                    catch (Throwable x) {
                        // empty catch block
                    }
                }
            }
            if (changed) {
                GraphTableEditor.this.notifyListeners(e.graph);
                GraphTableEditor.this.tableViewer.refresh((Object)e);
            }
        }
    }

    public static class GraphContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object input) {
            return ((Vector)input).toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class GraphLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            Image columnImage = null;
            GraphElement graphElement = (GraphElement)element;
            switch (columnIndex) {
                case 2: {
                    columnImage = graphElement.image;
                }
            }
            return columnImage;
        }

        public String getColumnText(Object element, int columnIndex) {
            String columnText = null;
            GraphElement graphElement = (GraphElement)element;
            switch (columnIndex) {
                case 0: {
                    columnText = graphElement.name;
                    break;
                }
                case 1: {
                    columnText = graphElement.description;
                    break;
                }
                case 2: {
                    columnText = "";
                    break;
                }
                case 3: {
                    columnText = "" + graphElement.line_width;
                    break;
                }
                case 4: {
                    int index = 0;
                    index = 0;
                    while (index < GraphTableEditor.this.styleChoices.length) {
                        if (graphElement.line_style.equals(GraphTableEditor.this.styleChoices[index])) break;
                        ++index;
                    }
                    columnText = GraphTableEditor.this.styleChoicesString[index];
                    break;
                }
                case 5: {
                    int xindex = graphElement.xslider;
                    columnText = GraphTableEditor.this.sliderXChoicesString[xindex];
                    break;
                }
                case 6: {
                    int yindex = graphElement.yslider;
                    columnText = GraphTableEditor.this.sliderYChoicesString[yindex];
                    break;
                }
                case 7: {
                    columnText = graphElement.scaling.toString();
                }
            }
            return columnText;
        }
    }

    public class GraphElement {
        public Graph graph;
        public String name;
        public String description;
        public Integer line_width;
        public Integer line_style;
        public Integer xslider;
        public Integer yslider;
        public RGB color;
        public Double scaling;
        RGB black_rgb;
        Image image;
        GC image_gc;
        Color bg_col;
        Color fg_col;

        public GraphElement(Graph graph, String name, String description, RGB color, Integer line_width, Integer line_style, Integer x_slider, Integer y_slider, Double scaling) {
            this.graph = graph;
            this.name = name;
            this.description = description;
            this.line_width = line_width;
            this.line_style = line_style;
            this.xslider = x_slider;
            this.yslider = y_slider;
            this.color = color;
            this.scaling = scaling;
            this.black_rgb = new RGB(0, 0, 0);
            PaletteData palettedat = new PaletteData(new RGB[]{color, color});
            ImageData imgdat = new ImageData(11, 11, 1, palettedat);
            this.image = new Image((Device)GraphTableEditor.this.getDisplay(), imgdat);
            this.redrawImage();
        }

        public void update() {
            this.redrawImage();
        }

        public void redrawImage() {
            PaletteData palettedat = new PaletteData(new RGB[]{this.color, this.color});
            ImageData imgdat = new ImageData(11, 11, 1, palettedat);
            Image tmpimage = this.image;
            this.image = new Image((Device)GraphTableEditor.this.getDisplay(), imgdat);
            tmpimage.dispose();
        }

        public void dispose() {
            this.image.dispose();
        }
    }
}

