/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.editor.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.editor.internal.StatConInterface;
import org.eclipse.hyades.statistical.ui.editor.internal.StatisticalModelGraphViewer;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.Dirtiable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public class StatisticalModelGraphEditor
extends EditorPart
implements Dirtiable,
IResourceChangeListener {
    long last_modified = 0L;
    IEditorSite site;
    IFileEditorInput input;
    IFile file;
    String filename;
    ArrayList configs = new ArrayList();
    StatisticalModelGraphViewer agg_editor;
    ArrayList disposables = new ArrayList();
    boolean dirty = false;

    public StatConInterface getStatCon() {
        return this.agg_editor;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.site = site;
        this.input = (IFileEditorInput)input;
        EditorPlugin.DBG.info("StatCon Editor got editor input");
        this.file = this.input.getFile();
        this.filename = this.file.getName();
        this.setTitle("StatCon - " + this.file.getName());
        EditorPlugin.DBG.info("set title - " + this.getTitle());
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addResourceChangeListener((IResourceChangeListener)this);
        try {
            EditorPlugin.DBG.info("loading file");
            this.load(this.file);
            this.last_modified = this.file.getModificationStamp();
        }
        catch (CoreException e) {
            e.printStackTrace();
            throw new PartInitException(EditorPlugin.getString("ERROR_OCCURRED") + ":" + e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new PartInitException(EditorPlugin.getString("IO_ERROR_OCCURRED") + ":" + e.getMessage());
        }
        if (this.configs.size() == 0) {
            throw new PartInitException(EditorPlugin.getString("NO_STAT_MODEL_FOUND"));
        }
    }

    public void load(IFile file) throws CoreException, IOException {
        if (file == null) {
            throw new IOException(EditorPlugin.getString("NULL_FILE"));
        }
        this.configs.add(file);
        EditorPlugin.DBG.info("asked to load file URI " + URI.createPlatformResourceURI((String)file.getFullPath().toString()));
    }

    public void createPartControl(Composite parent) {
        System.gc();
        long free = Runtime.getRuntime().freeMemory();
        long total = Runtime.getRuntime().totalMemory();
        double d = total - free;
        d /= (double)total;
        EditorPlugin.DBG.info("MEMORY USED = " + (total - free) / 1024L + "k (" + (d *= 100.0) + "%)");
        URI curr_project = null;
        try {
            curr_project = URI.createPlatformResourceURI((String)this.file.getParent().getFullPath().toString());
        }
        catch (Exception e) {
            // empty catch block
        }
        this.agg_editor = new StatisticalModelGraphViewer(parent, 0, false, this, curr_project);
        int i = 0;
        while (i < this.configs.size()) {
            try {
                IFile file = (IFile)this.configs.get(i);
                InputStream filecontents = file.getContents();
                this.agg_editor.applyConfig(filecontents);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            ++i;
        }
        this.setDirty(false);
        this.disposables.add(this.agg_editor);
    }

    public void dispose() {
        this.agg_editor.unloadModules();
        super.dispose();
        int i = 0;
        while (i < this.disposables.size()) {
            try {
                Object o = this.disposables.get(i);
                if (o != null) {
                    if (o instanceof Widget) {
                        ((Widget)o).dispose();
                    } else if (o instanceof Color) {
                        ((Color)o).dispose();
                    } else if (o instanceof Image) {
                        ((Image)o).dispose();
                    } else {
                        try {
                            EditorPlugin.disposeObject(o);
                        }
                        catch (Throwable e) {
                            EditorPlugin.DBG.warning("failed to dispose object " + o);
                        }
                    }
                }
            }
            catch (Throwable e) {
                EditorPlugin.DBG.error("failed to dispose properly", e);
            }
            ++i;
        }
    }

    public void resourceChanged(IResourceChangeEvent e) {
        if (e == null) {
            return;
        }
        if (e.getDelta() == null) {
            return;
        }
        try {
            if (this.agg_editor.getGraphWindow().isDisposed()) {
                return;
            }
            if (!((e.getDelta().getKind() & 2) == 0 && (e.getDelta().getKind() & 4) == 0 || this.file.exists())) {
                this.agg_editor.getGraphWindow().getDisplay().asyncExec((Runnable)new EditorClose());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public boolean requestOverwrite() {
        try {
            this.file.refreshLocal(0, null);
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (this.last_modified != this.file.getModificationStamp()) {
            MessageBox mbox = new MessageBox(this.agg_editor.getGraphWindow().getShell(), 456);
            mbox.setMessage(EditorPlugin.getString("EDITOR_FILE_CHANGED"));
            mbox.setText(EditorPlugin.getString("EDITOR_FILE_CHANGED_TITLE"));
            int result = mbox.open();
            if (result != 64) {
                return false;
            }
        }
        return true;
    }

    public void doSave(IProgressMonitor monitor) {
        EditorPlugin.DBG.info("saving file");
        if (!this.requestOverwrite()) {
            return;
        }
        try {
            String xmlconfig = this.agg_editor.generateConfig();
            ByteArrayInputStream bin = new ByteArrayInputStream(xmlconfig.getBytes());
            if (this.file.exists()) {
                this.file.setContents((InputStream)bin, true, false, null);
            } else {
                this.file.create((InputStream)bin, true, null);
            }
            this.last_modified = this.file.getModificationStamp();
            this.setDirty(false);
        }
        catch (Throwable e) {
            EditorPlugin.DBG.error("problem saving file", e);
        }
    }

    public void doSaveAs() {
        block6: {
            EditorPlugin.DBG.info("saving file As");
            if (!this.requestOverwrite()) {
                return;
            }
            try {
                IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                FileDialog dialog = new FileDialog(this.agg_editor.getGraphWindow().getShell(), 8192);
                dialog.setFileName("new.statcon");
                dialog.setFilterExtensions(new String[]{".statcon"});
                dialog.setFilterPath(workspaceRoot.getLocation().toString());
                String file = dialog.open();
                EditorPlugin.DBG.info("user selected file " + file);
                if (file != null) {
                    Path path = new Path(file);
                    EditorPlugin.DBG.info("user selected path " + path);
                    IFile ifile = workspaceRoot.getFileForLocation((IPath)path);
                    String xmlconfig = this.agg_editor.generateConfig();
                    ByteArrayInputStream bin = new ByteArrayInputStream(xmlconfig.getBytes());
                    EditorPlugin.DBG.info("trying to set contents of " + ifile);
                    if (ifile.exists()) {
                        ifile.setContents((InputStream)bin, true, false, null);
                    } else {
                        ifile.create((InputStream)bin, true, null);
                    }
                    EditorPlugin.DBG.info("new file saved ok");
                    this.last_modified = ifile.getModificationStamp();
                    break block6;
                }
                EditorPlugin.DBG.info("user cancelled Save As");
            }
            catch (Throwable e) {
                EditorPlugin.DBG.error("problem saving file As", e);
            }
        }
    }

    public void gotoMarker(IMarker marker) {
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void setDirty(boolean b) {
        this.dirty = b;
        this.firePropertyChange(257);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setFocus() {
    }

    public class EditorClose
    implements Runnable {
        public void run() {
            EditorPlugin.DBG.info("closing Editor");
            if (!StatisticalModelGraphEditor.this.isDirty()) {
                EditorPlugin.DBG.info("editor is not dirty - will close now");
                StatisticalModelGraphEditor.this.site.getPage().closeEditor((IEditorPart)StatisticalModelGraphEditor.this, false);
            } else {
                EditorPlugin.DBG.info("file has been deleted, editor is dirty - asking user for input");
                MessageBox mbox = new MessageBox(StatisticalModelGraphEditor.this.agg_editor.getGraphWindow().getShell(), 200);
                mbox.setMessage(EditorPlugin.getString("EDITOR_FILE_DELETED") + " (" + StatisticalModelGraphEditor.this.filename + "), " + EditorPlugin.getString("EDITOR_FILE_DELETED_2"));
                mbox.setText(EditorPlugin.getString("EDITOR_FILE_DELETED_TITLE") + " - " + StatisticalModelGraphEditor.this.getTitle());
                int result = mbox.open();
                if (result == 64) {
                    StatisticalModelGraphEditor.this.last_modified = -1L;
                    StatisticalModelGraphEditor.this.doSaveAs();
                }
                StatisticalModelGraphEditor.this.site.getPage().closeEditor((IEditorPart)StatisticalModelGraphEditor.this, false);
            }
        }
    }
}

