/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.editor.internal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.editor.internal.CheckboxTreeAndListGroup;
import org.eclipse.hyades.ui.internal.wizard.HyadesWizard;
import org.eclipse.hyades.ui.internal.wizard.LocationPage;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.FileEditorInput;

public class StatisticalModelGraphEditorWizard
extends HyadesWizard
implements INewWizard {
    LocationPage location_page;
    ResourceSelectionPage select_page;
    ModulePage[] module_pages;

    public void initPages() {
        EditorPlugin.DBG.info("initialising pages");
        IStructuredSelection structuredSelection = this.getSelection();
        this.location_page = new LocationPage("location", structuredSelection);
        this.location_page.setTitle(EditorPlugin.getString("CREATE_NEW_STATCON_FILE"));
        this.location_page.setImageDescriptor(EditorPlugin.img.getImageDescriptor("new_statcon_wiz.gif"));
        this.location_page.setDescription(EditorPlugin.getString("CREATE_NEW_STATCON_FILE_DESC"));
        this.location_page.setFileExtension("statcon");
        this.location_page.setFileName("newfile.statcon");
    }

    public void addPages() {
        EditorPlugin.DBG.info("adding pages");
        this.addPage((IWizardPage)this.location_page);
        this.select_page = new ResourceSelectionPage(EditorPlugin.getString("CHOOSE_MODELS_TO_GRAPH"), new String[]{"trcmxmi", "trcnxmi", "trcpxmi", "trcaxmi"}, EditorPlugin.getString("CHOOSE_MODELS_TO_GRAPH_DESC"));
        this.select_page.setImageDescriptor(EditorPlugin.img.getImageDescriptor("new_statcon_wiz.gif"));
        this.addPage((IWizardPage)this.select_page);
        IPluginRegistry registry = Platform.getPluginRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.hyades.statistical.ui.StatConFile");
        IExtension[] extensions = point.getExtensions();
        this.module_pages = new ModulePage[extensions.length];
        EditorPlugin.DBG.info("found " + this.module_pages + " module pages");
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configs = extensions[i].getConfigurationElements();
            IPluginDescriptor pdescriptor = extensions[i].getDeclaringPluginDescriptor();
            int z = 0;
            while (z < configs.length) {
                String file_extension = configs[z].getAttribute("file_extension");
                String element_name = configs[z].getAttribute("element_name");
                String path_attribute = configs[z].getAttribute("path_attribute");
                String page_title = configs[z].getAttribute("page_title");
                String page_description = configs[z].getAttribute("page_description");
                EditorPlugin.DBG.info("added module page for " + file_extension + " files");
                ModulePage page = new ModulePage();
                page.element = element_name;
                page.attribute = path_attribute;
                page.page.setImageDescriptor(EditorPlugin.img.getImageDescriptor("new_statcon_wiz.gif"));
                page.page = new ResourceSelectionPage(page_title, new String[]{file_extension}, page_description);
                this.addPage((IWizardPage)page.page);
                this.module_pages[i] = page;
                ++z;
            }
            ++i;
        }
    }

    public boolean performFinish() {
        EditorPlugin.DBG.info("finish - creating new StatCon file");
        IFile file = this.location_page.createNewFile();
        StringBuffer xml = new StringBuffer();
        xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        xml.append("<!-- Statistical Model Graph Viewer configuration file -->\n");
        xml.append("<!-- Not intended to be human editable - edit at your own risk -->\n");
        xml.append("<smgconfig>\n");
        ArrayList models = this.select_page.getSelectedFiles();
        int i = 0;
        while (i < models.size()) {
            IFile model = (IFile)models.get(i);
            URI fileURI = URI.createPlatformResourceURI((String)model.getFullPath().toString());
            xml.append("  <model file=\"").append(fileURI).append("\" />\n");
            ++i;
        }
        int i2 = 0;
        while (i2 < this.module_pages.length) {
            if (this.module_pages[i2] != null) {
                ArrayList files = this.module_pages[i2].page.getSelectedFiles();
                int k = 0;
                while (k < files.size()) {
                    IFile selected_file = (IFile)files.get(k);
                    URI fileURI = URI.createPlatformResourceURI((String)selected_file.getFullPath().toString());
                    xml.append("  <");
                    xml.append(this.module_pages[i2].element);
                    xml.append(" ");
                    xml.append(this.module_pages[i2].attribute);
                    xml.append("=\"");
                    xml.append(fileURI);
                    xml.append("\" />\n");
                    ++k;
                }
            }
            ++i2;
        }
        xml.append("</smgconfig>\n");
        ByteArrayInputStream bin = new ByteArrayInputStream(xml.toString().getBytes());
        try {
            EditorPlugin.DBG.info("trying to set file contents");
            file.setContents((InputStream)bin, true, false, null);
        }
        catch (Exception e) {
            EditorPlugin.DBG.error("unable to set file contents", e);
            return false;
        }
        StatisticalModelGraphEditorWizard.openEditor(file, null, false);
        return true;
    }

    public static IWorkbenchPage getActiveWorkbenchPage() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchPage activePage = null;
        if (workbench.getActiveWorkbenchWindow() != null) {
            activePage = workbench.getActiveWorkbenchWindow().getActivePage();
        } else if (workbench.getWorkbenchWindows().length > 0) {
            activePage = workbench.getWorkbenchWindows()[0].getActivePage();
        }
        return activePage;
    }

    public static IEditorPart openEditor(IFile file, String editorId, boolean substring) {
        block8: {
            if (file == null) {
                return null;
            }
            IWorkbenchPage activePage = StatisticalModelGraphEditorWizard.getActiveWorkbenchPage();
            if (activePage == null) {
                return null;
            }
            if ("".equals(editorId)) {
                editorId = null;
            }
            try {
                if (editorId == null) {
                    return IDE.openEditor((IWorkbenchPage)activePage, (IFile)file, (boolean)true);
                }
                IWorkbench workbench = PlatformUI.getWorkbench();
                IEditorDescriptor[] editors = workbench.getEditorRegistry().getEditors(file.getName());
                if (editors == null) break block8;
                boolean found = false;
                int i = 0;
                int length = editors.length;
                while (i < length) {
                    found = substring ? editors[i].getId().startsWith(editorId) : editorId.equals(editors[i].getId());
                    if (found) {
                        return activePage.openEditor((IEditorInput)new FileEditorInput(file), editors[i].getId());
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                EditorPlugin.DBG.error("couldnt open editor", e);
                EditorPlugin.DBG.logVisibleError(e, EditorPlugin.getString("ERROR_OPEN_STATCON"), false);
            }
        }
        return null;
    }

    public class SMGFileProvider
    extends WorkbenchContentProvider {
        String[] extensions;

        public SMGFileProvider(String[] extensions) {
            this.extensions = extensions;
        }

        public Object[] getChildren(Object o) {
            if (o instanceof IContainer) {
                IResource[] members = null;
                try {
                    members = ((IContainer)o).members();
                }
                catch (CoreException e) {
                    return new Object[0];
                }
                ArrayList<IResource> results = new ArrayList<IResource>();
                int i = 0;
                while (i < members.length) {
                    if ((members[i].getType() & 1) > 0) {
                        String name = members[i].getName();
                        name = name.substring(name.lastIndexOf(".") + 1);
                        int k = 0;
                        while (k < this.extensions.length) {
                            if (name.equalsIgnoreCase(this.extensions[k])) {
                                results.add(members[i]);
                            }
                            ++k;
                        }
                    }
                    ++i;
                }
                return results.toArray();
            }
            if (o instanceof ArrayList) {
                return ((ArrayList)o).toArray();
            }
            return new Object[0];
        }
    }

    public class FolderProvider
    extends WorkbenchContentProvider {
        public Object[] getChildren(Object o) {
            int resourceType = 14;
            if (o instanceof IContainer) {
                IResource[] members = null;
                try {
                    members = ((IContainer)o).members();
                }
                catch (CoreException e) {
                    return new Object[0];
                }
                ArrayList<IResource> results = new ArrayList<IResource>();
                int i = 0;
                while (i < members.length) {
                    if ((members[i].getType() & resourceType) > 0) {
                        results.add(members[i]);
                    }
                    ++i;
                }
                return results.toArray();
            }
            if (o instanceof ArrayList) {
                return ((ArrayList)o).toArray();
            }
            return new Object[0];
        }
    }

    public class ResourceSelectionPage
    extends WizardPage {
        private IAdaptable root;
        private CheckboxTreeAndListGroup main_widget;
        private Control page_control;
        private static final int SIZING_SELECTION_WIDGET_WIDTH = 400;
        private static final int SIZING_SELECTION_WIDGET_HEIGHT = 300;
        String[] extensions;

        public Control getControl() {
            return this.page_control;
        }

        public ResourceSelectionPage(String title, String[] extensions, String description) {
            super(title);
            this.setTitle(title);
            this.setDescription(description);
            this.extensions = extensions;
            this.root = ResourcesPlugin.getWorkspace().getRoot();
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new FillLayout());
            ArrayList<IAdaptable> input = new ArrayList<IAdaptable>();
            input.add(this.root);
            this.main_widget = new CheckboxTreeAndListGroup(composite, input, (ITreeContentProvider)new FolderProvider(), WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider(), (IStructuredContentProvider)new SMGFileProvider(this.extensions), WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider(), 0, 400, 300);
            composite.addControlListener(new ControlListener(this){
                private final /* synthetic */ ResourceSelectionPage this$1;
                {
                    this.this$1 = this$1;
                }

                public void controlMoved(ControlEvent e) {
                }

                public void controlResized(ControlEvent e) {
                    TableColumn[] columns = ResourceSelectionPage.access$000(this.this$1).getListTable().getColumns();
                    int i = 0;
                    while (i < columns.length) {
                        columns[i].pack();
                        ++i;
                    }
                }
            });
            this.page_control = composite;
            this.setControl(this.page_control);
        }

        public ArrayList getSelectedFiles() {
            Iterator resultEnum = this.main_widget.getAllCheckedListItems();
            ArrayList list = new ArrayList();
            while (resultEnum.hasNext()) {
                list.add(resultEnum.next());
            }
            return list;
        }

        static /* synthetic */ CheckboxTreeAndListGroup access$000(ResourceSelectionPage x0) {
            return x0.main_widget;
        }
    }

    class ModulePage {
        ResourceSelectionPage page;
        String element;
        String attribute;

        ModulePage() {
        }
    }
}

