/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.widgets.grapher.internal;

import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.BasicGraphSource;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.Graph;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.GraphSource;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.IndicatorSource;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.TimeZoomSlider;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomIndicator;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomSlider;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomSliderTick;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;

public class LineGraph
implements Graph {
    public static final int TYPE_NEAREST = 0;
    public static final int TYPE_AVERAGE = 1;
    public static final int TYPE_SUM = 2;
    private static final boolean DRAW_ONLY_IF_DATA = true;
    GraphSource source;
    ZoomSlider yslider;
    TimeZoomSlider xslider;
    Color fg_col;
    int line_width = 1;
    int line_style = 1;
    int type;
    double scaling = 1.0;
    double last_drawn_value = 0.0;
    boolean pixel_perfect = false;
    boolean use_indicators = true;
    ZoomIndicator indicator;
    IndicatorSource isource;

    public LineGraph(int type, GraphSource source, TimeZoomSlider xslider, ZoomSlider yslider, Color col) {
        this.type = type;
        this.source = source;
        this.fg_col = col;
        this.xslider = xslider;
        this.yslider = yslider;
        this.init();
    }

    public LineGraph(int type, GraphSource source, TimeZoomSlider xslider, ZoomSlider yslider, Color col, boolean pixel_perfect, boolean use_indicators) {
        this.type = type;
        this.source = source;
        this.fg_col = col;
        this.xslider = xslider;
        this.yslider = yslider;
        this.pixel_perfect = pixel_perfect;
        this.use_indicators = use_indicators;
        this.init();
    }

    public BasicGraphSource getGraphSource() {
        return this.source;
    }

    private void init() {
        if (this.use_indicators) {
            this.indicator = new ZoomIndicator(this.yslider, this.last_drawn_value, this.fg_col);
            this.yslider.addZoomIndicator(this.indicator);
        }
    }

    public void setIndicatorSource(IndicatorSource source) {
        this.isource = source;
    }

    public void setUseIndicator(boolean b) {
        if (this.use_indicators && !b) {
            this.yslider.removeIndicator(this.indicator);
            this.indicator.dispose();
        } else if (!this.use_indicators && b) {
            this.indicator = new ZoomIndicator(this.yslider, this.last_drawn_value, this.fg_col);
            this.yslider.addZoomIndicator(this.indicator);
        }
        this.use_indicators = b;
    }

    public double getXMin() {
        return this.source.getMin();
    }

    public double getXMax() {
        return this.source.getMax();
    }

    public double getYMin() {
        return this.source.getValueMin();
    }

    public double getYMax() {
        return this.source.getValueMax();
    }

    public void setForeground(Color col) {
        this.fg_col = col;
        if (this.use_indicators) {
            this.indicator.setColor(col);
        }
    }

    public Color getForeground() {
        return this.fg_col;
    }

    public void setLineWidth(int w) {
        this.line_width = w;
    }

    public int getLineWidth() {
        return this.line_width;
    }

    public void setLineStyle(int swt_line_style) {
        this.line_style = swt_line_style;
    }

    public int getLineStyle() {
        return this.line_style;
    }

    public void paintGraph(GC gc, int x, int y, int w, int h) {
        gc.setForeground(this.fg_col);
        gc.setLineWidth(this.line_width);
        gc.setLineStyle(this.line_style);
        ZoomSliderTick tick_start = this.xslider.getFirstTick();
        ZoomSliderTick tick_end = this.xslider.getLastTick();
        if (tick_start == null || tick_end == null) {
            return;
        }
        double res = this.xslider.getIncrement();
        double start = tick_start.value - res;
        double end = tick_end.value;
        if (this.pixel_perfect) {
            res = this.xslider.getUnitIncrement();
        }
        boolean found_indicator = false;
        double indicator_loc = this.isource.getIndicatorLocation();
        double indicator_val = this.last_drawn_value;
        int indicator_type = this.isource.getSourceType();
        boolean first = true;
        double px = 0.0;
        double py = 0.0;
        double last_cy = 0.0;
        double i = start;
        while (i <= end) {
            double cx = i;
            if (!(i > this.source.getMax() + res) && !(i < this.source.getMin() - res)) {
                double pixel_y;
                double pixel_x;
                double cy;
                if (first) {
                    first = false;
                    cy = this.source.getValueAt(cx);
                    last_cy = cy *= this.scaling;
                    pixel_x = this.xslider.value2Pixel(cx);
                    pixel_y = this.yslider.value2Pixel(cy);
                    gc.drawLine((int)pixel_x, (int)pixel_y, (int)pixel_x, (int)pixel_y);
                } else {
                    cy = 0.0;
                    cy = this.type == 0 ? this.source.getValueAt(cx) : (this.type == 1 ? this.source.getAverageBetween(cx - res, cx) : (this.type == 2 ? this.source.getSumBetween(cx - res, cx) : this.source.getAverageBetween(cx - res, cx)));
                    cy *= this.scaling;
                    if (indicator_type == 0 && indicator_loc > cx - res && indicator_loc < cx) {
                        found_indicator = true;
                        indicator_val = cy;
                    }
                    last_cy = cy;
                    pixel_x = this.xslider.value2Pixel(cx);
                    pixel_y = this.yslider.value2Pixel(cy);
                    if (indicator_type == 1 && indicator_loc > px && indicator_loc < pixel_x) {
                        found_indicator = true;
                        indicator_val = cy;
                    }
                    gc.drawLine((int)px, (int)py, (int)pixel_x, (int)pixel_y);
                }
                px = pixel_x;
                py = pixel_y;
            }
            i += res;
        }
        this.last_drawn_value = last_cy;
        if (this.isource == null || !found_indicator) {
            this.indicator.setValue(this.last_drawn_value);
        } else {
            this.indicator.setValue(indicator_val);
        }
        this.yslider.updateIndicators();
    }

    public void paintGraphNearest(GC gc, int x, int y, int w, int h) {
    }

    public TimeZoomSlider getXSlider() {
        return this.xslider;
    }

    public ZoomSlider getYSlider() {
        return this.yslider;
    }

    public void setXSlider(TimeZoomSlider slider) {
        this.xslider = slider;
    }

    public void setYSlider(ZoomSlider slider) {
        if (this.use_indicators) {
            this.yslider.removeIndicator(this.indicator);
            this.indicator.dispose();
        }
        this.yslider = slider;
        if (this.use_indicators) {
            this.indicator = new ZoomIndicator(this.yslider, this.last_drawn_value, this.fg_col);
            this.yslider.addZoomIndicator(this.indicator);
        }
    }

    public void setStaticScaling(double mult) {
        this.scaling = mult;
    }

    public double getStaticScaling() {
        return this.scaling;
    }
}

