/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.cbe;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;

public class CBEUtils {
    public static double computeAdjustedCreationTime(CBECommonBaseEvent event) {
        double creationTime = event.getCreationTime();
        try {
            return creationTime + event.getAgent().getAgentProxy().getProcessProxy().getNode().getDeltaTime();
        }
        catch (Exception e) {
            return creationTime;
        }
    }

    public static String formatCreationTime(CBECommonBaseEvent event, SimpleDateFormat dateFormat) {
        String res;
        block2: {
            res = "0";
            if (event.getCreationTime() == 0.0) break block2;
            try {
                short value = event.getTimeZone();
                double ct = CBEUtils.computeAdjustedCreationTime(event);
                Double l2 = new Double(ct);
                res = dateFormat.format(new Date(l2.longValue() / 1000L + (long)(value * 60 * 1000)));
                String microseconds = "" + l2.longValue() % 1000000L;
                res = res + "." + "000000".substring(0, 6 - microseconds.length()) + microseconds;
                res = res + (value > 0 ? "+00" : "-00").substring(0, 3 - ("" + Math.abs(value / 60)).length()) + Math.abs(value / 60);
                res = res + ":00".substring(0, 3 - ("" + Math.abs(value % 60)).length()) + Math.abs(value % 60);
            }
            catch (Exception e) {}
        }
        return res;
    }
}

