/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.perfmon.xml;

import java.util.Arrays;

public class FastStringBuffer {
    private char[] value;
    private int count;
    private static final FastStringBuffer NULL = new FastStringBuffer("null");

    public FastStringBuffer() {
        this(16);
    }

    public FastStringBuffer(int length) {
        this.value = new char[length];
    }

    public FastStringBuffer(String str) {
        this(str.length() + 16);
        this.append(str);
    }

    public int length() {
        return this.count;
    }

    public int capacity() {
        return this.value.length;
    }

    private void expandCapacity(int minimumCapacity) {
        int newCapacity = (this.value.length + 1) * 2;
        if (newCapacity < 0) {
            newCapacity = Integer.MAX_VALUE;
        } else if (minimumCapacity > newCapacity) {
            newCapacity = minimumCapacity;
        }
        char[] newValue = new char[newCapacity];
        System.arraycopy(this.value, 0, newValue, 0, this.count);
        this.value = newValue;
    }

    public void setLength(int newLength) {
        if (newLength < 0) {
            throw new StringIndexOutOfBoundsException(newLength);
        }
        if (newLength > this.value.length) {
            this.expandCapacity(newLength);
        }
        if (this.count < newLength) {
            Arrays.fill(this.value, this.count, this.value.length, '\u0000');
        } else {
            this.count = newLength;
        }
    }

    public char charAt(int index) {
        return this.value[index];
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        System.arraycopy(this.value, srcBegin, dst, dstBegin, srcEnd - srcBegin);
    }

    public void setCharAt(int index, char ch) {
        this.value[index] = ch;
    }

    public FastStringBuffer append(Object obj) {
        return this.append(String.valueOf(obj));
    }

    public FastStringBuffer append(String str) {
        int len;
        int newcount;
        if (str == null) {
            str = String.valueOf(str);
        }
        if ((newcount = this.count + (len = str.length())) > this.value.length) {
            this.expandCapacity(newcount);
        }
        str.getChars(0, len, this.value, this.count);
        this.count = newcount;
        return this;
    }

    public FastStringBuffer append(FastStringBuffer sb) {
        int len;
        int newcount;
        if (sb == null) {
            sb = NULL;
        }
        if ((newcount = this.count + (len = sb.length())) > this.value.length) {
            this.expandCapacity(newcount);
        }
        sb.getChars(0, len, this.value, this.count);
        this.count = newcount;
        return this;
    }

    public FastStringBuffer append(char[] str) {
        int len = str.length;
        int newcount = this.count + len;
        if (newcount > this.value.length) {
            this.expandCapacity(newcount);
        }
        System.arraycopy(str, 0, this.value, this.count, len);
        this.count = newcount;
        return this;
    }

    public FastStringBuffer append(char[] str, int offset, int len) {
        int newcount = this.count + len;
        if (newcount > this.value.length) {
            this.expandCapacity(newcount);
        }
        System.arraycopy(str, offset, this.value, this.count, len);
        this.count = newcount;
        return this;
    }

    public FastStringBuffer append(boolean b) {
        return this.append(String.valueOf(b));
    }

    public FastStringBuffer append(char c) {
        int newcount = this.count + 1;
        if (newcount > this.value.length) {
            this.expandCapacity(newcount);
        }
        this.value[this.count++] = c;
        return this;
    }

    public FastStringBuffer append(int i) {
        return this.append(String.valueOf(i));
    }

    public FastStringBuffer append(long l) {
        return this.append(String.valueOf(l));
    }

    public FastStringBuffer append(float f) {
        return this.append(String.valueOf(f));
    }

    public FastStringBuffer append(double d) {
        return this.append(String.valueOf(d));
    }

    public FastStringBuffer delete(int start, int end) {
        int len;
        if (end > this.count) {
            end = this.count;
        }
        if ((len = end - start) > 0) {
            System.arraycopy(this.value, start + len, this.value, start, this.count - end);
            this.count -= len;
        }
        return this;
    }

    public FastStringBuffer deleteCharAt(int index) {
        System.arraycopy(this.value, index + 1, this.value, index, this.count - index - 1);
        --this.count;
        return this;
    }

    public FastStringBuffer replace(int start, int end, String str) {
        int len;
        int newCount;
        if (end > this.count) {
            end = this.count;
        }
        if ((newCount = this.count + (len = str.length()) - (end - start)) > this.value.length) {
            this.expandCapacity(newCount);
        }
        System.arraycopy(this.value, end, this.value, start + len, this.count - end);
        str.getChars(0, len, this.value, start);
        this.count = newCount;
        return this;
    }

    public String substring(int start) {
        return this.substring(start, this.count);
    }

    public String substring(int start, int end) {
        return new String(this.value, start, end - start);
    }

    public FastStringBuffer insert(int index, char[] str, int offset, int len) {
        int newCount = this.count + len;
        if (newCount > this.value.length) {
            this.expandCapacity(newCount);
        }
        System.arraycopy(this.value, index, this.value, index + len, this.count - index);
        System.arraycopy(str, offset, this.value, index, len);
        this.count = newCount;
        return this;
    }

    public FastStringBuffer insert(int offset, Object obj) {
        return this.insert(offset, String.valueOf(obj));
    }

    public FastStringBuffer insert(int offset, String str) {
        int len;
        int newcount;
        if (str == null) {
            str = String.valueOf(str);
        }
        if ((newcount = this.count + (len = str.length())) > this.value.length) {
            this.expandCapacity(newcount);
        }
        System.arraycopy(this.value, offset, this.value, offset + len, this.count - offset);
        str.getChars(0, len, this.value, offset);
        this.count = newcount;
        return this;
    }

    public FastStringBuffer insert(int offset, char[] str) {
        int len = str.length;
        int newcount = this.count + len;
        if (newcount > this.value.length) {
            this.expandCapacity(newcount);
        }
        System.arraycopy(this.value, offset, this.value, offset + len, this.count - offset);
        System.arraycopy(str, 0, this.value, offset, len);
        this.count = newcount;
        return this;
    }

    public FastStringBuffer insert(int offset, boolean b) {
        return this.insert(offset, String.valueOf(b));
    }

    public FastStringBuffer insert(int offset, char c) {
        int newcount = this.count + 1;
        if (newcount > this.value.length) {
            this.expandCapacity(newcount);
        }
        System.arraycopy(this.value, offset, this.value, offset + 1, this.count - offset);
        this.value[offset] = c;
        this.count = newcount;
        return this;
    }

    public FastStringBuffer insert(int offset, int i) {
        return this.insert(offset, String.valueOf(i));
    }

    public FastStringBuffer insert(int offset, long l) {
        return this.insert(offset, String.valueOf(l));
    }

    public FastStringBuffer insert(int offset, float f) {
        return this.insert(offset, String.valueOf(f));
    }

    public FastStringBuffer insert(int offset, double d) {
        return this.insert(offset, String.valueOf(d));
    }

    public int indexOf(char c, int index) {
        int i = index;
        while (i < this.count) {
            if (this.value[i] == c) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOf(String str) {
        return this.indexOf(str, 0);
    }

    private int indexOf(char[] search, int index) {
        int vallen = this.count - search.length + 1;
        int match = 0;
        int matchlen = search.length;
        int i = index;
        while (i < vallen) {
            if (this.value[i] == search[match]) {
                if (++match == matchlen) {
                    return i + 1 - match;
                }
            } else {
                match = 0;
            }
            ++i;
        }
        return -1;
    }

    private int rindexOf(char[] search, int index) {
        int slen;
        int match = slen = search.length - 1;
        int i = index += search.length - 1;
        while (i >= 0) {
            if (this.value[i] == search[match]) {
                if (--match == -1) {
                    return i;
                }
            } else {
                match = slen;
            }
            --i;
        }
        return -1;
    }

    public int indexOf(String str, int fromIndex) {
        char[] search = str.toCharArray();
        return this.indexOf(search, fromIndex);
    }

    public int lastIndexOf(String str) {
        return this.lastIndexOf(str, this.count);
    }

    public int lastIndexOf(String str, int fromIndex) {
        char[] search = str.toCharArray();
        return this.rindexOf(search, fromIndex);
    }

    public FastStringBuffer reverse() {
        int n = this.count - 1;
        int j = n - 1 >> 1;
        while (j >= 0) {
            char temp = this.value[j];
            this.value[j] = this.value[n - j];
            this.value[n - j] = temp;
            --j;
        }
        return this;
    }

    public String toString() {
        return new String(this.value, 0, this.count);
    }
}

