/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.trace;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.hyades.loaders.trace.CallStackPerThread;
import org.eclipse.hyades.loaders.trace.InvocationContext;
import org.eclipse.hyades.loaders.trace.TString;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCConfiguration;
import org.eclipse.hyades.models.hierarchy.TRCOption;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCSourceInfo;
import org.eclipse.hyades.models.trace.TraceFactory;

public final class TraceUtils {
    private static StringBuffer strBuf = new StringBuffer();
    static /* synthetic */ Class class$org$eclipse$hyades$models$trace$TRCSourceInfo;
    static /* synthetic */ Class class$org$eclipse$hyades$models$trace$impl$TRCPackageImpl;
    static /* synthetic */ Class class$org$eclipse$hyades$loaders$trace$VirtualObjectInfo;

    public static boolean isConstructor(String msg) {
        return msg.equals("<clinit>") || msg.equals("-clinit-") || msg.equals("-init-");
    }

    public static String getForwardInvocationsId(InvocationContext invocationContext) {
        return TraceUtils.getForwardInvocationsId(invocationContext.getInvocationAgentIdRef());
    }

    public static String getForwardInvocationsId(String agentRuntimeID) {
        return agentRuntimeID;
    }

    public static String getMethodInvocationId(InvocationContext invocationContext) {
        return TraceUtils.getMethodInvocationId(invocationContext.getInvocationThreadIdRef(), invocationContext.getInvocationTicket());
    }

    public static String getMethodInvocationId(int threadId, long ticket) {
        return threadId + "_" + ticket;
    }

    public static String getMethodName(TRCMethod method, String originalMethodName) {
        if (originalMethodName.equals("-init-")) {
            return method.getDefiningClass().getName();
        }
        return originalMethodName;
    }

    public static TRCProcess getProcess(TRCAgent agent) {
        if (agent != null && agent.getProcess() instanceof TRCProcess) {
            return (TRCProcess)agent.getProcess();
        }
        return null;
    }

    public static String getOptionValue(TRCAgentProxy agentProxy, String optionName) {
        if (agentProxy == null || agentProxy.getConfigurations() == null) {
            return null;
        }
        Object[] conflist = agentProxy.getConfigurations().toArray();
        int idx = 0;
        while (idx < conflist.length) {
            TRCConfiguration c = (TRCConfiguration)conflist[idx];
            if (c.isActive()) {
                Object[] optlist = c.getOptions().toArray();
                int jdx = 0;
                while (jdx < optlist.length) {
                    TRCOption o = (TRCOption)optlist[jdx];
                    if (o.getKey().equals(optionName)) {
                        return o.getValue();
                    }
                    ++jdx;
                }
            }
            ++idx;
        }
        return null;
    }

    public static boolean isBooleanOptionEnabled(HierarchyContext context, String name) {
        boolean optionValue;
        boolean optionSet = context.getCustomData().containsKey(name);
        if (!optionSet) {
            String value = TraceUtils.getOptionValue(context.getAgentProxy(), name);
            if (value != null && Boolean.valueOf(value).booleanValue()) {
                context.getCustomData().put(name, Boolean.TRUE);
                optionValue = true;
            } else {
                context.getCustomData().put(name, Boolean.FALSE);
                optionValue = false;
            }
        } else {
            optionValue = (Boolean)context.getCustomData().get(name);
        }
        return optionValue;
    }

    public static void setSourceInfo(HierarchyContext context, TRCProcess p, TRCClass theClass, String sourceName) {
        TRCSourceInfo sourceInfo = (TRCSourceInfo)LookupServiceExtensions.getInstance().locate(context, class$org$eclipse$hyades$models$trace$TRCSourceInfo == null ? (class$org$eclipse$hyades$models$trace$TRCSourceInfo = TraceUtils.class$("org.eclipse.hyades.models.trace.TRCSourceInfo")) : class$org$eclipse$hyades$models$trace$TRCSourceInfo, LoadersUtils.getLookUpKey((String)sourceName));
        if (sourceInfo == null) {
            sourceInfo = TraceUtils.isBooleanOptionEnabled(context, "LLDATA_ENABLED") ? TraceFactory.eINSTANCE.createTRCSourceInfoWithLLData() : TraceFactory.eINSTANCE.createTRCSourceInfo();
            sourceInfo.setLocation(sourceName);
            p.getSourceInfos().add((Object)sourceInfo);
        }
        if (theClass.getSourceInfo() == null) {
            theClass.setSourceInfo(sourceInfo);
        } else if (!theClass.getSourceInfo().getLocation().equals(sourceName)) {
            theClass.setSourceInfo(sourceInfo);
        }
    }

    public static void addClassObjectToClassClass(HierarchyContext context, TRCProcess process, TRCObject theObject) {
        TRCClass theClassClass = process.getClassClass();
        if (theClassClass == null) {
            theClassClass = TraceFactory.eINSTANCE.createTRCClass();
            theClassClass.setId(-1);
            theClassClass.setName("Class");
            TraceUtils.addClassToPackage(context, theClassClass, "java.lang.Class", process);
            TraceUtils.setSourceInfo(context, process, theClassClass, "Class.java");
            theClassClass.getSourceInfo().setLocation("Class.java");
            LookupServiceExtensions.getInstance().register(context, (Object)theClassClass);
            process.setClassClass(theClassClass);
        }
        if (theObject != null && theObject.getIsA() != theClassClass) {
            theObject.setIsA(theClassClass);
        }
    }

    public static void addClassToPackage(HierarchyContext context, TRCClass theClass, String classFullyQualifiedName, TRCProcess process) {
        if (theClass.getPackage() != null) {
            return;
        }
        String packageName = TraceUtils.packageName(classFullyQualifiedName);
        TRCPackage thePackage = (TRCPackage)LookupServiceExtensions.getInstance().locate(context, class$org$eclipse$hyades$models$trace$impl$TRCPackageImpl == null ? (class$org$eclipse$hyades$models$trace$impl$TRCPackageImpl = TraceUtils.class$("org.eclipse.hyades.models.trace.impl.TRCPackageImpl")) : class$org$eclipse$hyades$models$trace$impl$TRCPackageImpl, LoadersUtils.getLookUpKey((String)packageName));
        if (thePackage != null) {
            theClass.setPackage(thePackage);
            return;
        }
        thePackage = TraceFactory.eINSTANCE.createTRCPackage();
        thePackage.setName(packageName);
        thePackage.setProcess(process);
        theClass.setPackage(thePackage);
        TraceUtils.createSuperPackages(context, thePackage);
    }

    public static String className(String fullclassname) {
        if (fullclassname.startsWith("[")) {
            strBuf.setLength(0);
            TraceUtils.expandArrayType(fullclassname, 0, strBuf);
            String s = strBuf.toString();
            strBuf.setLength(0);
            return s;
        }
        int lastslash = Math.max(fullclassname.lastIndexOf(47), fullclassname.lastIndexOf(92));
        int lastdot = fullclassname.lastIndexOf(46);
        if ((lastslash = Math.max(lastslash, lastdot)) < 0) {
            return fullclassname;
        }
        return fullclassname.substring(lastslash + 1);
    }

    public static String convertMethodSignature(TRCMethod method, String originalMethodSignature) {
        return TraceUtils.convertMethodSignature(method.getModifier(), originalMethodSignature);
    }

    public static String convertMethodSignature(int modifiers, String originalMethodSignature) {
        if (originalMethodSignature == null) {
            return "()";
        }
        StringBuffer newMethodSignature = new StringBuffer();
        int i1 = originalMethodSignature.indexOf(40);
        if (i1 >= 0) {
            int i2 = originalMethodSignature.indexOf(41);
            if (i2 == ++i1) {
                newMethodSignature.append("()");
            } else {
                newMethodSignature.append("(");
                while (i1 < i2) {
                    if ((i1 = TraceUtils.expandMessageFieldType(originalMethodSignature, i1, newMethodSignature)) >= i2) continue;
                    newMethodSignature.append(", ");
                }
                newMethodSignature.append(")");
            }
            if ((modifiers & 0x80) == 0) {
                newMethodSignature.append(" ");
                TraceUtils.expandMessageFieldType(originalMethodSignature, ++i1, newMethodSignature);
            }
        }
        return newMethodSignature.toString();
    }

    public static void createSuperPackages(HierarchyContext context, TRCPackage thePackage) {
        TRCProcess p = thePackage.getProcess();
        String packageName = thePackage.getName();
        int pos = 0;
        int pPos = packageName.length();
        while (pPos > 0) {
            pos = packageName.lastIndexOf(46, pPos);
            if (pos < 0) break;
            String pName = packageName.substring(0, pos);
            TRCPackage sPkg = (TRCPackage)LookupServiceExtensions.getInstance().locate(context, class$org$eclipse$hyades$models$trace$impl$TRCPackageImpl == null ? TraceUtils.class$("org.eclipse.hyades.models.trace.impl.TRCPackageImpl") : class$org$eclipse$hyades$models$trace$impl$TRCPackageImpl, LoadersUtils.getLookUpKey((String)pName));
            if (sPkg == null) {
                sPkg = TraceFactory.eINSTANCE.createTRCPackage();
                sPkg.setName(pName);
                sPkg.setProcess(p);
            }
            thePackage.setParent(sPkg);
            thePackage = sPkg;
            pPos = pos - 1;
        }
    }

    public static int expandMessageFieldType(String strInput, int iIndex, StringBuffer strbufExpanded) {
        int iArray = 0;
        char cFieldType = strInput.charAt(iIndex);
        while (cFieldType == '[') {
            ++iArray;
            cFieldType = strInput.charAt(++iIndex);
        }
        switch (cFieldType) {
            case 'B': {
                strbufExpanded.append("byte");
                break;
            }
            case 'C': {
                strbufExpanded.append("char");
                break;
            }
            case 'D': {
                strbufExpanded.append("double");
                break;
            }
            case 'F': {
                strbufExpanded.append("float");
                break;
            }
            case 'I': {
                strbufExpanded.append("int");
                break;
            }
            case 'J': {
                strbufExpanded.append("long");
                break;
            }
            case 'S': {
                strbufExpanded.append("short");
                break;
            }
            case 'Z': {
                strbufExpanded.append("boolean");
                break;
            }
            case 'V': {
                strbufExpanded.append("void");
                break;
            }
            case 'L': {
                int iSemiColon = strInput.indexOf(59, iIndex);
                strbufExpanded.append(strInput.substring(iIndex + 1, iSemiColon).replace('/', '.'));
                iIndex = iSemiColon;
            }
        }
        while (iArray > 0) {
            strbufExpanded.append("[]");
            --iArray;
        }
        return ++iIndex;
    }

    public static String fullClassName(String fullclassname) {
        String name = TString.change(fullclassname, "/", ".");
        name = TString.change(name, "\\", ".");
        return name;
    }

    public static String packageName(String fullclassname) {
        int lastslash = Math.max(fullclassname.lastIndexOf(47), fullclassname.lastIndexOf(92));
        if (fullclassname.startsWith("[")) {
            return "";
        }
        int lastdot = fullclassname.lastIndexOf(46);
        if ((lastslash = Math.max(lastslash, lastdot)) < 0) {
            return "";
        }
        String packageName = fullclassname.substring(0, lastslash);
        packageName = TString.change(packageName, "/", ".");
        packageName = TString.change(packageName, "\\", ".");
        return packageName;
    }

    public static void removeSnapshot(TRCProcess process) {
        process.removeSnapshot();
        Iterator iter1 = process.getPackages().iterator();
        while (iter1.hasNext()) {
            TRCPackage thePackage = (TRCPackage)iter1.next();
            thePackage.removeSnapshot();
            Iterator iter2 = thePackage.getClasses().iterator();
            while (iter2.hasNext()) {
                TRCClass theClass = (TRCClass)iter2.next();
                theClass.removeSnapshot();
                Iterator iter = theClass.getMethods().iterator();
                while (iter.hasNext()) {
                    TRCMethod theMethod = (TRCMethod)iter.next();
                    theMethod.removeSnapshot();
                }
            }
        }
    }

    public static void removeVirtualObject(HierarchyContext context, long objIdRef) {
        LookupServiceExtensions.getInstance().deregister(context, class$org$eclipse$hyades$loaders$trace$VirtualObjectInfo == null ? (class$org$eclipse$hyades$loaders$trace$VirtualObjectInfo = TraceUtils.class$("org.eclipse.hyades.loaders.trace.VirtualObjectInfo")) : class$org$eclipse$hyades$loaders$trace$VirtualObjectInfo, LoadersUtils.getLookUpKey((long)objIdRef));
    }

    public static void takeSnapshot(TRCProcess process) {
        process.takeSnapshot();
        Iterator iter1 = process.getPackages().iterator();
        while (iter1.hasNext()) {
            TRCPackage thePackage = (TRCPackage)iter1.next();
            thePackage.takeSnapshot();
            Iterator iter2 = thePackage.getClasses().iterator();
            while (iter2.hasNext()) {
                TRCClass theClass = (TRCClass)iter2.next();
                theClass.takeSnapshot();
                Iterator iter = theClass.getMethods().iterator();
                while (iter.hasNext()) {
                    TRCMethod theMethod = (TRCMethod)iter.next();
                    theMethod.takeSnapshot();
                }
            }
        }
    }

    private static int expandArrayType(String strInput, int iIndex, StringBuffer strbufExpanded) {
        int iArray = 0;
        char cFieldType = strInput.charAt(iIndex);
        while (cFieldType == '[') {
            ++iArray;
            strbufExpanded.append(cFieldType);
            cFieldType = strInput.charAt(++iIndex);
        }
        switch (cFieldType) {
            case 'B': {
                strbufExpanded.append("byte");
                break;
            }
            case 'C': {
                strbufExpanded.append("char");
                break;
            }
            case 'D': {
                strbufExpanded.append("double");
                break;
            }
            case 'F': {
                strbufExpanded.append("float");
                break;
            }
            case 'I': {
                strbufExpanded.append("int");
                break;
            }
            case 'J': {
                strbufExpanded.append("long");
                break;
            }
            case 'S': {
                strbufExpanded.append("short");
                break;
            }
            case 'Z': {
                strbufExpanded.append("boolean");
                break;
            }
            case 'V': {
                strbufExpanded.append("void");
                break;
            }
            case 'L': {
                int iSemiColon = strInput.indexOf(59, iIndex);
                strbufExpanded.append(strInput.substring(++iIndex, iSemiColon).replace('/', '.'));
                iIndex = iSemiColon;
                break;
            }
            default: {
                strbufExpanded.append(strInput.substring(iIndex).replace('/', '.'));
            }
        }
        return ++iIndex;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static final class InvocationPool {
        private ArrayList invocations = new ArrayList(20);
        private int currentEntryIndex = -1;

        public InvocationInfo allocInvocation(TRCFullMethodInvocation inv, CallStackPerThread callStackPerThread) {
            InvocationInfo invocationInfo;
            if (this.invocations.size() == this.currentEntryIndex + 1) {
                invocationInfo = new InvocationInfo(inv, callStackPerThread);
                this.invocations.add(invocationInfo);
                ++this.currentEntryIndex;
            } else {
                ++this.currentEntryIndex;
                invocationInfo = (InvocationInfo)this.invocations.get(this.currentEntryIndex);
                invocationInfo.callStackPerThread = callStackPerThread;
                invocationInfo.update(inv);
            }
            return invocationInfo;
        }

        public InvocationInfo allocInvocation(CallStackPerThread callStackPerThread, TRCFullTraceObject object, TRCClass theClass, TRCMethod method, double entryTime) {
            InvocationInfo invocationInfo;
            if (this.invocations.size() == this.currentEntryIndex + 1) {
                invocationInfo = new InvocationInfo(callStackPerThread, object, theClass, method, entryTime);
                this.invocations.add(invocationInfo);
                ++this.currentEntryIndex;
            } else {
                ++this.currentEntryIndex;
                invocationInfo = (InvocationInfo)this.invocations.get(this.currentEntryIndex);
                invocationInfo.callStackPerThread = callStackPerThread;
                invocationInfo.update(object, theClass, method, entryTime);
            }
            return invocationInfo;
        }

        public void release(InvocationInfo invocationInfo) {
            invocationInfo.reset();
            --this.currentEntryIndex;
        }
    }

    public static final class InvocationInfo {
        private CallStackPerThread callStackPerThread;
        private TRCClass theClass;
        private TRCClass theObjectClass;
        private TRCFullMethodInvocation methodInvocation;
        private TRCFullTraceObject theObject;
        private TRCMethod theMethod;
        private boolean classLocked = false;
        private boolean methodLocked = false;
        private boolean objectClassLocked = false;
        private boolean objectLocked = false;
        private double entryTime = -1.0;
        private double lastChildExitTime = -1.0;

        public InvocationInfo(TRCFullMethodInvocation inv, CallStackPerThread callStackPerThread) {
            this.callStackPerThread = callStackPerThread;
            this.update(inv);
        }

        public InvocationInfo(CallStackPerThread callStackPerThread, TRCFullTraceObject object, TRCClass theClass, TRCMethod method, double entryTime) {
            this.callStackPerThread = callStackPerThread;
            this.update(object, theClass, method, entryTime);
        }

        public boolean isClassLocked() {
            return this.classLocked;
        }

        public double getEntryTime() {
            return this.entryTime;
        }

        public void setLastChildExitTime(double lastChildExitTime) {
            this.lastChildExitTime = lastChildExitTime;
        }

        public double getLastChildExitTime() {
            return this.lastChildExitTime;
        }

        public TRCMethod getMethod() {
            return this.theMethod;
        }

        public TRCFullMethodInvocation getMethodInvocation() {
            return this.methodInvocation;
        }

        public boolean isMethodLocked() {
            return this.methodLocked;
        }

        public TRCFullTraceObject getObject() {
            return this.theObject;
        }

        public TRCClass getObjectClass() {
            return this.theObjectClass;
        }

        public boolean isObjectClassLocked() {
            return this.objectClassLocked;
        }

        public boolean isObjectLocked() {
            return this.objectLocked;
        }

        public TRCClass getTheClass() {
            return this.theClass;
        }

        public void initInvocationInfo(double entryTime) {
            this.theObjectClass = null;
            if (this.theObject.getIsA() != this.theClass && this.theObject.getIsA() != this.theObject.getProcess().getClassClass()) {
                this.theObjectClass = this.theObject.getIsA();
            }
            this.entryTime = entryTime;
            if (this.callStackPerThread.locks.containsKey(this.theObject)) {
                this.objectLocked = true;
            } else {
                this.callStackPerThread.locks.put(this.theObject, null);
            }
            if (this.callStackPerThread.locks.containsKey(this.theMethod)) {
                this.methodLocked = true;
            } else {
                this.callStackPerThread.locks.put(this.theMethod, null);
            }
            if (this.callStackPerThread.locks.containsKey(this.theClass)) {
                this.classLocked = true;
            } else {
                this.callStackPerThread.locks.put(this.theClass, null);
            }
            if (this.theObjectClass != null) {
                if (this.callStackPerThread.locksInherited.containsKey(this.theObjectClass)) {
                    this.objectClassLocked = true;
                } else {
                    this.callStackPerThread.locksInherited.put(this.theObjectClass, null);
                }
            }
        }

        public void removeLocks() {
            if (!this.methodLocked) {
                this.callStackPerThread.locks.remove(this.theMethod);
            }
            if (!this.objectLocked) {
                this.callStackPerThread.locks.remove(this.theObject);
            }
            if (!this.classLocked) {
                this.callStackPerThread.locks.remove(this.theClass);
            }
            if (!this.objectClassLocked) {
                this.callStackPerThread.locksInherited.remove(this.theObjectClass);
            }
        }

        public void reset() {
            this.removeLocks();
            this.methodLocked = false;
            this.objectLocked = false;
            this.objectClassLocked = false;
            this.classLocked = false;
            this.entryTime = -1.0;
            this.lastChildExitTime = -1.0;
            this.theClass = null;
            this.theObject = null;
            this.theObjectClass = null;
            this.theMethod = null;
            this.methodInvocation = null;
            this.callStackPerThread = null;
        }

        public void update(TRCFullTraceObject object, TRCClass theClass, TRCMethod method, double entryTime) {
            this.theMethod = method;
            this.theObject = object;
            this.theClass = theClass;
            this.initInvocationInfo(entryTime);
        }

        public void update(TRCFullMethodInvocation inv) {
            this.methodInvocation = inv;
            this.theObject = (TRCFullTraceObject)inv.getOwningObject();
            this.theMethod = inv.getMethod();
            this.theClass = this.theMethod.getDefiningClass();
            this.initInvocationInfo(inv.getEntryTime());
        }
    }
}

