/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.adapter.internal;

import java.util.Enumeration;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.TraceViewer;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.views.adapter.internal.PatternPage;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.GraphColorDialog;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.part.IPage;

public class PatternViewer
extends TraceViewer {
    protected Action _reset;
    protected Action _showRawTime;
    private Action _zoomInAction;
    private Action _zoomOutAction;
    private Action _stdSelectAction;
    protected Action _showCompensatedTime;
    private boolean _stdSelect = true;
    private boolean _zoomIn = false;
    private boolean _zoomOut = false;

    public TraceViewerPage createPage(EObject mofObject) {
        return new PatternPage(mofObject, this);
    }

    public void dispose() {
        Enumeration pages = this._pages.elements();
        while (pages.hasMoreElements()) {
            IPage page = (IPage)pages.nextElement();
            if (!(page instanceof PatternPage)) continue;
            ((PatternPage)page).dispose();
        }
        this._showCompensatedTime = null;
        this._showRawTime = null;
        this._stdSelectAction = null;
        this._zoomInAction = null;
        this._zoomOutAction = null;
        super.dispose();
    }

    public void makeActions() {
        if (this.isInitializedMenu()) {
            return;
        }
        this.initializedMenu(true);
        String compTime = TraceUIPlugin.getString("STR_COMPENSATED_TIME");
        this._showCompensatedTime = new Action(compTime){

            public void run() {
                TraceUIPlugin.getDefault().getPreferenceStore().setValue("time_display", 0);
                TraceUIPlugin.getDefault().notifyTimeChangedEventListener();
            }
        };
        this._showCompensatedTime.setText(compTime);
        this._showCompensatedTime.setDescription(compTime);
        this._showCompensatedTime.setToolTipText(compTime);
        int ref = TraceUIPlugin.getDefault().getPreferenceStore().getInt("time_display");
        this._showCompensatedTime.setChecked(ref == 0);
        String rawTime = TraceUIPlugin.getString("STR_RAW_TIME");
        this._showRawTime = new Action(rawTime){

            public void run() {
                TraceUIPlugin.getDefault().getPreferenceStore().setValue("time_display", 1);
                TraceUIPlugin.getDefault().notifyTimeChangedEventListener();
            }
        };
        this._showRawTime.setText(rawTime);
        this._showRawTime.setDescription(rawTime);
        this._showRawTime.setToolTipText(rawTime);
        ref = TraceUIPlugin.getDefault().getPreferenceStore().getInt("time_display");
        this._showRawTime.setChecked(ref == 1);
        String strHome = TraceUIPlugin.getString("STR_HOME");
        this._reset = new Action(strHome){

            public void run() {
                PatternPage page = (PatternPage)PatternViewer.this.getCurrentPage();
                if (page == null) {
                    return;
                }
                page.getView().update();
            }
        };
        this._reset.setText(strHome);
        TracePluginImages.setImageDescriptors((IAction)this._reset, "tool16", "home_nav.gif");
        this._reset.setDescription(strHome);
        this._reset.setToolTipText(strHome);
        String strStdSelect = TraceUIPlugin.getString("STR_STD_SELECT");
        this._stdSelectAction = new Action(strStdSelect){

            public void run() {
                PatternPage page = (PatternPage)PatternViewer.this.getCurrentPage();
                if (page == null) {
                    return;
                }
                PatternViewer.this._stdSelect = true;
                PatternViewer.this._zoomIn = !PatternViewer.this._stdSelect;
                PatternViewer.this._zoomOut = !PatternViewer.this._stdSelect;
                PatternViewer.this._stdSelectAction.setChecked(true);
                PatternViewer.this._zoomInAction.setChecked(false);
                PatternViewer.this._zoomOutAction.setChecked(false);
                page.getView().zoomIn(PatternViewer.this._zoomIn);
                page.getView().zoomOut(PatternViewer.this._zoomOut);
            }

            public int getStyle() {
                return 2;
            }
        };
        this._stdSelectAction.setText(strStdSelect);
        TracePluginImages.setImageDescriptors((IAction)this._stdSelectAction, "lcl16", "select_zoomin.gif");
        this._stdSelectAction.setDescription(strStdSelect);
        this._stdSelectAction.setToolTipText(strStdSelect);
        String strZoomIn = TraceUIPlugin.getString("STR_ZOOM_IN");
        this._zoomInAction = new Action(strZoomIn){

            public void run() {
                PatternPage page = (PatternPage)PatternViewer.this.getCurrentPage();
                if (page == null) {
                    return;
                }
                PatternViewer.this._zoomIn = this.isChecked();
                if (!PatternViewer.this._zoomIn) {
                    PatternViewer.this._stdSelect = true;
                } else {
                    PatternViewer.this._stdSelect = !PatternViewer.this._zoomIn;
                    PatternViewer.this._zoomOut = !PatternViewer.this._zoomIn;
                }
                if (PatternViewer.this._zoomIn) {
                    PatternViewer.this._stdSelectAction.setChecked(false);
                    PatternViewer.this._zoomOutAction.setChecked(false);
                } else {
                    PatternViewer.this._stdSelectAction.setChecked(true);
                }
                page.getView().zoomIn(PatternViewer.this._zoomIn);
            }

            public int getStyle() {
                return 2;
            }
        };
        this._zoomInAction.setText(strZoomIn);
        TracePluginImages.setImageDescriptors((IAction)this._zoomInAction, "lcl16", "zoomin_nav.gif");
        this._zoomInAction.setDescription(strZoomIn);
        this._zoomInAction.setToolTipText(strZoomIn);
        String strZoomOut = TraceUIPlugin.getString("STR_ZOOM_OUT");
        this._zoomOutAction = new Action(strZoomOut){

            public void run() {
                PatternPage page = (PatternPage)PatternViewer.this.getCurrentPage();
                if (page == null) {
                    return;
                }
                PatternViewer.this._zoomOut = this.isChecked();
                if (!PatternViewer.this._zoomOut) {
                    PatternViewer.this._stdSelect = true;
                } else {
                    PatternViewer.this._stdSelect = !PatternViewer.this._zoomOut;
                    PatternViewer.this._zoomIn = !PatternViewer.this._zoomOut;
                }
                if (PatternViewer.this._zoomOut) {
                    PatternViewer.this._stdSelectAction.setChecked(false);
                    PatternViewer.this._zoomInAction.setChecked(false);
                } else {
                    PatternViewer.this._stdSelectAction.setChecked(true);
                }
                page.getView().zoomOut(PatternViewer.this._zoomOut);
            }

            public int getStyle() {
                return 2;
            }
        };
        this._zoomOutAction.setText(strZoomOut);
        TracePluginImages.setImageDescriptors((IAction)this._zoomOutAction, "lcl16", "zoomout_nav.gif");
        this._zoomOutAction.setDescription(strZoomOut);
        this._zoomOutAction.setToolTipText(strZoomOut);
        Action openColorDialog = new Action(TraceUIPlugin.getString("OPEN_COLOR_DLG_TEXT")){

            public void run() {
                GraphColorDialog dialog = new GraphColorDialog(PatternViewer.this.getViewSite().getShell(), TraceUIPlugin.getString("STR_GRAPH_COLOR_DLG"), null);
                dialog.open();
            }
        };
        openColorDialog.setText(TraceUIPlugin.getString("OPEN_COLOR_DLG_TEXT"));
        TracePluginImages.setImageDescriptors((IAction)openColorDialog, "tool16", "opengraphcolor_co.gif");
        openColorDialog.setDescription(TraceUIPlugin.getString("OPEN_COLOR_DLG_TEXT"));
        openColorDialog.setToolTipText(TraceUIPlugin.getString("OPEN_COLOR_DLG_TEXT"));
        IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        IMenuManager menu = this.getViewSite().getActionBars().getMenuManager();
        MenuManager submenu = new MenuManager(TraceUIPlugin.getString("STR_SHOW_TIME"));
        menu.add((IContributionItem)submenu);
        submenu.add((IAction)this._showCompensatedTime);
        submenu.add((IAction)this._showRawTime);
        tbm.removeAll();
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this._stdSelectAction);
        tbm.add((IAction)this._zoomInAction);
        tbm.add((IAction)this._zoomOutAction);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this._reset);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)openColorDialog);
        this.getViewSite().getActionBars().updateActionBars();
    }

    public Action baseTime() {
        return this._showCompensatedTime;
    }

    public Action rawTime() {
        return this._showRawTime;
    }

    public void setFocus() {
        if (this.getCurrentPage() != null) {
            ((PatternPage)this.getCurrentPage()).setFocus();
        }
    }

    public EObject getObjectToView(EObject selObject) {
        if (selObject == null) {
            return selObject;
        }
        if (selObject instanceof TRCProcessProxy) {
            int nbOfAgents = 0;
            TRCAgentProxy a = null;
            EList agents = ((TRCProcessProxy)selObject).getAgentProxies();
            int idx = 0;
            while (idx < agents.size()) {
                TRCAgentProxy agent = (TRCAgentProxy)agents.get(idx);
                if (agent != null && !agent.eIsProxy() && agent.getType().equals("Profiler")) {
                    ++nbOfAgents;
                    a = agent;
                }
                ++idx;
            }
            if (nbOfAgents == 1) {
                return a;
            }
        }
        return selObject;
    }

    public String getViewTitle() {
        return TraceUIPlugin.getString("STR_EXEC_TITLE");
    }

    public void initializeActionBar() {
        this._stdSelectAction.setChecked(true);
    }
}

