/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCTraceObject;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.hyades.trace.views.adapter.internal.ExecutionStatisticPage;
import org.eclipse.hyades.trace.views.internal.StatisticView;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.ITimeChangedListener;
import org.eclipse.hyades.trace.views.util.internal.PerftraceUtil;
import org.eclipse.hyades.trace.views.util.internal.StatisticTableColumnInfo;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class ExecutionStatistic
extends StatisticView
implements ITimeChangedListener {
    protected String tmpString;
    private int _drawMode = TraceUIPlugin.getDefault().getPreferenceStore().getInt("time_display");

    protected Composite createTable(Composite parent, int options) {
        return new TableTree(parent, options);
    }

    public ExecutionStatistic(Composite parent, TraceViewerPage page) {
        super(parent, page);
        TraceUIPlugin.getDefault().addTimeChangedEventListener(this);
        this._viewerFilter = new ExecutionStatisticFilter();
    }

    public String getColumnsPreferencesKey() {
        return "Exec51";
    }

    public String getDefaultColumnsTemplate() {
        String executionColumn = TraceUIPlugin.getString("STR_THREAD_NAME") + ":0:" + String.valueOf(7) + ":left:200," + TraceUIPlugin.getString("STR_ST_INSTANCE_INDEX") + ":1:" + String.valueOf(1) + ":left:200," + TraceUIPlugin.getString("TITLE_START_TIME") + ":2:" + String.valueOf(1) + ":right:100," + TraceUIPlugin.getString("TITLE_TIME_ON_STACK") + ":3:" + String.valueOf(1) + ":right:100";
        return executionColumn;
    }

    public Table getTable() {
        return ((TableTree)this.getTableViewer().getControl()).getTable();
    }

    protected StructuredViewer createTableViewer(Composite table) {
        ExecutionTreeViewer tv = new ExecutionTreeViewer((TableTree)table);
        return tv;
    }

    protected void handleSelectionEvent() {
    }

    public void menuAboutToShow(IMenuManager menu) {
        menu.add((IContributionItem)this.fSeparator);
        menu.add((IAction)this.getUpdateAction());
        menu.add((IContributionItem)this.fSeparator);
        menu.add((IAction)this.getChooseColumnsAction(this.getColumnDataList(), this.getColumnsPreferencesKey()));
    }

    public void updateButtons() {
    }

    protected void updateDetailsPane() {
        int selIndex = this.getTable().getSelectionIndex();
        if (selIndex < 0) {
            return;
        }
        TableItem item = this.getTable().getItem(selIndex);
        Object itemData = item.getData();
        if (itemData == null) {
            return;
        }
        if (itemData != null && itemData instanceof TableTreeItem) {
            Object object = ((TableTreeItem)itemData).getData();
        }
    }

    public void updateModelSelection() {
        ISelection selection = this.getTableViewer().getSelection();
        if (selection != null && !selection.isEmpty()) {
            Object sel = ((IStructuredSelection)selection).getFirstElement();
            this.notifyViewSelectionChanged(this, sel);
        }
    }

    public void update() {
        if (this._firstTime) {
            this.getTableViewer().addFilter((ViewerFilter)this.getViewerFilter());
            this._firstTime = false;
            Table table = this.getTable();
            TableColumn firstColumn = table.getColumn(2);
            this._viewerSorter = new ExecutionStatisticSorter();
            this.getViewerSorter().setSortedColumn(firstColumn);
            this.getTableViewer().setSorter((ViewerSorter)this.getViewerSorter());
            this.handleTimeChangedEvent();
        }
        this.getTableViewer().setInput((Object)this._page.getMOFObject());
        this.getTable().setRedraw(false);
        this.getTableViewer().refresh();
        this.getTable().setRedraw(true);
        this.handleSelectionEvent();
    }

    public void handleTimeChangedEvent() {
        Action base = ((ExecutionStatisticPage)this.getTraceViewerPage()).baseTime();
        Action raw = ((ExecutionStatisticPage)this.getTraceViewerPage()).rawTime();
        this._drawMode = TraceUIPlugin.getDefault().getPreferenceStore().getInt("time_display");
        if (base != null) {
            base.setChecked(this._drawMode == 0);
        }
        if (raw != null) {
            raw.setChecked(this._drawMode == 1);
        }
        String oldName = TraceUIPlugin.getString("TITLE_RAW_TIME_ON_STACK");
        String newName = TraceUIPlugin.getString("TITLE_TIME_ON_STACK");
        if (this._drawMode == 1) {
            newName = TraceUIPlugin.getString("TITLE_RAW_TIME_ON_STACK");
            oldName = TraceUIPlugin.getString("TITLE_TIME_ON_STACK");
        }
        Table table = this.getTable();
        int idx = table.getColumnCount();
        while (idx > 0) {
            TableColumn col = table.getColumn(table.getColumnCount() - 1);
            StatisticTableColumnInfo staticTblColInfo = (StatisticTableColumnInfo)col.getData();
            String columnName = staticTblColInfo.getColumnData().name();
            if (columnName.equals(oldName)) {
                staticTblColInfo.getColumnData().name(newName);
                if (staticTblColInfo.isSortColumn()) {
                    newName = col.getText().substring(0, 1) + newName;
                }
                col.setText(newName);
            }
            --idx;
        }
        this.getTableViewer().refresh();
    }

    public void dispose() {
        super.dispose();
        TraceUIPlugin.getDefault().removeTimeChangedEventListener(this);
    }

    public IContentProvider getContentProvider() {
        return new ExecutionStatisticContentProvider();
    }

    public LabelProvider getTableLabelProvider() {
        return new ExecutionStatisticLableProvider(this);
    }

    public void handleViewSelectionChangedEvent(ViewSelectionChangedEvent event) {
        Object source = event.getSource();
        if (source != this) {
            this.handleSelectionEvent();
        }
    }

    public boolean isEmpty() {
        return PerftraceUtil.getAllThreads(this._page.getMOFObject()).length <= 0;
    }

    class ExecutionTreeViewer
    extends TableTreeViewer {
        public ExecutionTreeViewer(Composite parent) {
            super(parent);
        }

        public ExecutionTreeViewer(TableTree table) {
            super(table);
        }

        public void expandItem(TableTreeItem item) {
            item.setExpanded(true);
            this.createChildren((Widget)item);
        }
    }

    public class ExecutionStatisticLableProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected StatisticView _viewer;

        public ExecutionStatisticLableProvider(StatisticView viewer) {
            this._viewer = viewer;
        }

        public Image getColumnImage(Object obj, int col) {
            return null;
        }

        public String getColumnText(Object obj, int col) {
            int pos = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTable().getColumn(col)).getColumnData().getInitalPos();
            if (obj instanceof TRCThread && pos == 0) {
                return PerftraceUtil.getThreadName((TRCThread)obj);
            }
            if (obj instanceof TRCMethodInvocation) {
                switch (pos) {
                    case 0: {
                        return ((TRCMethodInvocation)obj).getMethod().getName();
                    }
                    case 1: {
                        TRCTraceObject tmpObject = ((TRCMethodInvocation)obj).getOwningObject();
                        TRCClass tmpClass = tmpObject.getIsA();
                        return tmpClass.getName() + "." + tmpObject.getId();
                    }
                    case 2: {
                        if (obj instanceof TRCFullMethodInvocation) {
                            return PerftraceUtil.formatTimeValue(((TRCFullMethodInvocation)obj).getEntryTime());
                        }
                    }
                    case 3: {
                        if (!(obj instanceof TRCFullMethodInvocation)) break;
                        TRCFullMethodInvocation tmpInv = (TRCFullMethodInvocation)obj;
                        double start = tmpInv.getEntryTime();
                        double end = tmpInv.getExitTime();
                        double overhead = tmpInv.getOverhead();
                        if (end == 0.0) {
                            end = tmpInv.getOwningObject().getProcess().getLastEventTime();
                        }
                        if (ExecutionStatistic.this._drawMode == 0) {
                            return PerftraceUtil.formatTimeValue(end - start - overhead);
                        }
                        return PerftraceUtil.formatTimeValue(end - start);
                    }
                }
            }
            return "";
        }
    }

    public class ExecutionStatisticContentProvider
    implements ITreeContentProvider {
        public void dispose() {
        }

        public Object getParent(Object element) {
            return null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return PerftraceUtil.getAllThreads(ExecutionStatistic.this._page.getMOFObject());
        }

        public Object[] getChildren(Object element) {
            ExecutionStatistic.this.tmpList.clear();
            if (element instanceof TRCThread) {
                return ((TRCThread)element).getInitialInvocations().toArray();
            }
            TRCMethodInvocation inv = (TRCMethodInvocation)element;
            Object[] segments = inv.getInvokes().toArray();
            int idx = 0;
            while (idx < segments.length) {
                ExecutionStatistic.this.tmpList.add((TRCMethodInvocation)segments[idx]);
                ++idx;
            }
            return ExecutionStatistic.this.tmpList.toArray();
        }

        public boolean hasChildren(Object element) {
            if (element instanceof TRCThread) {
                return true;
            }
            return ((TRCMethodInvocation)element).getInvokes().size() > 0;
        }
    }

    public class ExecutionStatisticSorter
    extends StatisticView.StatisticSorter {
        public ExecutionStatisticSorter() {
            super(ExecutionStatistic.this);
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            double d = 0.0;
            if (e1 instanceof TRCThread && e2 instanceof TRCThread && this._pos == 0) {
                return this._sortSequence * PerftraceUtil.getThreadName((TRCThread)e1).compareToIgnoreCase(PerftraceUtil.getThreadName((TRCThread)e2));
            }
            if (e1 instanceof TRCFullMethodInvocation && e2 instanceof TRCFullMethodInvocation) {
                TRCFullMethodInvocation inv1 = (TRCFullMethodInvocation)e1;
                TRCFullMethodInvocation inv2 = (TRCFullMethodInvocation)e2;
                if (this._pos == 0) {
                    return this._sortSequence * ((TRCMethodInvocation)e1).getMethod().getName().compareToIgnoreCase(((TRCMethodInvocation)e2).getMethod().getName());
                }
                if (this._pos == 1) {
                    return this._sortSequence * PerftraceUtil.getClass((TRCMethodInvocation)inv1).getName().compareToIgnoreCase(PerftraceUtil.getClass((TRCMethodInvocation)inv2).getName());
                }
                if (this._pos == 2) {
                    d = inv1.getEntryTime() - inv2.getEntryTime();
                    if (d < 0.0) {
                        return -1 * this._sortSequence;
                    }
                    if (d > 0.0) {
                        return this._sortSequence;
                    }
                    return 0;
                }
                if (this._pos == 3) {
                    double start = inv1.getEntryTime();
                    double end = inv1.getExitTime();
                    if (end == 0.0) {
                        end = inv1.getOwningObject().getProcess().getLastEventTime();
                    }
                    d = end - start;
                    start = inv2.getEntryTime();
                    end = inv2.getExitTime();
                    if (end == 0.0) {
                        end = inv2.getOwningObject().getProcess().getLastEventTime();
                    }
                    if ((d -= end - start) < 0.0) {
                        return -1 * this._sortSequence;
                    }
                    if (d > 0.0) {
                        return this._sortSequence;
                    }
                    return 0;
                }
            }
            return 0;
        }
    }

    public class ExecutionStatisticFilter
    extends StatisticView.StatisticFilter {
        public ExecutionStatisticFilter() {
            super(ExecutionStatistic.this);
        }

        public boolean select(Viewer viewer, Object parent, Object element) {
            boolean flag = true;
            if (!(element instanceof TRCThread)) {
                return true;
            }
            String compareText = "";
            compareText = ((TRCThread)element).getName();
            if (compareText.equals("")) {
                compareText = TraceUIPlugin.getString("DEFAULT_PACKAGE");
            }
            if (this._noPattern) {
                return true;
            }
            if (!this._caseSensitive) {
                compareText = compareText.toLowerCase();
            }
            if (this._exactMatch) {
                return compareText.compareTo(this._prefix) == 0;
            }
            if (this._prefix != "") {
                flag = compareText.startsWith(this._prefix);
            }
            if (flag && this._suffix != "") {
                flag = compareText.endsWith(this._suffix);
            }
            if (flag) {
                int k = 0;
                while (k < this._textList.size()) {
                    String str1 = (String)this._textList.get(k);
                    int index = compareText.lastIndexOf(str1);
                    if (index == -1) {
                        flag = false;
                        break;
                    }
                    compareText = compareText.substring(index + str1.length());
                    ++k;
                }
            }
            return flag;
        }
    }
}

