/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.IViewSelectionChangedListener;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.ColumnData;
import org.eclipse.hyades.trace.views.util.internal.ColumnsDialog;
import org.eclipse.hyades.trace.views.util.internal.IPercentChangedListener;
import org.eclipse.hyades.trace.views.util.internal.PerftraceUtil;
import org.eclipse.hyades.trace.views.util.internal.PrintColumnsDialog;
import org.eclipse.hyades.trace.views.util.internal.StatisticTableColumnInfo;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public abstract class StatisticView
implements IViewSelectionChangedListener,
SelectionListener,
ControlListener,
IPercentChangedListener {
    protected ArrayList tmpList;
    protected StructuredViewer _viewer;
    protected TableLayout _tableLayout;
    protected Composite _viewContainer;
    protected Composite _filterContainer;
    protected ViewForm _dataPane;
    protected Composite _viewComp;
    protected Text _filterText;
    protected Button _caseControl;
    protected boolean _initialized = false;
    protected TraceViewerPage _page;
    protected StatisticFilter _viewerFilter;
    protected StatisticSorter _viewerSorter;
    protected ArrayList _currentColumns = null;
    protected boolean _newSelection = false;
    protected boolean _isShowPercent = false;
    protected boolean _deltaColumns = false;
    protected boolean _refresh = false;
    protected Action _updateAction;
    protected Action _chooseColumnAction;
    protected Action _showPercent;
    protected Action _deltaColumnsAction;
    protected Action _printColumnsAction;
    protected Separator fSeparator;
    protected double _maxTime;
    protected int _totalInst;
    protected int _totalCalls;
    protected int _activeInst;
    protected long _totalSize;
    protected long _activeSize;
    protected ArrayList _listOfColumExtension = new ArrayList();
    protected String _templateOfColumExtension = "";
    protected boolean _firstTime = true;

    protected StatisticView(Composite parent, TraceViewerPage page) {
        this._page = page;
        this._currentColumns = ColumnData.createColumnData(this.getColumnsPreferencesKey(), this.getDefaultColumnsTemplate());
        ArrayList list = this.parseExtensions();
        if (list != null && list.size() != 0) {
            this._currentColumns.addAll(list);
        }
        this.createControl(parent, this._currentColumns);
        int perc = TraceUIPlugin.getDefault().getPreferenceStore().getInt("percent");
        if (perc == 1) {
            this._isShowPercent = true;
        }
        this.initialize();
        this.tmpList = new ArrayList();
        this.fSeparator = new Separator();
        TraceUIPlugin.getDefault().addPercentChangedEventListener(this);
    }

    private void setMenuListener(IMenuListener menuListener) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(menuListener);
        Menu menu = menuMgr.createContextMenu(this._viewer.getControl());
        this._viewer.getControl().setMenu(menu);
    }

    public void widgetSelected(SelectionEvent arg0) {
        if (arg0.widget instanceof TableColumn) {
            this._viewerSorter.setSortedColumn((TableColumn)arg0.widget);
            this._viewer.setSorter((ViewerSorter)this._viewerSorter);
            this._viewer.refresh();
        } else if (arg0.widget instanceof Table || arg0.widget instanceof TableTree) {
            this.updateModelSelection();
        } else if (arg0.widget instanceof Button && arg0.widget == this._caseControl) {
            this.filterNames();
        }
        this.updateButtons();
    }

    public abstract Table getTable();

    protected abstract IContentProvider getContentProvider();

    protected abstract void handleSelectionEvent();

    protected abstract StructuredViewer createTableViewer(Composite var1);

    protected abstract Composite createTable(Composite var1, int var2);

    protected abstract String getColumnsPreferencesKey();

    protected abstract String getDefaultColumnsTemplate();

    protected Composite getViewComponent() {
        return this._viewComp;
    }

    protected TraceViewerPage getTraceViewerPage() {
        return this._page;
    }

    protected ViewForm getDataPane() {
        return this._dataPane;
    }

    public void showNewSelection() {
        if (this._newSelection) {
            this.getTable().showSelection();
            this._newSelection = false;
        }
    }

    public boolean showingDeltaColumns() {
        return this._deltaColumns;
    }

    protected void setNewSelection() {
        this._newSelection = true;
    }

    public Action getUpdateAction() {
        if (this._updateAction == null) {
            this._updateAction = new UpdateAction(UIPlugin.getResourceString((String)"REFRESH_VIEWS"));
        }
        return this._updateAction;
    }

    public Action getDeltaColumnsAction() {
        if (this._deltaColumnsAction == null) {
            this._deltaColumnsAction = new DeltaColumnsAction(TraceUIPlugin.getString("STR_ST_SHOW_DELTA_COLUMNS"));
        }
        return this._deltaColumnsAction;
    }

    public Action getChooseColumnsAction(ArrayList cols, String key) {
        if (this._chooseColumnAction == null) {
            this._chooseColumnAction = new ChooseColumnsAction(TraceUIPlugin.getString("STR_ST_CHOOSE_COL"), cols, key);
        }
        return this._chooseColumnAction;
    }

    public Action getPrintColumnsAction() {
        if (this._printColumnsAction == null) {
            this._printColumnsAction = new PrintColumnsAction(TraceUIPlugin.getString("STR_ST_PRINT_COL"));
        }
        return this._printColumnsAction;
    }

    public Action getShowPercentAction() {
        if (this._showPercent == null) {
            this._showPercent = new ShowPercentAction(TraceUIPlugin.getString("SHOW_PERCENT"));
        }
        return this._showPercent;
    }

    public boolean isShowPercent() {
        return this._isShowPercent;
    }

    public Control getControl() {
        return this._viewContainer;
    }

    public ArrayList getColumnDataList() {
        return this._currentColumns;
    }

    public StructuredViewer getTableViewer() {
        return this._viewer;
    }

    public StatisticSorter getViewerSorter() {
        return this._viewerSorter;
    }

    public StatisticFilter getViewerFilter() {
        return this._viewerFilter;
    }

    public TableLayout getTableLayout() {
        return this._tableLayout;
    }

    protected abstract void updateButtons();

    public abstract void updateModelSelection();

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    public void controlMoved(ControlEvent arg0) {
    }

    public void controlResized(ControlEvent arg0) {
        Rectangle dataBounds = this.getViewComponent().getClientArea();
        this.getDataPane().setBounds(dataBounds.x, dataBounds.y, dataBounds.width, dataBounds.height);
        if (arg0.getSource() instanceof TableColumn) {
            TableColumn col = (TableColumn)arg0.getSource();
            StatisticTableColumnInfo columnInfo = (StatisticTableColumnInfo)col.getData();
            ColumnData.setColumns(this.getColumnDataList(), this.getColumnsPreferencesKey());
        }
    }

    public void menuAboutToShow(IMenuManager arg0) {
    }

    public void refresh() {
        if (this.isShowPercent()) {
            this._totalCalls = PerftraceUtil.getTotalCalls(this._page.getMOFObject());
            this._totalInst = PerftraceUtil.getTotalInstances(this._page.getMOFObject());
            this._activeInst = PerftraceUtil.getActiveInstances(this._page.getMOFObject());
            this._totalSize = PerftraceUtil.getTotalSize(this._page.getMOFObject());
            this._activeSize = PerftraceUtil.getActiveSize(this._page.getMOFObject());
            this._maxTime = PerftraceUtil.getMaximumTime(this._page.getMOFObject());
        }
        if (!this.getTableViewer().getControl().isDisposed()) {
            this.update();
        }
    }

    public void selectionChanged() {
        this.handleSelectionEvent();
    }

    protected void filterNames() {
        String pattern = this._filterText.getText().trim();
        this._viewerFilter.setPattern(pattern, this._caseControl.getSelection());
        this._viewer.getControl().setRedraw(false);
        this._viewer.refresh();
        this._viewer.getControl().setRedraw(true);
    }

    public void updateUI(ArrayList cols) {
        this.update();
        this.updateButtons();
    }

    public void update() {
        if (this._firstTime) {
            this._viewer.addFilter((ViewerFilter)this._viewerFilter);
            this._firstTime = false;
            Table table = this.getTable();
            TableColumn firstColumn = table.getColumn(0);
            this._viewerSorter.setSortedColumn(firstColumn);
            this._viewer.setSorter((ViewerSorter)this._viewerSorter);
        }
        this.getTableViewer().refresh();
    }

    protected void resetColumns(ArrayList list) {
        String sortedColumnName = "";
        int sortSequence = this._viewerSorter.getSortSequence();
        Table table = this.getTable();
        table.setRedraw(false);
        this._tableLayout = new TableLayout();
        table.setLayout((Layout)this._tableLayout);
        int idx = table.getColumnCount();
        while (idx > 0) {
            TableColumn col = table.getColumn(table.getColumnCount() - 1);
            StatisticTableColumnInfo staticTblColInfo = (StatisticTableColumnInfo)col.getData();
            if (staticTblColInfo.isSortColumn()) {
                sortedColumnName = staticTblColInfo.getColumnData().name();
            }
            col.dispose();
            --idx;
        }
        int idx2 = 0;
        while (idx2 < list.size()) {
            ColumnData data = (ColumnData)list.get(idx2);
            if (data.visible()) {
                StatisticTableColumnInfo staticTblColInfo = new StatisticTableColumnInfo(this, data, this._deltaColumns);
                if (data.name().equals(sortedColumnName)) {
                    staticTblColInfo.setSortColumn(true);
                }
            }
            ++idx2;
        }
        if (this._viewerSorter.resetSortColumn(this.getTable()) == null) {
            this._viewer.setSorter(null);
        } else {
            this._viewerSorter.setSortSequence(sortSequence * -1);
            this._viewerSorter.setSortedColumn(this._viewerSorter.resetSortColumn(this.getTable()));
            this._viewer.setSorter((ViewerSorter)this._viewerSorter);
        }
        table.layout(true);
        table.redraw();
        this._viewer.refresh();
        table.setRedraw(true);
    }

    private void createControl(Composite parent, ArrayList cols) {
        this._viewContainer = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this._viewContainer.setLayout((Layout)layout);
        this._viewContainer.setLayoutData((Object)GridUtil.createFill());
        this._filterContainer = new Composite(this._viewContainer, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        this._filterContainer.setLayout((Layout)layout);
        GridData data = GridUtil.createHorizontalFill();
        data.horizontalSpan = 2;
        this._filterContainer.setLayoutData((Object)data);
        this.createFilterControl(this._filterContainer);
        this._viewComp = new Composite(this._viewContainer, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        this._viewComp.setLayout((Layout)layout);
        data = GridUtil.createFill();
        data.horizontalSpan = 2;
        this._viewComp.setLayoutData((Object)data);
        this._dataPane = new ViewForm(this._viewComp, 0);
        Control table = this.createTableViewer((Composite)this._dataPane, cols);
        this._dataPane.setContent(table);
        this._dataPane.setLayoutData((Object)GridUtil.createFill());
        this._viewContainer.addControlListener((ControlListener)this);
    }

    private void createFilterControl(Composite parent) {
        Label filter = new Label(parent, 0);
        filter.setText(TraceUIPlugin.getString("STR_ST_FILTER"));
        this._filterText = new Text(parent, 2048);
        this._filterText.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._filterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent key) {
                if (key.character == '\r') {
                    StatisticView.this.filterNames();
                }
            }
        });
        this._caseControl = new Button(parent, 32);
        this._caseControl.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._caseControl.setText(TraceUIPlugin.getString("STR_ST_CASE_SENSITIVE"));
        this._caseControl.setSelection(true);
        this._caseControl.addSelectionListener((SelectionListener)this);
        WorkbenchHelp.setHelp((Control)this._filterText, (String)(TraceUIPlugin.getPluginId() + ".stvw0001"));
        WorkbenchHelp.setHelp((Control)this._caseControl, (String)(TraceUIPlugin.getPluginId() + ".stvw0002"));
    }

    private Control createTableViewer(Composite parent, ArrayList cols) {
        this._tableLayout = new TableLayout();
        Composite table = this.createTable(parent, 65540);
        this._viewer = this.createTableViewer(table);
        int idx = 0;
        while (idx < cols.size()) {
            ColumnData data = (ColumnData)cols.get(idx);
            if (data.visible()) {
                new StatisticTableColumnInfo(this, data, this._deltaColumns);
            }
            ++idx;
        }
        Table tbl = this.getTable();
        tbl.setLinesVisible(true);
        tbl.setHeaderVisible(true);
        tbl.setLayout((Layout)this._tableLayout);
        tbl.setLayoutData((Object)new GridData(1808));
        this._viewer.setContentProvider(this.getContentProvider());
        this._viewer.setLabelProvider((IBaseLabelProvider)this.getTableLabelProvider());
        if (table instanceof TableTree) {
            ((TableTree)table).addSelectionListener((SelectionListener)this);
        } else if (table instanceof Table) {
            ((Table)table).addSelectionListener((SelectionListener)this);
        }
        UIPlugin.getDefault().addViewSelectionChangedListener((IViewSelectionChangedListener)this);
        return this._viewer.getControl();
    }

    public void dispose() {
        TraceUIPlugin.getDefault().removePercentChangedEventListener(this);
        UIPlugin.getDefault().removeViewSelectionChangedListener((IViewSelectionChangedListener)this);
        this._page = null;
    }

    private void initialize() {
        if (this._initialized) {
            return;
        }
        this._initialized = true;
    }

    public abstract LabelProvider getTableLabelProvider();

    public void handlePercentChangedEvent() {
        this._isShowPercent = !this._isShowPercent;
        TraceUIPlugin.getDefault().getPreferenceStore().setValue("percent", this._isShowPercent ? 1 : 0);
        this.refresh();
        this.updateButtons();
    }

    private void printColumnsToHTML(String fileName) {
        String time;
        OutputStreamWriter writer = null;
        try {
            File file = new File(fileName);
            FileOutputStream outputStream = new FileOutputStream(file.toString(), false);
            writer = new OutputStreamWriter((OutputStream)outputStream, "UTF8");
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
        }
        String caption = this._page.getTraceViewer().getTitle();
        EObject element = this._page.getMOFObject();
        if (element != null && element instanceof TRCAgent && (time = String.valueOf(((TRCAgent)element).getStartTime())) != null) {
            caption = caption + " (" + time + ")";
        }
        String newLine = System.getProperties().getProperty("line.separator");
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html>" + newLine);
        buffer.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">" + newLine + "<head>" + newLine + "<STYLE TYPE=\"text/css\">" + newLine + "p, table, td, th {  font-family: arial, helvetica, geneva; font-size: 10pt}" + newLine + "body {  font-family: arial, helvetica, geneva; font-size: 10pt; clip:   rect(   ); margin-top: 5mm; margin-left: 3mm}" + newLine + "</STYLE>" + newLine + "</head>" + newLine);
        buffer.append("<body text=\"#000000\" bgcolor=\"#ffffff\">" + newLine);
        buffer.append("<table border=0 cellspacing=2 cellpadding=2 WIDTH=\"100%\">" + newLine);
        buffer.append("<caption align=top><B>" + newLine);
        buffer.append(caption + newLine);
        buffer.append("</B></caption>" + newLine);
        Table table = this.getTable();
        buffer.append("<tr>" + newLine);
        int idx = 0;
        while (idx < table.getColumnCount()) {
            if (idx != 1) {
                String columnText = table.getColumn(idx).getText();
                if (columnText.indexOf("<") == 0) {
                    columnText = "&lt;" + columnText.substring(1);
                } else if (columnText.indexOf(">") == 0) {
                    columnText = "&gt;" + columnText.substring(1);
                }
                buffer.append("<th align=left>" + columnText + "</th>" + newLine);
            }
            ++idx;
        }
        buffer.append("</tr>" + newLine);
        boolean color = true;
        int kdx = 0;
        while (kdx < table.getItemCount()) {
            if (color) {
                buffer.append("<tr BGCOLOR=\"#ffffbb\">" + newLine);
            } else {
                buffer.append("<tr>" + newLine);
            }
            color = !color;
            int ndx = 0;
            while (ndx < table.getColumnCount()) {
                if (ndx != 1) {
                    String itemText = table.getItem(kdx).getText(ndx);
                    buffer.append("<td align=left>" + itemText + "</td>" + newLine);
                }
                ++ndx;
            }
            buffer.append("</tr>" + newLine);
            ++kdx;
        }
        buffer.append("</table>" + newLine);
        buffer.append("</body>" + newLine);
        buffer.append("</html>" + newLine);
        try {
            writer.write(buffer.toString());
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected ArrayList parseExtensions() {
        return null;
    }

    public void notifyViewSelectionChanged(Object source, Object selection) {
        UIPlugin.getDefault().getSelectionModel(this._page.getMOFObject()).add(selection);
        ViewSelectionChangedEvent event = UIPlugin.getDefault().getViewSelectionChangedEvent();
        event.setSource(source);
        UIPlugin.getDefault().notifyViewSelectionChangedListener(event);
    }

    class DeltaColumnsAction
    extends Action {
        public DeltaColumnsAction(String name) {
            super(name);
            WorkbenchHelp.setHelp((IAction)this, (String)(TraceUIPlugin.getPluginId() + ".ccol0000"));
        }

        public void run() {
            StatisticView.this._deltaColumns = !StatisticView.this._deltaColumns;
            StatisticView.this.resetColumns(StatisticView.this._currentColumns);
        }
    }

    class ShowPercentAction
    extends Action {
        public ShowPercentAction(String name) {
            super(name);
            WorkbenchHelp.setHelp((IAction)this, (String)(TraceUIPlugin.getPluginId() + ".clst0003"));
        }

        public void setChecked(boolean value) {
            super.setChecked(value);
        }

        public void run() {
            TraceUIPlugin.getDefault().notifyPercentChangedEventListener();
        }
    }

    class PrintColumnsAction
    extends Action {
        public PrintColumnsAction(String name) {
            super(name);
        }

        public void run() {
            PrintColumnsDialog dialog = new PrintColumnsDialog(StatisticView.this.getControl().getShell(), TraceUIPlugin.getString("STR_ST_PRINT_COL"), null);
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                StatisticView.this.printColumnsToHTML(dialog.getFileName());
            }
        }
    }

    class ChooseColumnsAction
    extends Action {
        private ArrayList _cols;
        private String _key;

        public ChooseColumnsAction(String name, ArrayList cols, String key) {
            super(name);
            this._cols = cols;
            this._key = key;
            WorkbenchHelp.setHelp((IAction)this, (String)(TraceUIPlugin.getPluginId() + ".ccol0000"));
        }

        public void run() {
            ColumnsDialog dialog = new ColumnsDialog(StatisticView.this.getControl().getShell(), TraceUIPlugin.getString("STR_ST_COL_SETTINGS"), null, this._cols, StatisticView.this.getDefaultColumnsTemplate());
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                ColumnData.setColumns(dialog.getData(), this._cols, this._key);
                StatisticView.this.resetColumns(this._cols);
            }
        }
    }

    class UpdateAction
    extends Action {
        public UpdateAction(String name) {
            super(name);
            WorkbenchHelp.setHelp((IAction)this, (String)(TraceUIPlugin.getPluginId() + ".uvew0000"));
            PDPluginImages.setImageDescriptors((IAction)this, (String)"lcl16", (String)"updateviews_co.gif");
        }

        public void run() {
            ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
            event.setSource((Object)StatisticView.this._page.getMOFObject());
            event.setType(32);
            UIPlugin.getDefault().notifyProfileEventListener(event);
        }
    }

    public class StatisticFilter
    extends ViewerFilter {
        protected String _pattern;
        protected String _prefix = "";
        protected String _suffix = "";
        protected ArrayList _textList;
        protected boolean _caseSensitive = true;
        protected boolean _exactMatch;
        protected boolean _noPattern = true;

        public void setPattern(String pattern, boolean caseSensitive) {
            this._caseSensitive = caseSensitive;
            this._pattern = this._caseSensitive ? pattern : pattern.toLowerCase();
            this._noPattern = pattern == "*" || pattern == "";
            this._exactMatch = this._pattern.indexOf("*") == -1;
            StringTokenizer st = new StringTokenizer(this._pattern, "*");
            this._textList = new ArrayList();
            while (st.hasMoreTokens()) {
                this._textList.add(st.nextToken());
            }
            if (this._pattern.startsWith("*")) {
                this._prefix = "";
            } else if (this._textList.size() > 0) {
                this._prefix = (String)this._textList.get(0);
                this._textList.remove(0);
            }
            if (this._pattern.endsWith("*")) {
                this._suffix = "";
            } else if (this._textList.size() > 0) {
                this._suffix = (String)this._textList.get(this._textList.size() - 1);
                this._textList.remove(this._textList.size() - 1);
            }
        }

        public boolean select(Viewer viewer, Object parent, Object element) {
            boolean flag = true;
            if (this._noPattern) {
                return true;
            }
            String compareText = "";
            if (element instanceof TRCPackage) {
                compareText = ((TRCPackage)element).getName();
                if (compareText.equals("")) {
                    compareText = TraceUIPlugin.getString("DEFAULT_PACKAGE");
                }
            } else if (element instanceof TRCClass) {
                compareText = ((TRCClass)element).getName();
            } else if (element instanceof TRCMethod) {
                compareText = ((TRCMethod)element).getName() + ((TRCMethod)element).getSignature();
            } else if (element instanceof TRCObject) {
                TRCObject obj = (TRCObject)element;
                compareText = obj.getIsA().getName();
            }
            if (!this._caseSensitive) {
                compareText = compareText.toLowerCase();
            }
            if (this._exactMatch) {
                return compareText.compareTo(this._prefix) == 0;
            }
            if (this._prefix != "") {
                flag = compareText.startsWith(this._prefix);
            }
            if (flag && this._suffix != "") {
                flag = compareText.endsWith(this._suffix);
            }
            if (flag) {
                int k = 0;
                while (k < this._textList.size()) {
                    String str1 = (String)this._textList.get(k);
                    int index = compareText.lastIndexOf(str1);
                    if (index == -1) {
                        flag = false;
                        break;
                    }
                    compareText = compareText.substring(index + str1.length());
                    ++k;
                }
            }
            return flag;
        }
    }

    public abstract class StatisticSorter
    extends ViewerSorter {
        protected TableColumn _sortColumn;
        protected int _sortSequence = -1;
        protected StatisticTableColumnInfo _info;
        protected int _pos = 0;

        public void setSortedColumn(TableColumn newSortColumn) {
            String text;
            this._sortColumn = newSortColumn;
            TableColumn currentColumn = this.getCurrentSortColumn(newSortColumn.getParent());
            if (currentColumn != null) {
                text = currentColumn.getText();
                if (text.startsWith(">") || text.startsWith("<")) {
                    text = text.substring(1);
                }
                this._sortSequence = currentColumn == newSortColumn ? -this._sortSequence : -1;
                currentColumn.setText(text);
                StatisticTableColumnInfo.getStatisticTableColumnInfo(currentColumn).setSortColumn(false);
            } else {
                this._sortSequence = 1;
            }
            text = newSortColumn.getText();
            this._info = StatisticTableColumnInfo.getStatisticTableColumnInfo(newSortColumn);
            this._pos = this._info.getColumnData().getInitalPos();
            newSortColumn.setText((this._sortSequence > 0 ? ">" : "<") + text);
            StatisticTableColumnInfo.getStatisticTableColumnInfo(newSortColumn).setSortColumn(true);
        }

        protected int getSortSequence() {
            return this._sortSequence;
        }

        protected void setSortSequence(int sortSequence) {
            this._sortSequence = sortSequence;
        }

        private TableColumn getCurrentSortColumn(Table table) {
            int idx = 0;
            while (idx < table.getColumnCount()) {
                if (StatisticTableColumnInfo.getStatisticTableColumnInfo(table.getColumn(idx)).isSortColumn()) {
                    return table.getColumn(idx);
                }
                ++idx;
            }
            return null;
        }

        public TableColumn resetSortColumn(Table table) {
            this._sortColumn = this.getCurrentSortColumn(table);
            return this._sortColumn;
        }
    }
}

