/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sd.logc.internal.loader;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.sd.logc.SDLogcPlugin;
import org.eclipse.hyades.sd.logc.SDLogcPluginImages;
import org.eclipse.hyades.sd.logc.internal.loader.LogInteractions;
import org.eclipse.hyades.uml2sd.ui.core.LifelineCategories;

public class LogThreadInteractions
extends LogInteractions {
    private List threadIDs = new UniqueEList();

    protected void loadEvents() {
        if (!this.isDisplayingOnlyCorrelations()) {
            this.loadThreadIdsFromAgentList(true);
        } else {
            this.loadThreadIdsFromAgentList(false);
            this.loadEventsFromCorrelations();
        }
    }

    private void loadThreadIdsFromAgentList(boolean addEvents) {
        Iterator iter = this.agentsList.iterator();
        while (iter.hasNext()) {
            TRCAgentProxy trcAgentProxy = (TRCAgentProxy)iter.next();
            if (trcAgentProxy == null || trcAgentProxy.eIsProxy()) continue;
            this.loadThreadIdsFromAgent(trcAgentProxy);
            if (!addEvents) continue;
            this.addEvents(trcAgentProxy);
        }
    }

    private void loadThreadIdsFromAgent(TRCAgentProxy agentProxy) {
        EList events = agentProxy.getAgent().getDefaultEvents();
        CBECommonBaseEvent artifact = null;
        String threadID = null;
        Iterator iter = events.iterator();
        while (iter.hasNext()) {
            artifact = (CBECommonBaseEvent)iter.next();
            threadID = artifact.getSourceComponentId().getThreadId();
            if (threadID == null) {
                threadID = "-1";
            }
            this.threadIDs.add(agentProxy.getName() + " - " + "TID:" + threadID);
        }
    }

    protected void generateLifelines() {
        String id = null;
        Iterator iter = this.getLifelineArtifactsList().iterator();
        while (iter.hasNext()) {
            id = (String)iter.next();
            LogInteractions.TraceLifeline lifeLine = new LogInteractions.TraceLifeline();
            lifeLine.setName(id);
            lifeLine.setCategory(0);
            this.frame.addLifeLine(lifeLine);
            this.lifelinesMap.put(id, lifeLine);
        }
    }

    protected Object getLifelinesMapKey(CBECommonBaseEvent element) {
        String threadID = element.getSourceComponentId().getThreadId();
        if (threadID == null) {
            threadID = "-1";
        }
        return element.getAgent().getAgentProxy().getName() + " - " + "TID:" + threadID;
    }

    public String getTitleString() {
        String title = SDLogcPlugin.getString("STR_VIEW_TITLE") + ": " + SDLogcPlugin.getString("STR_MENU_LOT");
        if (this.correlationContainerProxy != null) {
            title = title + " <" + this.correlationContainerProxy.getCorrelationEngine().getName() + "> ";
        }
        return title;
    }

    protected List getLifelineArtifactsList() {
        return this.threadIDs;
    }

    protected void clearDiagramCaches() {
        this.threadIDs.clear();
        super.clearDiagramCaches();
    }

    protected String getFrameTitle() {
        return SDLogcPlugin.getString("STR_MENU_LOT") + ":      " + this.getFrameName();
    }

    static {
        LogInteractions.traceCategories = new LifelineCategories[1];
        LogInteractions.traceCategories[0] = new LifelineCategories();
        LogInteractions.traceCategories[0].setName("");
        LogInteractions.image = SDLogcPluginImages.getImage("thread_obj.gif");
        LogInteractions.traceCategories[0].setImage(LogInteractions.image);
    }
}

