/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.config.sensors;

import java.util.Hashtable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.impl.Sensor;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.impl.SimpleEventFactoryHomeImpl;
import org.eclipse.hyades.logging.parsers.IParser;
import org.eclipse.hyades.logging.parsers.Parser;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class StaticParserSensor
extends Sensor {
    public static final String PATH_SEPARATOR = System.getProperty("file.separator");
    protected String parserClassName = null;
    protected Parser parser = null;
    private String directory = null;
    private String fileName = null;
    protected String rawLogFileName = null;

    public void stop() {
        super.stop();
        this.clean();
    }

    public void update() throws AdapterInvalidConfig {
        super.update();
        String directory = null;
        String fileName = null;
        String className = null;
        String propertyName = null;
        String propertyValue = null;
        Element sensorProperty = null;
        Element sensorTypeInstance = null;
        Element element = this.getConfiguration();
        Hashtable<String, Object> parserParameters = this.getProperties();
        if (parserParameters != null && !parserParameters.isEmpty()) {
            directory = (String)parserParameters.get(Messages.getString((String)"HyadesGAdirectoryAttributeName"));
            fileName = (String)parserParameters.get(Messages.getString((String)"HyadesGAfileNameAttributeName"));
            className = (String)parserParameters.get(Messages.getString((String)"HyadesGAstaticParserClassAttributeName"));
        } else {
            parserParameters = new Hashtable<String, Object>();
            NodeList sensorNodes = element.getChildNodes();
            int i = 0;
            while (i < sensorNodes.getLength()) {
                Element sensorNode;
                if (sensorNodes.item(i).getNodeType() == 1 && (sensorNode = (Element)sensorNodes.item(i)).getTagName().equals(Messages.getString((String)"HyadesGAStaticParserSensorTagName"))) {
                    String file;
                    String dir;
                    sensorTypeInstance = sensorNode;
                    if (sensorTypeInstance.hasAttribute(Messages.getString((String)"HyadesGAdirectoryAttributeName")) && (dir = sensorTypeInstance.getAttribute(Messages.getString((String)"HyadesGAdirectoryAttributeName"))) != null && dir.length() > 0 && directory == null) {
                        directory = dir;
                    }
                    if (sensorTypeInstance.hasAttribute(Messages.getString((String)"HyadesGAfileNameAttributeName")) && (file = sensorTypeInstance.getAttribute(Messages.getString((String)"HyadesGAfileNameAttributeName"))) != null && file.length() > 0 && fileName == null) {
                        fileName = file;
                    }
                    if (sensorTypeInstance.hasAttribute(Messages.getString((String)"HyadesGAstaticParserClassAttributeName"))) {
                        className = sensorTypeInstance.getAttribute(Messages.getString((String)"HyadesGAstaticParserClassAttributeName"));
                    }
                    sensorNodes = sensorNode.getChildNodes();
                    int j = 0;
                    while (j < sensorNodes.getLength()) {
                        if (sensorNodes.item(j).getNodeType() == 1) {
                            sensorProperty = (Element)sensorNodes.item(j);
                            if (sensorProperty.hasAttribute(Messages.getString((String)"HyadesGASensorPropertyNameAttributeName"))) {
                                propertyName = sensorProperty.getAttribute(Messages.getString((String)"HyadesGASensorPropertyNameAttributeName"));
                            }
                            if (sensorProperty.hasAttribute(Messages.getString((String)"HyadesGASensorPropertyValueAttributeName"))) {
                                propertyValue = sensorProperty.getAttribute(Messages.getString((String)"HyadesGASensorPropertyValueAttributeName"));
                            }
                            if (propertyName != null && propertyName.length() > 0 && propertyValue != null && propertyValue.length() > 0) {
                                parserParameters.put(propertyName, propertyValue);
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        if (directory == null || directory.length() == 0 || fileName == null || fileName.length() == 0 || className == null || className.length() == 0) {
            throw new AdapterInvalidConfig(Messages.getString((String)"HyadesGA_CBE_StaticParserSensor_Invalid_Config_File_ERROR_"));
        }
        this.setDirectory(directory);
        this.setFileName(fileName);
        this.setParserClassName(className);
        this.rawLogFileName = this.getDirectory().endsWith(PATH_SEPARATOR) ? this.getDirectory() + this.getFileName() : this.getDirectory() + PATH_SEPARATOR + this.getFileName();
        parserParameters.put("file_path", this.rawLogFileName);
        parserParameters.put("array_size", new Integer(this.maximumBlocking));
        this.parser = (Parser)this.getParser(this.getParserClassName());
        if (this.parser != null) {
            try {
                this.parser.setConfiguration(parserParameters);
                this.parser.preParse();
            }
            catch (Throwable e) {
                throw new AdapterInvalidConfig(e);
            }
        }
    }

    public Object[] testGetNext() {
        Object[] eventArray = new CommonBaseEvent[]{new SimpleEventFactoryHomeImpl().getEventFactory("org.eclipse.hyades.logging.adapter.config.sensors.StaticParserSensor").createCommonBaseEvent()};
        return eventArray;
    }

    public Object[] getNext() {
        if (this.parser == null || this.flushingMode) {
            return null;
        }
        Object[] messages = null;
        try {
            messages = this.parser.parseNext();
        }
        catch (Throwable t) {
            CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
            event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_File_Parsing_ERROR_");
            event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.rawLogFileName, t.toString()});
            event.setSeverity((short)60);
            this.log(event);
        }
        if (messages != null && messages[0] != null) {
            return messages;
        }
        return null;
    }

    public void clean() {
        try {
            if (this.parser != null) {
                this.parser.postParse();
            }
        }
        catch (Exception e) {
            CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
            event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_File_Parsing_ERROR_");
            event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.rawLogFileName, e.toString()});
            event.setSeverity((short)60);
            this.log(event);
        }
    }

    public final String getDirectory() {
        return this.directory;
    }

    public final String getFileName() {
        return this.fileName;
    }

    public final void setDirectory(String directory) {
        this.directory = directory;
    }

    public final void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getParserClassName() {
        return this.parserClassName;
    }

    public void setParserClassName(String string) {
        this.parserClassName = string;
    }

    /*
     * Unable to fully structure code
     */
    public IParser getParser(String classname) {
        block6: {
            parser = null;
            try {
                parser = (IParser)Class.forName(this.getParserClassName()).newInstance();
                break block6;
            }
            catch (Throwable t) {
                elements = Platform.getPluginRegistry().getConfigurationElementsFor("org.eclipse.hyades.logging.adapter.config", "staticParser");
                i = 0;
                ** while (i < elements.length)
            }
lbl-1000:
            // 1 sources

            {
                elem = elements[i];
                if (elem.getAttribute("name").equals(classname)) {
                    try {
                        parser = (IParser)elem.createExecutableExtension("name");
                        break;
                    }
                    catch (Throwable e) {
                        event = this.getEventFactory().createCommonBaseEvent();
                        event.setMsg(e.toString());
                        event.setSeverity((short)30);
                        this.log(event);
                    }
                }
                ++i;
                continue;
            }
        }
        return parser;
    }
}

