/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;

public class KeystoreHelper {
    public static KeyStore createKeyStore(String pathname, String password) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, NoSuchProviderException {
        KeyStore ks = KeyStore.getInstance("JKS");
        File file = new File(pathname);
        if (file.exists()) {
            return KeystoreHelper.loadKeyStore(pathname, password);
        }
        ks.load(null, password.toCharArray());
        KeystoreHelper.persistKeyStore(ks, pathname, password);
        return ks;
    }

    public static KeyStore loadKeyStore(String pathname, String password) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, NoSuchProviderException {
        KeyStore ks = null;
        File file = new File(pathname);
        if (file.exists()) {
            ks = KeyStore.getInstance("JKS");
            FileInputStream is = new FileInputStream(file);
            ks.load(is, password.toCharArray());
            is.close();
        }
        return ks;
    }

    public static Certificate loadCertificate(String certFilename) throws CertificateException, FileNotFoundException {
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        return factory.generateCertificate(new FileInputStream(certFilename));
    }

    public static void addCertificateToKeyStore(KeyStore ks, Certificate cert, String alias) throws KeyStoreException {
        ks.setCertificateEntry(alias, cert);
    }

    public static void persistKeyStore(KeyStore ks, String pathname, String password) throws KeyStoreException, FileNotFoundException, NoSuchAlgorithmException, CertificateException, IOException {
        FileOutputStream os = new FileOutputStream(pathname);
        ks.store(os, password.toCharArray());
        os.close();
    }
}

