/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.internal.ui;

import java.util.Iterator;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.models.hierarchy.util.IUnresolvedResourceHelper;
import org.eclipse.hyades.trace.internal.ui.PDContentProvider;
import org.eclipse.hyades.trace.internal.ui.PDLabelProvider;
import org.eclipse.hyades.trace.internal.ui.PDProjectViewer;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.IProfileEventListener;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.actions.TraceNavigatorActionGroup;
import org.eclipse.hyades.trace.ui.internal.core.TraceAssociationManager;
import org.eclipse.hyades.trace.ui.internal.util.UnresolvedResourceHelper;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.ui.internal.navigator.Navigator;
import org.eclipse.hyades.ui.internal.navigator.action.NavigatorActionGroup;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class PDProjectExplorer
extends Navigator
implements IProfileEventListener,
IPropertyListener {
    public static final String ID = "org.eclipse.hyades.trace.ui.profileNavigator";
    private final String TRACE_SECTION = "TraceNavigator";
    protected TraceNavigatorActionGroup actionGroup;

    public PDProjectExplorer() {
        super(ID);
        IUnresolvedResourceHelper ue = HierarchyResourceSetImpl.getInstance().getUnresolvedException();
        if (ue != null && ue instanceof UnresolvedResourceHelper) {
            ((UnresolvedResourceHelper)ue).setPDProjectExplorer(this);
        }
    }

    public void createPartControl(Composite parent) {
        TraceAssociationManager.getTraceViewMappingRegistry().addCommitChangeListener((IPropertyListener)this);
        super.createPartControl(parent);
        this.initListeners();
        UIPlugin.getDefault().addSelectionProvider((ISelectionProvider)this.getViewer(), (IWorkbenchPart)this);
        UIPlugin.getDefault().addProfileEventListener(this);
        new RefreshUI().start();
    }

    protected void updateActionBars(IStructuredSelection selection) {
        TraceNavigatorActionGroup group = (TraceNavigatorActionGroup)this.getActionGroup(false);
        if (group != null) {
            group.setContext(new ActionContext((ISelection)selection));
            group.updateActionBars();
        }
    }

    public void updateActionBars() {
        TraceNavigatorActionGroup group = (TraceNavigatorActionGroup)this.getActionGroup(false);
        if (group != null) {
            group.updateActionBars();
        }
    }

    public void dispose() {
        TraceAssociationManager.getTraceViewMappingRegistry().removeCommitChangeListener((IPropertyListener)this);
        if (this.getActionGroup(true) != null) {
            this.getActionGroup(true).dispose();
            this.actionGroup = null;
        }
        UIPlugin.getDefault().removeProfileEventListener(this);
        if (this.getViewer() != null) {
            UIPlugin.getDefault().removeSelectionProvider((ISelectionProvider)this.getViewer(), (IWorkbenchPart)this);
        }
        HyadesUtil.cleanupResources("org.eclipse.hyades.trace.internal.ui.PDProjectExplorer");
        super.dispose();
    }

    public Control getControl() {
        return this.getViewer().getControl();
    }

    public void refresh() {
        this.getViewer().refresh();
    }

    protected void initContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                PDProjectExplorer.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)((PDProjectViewer)this.getViewer()).getTree());
        ((PDProjectViewer)this.getViewer()).getTree().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.getViewer());
    }

    protected void initListeners() {
        this.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                PDProjectExplorer.this.handleDoubleClick(event);
            }
        });
    }

    public void fillContextMenu(IMenuManager menu) {
        IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
        this.getActionGroup(false).setContext(new ActionContext((ISelection)selection));
        this.getActionGroup(false).fillContextMenu(menu);
    }

    public static PDProjectExplorer getFromActivePerspective() {
        IViewPart view = UIPlugin.getActivePage().findView("org.eclipse.hyades.trace.internal.ui.PDProjectExplorer");
        if (view instanceof PDProjectExplorer) {
            return (PDProjectExplorer)view;
        }
        return null;
    }

    protected String getToolTipText() {
        return UIPlugin.getResourceString("PDPROEXPTOOLTIP");
    }

    protected NavigatorActionGroup getActionGroup() {
        return this.actionGroup;
    }

    protected NavigatorActionGroup getActionGroup(boolean dispose) {
        if (!dispose && this.actionGroup == null) {
            this.createActions();
        }
        return this.getActionGroup();
    }

    protected void setActionGroup(TraceNavigatorActionGroup actionGroup) {
        this.actionGroup = actionGroup;
    }

    protected void handleDoubleClick(DoubleClickEvent event) {
        ((TraceNavigatorActionGroup)this.getActionGroup(false)).handleDoubleClick(event);
    }

    public void refreshView(Object selection) {
        this.getViewer().refresh();
        ((PDProjectViewer)this.getViewer()).selectObject(selection);
    }

    public void selectObject(Object item) {
        ((PDProjectViewer)this.getViewer()).selectObject(item);
    }

    public void setFocus() {
        if (this.getViewer() != null) {
            ((PDProjectViewer)this.getViewer()).getTree().setFocus();
        }
    }

    public void handleProfileEvent(ProfileEvent event) {
        switch (event.getType()) {
            case 1: {
                ((PDProjectViewer)this.getViewer()).selectObject(event.getSource());
                break;
            }
            case 4: {
                ((PDProjectViewer)this.getViewer()).selectObject(event.getSource());
                break;
            }
            case 4096: {
                break;
            }
            case 4608: {
                break;
            }
            default: {
                ((PDProjectViewer)this.getViewer()).refresh(event.getSource());
            }
        }
    }

    public void propertyChanged(Object source, int propId) {
        ((TraceNavigatorActionGroup)this.getActionGroup(false)).propertyChanged(source, propId);
    }

    public void setLinkingEnabled(boolean enabled) {
        super.setLinkingEnabled(enabled);
        if (enabled && this.getViewer() != null) {
            this.getViewer().setSelection(this.getViewer().getSelection());
        }
    }

    public AbstractUIPlugin getPlugin() {
        return UIPlugin.getDefault();
    }

    public String getStoreSection() {
        return "TraceNavigator";
    }

    protected void createActions() {
        this.setActionGroup(new TraceNavigatorActionGroup((INavigator)this));
    }

    protected Object createViewerInput() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    protected StructuredViewer createViewer(Composite parent) {
        PDProjectViewer viewer = new PDProjectViewer(parent);
        viewer.setContentProvider((IContentProvider)new PDContentProvider(this));
        viewer.setLabelProvider((IBaseLabelProvider)new PDLabelProvider());
        return viewer;
    }

    protected boolean editorActivated(IEditorPart editor) {
        return false;
    }

    protected void linkToEditor(IStructuredSelection selection) {
    }

    public boolean isShowingFolders() {
        return false;
    }

    public Shell getShell() {
        return this.getViewSite().getShell();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
    }

    public void clear() {
        Iterator docs = HierarchyResourceSetImpl.getInstance().getResources().iterator();
        int counter = 0;
        while (docs.hasNext()) {
            ++counter;
            docs.next();
        }
        if (counter < 2) {
            if (this.getActionGroup(true) != null) {
                this.getActionGroup(true).dispose();
                this.actionGroup = null;
            }
            ProfileEvent event = new ProfileEvent();
            event.setSource(null);
            event.setType(4096);
            UIPlugin.getDefault().notifyProfileEventListener(event);
        }
        this.refresh();
    }

    public void selectionChanged(SelectionChangedEvent event) {
    }

    public void partActivated(IWorkbenchPart part) {
        super.partActivated(part);
        if (part == this) {
            this.getViewer().setSelection((ISelection)((Navigator)part).getStructuredSelection());
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
        super.partBroughtToTop(part);
        if (part == this) {
            this.getViewer().setSelection((ISelection)((Navigator)part).getStructuredSelection());
        }
    }

    class RefreshUI
    extends Thread {
        public RefreshUI() {
            super("Profile_Refresh");
        }

        public void run() {
            while (PDProjectExplorer.this.getViewer() != null) {
                try {
                    IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
                    int refreshType = store.getInt("refresh_type");
                    Display display = Display.getDefault();
                    if (refreshType == 1 && display != null && !display.isDisposed()) {
                        display.asyncExec(new Runnable(this){
                            private final /* synthetic */ RefreshUI this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void run() {
                                EObject data;
                                TreeItem item = ((PDProjectViewer)RefreshUI.access$000(this.this$1).getViewer()).getTreeSelection();
                                if (item != null && item.getData() instanceof EObject && RefreshUI.access$100(this.this$1, data = (EObject)item.getData())) {
                                    ProfileEvent event = UIPlugin.getDefault().getUpdateModelEvent(data);
                                    UIPlugin.getDefault().notifyProfileEventListener(event);
                                }
                            }
                        });
                    }
                    Thread.sleep(store.getInt("refresh_int") * 1000);
                }
                catch (InterruptedException exc) {
                    // empty catch block
                }
            }
        }

        private boolean isModified(Object selObject) {
            if (selObject != null) {
                if (selObject instanceof TRCAgentProxy) {
                    return this.isAgentModified((TRCAgentProxy)selObject);
                }
                if (selObject instanceof TRCProcessProxy) {
                    Object[] agents = ((TRCProcessProxy)selObject).getAgentProxies().toArray();
                    int idx = 0;
                    while (idx < agents.length) {
                        boolean isModified = this.isAgentModified((TRCAgentProxy)agents[idx]);
                        if (isModified) {
                            return true;
                        }
                        ++idx;
                    }
                    return false;
                }
                if (selObject instanceof TRCNode) {
                    Object[] processes = ((TRCNode)selObject).getProcessProxies().toArray();
                    int idx = 0;
                    while (idx < processes.length) {
                        Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                        int i = 0;
                        while (i < agents.length) {
                            boolean isModified = this.isAgentModified((TRCAgentProxy)agents[i]);
                            if (isModified) {
                                return true;
                            }
                            ++i;
                        }
                        ++idx;
                    }
                    return false;
                }
                if (selObject instanceof TRCMonitor) {
                    Object[] nodes = ((TRCMonitor)selObject).getNodes().toArray();
                    int k = 0;
                    while (k < nodes.length) {
                        Object[] processes = ((TRCNode)nodes[k]).getProcessProxies().toArray();
                        int idx = 0;
                        while (idx < processes.length) {
                            Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                            int i = 0;
                            while (i < agents.length) {
                                boolean isModified = this.isAgentModified((TRCAgentProxy)agents[i]);
                                if (isModified) {
                                    return true;
                                }
                                ++i;
                            }
                            ++idx;
                        }
                        ++k;
                    }
                    return false;
                }
            }
            return false;
        }

        private boolean isAgentModified(TRCAgentProxy agent) {
            if (agent.getType().equals("Profiler")) {
                if (agent.isCollectionData()) {
                    return true;
                }
                if (agent.getAgent() != null && agent.getAgent().eResource() != null && agent.getAgent().eResource().isModified()) {
                    agent.getAgent().eResource().setModified(false);
                    return true;
                }
                return false;
            }
            if (agent.getAgent() != null && agent.getAgent().eResource() != null && agent.getAgent().eResource().isModified()) {
                agent.getAgent().eResource().setModified(false);
                return true;
            }
            return false;
        }

        static /* synthetic */ PDProjectExplorer access$000(RefreshUI x0) {
            return x0.PDProjectExplorer.this;
        }

        static /* synthetic */ boolean access$100(RefreshUI x0, Object x1) {
            return x0.isModified(x1);
        }
    }
}

