/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.actions;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.actions.DeleteAction;
import org.eclipse.hyades.trace.ui.internal.actions.OpenWizardAction;
import org.eclipse.hyades.trace.ui.internal.actions.RefreshFromLocalAction;
import org.eclipse.hyades.trace.ui.internal.actions.RefreshTreeAction;
import org.eclipse.hyades.trace.ui.internal.actions.SaveAction;
import org.eclipse.hyades.trace.ui.internal.actions.ToggleLinkingAction;
import org.eclipse.hyades.trace.ui.internal.core.TraceAssociationManager;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.IAssociationMapping;
import org.eclipse.hyades.ui.extension.IAssociationMappingRegistry;
import org.eclipse.hyades.ui.extension.INavigatorItem;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.ui.internal.navigator.action.NavigatorActionGroup;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.ExportResourcesAction;
import org.eclipse.ui.actions.ImportResourcesAction;

public class TraceLogActionGroup
extends NavigatorActionGroup {
    protected DeleteAction fDeleteAction;
    protected OpenWizardAction fOpenLogAgentAction;
    protected OpenWizardAction fOpenNodeAction;
    protected SaveAction fSaveToFile;
    protected ToggleLinkingAction toggleLinkingAction;
    protected RefreshTreeAction fRefreshTree;
    protected RefreshFromLocalAction fRefreshLocal;
    protected Separator fRefreshGrp;
    protected ActionGroup fImportActionGroup;
    protected Separator fAttachGrp;
    protected Separator fMonitorGrp;
    protected Separator fTerminateGrp;
    protected Separator fNewSnapshotGrp;
    protected Separator fGCGroup;
    protected final String GROUP_ADD_VIEWS = "group.add.views";
    protected Map traceViewsMap;
    static /* synthetic */ Class class$org$eclipse$hyades$trace$ui$internal$wizard$OpenLogAgentWizard;
    static /* synthetic */ Class class$org$eclipse$hyades$trace$ui$internal$wizard$OpenNodeWizard;

    public TraceLogActionGroup(INavigator viewer) {
        super(viewer);
    }

    protected void createActions() {
        super.createActions();
        this.traceViewsMap = new HashMap();
        this.toggleLinkingAction = new ToggleLinkingAction(this.getNavigator(), UIPlugin.getResourceString("STR_LINK_VIEW"));
        this.toggleLinkingAction.setToolTipText(UIPlugin.getResourceString("STR_LINK_VIEW_TIP"));
        PDPluginImages.setImageDescriptors((IAction)this.toggleLinkingAction, "lcl16", "synced.gif");
        this.fImportActionGroup = new ImportActionGroup(this.getNavigator());
        this.fNewSnapshotGrp = new Separator("newSnapshotGroup");
        this.fGCGroup = new Separator("gcGroup");
        this.fRefreshGrp = new Separator("refreshGroup");
        this.fAttachGrp = new Separator("attachGroup");
        this.fTerminateGrp = new Separator("terminateGroup");
        this.fRefreshTree = new RefreshTreeAction(this.getNavigator());
        this.fMonitorGrp = new Separator("monitoringGroup");
        this.fSaveToFile = new SaveAction(this.getNavigator());
        this.fRefreshLocal = new RefreshFromLocalAction(this.getNavigator());
        this.fOpenLogAgentAction = new OpenWizardAction(this.getNavigator(), class$org$eclipse$hyades$trace$ui$internal$wizard$OpenLogAgentWizard == null ? (class$org$eclipse$hyades$trace$ui$internal$wizard$OpenLogAgentWizard = TraceLogActionGroup.class$("org.eclipse.hyades.trace.ui.internal.wizard.OpenLogAgentWizard")) : class$org$eclipse$hyades$trace$ui$internal$wizard$OpenLogAgentWizard, UIPlugin.getResourceString("PROPERTIES"));
        this.fOpenNodeAction = new OpenWizardAction(this.getNavigator(), class$org$eclipse$hyades$trace$ui$internal$wizard$OpenNodeWizard == null ? (class$org$eclipse$hyades$trace$ui$internal$wizard$OpenNodeWizard = TraceLogActionGroup.class$("org.eclipse.hyades.trace.ui.internal.wizard.OpenNodeWizard")) : class$org$eclipse$hyades$trace$ui$internal$wizard$OpenNodeWizard, UIPlugin.getResourceString("PROPERTIES"));
        this.fDeleteAction = new DeleteAction(this.getNavigator());
    }

    public void dispose() {
        if (this.traceViewsMap != null) {
            this.traceViewsMap.clear();
            this.traceViewsMap = null;
        }
        if (this.fImportActionGroup != null) {
            this.fImportActionGroup.dispose();
            this.fImportActionGroup = null;
        }
        this.deleteSeparators();
        this.deleteActions();
        super.dispose();
    }

    private void deleteSeparators() {
        if (this.fAttachGrp != null) {
            this.fAttachGrp.dispose();
            this.fAttachGrp = null;
        }
        if (this.fRefreshGrp != null) {
            this.fRefreshGrp.dispose();
            this.fRefreshGrp = null;
        }
        if (this.fTerminateGrp != null) {
            this.fTerminateGrp.dispose();
            this.fTerminateGrp = null;
        }
        if (this.fMonitorGrp != null) {
            this.fMonitorGrp.dispose();
            this.fMonitorGrp = null;
        }
        if (this.fNewSnapshotGrp != null) {
            this.fNewSnapshotGrp.dispose();
            this.fNewSnapshotGrp = null;
        }
        if (this.fGCGroup != null) {
            this.fGCGroup.dispose();
            this.fGCGroup = null;
        }
    }

    private void deleteActions() {
        if (this.fSaveToFile != null) {
            this.fSaveToFile.dispose();
            this.fSaveToFile = null;
        }
        if (this.fDeleteAction != null) {
            this.fDeleteAction.dispose();
            this.fDeleteAction = null;
        }
        if (this.fOpenLogAgentAction != null) {
            this.fOpenLogAgentAction.dispose();
            this.fOpenLogAgentAction = null;
        }
        if (this.fOpenNodeAction != null) {
            this.fOpenNodeAction.dispose();
            this.fOpenNodeAction = null;
        }
        if (this.fRefreshLocal != null) {
            this.fRefreshLocal.dispose();
            this.fRefreshLocal = null;
        }
        if (this.fRefreshTree != null) {
            this.fRefreshTree.dispose();
            this.fRefreshTree = null;
        }
        if (this.toggleLinkingAction != null) {
            this.toggleLinkingAction.dispose();
            this.toggleLinkingAction = null;
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        IMenuManager menu = actionBars.getMenuManager();
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.toggleLinkingAction);
        actionBars.updateActionBars();
        IToolBarManager toolbar = actionBars.getToolBarManager();
        toolbar.add((IContributionItem)new Separator());
        toolbar.add((IAction)this.toggleLinkingAction);
    }

    protected boolean areSameClass(IStructuredSelection selection) {
        if (selection == null || selection.isEmpty()) {
            return true;
        }
        Class<?> objClass = selection.getFirstElement().getClass();
        Iterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            if (objClass.equals(iterator.next().getClass())) continue;
            return false;
        }
        return true;
    }

    public void handleDoubleClick(DoubleClickEvent event) {
        TRCAgentProxy a;
        IAction[] actions;
        IAction[] actions2;
        IStructuredSelection s = (IStructuredSelection)event.getSelection();
        Object obj = s.getFirstElement();
        if (obj == null || !(obj instanceof EObject)) {
            return;
        }
        if (obj instanceof TRCAgentProxy && (actions2 = this.getViewMappingForType(((TRCAgentProxy)obj).getType())).length > 0 && actions2[0] != null) {
            actions2[0].run();
        }
        if (obj instanceof CorrelationContainerProxy && ((CorrelationContainerProxy)obj).getCorrelatedAgents().size() > 0 && (actions = this.getViewMappingForType((a = (TRCAgentProxy)((CorrelationContainerProxy)obj).getCorrelatedAgents().get(0)).getType())).length > 0 && actions[0] != null) {
            actions[0].run();
        }
    }

    protected IAction getDefaultViewMappingForType(String type) {
        IAction[] actions = this.getViewMappingForTypeUnsorted(type);
        if (actions.length >= 1) {
            return actions[0];
        }
        return null;
    }

    protected IAction[] getViewMappingForType(String type) {
        IAction[] actions = (IAction[])this.getViewMappingForTypeUnsorted(type).clone();
        Arrays.sort(actions, new Comparator(){

            public int compare(Object o1, Object o2) {
                IAction a = (IAction)o1;
                IAction b = (IAction)o2;
                return a.getText().compareTo(b.getText());
            }
        });
        return actions;
    }

    private IAction[] getViewMappingForTypeUnsorted(String type) {
        Object mapp = this.traceViewsMap.get(type);
        if (mapp != null) {
            return (IAction[])mapp;
        }
        IAssociationMappingRegistry registry = TraceAssociationManager.getTraceViewMappingRegistry();
        IAssociationMapping mapping = registry.getAssociationMapping("analyzerExtensions");
        if (mapping == null) {
            IAction[] actions = new IAction[]{};
            this.traceViewsMap.put(type, actions);
            return actions;
        }
        IAssociationDescriptor[] array = mapping.getAssociationDescriptors(type);
        IAction[] actions = new IAction[array.length];
        int idx = 0;
        while (idx < array.length) {
            IAssociationDescriptor desc = array[idx];
            try {
                IAction action = (IAction)desc.createImplementationClassInstance();
                if (action != null) {
                    action.setText(desc.getName());
                    action.setImageDescriptor(desc.getImageDescriptor());
                    actions[idx] = action;
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
            ++idx;
        }
        this.traceViewsMap.put(type, actions);
        return actions;
    }

    public void handleKeyPressed(KeyEvent event) {
        if (event.character == '\u007f' && event.stateMask == 0 && this.fDeleteAction.isEnabled()) {
            this.fDeleteAction.run();
        }
    }

    protected void updateActions(IStructuredSelection selection) {
        boolean saveEnabled = true;
        boolean deleteEnabled = true;
        if (selection.size() == 0) {
            deleteEnabled = false;
            saveEnabled = false;
        }
        Iterator i = selection.iterator();
        while (i.hasNext()) {
            Object next = i.next();
            if (!(next instanceof INavigatorItem)) continue;
            INavigatorItem item = (INavigatorItem)next;
            if (!item.isSaveEnabled()) {
                saveEnabled = false;
            }
            if (item.isDeleteEnabled()) continue;
            deleteEnabled = false;
        }
        this.fSaveToFile.setEnabled(saveEnabled);
        this.fDeleteAction.setEnabled(deleteEnabled);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ImportActionGroup
    extends ActionGroup {
        private ImportResourcesAction fImportAction;
        private ExportResourcesAction fExportAction;

        public ImportActionGroup(INavigator part) {
            IWorkbenchWindow workbench = part.getSite().getWorkbenchWindow();
            this.fImportAction = new ImportResourcesAction(workbench);
            this.fExportAction = new ExportResourcesAction(workbench);
            PDPluginImages.setImageDescriptors((IAction)this.fImportAction, "lcl16", "import_wiz.gif");
            PDPluginImages.setImageDescriptors((IAction)this.fExportAction, "lcl16", "export_wiz.gif");
        }

        public void fillContextMenu(IMenuManager menu) {
            menu.appendToGroup("group.import", (IAction)this.fImportAction);
            menu.appendToGroup("group.import", (IAction)this.fExportAction);
            super.fillContextMenu(menu);
        }
    }
}

