/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.core;

import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.CList;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TraceLogUI
implements SelectionListener,
ModifyListener {
    private CList _list;
    private Button _delete;
    private Button _addAgent;
    private Label _newAgentLabel;
    private Text _newAgent;

    protected void addAgent() {
        String agentName = this._newAgent.getText().trim();
        this.addAgent(agentName);
    }

    public void addAgent(String name) {
        this._list.add(name);
        this._list.getList().setSelection(this._list.getList().indexOf(name));
        this._newAgent.setText("");
        this._newAgent.setFocus();
        this._addAgent.setEnabled(false);
        this._delete.setEnabled(true);
    }

    public Composite createControl(Composite parent) {
        Composite _result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 2;
        _result.setLayout((Layout)layout);
        _result.setLayoutData((Object)GridUtil.createFill());
        this._list = new CList(_result, "");
        Composite buttons = new Composite(_result, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 3;
        buttons.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.widthHint = 120;
        buttons.setLayoutData((Object)gd);
        this._delete = new Button(buttons, 8);
        this._delete.setText(UIPlugin.getResourceString("REMOVE_AGENT"));
        this._delete.setLayoutData((Object)GridUtil.createHorizontalFill());
        Composite space = new Composite(buttons, 0);
        space.setLayout((Layout)layout);
        space.setLayoutData((Object)GridUtil.createFill());
        Composite addAgent = new Composite(_result, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 3;
        addAgent.setLayout((Layout)layout);
        addAgent.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._newAgentLabel = new Label(addAgent, 0);
        this._newAgentLabel.setText(UIPlugin.getResourceString("ADD_AGENT"));
        this._newAgent = new Text(addAgent, 2048);
        this._newAgent.setLayoutData((Object)GridUtil.createHorizontalFill());
        Composite addButton = new Composite(_result, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 1;
        addButton.setLayout((Layout)layout);
        gd = new GridData();
        gd.widthHint = 120;
        addButton.setLayoutData((Object)gd);
        this._addAgent = new Button(addButton, 8);
        this._addAgent.setText(UIPlugin.getResourceString("ADD_AGENT_BUTTON"));
        this._addAgent.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._addAgent.setEnabled(false);
        this._delete.setEnabled(false);
        this._delete.addSelectionListener((SelectionListener)this);
        this._addAgent.addSelectionListener((SelectionListener)this);
        this._newAgent.addModifyListener((ModifyListener)this);
        this._newAgent.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    TraceLogUI.this.addAgent();
                    e.doit = false;
                }
            }
        });
        this._list.getList().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TraceLogUI.this._delete.setEnabled(TraceLogUI.this._list.getSelectedIndices().length > 0);
            }
        });
        this._newAgent.setFocus();
        return _result;
    }

    public String[] getAgents() {
        return this._list.getList().getItems();
    }

    public void modifyText(ModifyEvent event) {
        if (event.widget == this._newAgent) {
            this._addAgent.setEnabled(!this._newAgent.getText().trim().equals(""));
        }
    }

    protected void removeAgent() {
        int selection = this._list.getSelectedIndex();
        this._list.remove(selection);
        if (this._list.getItemCount() > 0) {
            if (selection == 0) {
                this._list.setSelectedIndex(0);
            }
            if (selection < this._list.getItemCount()) {
                this._list.setSelectedIndex(selection);
            } else if (selection - 1 < this._list.getItemCount()) {
                this._list.setSelectedIndex(selection - 1);
            } else {
                this._list.setSelectedIndex(0);
            }
        } else {
            this._delete.setEnabled(false);
        }
        this._newAgent.setFocus();
        this._newAgent.selectAll();
    }

    public void reset() {
        this._list.getList().removeAll();
        this._delete.setEnabled(false);
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.widget == this._addAgent) {
            this.addAgent();
        } else if (event.widget == this._delete) {
            this.removeAgent();
        }
    }
}

